/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw.util.infos;

import com.novell.emframe.dev.D;
import com.novell.emframe.dev.MContext;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.FwUtils;
import com.novell.emframe.fw.Registry;
import com.novell.emframe.fw.util.PluginDocComparator;
import com.novell.emframe.fw.util.infos.Info;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Document;
import org.jdom.Element;

public class RoleInfo
extends Info {
    private String m_sId;
    private String m_sResourceFile;
    private String m_sResIdDisplayName;
    private String m_sDefaultDisplayName;
    private HashMap m_htCategoriesByDisplayName;
    private LinkedHashMap m_lhmTaskDocsById;
    private int m_order = -1;
    private boolean m_bTasksAreSorted;

    public RoleInfo(String id, String resFile, String displayNameId, String defaultDisplayName, HashMap categories, int order) {
        this.m_sId = id;
        this.m_htCategoriesByDisplayName = categories == null ? new HashMap() : categories;
        this.initOrder(order);
        if (resFile != null) {
            this.m_sResourceFile = resFile;
            this.m_sResIdDisplayName = displayNameId;
        }
        if (defaultDisplayName != null) {
            this.m_sDefaultDisplayName = eMFrameUtils.trimQuotes(defaultDisplayName);
            this.m_sDefaultDisplayName = eMFrameUtils.replaceSubString(this.m_sDefaultDisplayName, "\\.", ".");
        }
        if (this.m_sResourceFile == null && this.m_sDefaultDisplayName == null) {
            this.m_sResourceFile = "FwResources";
            this.m_sResIdDisplayName = "eMFrameConsts.RES_RBS_UNNAMEDROLENAME";
        }
    }

    public RoleInfo(String newId, String defaultDisplayName, Document roleDoc, HashMap categories, MContext context) {
        this.m_sId = newId;
        this.doc = roleDoc;
        Element root = roleDoc.getRootElement();
        this.m_sResourceFile = root.getChildTextTrim("resource-properties-file");
        this.m_sResIdDisplayName = root.getChildTextTrim("display-name-key");
        this.m_htCategoriesByDisplayName = categories;
        this.m_sDefaultDisplayName = eMFrameUtils.getDisplayName(roleDoc, context);
        if (this.m_sResourceFile == null && this.m_sDefaultDisplayName == null) {
            this.m_sDefaultDisplayName = defaultDisplayName;
        }
        if (this.m_sResourceFile == null && this.m_sDefaultDisplayName == null) {
            this.m_sResourceFile = "FwResources";
            this.m_sResIdDisplayName = "eMFrameConsts.RES_RBS_UNNAMEDROLENAME";
        }
        this.initOrder(-1);
    }

    public RoleInfo(Document roleDoc, MContext context) {
        Element root = roleDoc.getRootElement();
        this.doc = roleDoc;
        this.m_sId = root.getChildTextTrim("id");
        this.m_sResourceFile = root.getChildTextTrim("resource-properties-file");
        this.m_sResIdDisplayName = root.getChildTextTrim("display-name-key");
        List categories = root.getChildren("role-category-assignment");
        this.m_htCategoriesByDisplayName = new HashMap(categories.size());
        for (Element categoryElement : categories) {
            String catId = categoryElement.getTextTrim();
            Document catDoc = Registry.getRegistry("Install").getCategoryDoc(catId);
            if (catDoc == null) continue;
            String sCatDisplayName = eMFrameUtils.getDisplayName(catDoc, context);
            this.m_htCategoriesByDisplayName.put(catId, sCatDisplayName);
        }
        this.m_sDefaultDisplayName = eMFrameUtils.getDisplayName(roleDoc, context);
        if (this.m_sResourceFile == null && this.m_sDefaultDisplayName == null) {
            this.m_sResourceFile = "FwResources";
            this.m_sResIdDisplayName = "eMFrameConsts.RES_RBS_UNNAMEDROLENAME";
        }
        this.initOrder(-1);
    }

    public void setTasks(Map tasks, MContext context) {
        this.m_lhmTaskDocsById = new LinkedHashMap(tasks);
        this.m_bTasksAreSorted = false;
    }

    public void sortTasks(MContext context) {
        if (!this.m_bTasksAreSorted) {
            FwUtils.sortLinkedHashMapByValue(this.m_lhmTaskDocsById, new PluginDocComparator(context));
            this.m_bTasksAreSorted = true;
        }
    }

    public String getDisplayName(MContext context) {
        String strRoleDisplayName = null;
        if (this.m_sResIdDisplayName != null) {
            strRoleDisplayName = eMFrameUtils.getLocalizedString(this.m_sResourceFile, this.m_sResIdDisplayName, context);
        }
        if (strRoleDisplayName == null) {
            strRoleDisplayName = this.m_sDefaultDisplayName;
        }
        return strRoleDisplayName;
    }

    public HashMap getTaskDocsById() {
        return this.m_lhmTaskDocsById;
    }

    @Override
    public String getId() {
        return this.m_sId;
    }

    private void initOrder(int order) {
        if (order == -1) {
            String sOrder = this.getDocument().getRootElement().getChildTextTrim("order");
            if (sOrder != null) {
                try {
                    this.m_order = Integer.parseInt(sOrder);
                }
                catch (Exception e) {
                    D.log("Error Parsing Order for Role:" + this.getId() + ".  :" + e.getLocalizedMessage(), 2);
                    D.log(e, 2, 3);
                }
            } else {
                this.m_order = this.getId().startsWith("base.") ? 300 : 500;
            }
        } else {
            this.m_order = order;
        }
        this.m_order = Math.max(this.m_order, 0);
        this.m_order = Math.min(this.m_order, 1000);
    }

    public int getOrder() {
        return this.m_order;
    }

    public Map getCategoryDisplayNamesByIdMap() {
        return this.m_htCategoriesByDisplayName;
    }

    public String getCategoryDisplayName(String id) {
        return (String)this.m_htCategoriesByDisplayName.get(id);
    }

    public boolean isInCategory(String categoryId) {
        return this.m_htCategoriesByDisplayName.containsKey(categoryId);
    }
}

