/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw.xmlinfos;

import com.novell.admin.ns.AdminNamespace;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.VersionInfo;
import com.novell.rbs.RBSNVDSRights;
import com.novell.rbs.RBSRights;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import org.jdom.Element;

public class TaskClassObject
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String TASKTYPE_SNAPIN = "snapinTask";
    public static final String TASKTYPE_URL = "urlTask";
    public static final String TASKTYPE_NDS = "ndsTask";
    private static final String INITIAL_STRING = "";
    private static final String INITIAL_VERSION = "";
    private String theType;
    private String theName;
    private Vector roleList;
    private Vector unassignRoleList;
    private String classPath;
    private String displayNameKey;
    private String mergeTemplateName;
    private String errorTemplateName;
    private String descData;
    private String descKeyData;
    private String miscData;
    private Vector attrList;
    private Vector rightsAssignmentList;
    private String resourceBundle;
    private String version;
    private String requiredVersion;
    private String order;
    private Element rbsXMLInfo;
    private Vector authAssignmentElement;
    private Element secondaryRightsElement;
    private String leafObjectSupport;
    private ArrayList validObjectTypes = new ArrayList();
    private ArrayList supportedDeviceTypes = new ArrayList();
    private String moduleID;
    private String expiredVersion;
    private StringBuffer extraParamData;
    private String checkForUpdate;
    private String iManagerVersion;
    private String objectClass;
    private AdminNamespace m_ns;
    private boolean isNVDS;

    public TaskClassObject(AdminNamespace ns) {
        this.m_ns = ns;
        try {
            this.isNVDS = this.m_ns.isSupported("NVDS");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.theType = TASKTYPE_SNAPIN;
        this.theName = "";
        this.roleList = new Vector();
        this.unassignRoleList = new Vector();
        this.classPath = "";
        this.displayNameKey = "";
        this.mergeTemplateName = "";
        this.errorTemplateName = "";
        this.descData = "";
        this.descKeyData = "";
        this.order = "";
        this.miscData = "";
        this.resourceBundle = "";
        this.version = "";
        this.requiredVersion = "";
        this.attrList = new Vector();
        this.rightsAssignmentList = new Vector();
        this.rbsXMLInfo = null;
        this.secondaryRightsElement = null;
        this.authAssignmentElement = new Vector();
        this.leafObjectSupport = "";
        this.moduleID = "";
        this.expiredVersion = "";
        this.extraParamData = new StringBuffer();
        this.checkForUpdate = "";
        this.iManagerVersion = "";
    }

    public void setType(String type) {
        this.theType = type;
    }

    public String getType() {
        return this.theType;
    }

    public void setName(String name) {
        this.theName = name;
    }

    public String getName() {
        return this.theName;
    }

    public void addUnassignRole(String role) {
        this.unassignRoleList.addElement(role);
    }

    public void addRole(String role) {
        this.roleList.addElement(role);
    }

    public void addAttribute(String attr) {
        this.attrList.addElement(attr);
    }

    public void addRightsAssignment(RBSRights rights) {
        this.rightsAssignmentList.addElement(rights);
    }

    public void removeRole(String role) {
        for (int i = 0; i < this.roleList.size(); ++i) {
            if (!role.equals(this.roleList.elementAt(i))) continue;
            this.roleList.removeElementAt(i);
            break;
        }
    }

    public Vector getRoles() {
        return this.roleList;
    }

    public String[] getRoleList() {
        if (this.roleList.size() == 0) {
            return null;
        }
        Object[] elements = new String[this.roleList.size()];
        this.roleList.copyInto(elements);
        return elements;
    }

    public String[] getUnassignRoleList() {
        if (this.unassignRoleList.size() == 0) {
            return null;
        }
        Object[] elements = new String[this.unassignRoleList.size()];
        this.unassignRoleList.copyInto(elements);
        return elements;
    }

    public void setClassPath(String path) {
        this.classPath = path;
    }

    public String getClassPath() {
        return this.classPath;
    }

    public void setDisplayNameKey(String displayName) {
        this.displayNameKey = displayName;
    }

    public String getDisplayNameKey() {
        return this.displayNameKey;
    }

    public void setOrder(String order) {
        this.order = order;
    }

    public String getOrder() {
        return this.order;
    }

    public void setMergeTemplateName(String mergeTemplate) {
        this.mergeTemplateName = mergeTemplate;
    }

    public String getMergeTemplateName() {
        return this.mergeTemplateName;
    }

    public void setErrorTemplateName(String errorTemplate) {
        this.errorTemplateName = errorTemplate;
    }

    public String getErrorTemplateName() {
        return this.errorTemplateName;
    }

    public void setDescData(String desc) {
        this.descData = desc;
    }

    public String getDescData() {
        return this.descData;
    }

    public void setDescKeyData(String descKey) {
        this.descKeyData = descKey;
    }

    public String getDescKeyData() {
        return this.descKeyData;
    }

    public void setMiscData(String misc) {
        this.miscData = misc;
    }

    public void addMiscData(String misc) {
        this.miscData = this.miscData.concat(misc);
    }

    public String getMiscData() {
        return this.miscData;
    }

    public void setRoleListWithCommaDelimitedString(String role, HttpServletRequest req) {
        StringTokenizer stringTokenizer = new StringTokenizer(role, ",");
        this.roleList.removeAllElements();
        while (stringTokenizer.hasMoreTokens()) {
            this.roleList.addElement(eMFrameUtils.urlDecode(stringTokenizer.nextToken(), req.getCharacterEncoding()));
        }
    }

    public String[] getAttrList() {
        if (this.attrList.size() == 0) {
            return null;
        }
        Object[] elements = new String[this.attrList.size()];
        this.attrList.copyInto(elements);
        return elements;
    }

    public void setAttrListWithCommaDelimitedString(String attrString, HttpServletRequest req) {
        StringTokenizer stringTokenizer = new StringTokenizer(attrString, ",");
        this.attrList.removeAllElements();
        while (stringTokenizer.hasMoreTokens()) {
            this.attrList.addElement(eMFrameUtils.urlDecode(stringTokenizer.nextToken(), req.getCharacterEncoding()));
        }
    }

    public RBSRights[] getRights() {
        Object[] rbsRights = null;
        String[] attrString = this.getAttrList();
        if (attrString != null && attrString.length > 0) {
            Vector<Object> rightsVector = new Vector<Object>();
            long entryRights = 0L;
            for (int i = 0; i < attrString.length; ++i) {
                RBSRights rights;
                String tokenString = attrString[i];
                if (tokenString.equals("[Supervisor Object]")) {
                    entryRights |= 0x10L;
                    continue;
                }
                if (tokenString.equals("[Delete Object]")) {
                    entryRights |= 5L;
                    continue;
                }
                if (tokenString.equals("[Create Object]")) {
                    entryRights |= 3L;
                    continue;
                }
                if (tokenString.equals("[Rename Object]")) {
                    entryRights |= 9L;
                    continue;
                }
                if (tokenString.equals("[Browse Object]")) {
                    entryRights |= 1L;
                    continue;
                }
                String str = new String(tokenString);
                boolean found = false;
                long priv = 0L;
                for (int j = 0; j < this.rightsAssignmentList.size(); ++j) {
                    found = false;
                    RBSRights assignedRights = (RBSRights)this.rightsAssignmentList.elementAt(j);
                    if (!str.equals(assignedRights.getProtectedAttrName())) continue;
                    priv = assignedRights.getPrivileges();
                    found = true;
                    break;
                }
                if (!found) {
                    priv = 32L;
                }
                if (this.isNVDS) {
                    rights = new RBSNVDSRights("", "", "", this.objectClass, str, 0L, priv);
                    rightsVector.addElement(rights);
                    continue;
                }
                rights = new RBSRights("", str, priv);
                rightsVector.addElement(rights);
            }
            if (entryRights > 0L) {
                if (this.isNVDS) {
                    RBSNVDSRights rights = new RBSNVDSRights("", "", "", this.objectClass, "[Entry Rights]", 0L, entryRights);
                    rightsVector.addElement(rights);
                } else {
                    RBSRights rights = new RBSRights("", "[Entry Rights]", entryRights);
                    rightsVector.addElement(rights);
                }
            }
            if (this.isNVDS) {
                rbsRights = new RBSNVDSRights[rightsVector.size()];
                rightsVector.copyInto(rbsRights);
            } else {
                rbsRights = new RBSRights[rightsVector.size()];
                rightsVector.copyInto(rbsRights);
            }
        }
        return rbsRights;
    }

    public String getParameters() {
        StringBuffer strBuffer = new StringBuffer();
        if (this.getVersion().length() > 0) {
            strBuffer.append("version=" + this.getVersion());
        }
        if (this.requiredVersion.length() > 0) {
            if (strBuffer.length() > 0) {
                strBuffer.append(";");
            }
            strBuffer.append("required-version=" + this.requiredVersion);
        }
        if (this.expiredVersion.length() > 0) {
            if (strBuffer.length() > 0) {
                strBuffer.append(";");
            }
            strBuffer.append("expired-version=" + this.expiredVersion);
        }
        if (this.mergeTemplateName.length() > 0) {
            if (strBuffer.length() > 0) {
                strBuffer.append(";");
            }
            strBuffer.append("merge-template=" + this.mergeTemplateName);
        }
        if (this.errorTemplateName.length() > 0) {
            if (strBuffer.length() > 0) {
                strBuffer.append(";");
            }
            strBuffer.append("error-template=" + this.errorTemplateName);
        }
        if (this.resourceBundle.length() > 0) {
            if (strBuffer.length() > 0) {
                strBuffer.append(";");
            }
            strBuffer.append("resource-properties-file=" + this.resourceBundle);
        }
        if (this.displayNameKey.length() > 0) {
            if (strBuffer.length() > 0) {
                strBuffer.append(";");
            }
            strBuffer.append("display-name-key=" + this.displayNameKey);
        }
        if (this.order.length() > 0) {
            if (strBuffer.length() > 0) {
                strBuffer.append(";");
            }
            strBuffer.append("order=" + this.order);
        }
        if (this.miscData.length() > 0) {
            if (strBuffer.length() > 0) {
                strBuffer.append(";");
            }
            strBuffer.append(this.miscData);
        }
        if (this.descKeyData.length() > 0) {
            if (strBuffer.length() > 0) {
                strBuffer.append(";");
            }
            strBuffer.append("description-key=" + this.descKeyData);
        }
        if (this.theType.length() > 0) {
            if (strBuffer.length() > 0) {
                strBuffer.append(";");
            }
            strBuffer.append("taskType=" + this.theType);
        }
        if (this.leafObjectSupport.length() > 0) {
            if (strBuffer.length() > 0) {
                strBuffer.append(";");
            }
            strBuffer.append("leaf-object-support=" + this.leafObjectSupport);
        }
        for (String s : this.validObjectTypes) {
            if (strBuffer.length() > 0) {
                strBuffer.append(";");
            }
            strBuffer.append("object-type-name=" + s);
        }
        for (String s : this.supportedDeviceTypes) {
            if (strBuffer.length() > 0) {
                strBuffer.append(";");
            }
            strBuffer.append("supported-device-type=" + s);
        }
        if (this.moduleID.length() > 0) {
            if (strBuffer.length() > 0) {
                strBuffer.append(";");
            }
            strBuffer.append("module=" + this.moduleID);
        }
        if (this.iManagerVersion.length() > 0) {
            if (strBuffer.length() > 0) {
                strBuffer.append(";");
            }
            strBuffer.append("last-updated-by-imanager-version=" + this.iManagerVersion);
        }
        if (this.getExtraParamData().length() > 0) {
            if (strBuffer.length() > 0) {
                strBuffer.append(";");
            }
            strBuffer.append(this.getExtraParamData());
        }
        return strBuffer.toString();
    }

    public void setResourceBundle(String bundle) {
        this.resourceBundle = bundle;
    }

    public String getResourceBundle() {
        return this.resourceBundle;
    }

    public void setVersion(String ver) {
        this.version = ver;
    }

    public String getVersion() {
        String ver = this.version;
        if (this.checkForUpdate.equalsIgnoreCase("yes")) {
            VersionInfo versionInfo = new VersionInfo(ver);
            versionInfo.setBuild(new Integer(1));
            ver = versionInfo.getVersionString();
        }
        return ver;
    }

    public void setRequiredVersion(String ver) {
        this.requiredVersion = ver;
    }

    public String getRequiredVersion() {
        return this.requiredVersion;
    }

    public void setExpiredVersion(String ver) {
        this.expiredVersion = ver;
    }

    public String getExpiredVersion() {
        return this.expiredVersion;
    }

    public void setRBSXMLInfo(Element element) {
        this.rbsXMLInfo = element;
    }

    public Element getRBSXMLInfo() {
        return this.rbsXMLInfo;
    }

    public void setSecondaryRightsElement(Element element) {
        this.secondaryRightsElement = element;
    }

    public Element getSecondaryRightsElement() {
        return this.secondaryRightsElement;
    }

    public void setLeafObjectSupport(String leafSupport) {
        this.leafObjectSupport = leafSupport;
    }

    public String getLeafObjectSupport() {
        return this.leafObjectSupport;
    }

    public void addValidObjectType(String objectType) {
        this.validObjectTypes.add(objectType);
    }

    public void addSupportedDeviceType(String supportedDeviceType) {
        this.supportedDeviceTypes.add(supportedDeviceType);
    }

    public void setModuleID(String id) {
        this.moduleID = id;
    }

    public String getModuleID() {
        return this.moduleID;
    }

    public void setExtraParamData(String key, String value) {
        if (this.extraParamData.length() > 0) {
            this.extraParamData.append(";");
        }
        this.extraParamData.append(key + "=" + value);
    }

    public String getExtraParamData() {
        return this.extraParamData.toString();
    }

    public void setCheckForUpdate(String update) {
        this.checkForUpdate = update;
    }

    public String getCheckForUpdate() {
        return this.checkForUpdate;
    }

    public void setiManagerVersion(String version) {
        this.iManagerVersion = version;
    }

    public String getiManagerVersion() {
        return this.iManagerVersion;
    }

    public void addAuthAssignmentElement(Element element) {
        this.authAssignmentElement.add(element);
    }

    public Element[] getAuthAssignmentElement() {
        if (this.authAssignmentElement.size() == 0) {
            return null;
        }
        Object[] elements = new Element[this.authAssignmentElement.size()];
        this.authAssignmentElement.copyInto(elements);
        return elements;
    }

    public void setObjectClass(String objectClass) {
        this.objectClass = objectClass;
    }

    public String getObjectClass() {
        return this.objectClass;
    }
}

