/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw.xmlinfos;

import com.novell.admin.ns.AdminNamespace;
import com.novell.emframe.fw.iManager;
import com.novell.emframe.fw.util.iManagerJDOMFactory;
import com.novell.emframe.fw.xmlinfos.BookAddOnClassObject;
import com.novell.emframe.fw.xmlinfos.BookClassObject;
import com.novell.emframe.fw.xmlinfos.CategoryClassObject;
import com.novell.emframe.fw.xmlinfos.ModuleClassObject;
import com.novell.emframe.fw.xmlinfos.PageClassObject;
import com.novell.emframe.fw.xmlinfos.RoleClassObject;
import com.novell.emframe.fw.xmlinfos.TaskClassObject;
import com.novell.rbs.RBSNVDSRights;
import com.novell.rbs.RBSRights;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Vector;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.JDOMFactory;
import org.jdom.input.SAXBuilder;

public class XMLFileReader {
    private AdminNamespace m_ns;
    private ModuleClassObject moduleClassObject;
    private String authName;
    private boolean isNVDS;

    public XMLFileReader(AdminNamespace ns) {
        this.m_ns = ns;
        this.moduleClassObject = new ModuleClassObject();
        try {
            this.isNVDS = this.m_ns.isSupported("NVDS");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public ModuleClassObject readFile(Document doc, String authName) throws JDOMException {
        this.authName = authName;
        this.installElementData(doc.getRootElement());
        return this.moduleClassObject;
    }

    public ModuleClassObject readFile(String fileName, String authName) throws JDOMException, IOException {
        this.authName = authName;
        SAXBuilder saxBuilder = new SAXBuilder(false);
        saxBuilder.setFeature("http://xml.org/sax/features/external-general-entities", false);
        saxBuilder.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        saxBuilder.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        saxBuilder.setFactory((JDOMFactory)iManagerJDOMFactory.getInstance());
        File theFile = new File(fileName);
        Document jdomDocumemt = saxBuilder.build(theFile);
        Element rootElement = jdomDocumemt.getRootElement();
        this.installElementData(rootElement);
        return this.moduleClassObject;
    }

    private void installElementData(Element rootElement) {
        List roleChildren;
        List categoryChildren;
        List moduleChildren = rootElement.getChildren("module");
        if (moduleChildren != null) {
            for (int i = 0; i < moduleChildren.size(); ++i) {
                Element currentElement = (Element)moduleChildren.get(i);
                if (currentElement.getChildren().isEmpty() || currentElement.getChild("non-ds") != null) continue;
                this.moduleElementData(currentElement);
            }
        }
        if ((categoryChildren = rootElement.getChildren("category")) != null) {
            for (int i = 0; i < categoryChildren.size(); ++i) {
                Element currentElement = (Element)categoryChildren.get(i);
                if (currentElement.getChildren().isEmpty() || !this.elementSupportsAuthenticator(currentElement)) continue;
                this.categoryElementData(currentElement);
            }
        }
        if ((roleChildren = rootElement.getChildren("role")) != null) {
            for (int i = 0; i < roleChildren.size(); ++i) {
                Element currentElement = (Element)roleChildren.get(i);
                if (currentElement.getChildren().isEmpty() || currentElement.getChild("non-ds") != null || !this.elementSupportsAuthenticator(currentElement)) continue;
                this.roleElementData(currentElement);
            }
        }
        List rootChildren = rootElement.getChildren();
        for (int i = 0; i < rootChildren.size(); ++i) {
            Element currentElement = (Element)rootChildren.get(i);
            if (currentElement.getName().equals("task")) {
                if (currentElement.getChildren().isEmpty() || !this.elementSupportsAuthenticator(currentElement)) continue;
                this.taskElementData(currentElement);
                continue;
            }
            if (currentElement.getName().equals("url-task")) {
                if (currentElement.getChildren().isEmpty() || !this.elementSupportsAuthenticator(currentElement)) continue;
                this.taskElementData(currentElement);
                continue;
            }
            if (currentElement.getName().equals("book")) {
                if (currentElement.getChildren().isEmpty() || !this.elementSupportsAuthenticator(currentElement)) continue;
                this.bookElementData(currentElement);
                continue;
            }
            if (!currentElement.getName().equals("book-addon") || currentElement.getChildren().isEmpty()) continue;
            this.bookAddOnElementData(currentElement);
        }
    }

    private void moduleElementData(Element moduleElement) {
        String iManVersion = iManager.getVersionString();
        if (iManVersion != null) {
            this.moduleClassObject.setiManagerVersion(iManVersion);
        }
        List moduleChildren = moduleElement.getChildren();
        for (int i = 0; i < moduleChildren.size(); ++i) {
            Element currentElement = (Element)moduleChildren.get(i);
            if (currentElement.getName().equals("id")) {
                this.moduleClassObject.setModuleName(currentElement.getTextTrim());
                continue;
            }
            if (currentElement.getName().equals("version")) {
                this.moduleClassObject.setVersion(currentElement.getTextTrim());
                continue;
            }
            if (currentElement.getName().equals("resource-properties-file")) {
                this.moduleClassObject.setResourceBundle(currentElement.getTextTrim());
                continue;
            }
            if (currentElement.getName().equals("display-name-key")) {
                this.moduleClassObject.setDisplayNameKey(currentElement.getTextTrim());
                continue;
            }
            if (currentElement.getName().equals("description")) {
                this.moduleClassObject.setDescData(currentElement.getTextTrim());
                continue;
            }
            if (currentElement.getName().equals("rbs-xml-info")) {
                List children = currentElement.getChildren();
                Element element = (Element)children.get(0);
                this.moduleClassObject.setRBSXMLInfo((Element)element.clone());
                continue;
            }
            if (!currentElement.getName().equals("check-for-update")) continue;
            this.moduleClassObject.setCheckForUpdate(currentElement.getTextTrim());
        }
    }

    private void categoryElementData(Element categoryElement) {
        List categoryChildren = categoryElement.getChildren();
        CategoryClassObject categoryClassObject = new CategoryClassObject();
        categoryClassObject.setModuleID(this.moduleClassObject.getModuleName());
        String iManVersion = iManager.getVersionString();
        if (iManVersion != null) {
            categoryClassObject.setiManagerVersion(iManVersion);
        }
        for (int i = 0; i < categoryChildren.size(); ++i) {
            Element currentElement = (Element)categoryChildren.get(i);
            if (currentElement.getName().equals("id")) {
                categoryClassObject.setName(currentElement.getTextTrim());
                continue;
            }
            if (currentElement.getName().equals("order")) {
                categoryClassObject.setOrder(currentElement.getTextTrim());
                continue;
            }
            if (currentElement.getName().equals("display-name-key")) {
                categoryClassObject.setDisplayNameKey(currentElement.getTextTrim());
                continue;
            }
            if (currentElement.getName().equals("description")) {
                categoryClassObject.setDescData(currentElement.getTextTrim());
                continue;
            }
            if (currentElement.getName().equals("description-key")) {
                categoryClassObject.setDescKeyData(currentElement.getTextTrim());
                continue;
            }
            if (currentElement.getName().equals("resource-properties-file")) {
                categoryClassObject.setResourceBundle(currentElement.getTextTrim());
                continue;
            }
            if (currentElement.getName().equals("rbs-xml-info")) {
                List children = currentElement.getChildren();
                Element element = (Element)children.get(0);
                categoryClassObject.setRBSXMLInfo((Element)element.clone());
                continue;
            }
            if (currentElement.getName().equals("check-for-update")) {
                categoryClassObject.setCheckForUpdate(currentElement.getTextTrim());
                continue;
            }
            categoryClassObject.setExtraParamData(currentElement.getName(), currentElement.getTextTrim());
        }
        this.moduleClassObject.addCategory(categoryClassObject);
    }

    private void roleElementData(Element roleElement) {
        List roleChildren = roleElement.getChildren();
        RoleClassObject roleClassObject = new RoleClassObject();
        roleClassObject.setModuleID(this.moduleClassObject.getModuleName());
        String iManVersion = iManager.getVersionString();
        if (iManVersion != null) {
            roleClassObject.setiManagerVersion(iManVersion);
        }
        for (int i = 0; i < roleChildren.size(); ++i) {
            Element currentElement = (Element)roleChildren.get(i);
            if (currentElement.getName().equals("id")) {
                roleClassObject.setName(currentElement.getTextTrim());
                continue;
            }
            if (currentElement.getName().equals("version")) {
                roleClassObject.setVersion(currentElement.getTextTrim());
                continue;
            }
            if (currentElement.getName().equals("required-version")) {
                roleClassObject.setInitialVersion(currentElement.getTextTrim());
                continue;
            }
            if (currentElement.getName().equals("expired-version")) {
                roleClassObject.setExpiredVersion(currentElement.getTextTrim());
                continue;
            }
            if (currentElement.getName().equals("order")) {
                roleClassObject.setOrder(currentElement.getTextTrim());
                continue;
            }
            if (currentElement.getName().equals("display-name-key")) {
                roleClassObject.setDisplayNameKey(currentElement.getTextTrim());
                continue;
            }
            if (currentElement.getName().equals("description")) {
                roleClassObject.setDescData(currentElement.getTextTrim());
                continue;
            }
            if (currentElement.getName().equals("description-key")) {
                roleClassObject.setDescKeyData(currentElement.getTextTrim());
                continue;
            }
            if (currentElement.getName().equals("resource-properties-file")) {
                roleClassObject.setResourceBundle(currentElement.getTextTrim());
                continue;
            }
            if (currentElement.getName().equals("url-param")) {
                List urlParamsChildren;
                if (currentElement.getChildren().isEmpty() || (urlParamsChildren = currentElement.getChildren()).size() != 2) continue;
                String[] strE = new String[2];
                for (int j = 0; j < urlParamsChildren.size(); ++j) {
                    Element urlParmsElement = (Element)urlParamsChildren.get(j);
                    strE[j] = urlParmsElement.getTextTrim();
                }
                roleClassObject.addMiscData(strE[0] + "=" + strE[1] + ";");
                continue;
            }
            if (currentElement.getName().equals("rbs-xml-info")) {
                List children = currentElement.getChildren();
                Element element = (Element)children.get(0);
                roleClassObject.setRBSXMLInfo((Element)element.clone());
                continue;
            }
            if (currentElement.getName().equals("role-category-assignment")) {
                roleClassObject.addCategory(currentElement.getTextTrim());
                continue;
            }
            if (currentElement.getName().equals("check-for-update")) {
                roleClassObject.setCheckForUpdate(currentElement.getTextTrim());
                continue;
            }
            if (currentElement.getName().equals("auth-assignment")) {
                roleClassObject.addAuthAssignmentElement((Element)currentElement.clone());
                continue;
            }
            roleClassObject.setExtraParamData(currentElement.getName(), currentElement.getTextTrim());
        }
        this.moduleClassObject.addRole(roleClassObject);
    }

    private void taskElementData(Element taskElement) {
        List taskChildren = taskElement.getChildren();
        TaskClassObject taskClassObject = new TaskClassObject(this.m_ns);
        taskClassObject.setModuleID(this.moduleClassObject.getModuleName());
        String iManVersion = iManager.getVersionString();
        if (iManVersion != null) {
            taskClassObject.setiManagerVersion(iManVersion);
        }
        for (int i = 0; i < taskChildren.size(); ++i) {
            Element currentElement = (Element)taskChildren.get(i);
            if (currentElement.getName().equals("id")) {
                taskClassObject.setName(currentElement.getTextTrim());
                continue;
            }
            if (currentElement.getName().equals("type")) {
                taskClassObject.setType(currentElement.getTextTrim());
                continue;
            }
            if (currentElement.getName().equals("version")) {
                taskClassObject.setVersion(currentElement.getTextTrim());
                continue;
            }
            if (currentElement.getName().equals("order")) {
                taskClassObject.setOrder(currentElement.getTextTrim());
                continue;
            }
            if (currentElement.getName().equals("required-version")) {
                taskClassObject.setRequiredVersion(currentElement.getTextTrim());
                continue;
            }
            if (currentElement.getName().equals("expired-version")) {
                taskClassObject.setExpiredVersion(currentElement.getTextTrim());
                continue;
            }
            if (currentElement.getName().equals("class-name")) {
                taskClassObject.setClassPath(currentElement.getTextTrim());
                continue;
            }
            if (currentElement.getName().equals("url")) {
                String url = currentElement.getTextTrim();
                taskClassObject.setClassPath("url:" + url);
                continue;
            }
            if (currentElement.getName().equals("merge-template")) {
                taskClassObject.setMergeTemplateName(currentElement.getTextTrim());
                continue;
            }
            if (currentElement.getName().equals("error-template")) {
                taskClassObject.setErrorTemplateName(currentElement.getTextTrim());
                continue;
            }
            if (currentElement.getName().equals("url-param")) {
                List urlParamsChildren;
                if (currentElement.getChildren().isEmpty() || (urlParamsChildren = currentElement.getChildren()).size() != 2) continue;
                String[] strE = new String[2];
                for (int j = 0; j < urlParamsChildren.size(); ++j) {
                    Element urlParmsElement = (Element)urlParamsChildren.get(j);
                    strE[j] = urlParmsElement.getTextTrim();
                }
                taskClassObject.addMiscData(strE[0] + "=" + strE[1] + ";");
                continue;
            }
            if (currentElement.getName().equals("description")) {
                taskClassObject.setDescData(currentElement.getTextTrim());
                continue;
            }
            if (currentElement.getName().equals("description-key")) {
                taskClassObject.setDescKeyData(currentElement.getTextTrim());
                continue;
            }
            if (currentElement.getName().equals("resource-properties-file")) {
                taskClassObject.setResourceBundle(currentElement.getTextTrim());
                continue;
            }
            if (currentElement.getName().equals("display-name-key")) {
                taskClassObject.setDisplayNameKey(currentElement.getTextTrim());
                continue;
            }
            if (currentElement.getName().equals("role-assignment")) {
                taskClassObject.addRole(currentElement.getTextTrim());
                continue;
            }
            if (currentElement.getName().equals("role-unassign")) {
                taskClassObject.addUnassignRole(currentElement.getTextTrim());
                continue;
            }
            if (currentElement.getName().equals("rights-assignment")) {
                if (currentElement.getChildren().isEmpty()) continue;
                List raChildren = currentElement.getChildren();
                String attrName = null;
                String objectClass = null;
                Vector<String> privStrings = new Vector<String>();
                for (int j = 0; j < raChildren.size(); ++j) {
                    Element raElement = (Element)raChildren.get(j);
                    if (raElement.getName().equals("attribute-name")) {
                        attrName = raElement.getTextTrim();
                    }
                    if (raElement.getName().equals("privilege")) {
                        privStrings.add(raElement.getTextTrim());
                    }
                    if (raElement.getName().equals("flag")) {
                        privStrings.add(raElement.getTextTrim());
                    }
                    if (!raElement.getName().equals("object-class")) continue;
                    objectClass = raElement.getTextTrim();
                }
                long entryRights = 0L;
                if (attrName.equals("[Entry Rights]")) {
                    for (int k = 0; k < privStrings.size(); ++k) {
                        String str = (String)privStrings.elementAt(k);
                        if (str.equals("Supervisor")) {
                            taskClassObject.addAttribute("[Supervisor Object]");
                            entryRights |= 0x10L;
                        }
                        if (str.equals("Create")) {
                            taskClassObject.addAttribute("[Create Object]");
                            entryRights |= 3L;
                        }
                        if (str.equals("Delete")) {
                            taskClassObject.addAttribute("[Delete Object]");
                            entryRights |= 5L;
                        }
                        if (str.equals("Rename")) {
                            taskClassObject.addAttribute("[Rename Object]");
                            entryRights |= 9L;
                        }
                        if (str.equals("Self")) {
                            taskClassObject.addAttribute("Self");
                            entryRights |= Integer.MIN_VALUE;
                        }
                        if (!str.equals("Browse")) continue;
                        taskClassObject.addAttribute("[Browse Object]");
                        entryRights |= 1L;
                    }
                } else {
                    RBSRights rights;
                    Object[] strings = new String[privStrings.size()];
                    privStrings.copyInto(strings);
                    taskClassObject.addAttribute(attrName);
                    if (this.isNVDS) {
                        taskClassObject.setObjectClass(objectClass);
                        rights = new RBSNVDSRights("", "", "", objectClass, attrName, 0L, (String[])strings);
                        taskClassObject.addRightsAssignment(rights);
                    } else {
                        rights = new RBSRights("", attrName, (String[])strings);
                        taskClassObject.addRightsAssignment(rights);
                    }
                }
                if (entryRights <= 0L) continue;
                if (this.isNVDS) {
                    taskClassObject.setObjectClass(objectClass);
                    RBSNVDSRights rights = new RBSNVDSRights("", "", "", objectClass, "[Entry Rights]", 0L, entryRights);
                    taskClassObject.addRightsAssignment((RBSRights)rights);
                    continue;
                }
                RBSRights rights = new RBSRights("", "[Entry Rights]", entryRights);
                taskClassObject.addRightsAssignment(rights);
                continue;
            }
            if (currentElement.getName().equals("rbs-xml-info")) {
                List children = currentElement.getChildren();
                Element element = (Element)children.get(0);
                taskClassObject.setRBSXMLInfo((Element)element.clone());
                continue;
            }
            if (currentElement.getName().equals("secondary-rights")) {
                Element cloneElement = (Element)currentElement.clone();
                taskClassObject.setSecondaryRightsElement(cloneElement);
                continue;
            }
            if (currentElement.getName().equals("leaf-object-support")) {
                taskClassObject.setLeafObjectSupport(currentElement.getTextTrim());
                continue;
            }
            if (currentElement.getName().equals("object-type-name")) {
                taskClassObject.addValidObjectType(currentElement.getTextTrim());
                continue;
            }
            if (currentElement.getName().equals("supported-device-type")) {
                taskClassObject.addSupportedDeviceType(currentElement.getTextTrim());
                continue;
            }
            if (currentElement.getName().equals("check-for-update")) {
                taskClassObject.setCheckForUpdate(currentElement.getTextTrim());
                continue;
            }
            if (currentElement.getName().equals("auth-assignment")) {
                taskClassObject.addAuthAssignmentElement((Element)currentElement.clone());
                continue;
            }
            taskClassObject.setExtraParamData(currentElement.getName(), currentElement.getTextTrim());
        }
        this.moduleClassObject.addTask(taskClassObject);
    }

    private void bookElementData(Element bookElement) {
        List bookChildren = bookElement.getChildren();
        BookClassObject bookClassObject = new BookClassObject(this.m_ns);
        bookClassObject.setModuleID(this.moduleClassObject.getModuleName());
        String iManVersion = iManager.getVersionString();
        if (iManVersion != null) {
            bookClassObject.setiManagerVersion(iManVersion);
        }
        for (int i = 0; i < bookChildren.size(); ++i) {
            int j;
            Element currentElement = (Element)bookChildren.get(i);
            if (currentElement.getName().equals("id")) {
                bookClassObject.setName(currentElement.getTextTrim());
                continue;
            }
            if (currentElement.getName().equals("resource-properties-file")) {
                bookClassObject.setResourceBundle(currentElement.getTextTrim());
                continue;
            }
            if (currentElement.getName().equals("class-name")) {
                bookClassObject.setClassPath(currentElement.getTextTrim());
                continue;
            }
            if (currentElement.getName().equals("version")) {
                bookClassObject.setVersion(currentElement.getTextTrim());
                continue;
            }
            if (currentElement.getName().equals("required-version")) {
                bookClassObject.setRequiredVersion(currentElement.getTextTrim());
                continue;
            }
            if (currentElement.getName().equals("expired-version")) {
                bookClassObject.setExpiredVersion(currentElement.getTextTrim());
                continue;
            }
            if (currentElement.getName().equals("order")) {
                bookClassObject.setOrder(currentElement.getTextTrim());
                continue;
            }
            if (currentElement.getName().equals("url-param")) {
                List urlParamsChildren;
                if (currentElement.getChildren().isEmpty() || (urlParamsChildren = currentElement.getChildren()).size() != 2) continue;
                String[] strE = new String[2];
                for (j = 0; j < urlParamsChildren.size(); ++j) {
                    Element urlParmsElement = (Element)urlParamsChildren.get(j);
                    strE[j] = urlParmsElement.getTextTrim();
                }
                bookClassObject.addMiscData(strE[0] + "=" + strE[1] + ";");
                continue;
            }
            if (currentElement.getName().equals("description")) {
                bookClassObject.setDescData(currentElement.getTextTrim());
                continue;
            }
            if (currentElement.getName().equals("description-key")) {
                bookClassObject.setDescKeyData(currentElement.getTextTrim());
                continue;
            }
            if (currentElement.getName().equals("display-name-key")) {
                bookClassObject.setDisplayNameKey(currentElement.getTextTrim());
                continue;
            }
            if (currentElement.getName().equals("object-type-name")) {
                bookClassObject.addObjectClassType(currentElement.getTextTrim());
                bookClassObject.addValidObjectType(currentElement.getTextTrim());
                continue;
            }
            if (currentElement.getName().equals("supported-device-type")) {
                bookClassObject.addSupportedDeviceType(currentElement.getTextTrim());
                continue;
            }
            if (currentElement.getName().equals("leaf-object-support")) {
                bookClassObject.setLeafObjectSupport(currentElement.getTextTrim());
                continue;
            }
            if (currentElement.getName().equals("page-assignment")) {
                bookClassObject.addPage(currentElement.getTextTrim());
                String[] pages = this.moduleClassObject.getPageList();
                boolean found = false;
                if (pages != null) {
                    for (j = 0; j < pages.length; ++j) {
                        if (!pages[j].equals(currentElement.getTextTrim())) continue;
                        found = true;
                        break;
                    }
                }
                if (found) continue;
                PageClassObject pageClassObject = new PageClassObject(this.m_ns);
                pageClassObject.setName(currentElement.getTextTrim());
                this.moduleClassObject.addPage(pageClassObject);
                continue;
            }
            if (currentElement.getName().equals("role-unassign")) {
                bookClassObject.addUnassignRole(currentElement.getTextTrim());
                continue;
            }
            if (currentElement.getName().equals("role-assignment")) {
                RoleClassObject rClassObj = this.moduleClassObject.getRole(currentElement.getTextTrim());
                if (rClassObj == null) continue;
                bookClassObject.addRole(currentElement.getTextTrim());
                continue;
            }
            if (currentElement.getName().equals("rbs-xml-info")) {
                List children = currentElement.getChildren();
                Element element = (Element)children.get(0);
                bookClassObject.setRBSXMLInfo((Element)element.clone());
                continue;
            }
            if (currentElement.getName().equals("rights-assignment")) {
                if (currentElement.getChildren().isEmpty()) continue;
                List raChildren = currentElement.getChildren();
                String attrName = null;
                Vector<String> privStrings = new Vector<String>();
                for (int j2 = 0; j2 < raChildren.size(); ++j2) {
                    Element raElement = (Element)raChildren.get(j2);
                    if (raElement.getName().equals("attribute-name")) {
                        attrName = raElement.getTextTrim();
                    }
                    if (raElement.getName().equals("privilege")) {
                        privStrings.add(raElement.getTextTrim());
                    }
                    if (!raElement.getName().equals("flag")) continue;
                    privStrings.add(raElement.getTextTrim());
                }
                long entryRights = 0L;
                if (attrName.equals("[Entry Rights]")) {
                    for (int k = 0; k < privStrings.size(); ++k) {
                        String str = (String)privStrings.elementAt(k);
                        if (str.equals("Supervisor")) {
                            bookClassObject.addAttribute("[Supervisor Object]");
                            entryRights |= 0x10L;
                        }
                        if (str.equals("Create")) {
                            bookClassObject.addAttribute("[Create Object]");
                            entryRights |= 3L;
                        }
                        if (str.equals("Delete")) {
                            bookClassObject.addAttribute("[Delete Object]");
                            entryRights |= 5L;
                        }
                        if (str.equals("Rename")) {
                            bookClassObject.addAttribute("[Rename Object]");
                            entryRights |= 9L;
                        }
                        if (str.equals("Self")) {
                            bookClassObject.addAttribute("Self");
                            entryRights |= Integer.MIN_VALUE;
                        }
                        if (!str.equals("Browse")) continue;
                        bookClassObject.addAttribute("[Browse Object]");
                        entryRights |= 1L;
                    }
                } else {
                    RBSRights rights;
                    Object[] strings = new String[privStrings.size()];
                    privStrings.copyInto(strings);
                    bookClassObject.addAttribute(attrName);
                    if (this.isNVDS) {
                        rights = new RBSNVDSRights("", "", "", "", attrName, 0L, (String[])strings);
                        bookClassObject.addRightsAssignment(rights);
                    } else {
                        rights = new RBSRights("", attrName, (String[])strings);
                        bookClassObject.addRightsAssignment(rights);
                    }
                }
                if (entryRights <= 0L) continue;
                if (this.isNVDS) {
                    RBSNVDSRights rights = new RBSNVDSRights("", "", "", "", "[Entry Rights]", 0L, entryRights);
                    bookClassObject.addRightsAssignment((RBSRights)rights);
                    continue;
                }
                RBSRights rights = new RBSRights("", "[Entry Rights]", entryRights);
                bookClassObject.addRightsAssignment(rights);
                continue;
            }
            if (currentElement.getName().equals("check-for-update")) {
                bookClassObject.setCheckForUpdate(currentElement.getTextTrim());
                continue;
            }
            if (currentElement.getName().equals("auth-assignment")) {
                bookClassObject.addAuthAssignmentElement((Element)currentElement.clone());
                continue;
            }
            bookClassObject.setExtraParamData(currentElement.getName(), currentElement.getTextTrim());
        }
        this.moduleClassObject.addBook(bookClassObject);
    }

    private void bookAddOnElementData(Element bookAddOnElement) {
        List bookAddOnChildren = bookAddOnElement.getChildren();
        BookAddOnClassObject bookAddOnClassObject = new BookAddOnClassObject(this.m_ns);
        for (int i = 0; i < bookAddOnChildren.size(); ++i) {
            Element currentElement = (Element)bookAddOnChildren.get(i);
            if (currentElement.getName().equals("book-id")) {
                bookAddOnClassObject.setName(currentElement.getTextTrim());
                continue;
            }
            if (currentElement.getName().equals("object-type-name")) {
                bookAddOnClassObject.addObjectClassType(currentElement.getTextTrim());
                continue;
            }
            if (!currentElement.getName().equals("page-assignment")) continue;
            bookAddOnClassObject.addPage(currentElement.getTextTrim());
            String[] pages = this.moduleClassObject.getPageList();
            boolean found = false;
            if (pages != null) {
                for (int j = 0; j < pages.length; ++j) {
                    if (!pages[j].equals(currentElement.getTextTrim())) continue;
                    found = true;
                    break;
                }
            }
            if (found) continue;
            PageClassObject pageClassObject = new PageClassObject(this.m_ns);
            pageClassObject.setName(currentElement.getTextTrim());
            this.moduleClassObject.addPage(pageClassObject);
        }
        this.moduleClassObject.addAddOnBook(bookAddOnClassObject);
    }

    private boolean elementSupportsAuthenticator(Element element) {
        boolean value = false;
        Element authAssignmentElement = element.getChild("auth-assignment");
        if (authAssignmentElement != null) {
            List valueList;
            Element nameElement;
            Element settingElement;
            Element idElement = authAssignmentElement.getChild("id");
            if (idElement != null && idElement.getTextTrim().equalsIgnoreCase("dir") && (settingElement = authAssignmentElement.getChild("setting")) != null && (nameElement = settingElement.getChild("name")) != null && nameElement.getTextTrim().equalsIgnoreCase("system") && (valueList = settingElement.getChildren("value")) != null) {
                for (int i = 0; i < valueList.size(); ++i) {
                    Element valueElement = (Element)valueList.get(i);
                    if (!valueElement.getTextTrim().equalsIgnoreCase(this.authName)) continue;
                    value = true;
                    break;
                }
            }
        } else if (this.authName.equalsIgnoreCase("eDir")) {
            value = true;
        }
        return value;
    }
}

