/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw.xmlinfos;

import com.novell.emframe.fw.xmlinfos.BookClassObject;
import com.novell.emframe.fw.xmlinfos.ModuleClassObject;
import com.novell.emframe.fw.xmlinfos.PageClassObject;
import com.novell.emframe.fw.xmlinfos.RoleClassObject;
import com.novell.emframe.fw.xmlinfos.TaskClassObject;
import com.novell.rbs.RBSRights;
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.StringTokenizer;
import java.util.Vector;

public class XMLFileWriter {
    public static final String NEW_LINE = "";

    public String getString(ModuleClassObject moduleClassObject) {
        StringBuffer stringBuffer = new StringBuffer();
        Vector xmlData = this.getXLMFormattedData(moduleClassObject);
        for (int i = 0; i < xmlData.size(); ++i) {
            stringBuffer.append((String)xmlData.elementAt(i));
        }
        return stringBuffer.toString();
    }

    public boolean writeFile(String filePath, ModuleClassObject moduleClassObject) throws IOException {
        Vector xmlData = this.getXLMFormattedData(moduleClassObject);
        File file = new File(filePath);
        if (file.exists()) {
            file.delete();
        }
        FileOutputStream fileOutput = new FileOutputStream(file);
        DataOutputStream dataOutput = new DataOutputStream(fileOutput);
        PrintWriter writer = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(dataOutput)), true);
        for (int i = 0; i < xmlData.size(); ++i) {
            writer.println((String)xmlData.elementAt(i));
        }
        dataOutput.close();
        return true;
    }

    public void writeTempFile(File file, ModuleClassObject moduleClassObject) throws IOException {
        Vector xmlData = this.getXLMFormattedData(moduleClassObject);
        FileOutputStream fileOutput = new FileOutputStream(file);
        DataOutputStream dataOutput = new DataOutputStream(fileOutput);
        PrintWriter writer = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(dataOutput)), true);
        for (int i = 0; i < xmlData.size(); ++i) {
            writer.println((String)xmlData.elementAt(i));
        }
        dataOutput.close();
    }

    public Vector getXLMFormattedData(ModuleClassObject moduleClassObject) {
        Vector<String> xmlData = new Vector<String>();
        xmlData.addElement("<install>");
        String[] moduleData = this.getModuleXMLFormattedData(moduleClassObject);
        for (int i = 0; i < moduleData.length; ++i) {
            xmlData.addElement(moduleData[i]);
        }
        String[] roleData = this.getRoleXMLFormattedData(moduleClassObject);
        for (int i = 0; i < roleData.length; ++i) {
            xmlData.addElement(roleData[i]);
        }
        String[] taskData = this.getTaskXMLFormattedData(moduleClassObject);
        for (int i = 0; i < taskData.length; ++i) {
            xmlData.addElement(taskData[i]);
        }
        String[] bookData = this.getBookXMLFormattedData(moduleClassObject);
        for (int i = 0; i < bookData.length; ++i) {
            xmlData.addElement(bookData[i]);
        }
        xmlData.addElement("</install>");
        return xmlData;
    }

    public String[] getModuleXMLFormattedData(ModuleClassObject moduleClassObject) {
        Vector<String> module = new Vector<String>();
        module.addElement("    <module>");
        if (moduleClassObject.getModuleName().length() > 0) {
            module.addElement("        <id>" + moduleClassObject.getModuleName() + "</id>" + NEW_LINE);
        }
        if (moduleClassObject.getVersion().length() > 0) {
            module.addElement("        <version>" + moduleClassObject.getVersion() + "</version>" + NEW_LINE);
        }
        if (moduleClassObject.getResourceBundle().length() > 0) {
            module.addElement("        <resource-properties-file>" + moduleClassObject.getResourceBundle() + "</resource-properties-file>" + NEW_LINE);
        }
        if (moduleClassObject.getDescData().length() > 0) {
            module.addElement("        <description>" + moduleClassObject.getDescData() + "</description>" + NEW_LINE);
        }
        module.addElement("    </module>");
        Object[] elements = new String[module.size()];
        module.copyInto(elements);
        return elements;
    }

    public String[] getTaskXMLFormattedData(ModuleClassObject moduleClassObject) {
        Vector<String> task = new Vector<String>();
        for (int i = 0; i < moduleClassObject.getTaskCount(); ++i) {
            String[] roleList;
            RBSRights[] attrList;
            StringTokenizer stringTokenizer;
            TaskClassObject taskClassObject = moduleClassObject.getTask(i);
            String taskType = taskClassObject.getType();
            if (taskType.equals("urlTask")) {
                task.addElement("    <url-task>");
            } else {
                task.addElement("    <task>");
            }
            if (taskClassObject.getName().length() > 0) {
                task.addElement("        <id>" + taskClassObject.getName() + "</id>" + NEW_LINE);
            }
            if (taskClassObject.getVersion().length() > 0) {
                task.addElement("        <version>" + taskClassObject.getVersion() + "</version>" + NEW_LINE);
            }
            if (taskClassObject.getRequiredVersion().length() > 0) {
                task.addElement("        <required-version>" + taskClassObject.getRequiredVersion() + "</required-version>" + NEW_LINE);
            }
            if (taskClassObject.getExpiredVersion().length() > 0) {
                task.addElement("        <expired-version>" + taskClassObject.getExpiredVersion() + "</expired-version>" + NEW_LINE);
            }
            if (taskClassObject.getType().length() > 0) {
                task.addElement("        <type>" + taskClassObject.getType() + "</type>" + NEW_LINE);
            }
            if (taskType.equals("urlTask")) {
                if (taskClassObject.getClassPath().length() > 0) {
                    task.addElement("        <url>url:" + taskClassObject.getClassPath() + "</url>" + NEW_LINE);
                }
            } else if (taskClassObject.getClassPath().length() > 0) {
                task.addElement("        <class-name>" + taskClassObject.getClassPath() + "</class-name>" + NEW_LINE);
            }
            if (taskClassObject.getMergeTemplateName().length() > 0) {
                task.addElement("        <merge-template>" + taskClassObject.getMergeTemplateName() + "</merge-template>" + NEW_LINE);
            }
            if (taskClassObject.getErrorTemplateName().length() > 0) {
                task.addElement("        <error-template>" + taskClassObject.getErrorTemplateName() + "</error-template>" + NEW_LINE);
            }
            if (taskClassObject.getOrder().length() > 0) {
                task.addElement("        <order>" + taskClassObject.getOrder() + "</order>" + NEW_LINE);
            }
            if (taskClassObject.getMiscData().length() > 0 && (stringTokenizer = new StringTokenizer(taskClassObject.getMiscData(), ";")).countTokens() > 0) {
                String[] str = new String[stringTokenizer.countTokens()];
                int c1 = 0;
                while (stringTokenizer.hasMoreTokens()) {
                    str[c1] = stringTokenizer.nextToken();
                    ++c1;
                }
                for (int j = 0; j < str.length; ++j) {
                    StringTokenizer equalTokenizer = new StringTokenizer(str[j], "=");
                    if (equalTokenizer.countTokens() != 2) continue;
                    String[] strE = new String[2];
                    int c2 = 0;
                    while (equalTokenizer.hasMoreTokens()) {
                        strE[c2] = equalTokenizer.nextToken();
                        ++c2;
                    }
                    task.addElement("        <url-param>");
                    task.addElement("            <param-key>" + strE[0] + "</param-key>" + NEW_LINE);
                    task.addElement("            <param-value>" + strE[1] + "</param-value>" + NEW_LINE);
                    task.addElement("        </url-param>");
                }
            }
            if (taskClassObject.getDescData().length() > 0) {
                task.addElement("        <description>" + taskClassObject.getDescData() + "</description>" + NEW_LINE);
            }
            if (taskClassObject.getDescKeyData().length() > 0) {
                task.addElement("        <description-key>" + taskClassObject.getDescKeyData() + "</description-key>" + NEW_LINE);
            }
            if (taskClassObject.getResourceBundle().length() > 0) {
                task.addElement("        <resource-properties-file>" + taskClassObject.getResourceBundle() + "</resource-properties-file>" + NEW_LINE);
            }
            if (taskClassObject.getDisplayNameKey().length() > 0) {
                task.addElement("        <display-name-key>" + taskClassObject.getDisplayNameKey() + "</display-name-key>" + NEW_LINE);
            }
            if ((attrList = taskClassObject.getRights()) != null) {
                for (int j = 0; j < attrList.length; ++j) {
                    task.addElement("        <rights-assignment>");
                    task.addElement("            <attribute-name>" + attrList[j].getProtectedAttrName() + "</attribute-name>" + NEW_LINE);
                    String[] privileges = attrList[j].convertLongToPrivilegeStrings();
                    if (privileges != null) {
                        for (int k = 0; k < privileges.length; ++k) {
                            task.addElement("            <privilege>" + privileges[k] + "</privilege>" + NEW_LINE);
                        }
                    }
                    task.addElement("        </rights-assignment>");
                }
            }
            if ((roleList = taskClassObject.getRoleList()) != null) {
                for (int j = 0; j < roleList.length; ++j) {
                    task.addElement("        <role-assignment>" + roleList[j] + "</role-assignment>" + NEW_LINE);
                }
            }
            if (taskType.equals("urlTask")) {
                task.addElement("    </url-task>");
                continue;
            }
            task.addElement("    </task>");
        }
        Object[] elements = new String[task.size()];
        task.copyInto(elements);
        return elements;
    }

    public String[] getPageXMLFormattedData(ModuleClassObject moduleClassObject) {
        Vector<String> page = new Vector<String>();
        for (int i = 0; i < moduleClassObject.getPageCount(); ++i) {
            PageClassObject pageClassObject = moduleClassObject.getPage(i);
            page.addElement("    <page>");
            if (pageClassObject.getName().length() > 0) {
                page.addElement("        <id>" + pageClassObject.getName() + "</id>" + NEW_LINE);
            }
            page.addElement("    </page>");
        }
        Object[] elements = new String[page.size()];
        page.copyInto(elements);
        return elements;
    }

    public String[] getRoleXMLFormattedData(ModuleClassObject moduleClassObject) {
        Vector<String> role = new Vector<String>();
        for (int i = 0; i < moduleClassObject.getRoleCount(); ++i) {
            StringTokenizer stringTokenizer;
            RoleClassObject roleClassObject = moduleClassObject.getRole(i);
            role.addElement("    <role>");
            if (roleClassObject.getName().length() > 0) {
                role.addElement("        <id>" + roleClassObject.getName() + "</id>" + NEW_LINE);
            }
            if (roleClassObject.getVersion().length() > 0) {
                role.addElement("        <version>" + roleClassObject.getVersion() + "</version>" + NEW_LINE);
            }
            if (roleClassObject.getExpiredVersion().length() > 0) {
                role.addElement("        <expired-version>" + roleClassObject.getExpiredVersion() + "</expired-version>" + NEW_LINE);
            }
            if (roleClassObject.getDisplayNameKey().length() > 0) {
                role.addElement("        <display-name-key>" + roleClassObject.getDisplayNameKey() + "</display-name-key>" + NEW_LINE);
            }
            if (roleClassObject.getDescData().length() > 0) {
                role.addElement("        <description>" + roleClassObject.getDescData() + "</description>" + NEW_LINE);
            }
            if (roleClassObject.getDescKeyData().length() > 0) {
                role.addElement("        <description-key>" + roleClassObject.getDescKeyData() + "</description-key>" + NEW_LINE);
            }
            if (roleClassObject.getOrder().length() > 0) {
                role.addElement("        <order>" + roleClassObject.getOrder() + "</order>" + NEW_LINE);
            }
            if (roleClassObject.getMiscData().length() > 0 && (stringTokenizer = new StringTokenizer(roleClassObject.getMiscData(), ";")).countTokens() > 0) {
                String[] str = new String[stringTokenizer.countTokens()];
                int c1 = 0;
                while (stringTokenizer.hasMoreTokens()) {
                    str[c1] = stringTokenizer.nextToken();
                    ++c1;
                }
                for (int j = 0; j < str.length; ++j) {
                    StringTokenizer equalTokenizer = new StringTokenizer(str[j], "=");
                    if (equalTokenizer.countTokens() != 2) continue;
                    String[] strE = new String[2];
                    int c2 = 0;
                    while (equalTokenizer.hasMoreTokens()) {
                        strE[c2] = equalTokenizer.nextToken();
                        ++c2;
                    }
                    role.addElement("        <url-param>");
                    role.addElement("            <param-key>" + strE[0] + "</param-key>" + NEW_LINE);
                    role.addElement("            <param-value>" + strE[1] + "</param-value>" + NEW_LINE);
                    role.addElement("        </url-param>");
                }
            }
            if (roleClassObject.getResourceBundle().length() > 0) {
                role.addElement("        <resource-properties-file>" + roleClassObject.getResourceBundle() + "</resource-properties-file>" + NEW_LINE);
            }
            role.addElement("    </role>");
        }
        Object[] elements = new String[role.size()];
        role.copyInto(elements);
        return elements;
    }

    public String[] getBookXMLFormattedData(ModuleClassObject moduleClassObject) {
        Vector<String> book = new Vector<String>();
        for (int i = 0; i < moduleClassObject.getBookCount(); ++i) {
            String[] roleList;
            String[] pageList;
            String[] objectType;
            int j;
            StringTokenizer stringTokenizer;
            BookClassObject bookClassObject = moduleClassObject.getBook(i);
            book.addElement("    <book>");
            if (bookClassObject.getName().length() > 0) {
                book.addElement("        <id>" + bookClassObject.getName() + "</id>" + NEW_LINE);
            }
            if (bookClassObject.getVersion().length() > 0) {
                book.addElement("        <version>" + bookClassObject.getVersion() + "</version>" + NEW_LINE);
            }
            if (bookClassObject.getClassPath().length() > 0) {
                book.addElement("        <class-name>" + bookClassObject.getClassPath() + "</class-name>" + NEW_LINE);
            }
            if (bookClassObject.getMiscData().length() > 0 && (stringTokenizer = new StringTokenizer(bookClassObject.getMiscData(), ";")).countTokens() > 0) {
                String[] str = new String[stringTokenizer.countTokens()];
                int c1 = 0;
                while (stringTokenizer.hasMoreTokens()) {
                    str[c1] = stringTokenizer.nextToken();
                    ++c1;
                }
                for (j = 0; j < str.length; ++j) {
                    StringTokenizer equalTokenizer = new StringTokenizer(str[j], "=");
                    if (equalTokenizer.countTokens() != 2) continue;
                    String[] strE = new String[2];
                    int c2 = 0;
                    while (equalTokenizer.hasMoreTokens()) {
                        strE[c2] = equalTokenizer.nextToken();
                        ++c2;
                    }
                    book.addElement("        <url-param>");
                    book.addElement("            <param-key>" + strE[0] + "</param-key>" + NEW_LINE);
                    book.addElement("            <param-value>" + strE[1] + "</param-value>" + NEW_LINE);
                    book.addElement("        </url-param>");
                }
            }
            if (bookClassObject.getDescData().length() > 0) {
                book.addElement("        <description>" + bookClassObject.getDescData() + "</description>" + NEW_LINE);
            }
            if (bookClassObject.getDescKeyData().length() > 0) {
                book.addElement("        <description-key>" + bookClassObject.getDescKeyData() + "</description-key>" + NEW_LINE);
            }
            if (bookClassObject.getResourceBundle().length() > 0) {
                book.addElement("        <resource-properties-file>" + bookClassObject.getResourceBundle() + "</resource-properties-file>" + NEW_LINE);
            }
            if (bookClassObject.getDisplayNameKey().length() > 0) {
                book.addElement("        <display-name-key>" + bookClassObject.getDisplayNameKey() + "</display-name-key>" + NEW_LINE);
            }
            if (bookClassObject.getOrder().length() > 0) {
                book.addElement("        <order>" + bookClassObject.getOrder() + "</order>" + NEW_LINE);
            }
            if ((objectType = bookClassObject.getObjectClassType()).length > 0) {
                for (int j2 = 0; j2 < objectType.length; ++j2) {
                    book.addElement("        <object-type-name>" + objectType[j2] + "</object-type-name>" + NEW_LINE);
                }
            }
            if ((pageList = bookClassObject.getPageList()) != null) {
                for (int j3 = 0; j3 < pageList.length; ++j3) {
                    book.addElement("        <page-assignment>" + pageList[j3] + "</page-assignment>" + NEW_LINE);
                }
            }
            if ((roleList = bookClassObject.getRoleList()) != null) {
                for (j = 0; j < roleList.length; ++j) {
                    book.addElement("        <role-assignment>" + roleList[j] + "</role-assignment>" + NEW_LINE);
                }
            }
            book.addElement("    </book>");
        }
        Object[] elements = new String[book.size()];
        book.copyInto(elements);
        return elements;
    }
}

