/*
 * Decompiled with CFR 0.152.
 */
package com.novell.imanager.logging.naudit;

import com.novell.imanager.logging.naudit.NauditEvent;
import com.novell.imanager.logging.naudit.NauditHelper;
import com.novell.naudit.LogEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LoggingEvent;

public final class NauditAppender
extends AppenderSkeleton {
    public static final String linuxCertFilePath = "/etc/imanicert.pem";
    public static final String linuxKeyFilePath = "/etc/imanipkey.pem";
    public static final String windowsCertFilePath = "c:\\windows\\imanicert.pem";
    public static final String windowsKeyFilePath = "c:\\windows\\imanipkey.pem";
    public static final String netwareCertFilePath = "sys:\\system\\imanicert.pem";
    public static final String netwareKeyFilePath = "sys:\\system\\imanipkey.pem";
    public static final String solarisCertFilePath = "/etc/imanicert.pem";
    public static final String solarisKeyFilePath = "/etc/imanipkey.pem";
    public static final String app_name = "iManager";
    private String m_noneNauditEventId = null;
    private String m_noneNauditComponent = null;
    private LogEvent m_log = null;
    private boolean m_enableNaudit = false;
    private String m_component = null;
    private long m_eventId = 0L;
    private int m_groupId = 0;

    protected void append(LoggingEvent event) {
        LogLog.debug((String)"In NauditAppender:append");
        if (!this.m_enableNaudit) {
            LogLog.debug((String)"Naudit was not enabled");
            LogLog.debug((String)"m_enableNaudit is false");
            return;
        }
        if (this.m_log == null) {
            LogLog.debug((String)"m_log is null... Call acitbateOptions()");
            this.activateOptions();
            if (!this.m_enableNaudit) {
                return;
            }
        }
        Object o = event.getMessage();
        Level level = event.getLevel();
        if (o instanceof NauditEvent) {
            NauditEvent nEvent = (NauditEvent)o;
            Object[] params = nEvent.getParams();
            if (params == null) {
                params = NauditHelper.getParamsArray(null, null);
            }
            String component = params[0] == null ? this.m_component : (String)params[0];
            int groupId = params[3] == null ? this.m_groupId : (Integer)params[3];
            long eventId = params[1] == null ? this.m_eventId : (long)((Integer)params[1]).intValue();
            boolean success = this.m_log.LogEventExt(component, eventId, (long)(level.getSyslogEquivalent() + 1), (long)groupId, 0L, (String)params[5], params[6] == null ? 0L : (long)((Integer)params[6]).intValue(), (String)params[7], params[8] == null ? 0L : (long)((Integer)params[8]).intValue(), (String)params[9], (String)params[10], (String)params[11], (String)params[12], params[13] == null ? 0L : (long)((Integer)params[13]).intValue(), params[14] == null ? 0L : (long)((Integer)params[14]).intValue(), params[15] == null ? 0L : (long)((Integer)params[15]).intValue(), params[16] == null ? 0L : (long)((Integer)params[16]).intValue(), params[17] == null ? 0L : (long)((Integer)params[17]).intValue(), (byte[])params[18]);
            if (success) {
                LogLog.debug((String)"Logging to Novell Audit Success");
            } else {
                this.errorHandler.error("Logging to Novell Audit failed");
                LogLog.error((String)"Logging to Novell Audit failed");
                System.out.println("Logging to Novell Audit failed");
            }
        } else if (this.m_noneNauditComponent != null && this.m_noneNauditEventId != null) {
            String msg = event.getRenderedMessage();
            if (msg == null) {
                return;
            }
            if (this.m_log.LogEventText(this.m_noneNauditComponent, (long)Integer.parseInt(this.m_noneNauditEventId, 16), (long)level.getSyslogEquivalent(), 0L, msg, null)) {
                LogLog.debug((String)"Logging to Novell Audit Success");
            } else {
                LogLog.error((String)"Logging to Novell Audit failed");
                System.out.println("Logging to Novell Audit failed");
            }
        } else {
            LogLog.debug((String)"Not Naudit Event");
        }
    }

    public synchronized void setNoneNauditEventId(String noneNauditEventId) {
        this.m_noneNauditEventId = noneNauditEventId;
    }

    public synchronized void setNoneNauditComponent(String noneNauditComponent) {
        this.m_noneNauditComponent = noneNauditComponent;
    }

    public synchronized boolean getEnableNaudit() {
        return this.m_enableNaudit;
    }

    public synchronized void activateOptions() {
        long rv = 0L;
        System.out.println("Initializing Novell Audit...");
        File certFile = null;
        File keyFile = null;
        String sCertificate = "";
        String sKey = "";
        String osname = System.getProperty("os.name").toLowerCase();
        if (osname.indexOf("linux") != -1) {
            certFile = new File("/etc/imanicert.pem");
            keyFile = new File("/etc/imanipkey.pem");
        } else if (osname.indexOf("windows") != -1) {
            certFile = new File(windowsCertFilePath);
            keyFile = new File(windowsKeyFilePath);
        } else if (osname.indexOf("netware") != -1) {
            certFile = new File(netwareCertFilePath);
            keyFile = new File(netwareKeyFilePath);
        } else if (osname.indexOf("solaris") != -1) {
            certFile = new File("/etc/imanicert.pem");
            keyFile = new File("/etc/imanipkey.pem");
        }
        if (certFile != null && keyFile != null && certFile.exists() && keyFile.exists()) {
            sCertificate = NauditAppender.getContentFromPemFile(certFile);
            sKey = NauditAppender.getContentFromPemFile(keyFile);
        }
        if (this.m_log != null) {
            this.m_log.LogClose();
        }
        this.m_log = new LogEvent();
        if (this.m_log == null) {
            this.m_enableNaudit = false;
            this.errorHandler.error("Exception creating Novell Audit LogEvent. Disabling Novell Audit Logging.");
            LogLog.error((String)"Exception creating Novell Audit LogEvent. Disabling Novell Audit Logging.");
            System.out.println("Exception creating Novell Audit LogEvent. Disabling Novell Audit Logging.");
            return;
        }
        if (sCertificate == null || sKey == null) {
            this.m_enableNaudit = false;
            this.errorHandler.error("Novell Audit Cert and PKEY are not available");
            LogLog.error((String)"Novell Audit Cert and PKEY are not available");
            System.out.println("Novell Audit Cert and PKEY are not available");
            return;
        }
        rv = this.m_log.LogOpen(app_name, sCertificate, sKey, 0L);
        if (rv > 0L) {
            this.m_enableNaudit = false;
            this.errorHandler.error(": Exception in Novell Audit LogOpen. Error #" + Long.toString(rv));
            LogLog.error((String)(": Exception in Novell Audit LogOpen. Error #" + Long.toString(rv)));
            System.out.println(": Exception in Novell Audit LogOpen. Error #" + Long.toString(rv));
        } else {
            this.m_enableNaudit = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getContentFromPemFile(File pemFile) {
        StringBuffer contents = new StringBuffer();
        BufferedReader input = null;
        try {
            input = new BufferedReader(new FileReader(pemFile));
            String line = null;
            while ((line = input.readLine()) != null) {
                contents.append(line);
                contents.append(System.getProperty("line.separator"));
            }
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return contents.toString();
    }

    public void close() {
        if (!this.closed) {
            this.m_log.LogClose();
            this.closed = true;
        }
    }

    public boolean requiresLayout() {
        return false;
    }
}

