/*
 * Decompiled with CFR 0.152.
 */
package com.novell.imanager.logging.syslog.impl;

import com.novell.imanager.logging.syslog.impl.iManTrustManager;
import java.io.FileInputStream;
import java.io.PrintWriter;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.KeyStore;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class MessageSender {
    private boolean m_bUdp = false;
    private Socket m_socket = null;
    private DatagramSocket m_udpSocket = null;
    private InetAddress m_serverAddress = null;
    private DatagramPacket m_dataPacket = null;
    private PrintWriter m_out = null;
    private String m_protocol = "tcp";
    private SSLSocket m_sslSocket = null;

    public MessageSender(String strHostName, String strProtocol, int iPort, String keystoreFilePath, String keystorePassword) throws Exception {
        this.m_protocol = strProtocol;
        if (this.m_protocol.equalsIgnoreCase("udp")) {
            this.m_udpSocket = new DatagramSocket();
            this.m_serverAddress = InetAddress.getByName(strHostName);
            this.m_dataPacket = new DatagramPacket(new byte[1], 0, 1, this.m_serverAddress, iPort);
        } else if (this.m_protocol.equalsIgnoreCase("tcp")) {
            this.m_socket = new Socket();
            this.m_socket.bind(null);
            try {
                this.m_socket.connect(new InetSocketAddress(strHostName, iPort), 30000);
                this.m_out = new PrintWriter(this.m_socket.getOutputStream(), true);
                System.out.println("Got Printwriter as well");
            }
            catch (Exception e) {
                System.out.println("Couldn't connect to " + strHostName + ":" + iPort);
            }
        } else if (this.m_protocol.equalsIgnoreCase("ssl")) {
            KeyStore ks = KeyStore.getInstance("JKS");
            ks.load(new FileInputStream(keystoreFilePath), keystorePassword.toCharArray());
            KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
            kmf.init(ks, keystorePassword.toCharArray());
            TrustManager[] tms = new TrustManager[]{new iManTrustManager(keystoreFilePath)};
            SSLContext context = SSLContext.getInstance("TLS", "SunJSSE");
            context.init(null, tms, null);
            SSLSocketFactory sf = context.getSocketFactory();
            this.m_sslSocket = (SSLSocket)sf.createSocket();
            this.m_sslSocket.bind(null);
            try {
                this.m_sslSocket.connect(new InetSocketAddress(strHostName, iPort), 30000);
                this.m_out = new PrintWriter(this.m_sslSocket.getOutputStream(), true);
                if (this.m_out != null) {
                    System.out.println("Setup ssl connection succesfully");
                }
            }
            catch (Exception e) {
                System.out.println("Couldn't connect to " + strHostName + ":" + iPort);
            }
        }
    }

    public void close() throws Exception {
        if (this.m_out != null) {
            this.m_out.close();
            this.m_out = null;
        }
        if (this.m_socket != null) {
            this.m_socket.close();
            this.m_socket = null;
        }
        if (this.m_udpSocket != null) {
            this.m_udpSocket.close();
            this.m_udpSocket = null;
        }
    }

    private int getHexValue(char[] cArray, int iStartPos) {
        int iHexVal = 0;
        for (int iLoop = 0; iLoop < 4; ++iLoop) {
            char c = cArray[iLoop + iStartPos];
            if (c >= '0' && c <= '9') {
                iHexVal <<= 4;
                iHexVal += c - 48;
                continue;
            }
            if (c >= 'a' && c <= 'f') {
                iHexVal <<= 4;
                iHexVal += c - 97 + 10;
                continue;
            }
            if (c >= 'A' && c <= 'F') {
                iHexVal <<= 4;
                iHexVal += c - 65 + 10;
                continue;
            }
            return -1;
        }
        return iHexVal;
    }

    private String checkForUnicode(String strLine) {
        int iPos = 0;
        char[] cArray = strLine.toCharArray();
        StringBuilder s = new StringBuilder(cArray.length);
        while (iPos < cArray.length) {
            int iCharHex;
            char c = cArray[iPos];
            ++iPos;
            if (c != '\\') {
                s.append(c);
                continue;
            }
            if (iPos >= cArray.length) {
                s.append(c);
                break;
            }
            c = cArray[iPos];
            if ((c == 'u' || c == 'U') && ++iPos + 4 <= cArray.length && (iCharHex = this.getHexValue(cArray, iPos)) != -1) {
                s.append((char)iCharHex);
                iPos += 4;
                continue;
            }
            s.append('\\');
            s.append(c);
        }
        return s.toString();
    }

    public void sendMessage(String strLine) throws Exception {
        if (strLine.length() > 0 && strLine.charAt(0) != '#') {
            String strOut = this.checkForUnicode(strLine);
            if (this.m_out != null) {
                this.m_out.println(strOut);
            } else {
                this.m_dataPacket.setData(strOut.getBytes("UTF-8"));
                this.m_udpSocket.send(this.m_dataPacket);
            }
        }
    }
}

