/*
 * Decompiled with CFR 0.152.
 */
package com.novell.imanager.logging.syslog.impl;

import java.io.Serializable;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;

public final class UUID
implements Serializable {
    static final long serialVersionUID = 3730887618280297000L;
    private static final int LOMASK = 15;
    private static final int BYTELEN = 16;
    private static final SecureRandom RANDOM;
    private byte[] m_bytes;

    private static byte loNibble(byte b) {
        return (byte)(b & 0xF);
    }

    private static byte hiNibble(byte b) {
        return (byte)(b >> 4 & 0xF);
    }

    private static void insertBytes(long val, int nbytes, byte[] buf, int pos) {
        long byteMask = 255L << (nbytes - 1) * 8;
        for (int i = 0; i < nbytes; ++i) {
            buf[pos + i] = (byte)((val & byteMask) >> (nbytes - i - 1) * 8);
            byteMask >>= 8;
        }
    }

    private static long extractBytes(byte[] buf, int pos, int nbytes) {
        long val = 0L;
        for (int i = 0; i < nbytes; ++i) {
            val <<= 8;
            val |= (long)(buf[pos + i] & 0xFF);
        }
        return val;
    }

    private static String toString(byte[] bytes) {
        if (16 != bytes.length) {
            return "** Bad UUID Format/Value **";
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < 16; ++i) {
            buf.append(Integer.toHexString(UUID.hiNibble(bytes[i])));
            buf.append(Integer.toHexString(UUID.loNibble(bytes[i])));
        }
        return buf.toString();
    }

    public static UUID generate() {
        byte[] res = null;
        res = new byte[16];
        RANDOM.nextBytes(res);
        short timeHiAndVer = (short)UUID.extractBytes(res, 6, 2);
        timeHiAndVer = (short)(timeHiAndVer & 0xFFF | 0x4000);
        UUID.insertBytes(timeHiAndVer, 2, res, 6);
        short clockSeqAndVariant = (short)UUID.extractBytes(res, 8, 2);
        clockSeqAndVariant = (short)(clockSeqAndVariant & 0x3FFF | 0x8000);
        UUID.insertBytes(clockSeqAndVariant, 2, res, 8);
        return new UUID(res);
    }

    private UUID(byte[] bytes) {
        this.m_bytes = bytes;
    }

    public String toString() {
        return UUID.toString(this.m_bytes);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof UUID)) {
            return false;
        }
        UUID uuid = (UUID)obj;
        if (uuid != this) {
            for (int i = 0; i < 16; ++i) {
                if (uuid.m_bytes[i] == this.m_bytes[i]) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int hash = 0;
        for (int i = 0; i < 16; ++i) {
            hash = hash * 33 + this.m_bytes[i];
        }
        return hash;
    }

    static {
        SecureRandom ran = null;
        try {
            ran = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException ex) {
            ran = new SecureRandom();
        }
        RANDOM = ran;
    }
}

