/*
 * Decompiled with CFR 0.152.
 */
package com.novell.imanager.logging.syslog.impl;

import com.novell.imanager.logging.naudit.NauditEvent;
import com.novell.imanager.logging.naudit.NauditHelper;
import com.novell.imanager.logging.syslog.impl.MessageSender;
import com.novell.imanager.logging.syslog.impl.iManXDasNauditHelper;
import java.util.StringTokenizer;
import org.apache.log4j.net.SyslogAppender;
import org.apache.log4j.spi.LoggingEvent;

public class iManSyslogAppender
extends SyslogAppender {
    private static String DEFAULT_SYSLOG_PROTOCOL = "udp";
    private static String DEFAULT_SYSLOG_PORT = "1443";
    private String m_component = null;
    private int m_eventId = 0;
    private String m_syslogProtocol = DEFAULT_SYSLOG_PROTOCOL;
    private String m_syslogSslKeystoreFile;
    private String m_syslogSslKeystorePassword;
    private MessageSender m_sender;

    public String getSyslogProtocol() {
        return this.m_syslogProtocol;
    }

    public void setSyslogProtocol(String syslogProtocol) {
        this.m_syslogProtocol = syslogProtocol;
    }

    public String getSyslogSslKeystoreFile() {
        return this.m_syslogSslKeystoreFile;
    }

    public void setSyslogSslKeystoreFile(String filePath) {
        this.m_syslogSslKeystoreFile = filePath;
    }

    public String getSyslogSslKeystorePassword() {
        return this.m_syslogSslKeystorePassword;
    }

    public void setSyslogSslKeystorePassword(String password) {
        this.m_syslogSslKeystorePassword = password;
    }

    public void activateOptions() {
        String host;
        System.out.println("Initializing Syslog Appender...");
        System.out.println("Syslog Protocol -->" + this.getSyslogProtocol() + ", Syslog Host --> " + this.getSyslogHost());
        String port = DEFAULT_SYSLOG_PORT;
        StringTokenizer tokenizer = new StringTokenizer(this.getSyslogHost(), ":");
        if (tokenizer.countTokens() == 1) {
            host = tokenizer.nextToken();
        } else if (tokenizer.countTokens() == 2) {
            host = tokenizer.nextToken();
            port = tokenizer.nextToken();
        } else {
            System.out.println("Can't configure Syslog Appender, Incorrect Host Information");
            return;
        }
        try {
            this.m_sender = new MessageSender(host, this.getSyslogProtocol(), Integer.parseInt(port), this.getSyslogSslKeystoreFile(), this.getSyslogSslKeystorePassword());
        }
        catch (Exception e) {
            System.out.println("Error while configuring Syslog Appender, " + e.getMessage());
        }
    }

    public synchronized void doAppend(LoggingEvent event) {
        Object o = event.getMessage();
        if (o instanceof NauditEvent) {
            NauditEvent nEvent = (NauditEvent)o;
            Object[] params = nEvent.getParams();
            if (params == null) {
                params = NauditHelper.getParamsArray(null, null);
            }
            String component = params[0] == null ? this.m_component : (String)params[0];
            int eventId = params[1] == null ? this.m_eventId : (Integer)params[1];
            String xdasEvent = iManXDasNauditHelper.getXDasV2Event(eventId, component, params);
            xdasEvent = this.addSourceInfo(xdasEvent);
            if (this.m_sender != null) {
                try {
                    this.m_sender.sendMessage("iManager: " + event.getLevel() + " " + xdasEvent);
                }
                catch (Exception e) {
                    System.out.println("Error while sending Syslog Event" + e.getMessage());
                }
            }
        }
    }

    private String addSourceInfo(String xdasEvent) {
        String sourceName = "{\"Source\" : \"iManager\",";
        if (xdasEvent != null) {
            xdasEvent = xdasEvent.substring(1);
            xdasEvent = sourceName + xdasEvent;
        }
        return xdasEvent;
    }

    public void append(LoggingEvent event) {
    }
}

