/*
 * Decompiled with CFR 0.152.
 */
package com.novell.imanager.logging.syslog.impl;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.security.KeyStore;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class iManTrustManager
implements X509TrustManager {
    private X509TrustManager pkixTrustManager;

    public iManTrustManager(String path) throws Exception {
        FileInputStream keyStoreIStream = null;
        try {
            keyStoreIStream = new FileInputStream(path);
        }
        catch (FileNotFoundException e) {
            keyStoreIStream = null;
        }
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        if (keyStoreIStream != null) {
            keyStoreIStream.close();
            keyStoreIStream = null;
        }
        keyStore.load(keyStoreIStream, "novell".toCharArray());
        TrustManagerFactory tmf = TrustManagerFactory.getInstance("PKIX");
        tmf.init(keyStore);
        TrustManager[] tms = tmf.getTrustManagers();
        for (int i = 0; i < tms.length; ++i) {
            if (!(tms[i] instanceof X509TrustManager)) continue;
            this.pkixTrustManager = (X509TrustManager)tms[i];
            return;
        }
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        try {
            this.pkixTrustManager.checkClientTrusted(chain, authType);
        }
        catch (CertificateException certificateException) {
            // empty catch block
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        try {
            this.pkixTrustManager.checkServerTrusted(chain, authType);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.pkixTrustManager.getAcceptedIssuers();
    }
}

