/*
 * Decompiled with CFR 0.152.
 */
package com.novell.imanager.logging.syslog.impl;

import com.novell.imanager.logging.syslog.impl.UUID;
import com.novell.imanager.logging.syslog.impl.iManEvent;
import com.novell.imanager.logging.syslog.util.JavaUtil;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import org.apache.log4j.Level;
import org.apache.log4j.spi.LoggingEvent;

public class iManXDasNauditHelper {
    public static final String APP_NAME = "iManager";
    private static final int LOGEVENT_SYSTEM_STARTED = 0x150001;
    private static final int LOGEVENT_SYSTEM_SHUTDOWN = 1376258;
    private static final int LOGEVENT_PORTAL_AUTHENTICATION_SUCCEEDED = 1376259;
    private static final int LOGEVENT_IMANAGER_AUTHENTICATION_SUCCEEDED = 1376260;
    private static final int LOGEVENT_PORTAL_AUTHENTICATION_FAILED = 0x150005;
    private static final int LOGEVENT_IMANAGER_AUTHENTICATION_FAILED = 1376262;
    private static final int LOGEVENT_PORTAL_LOGOUT = 1376263;
    private static final int LOGEVENT_IMANAGER_LOGOUT = 1376264;
    private static final int LOGEVENT_MODULE_INSTALL = 1376265;
    private static final int LOGEVENT_MODULE_INSTALL_FAILED = 0x150010;
    private static final int LOGEVENT_FAILED_SSL_CONNECTION = 0x150011;
    private static final int LOGEVENT_SYSTEM_CONFIGURATION_CHANGED = 1376274;
    private static final int LOGEVENT_AUTHORIZED_USER_ADDED = 1376275;
    private static final int LOGEVENT_AUTHORIZED_USER_REMOVED = 1376276;
    private static final int LOGEVENT_MODULE_UPLOAD = 0x150015;
    private static final String CID_SEPARATOR = "#";

    private iManXDasNauditHelper() {
    }

    static String getXDasEventNumber(int eventID) {
        switch (eventID) {
            case 0x150001: {
                return "0.0.9.0";
            }
            case 1376258: {
                return "0.0.9.1";
            }
            case 1376259: {
                return "0.0.11.0";
            }
            case 1376260: {
                return "0.0.11.0";
            }
            case 0x150005: {
                return "0.0.11.6";
            }
            case 1376262: {
                return "0.0.11.6";
            }
            case 1376263: {
                return "0.0.11.1";
            }
            case 1376264: {
                return "0.0.11.1";
            }
            case 1376265: {
                return "0.0.3.0";
            }
            case 0x150010: {
                return "0.0.4.1";
            }
            case 0x150011: {
                return "0.0.11.1";
            }
            case 1376274: {
                return "0.0.3.3";
            }
            case 1376275: {
                return "0.0.8.0";
            }
            case 1376276: {
                return "0.0.8.1";
            }
            case 0x150015: {
                return "0.0.3.0";
            }
        }
        return "0";
    }

    static String getXDasOutcome(int eventID) {
        switch (eventID) {
            case 0x150001: {
                return "0";
            }
            case 1376258: {
                return "0";
            }
            case 1376259: {
                return "0";
            }
            case 1376260: {
                return "0";
            }
            case 0x150005: {
                return "1";
            }
            case 1376262: {
                return "1";
            }
            case 1376263: {
                return "0";
            }
            case 1376264: {
                return "0";
            }
            case 1376265: {
                return "0";
            }
            case 0x150010: {
                return "1";
            }
            case 0x150011: {
                return "1";
            }
            case 1376274: {
                return "0";
            }
            case 1376275: {
                return "0";
            }
            case 1376276: {
                return "0";
            }
            case 0x150015: {
                return "0";
            }
        }
        return "0";
    }

    static String getXDasV2Event(int eventID, String component, Object[] params) {
        iManEvent.EventBuilder eBuilder = new iManEvent.EventBuilder();
        iManXDasNauditHelper.buildObserver(eventID, component, params, eBuilder);
        iManXDasNauditHelper.buildInitiator(eventID, component, params, eBuilder);
        iManXDasNauditHelper.buildTarget(eventID, component, params, eBuilder);
        iManXDasNauditHelper.buildAction(eventID, component, params, eBuilder);
        iManXDasNauditHelper.addEventGuid(eventID, component, params, eBuilder);
        iManXDasNauditHelper.addCorrelationID(eventID, component, params, eBuilder);
        eBuilder.set("$schema.$ref", "http://opengroup.org/2009/XDAS/v2");
        iManEvent eEvent = eBuilder.build();
        return eEvent.toJSON();
    }

    static String getCEFEvent(int eventID, String component, Object[] params, LoggingEvent event, int groupId) {
        iManEvent.EventBuilder eBuilder = new iManEvent.EventBuilder();
        String CEFEvent = null;
        iManEvent cefEvent = null;
        String severity = iManXDasNauditHelper.getEventLogLevel(event);
        String cefEventID = Integer.toHexString(eventID);
        String prefix = iManXDasNauditHelper.getCefMandatoryFields(component, cefEventID, severity);
        CEFEvent = iManXDasNauditHelper.buildCEFEvent(prefix, eventID, component, params, eBuilder, cefEvent, cefEventID, groupId);
        return CEFEvent;
    }

    private static String buildCEFEvent(String prefix, int eventID, String component, Object[] params, iManEvent.EventBuilder eBuilder, iManEvent cefEvent, String cefEventID, int groupId) {
        iManXDasNauditHelper.buildObserver(eventID, component, params, eBuilder);
        iManXDasNauditHelper.buildInitiator(eventID, component, params, eBuilder);
        iManXDasNauditHelper.buildTarget(eventID, component, params, eBuilder);
        iManXDasNauditHelper.buildAction(eventID, component, params, eBuilder);
        iManXDasNauditHelper.addEventGuid(eventID, component, params, eBuilder);
        iManXDasNauditHelper.addCorrelationID(eventID, component, params, eBuilder);
        cefEvent = eBuilder.build();
        Map<String, Object> cefFields = cefEvent.getMap();
        StringBuilder cefsb = new StringBuilder(prefix);
        cefsb.append(iManXDasNauditHelper.formatCEFString(cefFields));
        if (cefEvent.getActionOutcome() != null && !cefEvent.getActionOutcome().isEmpty()) {
            cefsb.append("outcome=" + (cefEvent.getActionOutcome().equals("0") ? "Success" : "Failure"));
        }
        return cefsb.toString().trim();
    }

    private static String formatCEFString(Map<String, Object> cefFields) {
        Map EntityFields;
        Map InitiatorFields;
        StringBuilder eventItems = new StringBuilder();
        if (cefFields.containsKey("Initiator") && cefFields.get("Initiator") instanceof Map && (InitiatorFields = (Map)cefFields.get("Initiator")).containsKey("Entity")) {
            EntityFields = (Map)InitiatorFields.get("Entity");
            for (Map.Entry EntityEntry : EntityFields.entrySet()) {
                if (((String)EntityEntry.getKey()).equalsIgnoreCase("SvcName") && ((String)EntityEntry.getValue()).length() > 0) {
                    eventItems.append("sourceServiceName=" + (String)EntityEntry.getValue() + " ");
                }
                if (!((String)EntityEntry.getKey()).equalsIgnoreCase("SysAddr")) continue;
                eventItems.append("src=" + (String)EntityEntry.getValue() + " ");
            }
        }
        if (cefFields.containsKey("Target") && cefFields.get("Target") instanceof Map) {
            InitiatorFields = (Map)cefFields.get("Target");
            if (InitiatorFields.containsKey("Entity")) {
                EntityFields = (Map)InitiatorFields.get("Entity");
                for (Map.Entry EntityEntry : EntityFields.entrySet()) {
                    if (((String)EntityEntry.getKey()).equalsIgnoreCase("SvcName")) {
                        eventItems.append("destinationServiceName=" + (String)EntityEntry.getValue() + " ");
                    }
                    if (!((String)EntityEntry.getKey()).equalsIgnoreCase("SvcComp")) continue;
                    eventItems.append("cs1Label=component cs1=" + (String)EntityEntry.getValue() + " ");
                }
            }
            if (InitiatorFields.containsKey("Data")) {
                EntityFields = (Map)InitiatorFields.get("Data");
                for (Map.Entry EntityEntry : EntityFields.entrySet()) {
                    if (((String)EntityEntry.getKey()).equalsIgnoreCase("MimeHint")) {
                        eventItems.append("cs2Label=MimeHint cs2=" + (String)EntityEntry.getValue() + " ");
                    }
                    if (!((String)EntityEntry.getKey()).equalsIgnoreCase("host")) continue;
                    eventItems.append("cs6Label=host cs6=" + (String)EntityEntry.getValue() + " ");
                }
            }
        }
        if (cefFields.containsKey("Action") && cefFields.get("Action") instanceof Map && (InitiatorFields = (Map)cefFields.get("Action")).containsKey("Event")) {
            EntityFields = (Map)InitiatorFields.get("Event");
            for (Map.Entry EntityEntry : EntityFields.entrySet()) {
                if (((String)EntityEntry.getKey()).equalsIgnoreCase("ID")) {
                    eventItems.append("cs3Label=eventID cs3=" + (String)EntityEntry.getValue() + " ");
                }
                if (((String)EntityEntry.getKey()).equalsIgnoreCase("Name")) {
                    eventItems.append("cs4Label=eventName cs4=" + (String)EntityEntry.getValue() + " ");
                }
                if (((String)EntityEntry.getKey()).equalsIgnoreCase("SubEvent")) {
                    eventItems.append("flexString1Label=SubEvent flexString1=" + (String)EntityEntry.getValue() + " ");
                }
                if (!((String)EntityEntry.getKey()).equalsIgnoreCase("CorrelationID")) continue;
                eventItems.append("cs5Label=CorrelationID cs5=" + (String)EntityEntry.getValue() + " ");
            }
        }
        return eventItems.toString();
    }

    private static String getCefMandatoryFields(String component, String cefEventID, String severity) {
        StringBuffer cefPrefix = new StringBuffer();
        cefPrefix.append("CEF:0").append("|");
        cefPrefix.append("NetIQ").append("|");
        cefPrefix.append(APP_NAME).append("|");
        cefPrefix.append("3.1.0").append("|");
        cefPrefix.append("CEF").append(cefEventID).append("|");
        cefPrefix.append(component).append("|");
        cefPrefix.append(severity).append("|");
        return cefPrefix.toString();
    }

    private static String getEventLogLevel(LoggingEvent event) {
        Level level = event.getLevel();
        String cefEquivalentLevel = iManXDasNauditHelper.getCEFEquivalent(level.getSyslogEquivalent() + 1);
        return cefEquivalentLevel;
    }

    private static String getCEFEquivalent(int level) {
        int cefLevel = 0;
        if (level == 1) {
            cefLevel = 9;
        }
        if (level == 2) {
            cefLevel = 9;
        }
        if (level == 3) {
            cefLevel = 8;
        }
        if (level == 4) {
            cefLevel = 7;
        }
        if (level == 5) {
            cefLevel = 4;
        }
        if (level == 6) {
            cefLevel = 2;
        }
        if (level == 7) {
            cefLevel = 1;
        }
        if (level == 8) {
            cefLevel = 0;
        }
        return Integer.toString(cefLevel);
    }

    private static void addCorrelationID(int eventID, String component, Object[] params, iManEvent.EventBuilder builder) {
    }

    private static void addEventGuid(int eventID, String component, Object[] params, iManEvent.EventBuilder builder) {
    }

    private static void buildAction(int eventID, String component, Object[] params, iManEvent.EventBuilder builder) {
        builder.set("Action.Event.Id", iManXDasNauditHelper.getXDasEventNumber(eventID));
        builder.set("Action.Event.Name", iManEvent.id2Name(iManXDasNauditHelper.getXDasEventNumber(eventID)));
        builder.set("Action.Outcome", iManXDasNauditHelper.getXDasOutcome(eventID));
        builder.set("Action.Event.SubEvent", Integer.toHexString(eventID));
        String cid = iManXDasNauditHelper.buildCorrelationID();
        builder.set("Action.Event.CorrelationID", cid);
    }

    private static String buildCorrelationID() {
        StringBuilder cid = new StringBuilder();
        cid.append(APP_NAME);
        cid.append(CID_SEPARATOR);
        cid.append("0");
        cid.append(CID_SEPARATOR);
        cid.append(UUID.generate().toString());
        return cid.toString();
    }

    private static void buildTarget(int eventID, String component, Object[] params, iManEvent.EventBuilder builder) {
        String targetName;
        String SubTargetName = (String)params[9];
        if (null != SubTargetName && !SubTargetName.isEmpty()) {
            builder.set("Target.Entity.SvcComp", SubTargetName);
        }
        if (null != (targetName = (String)params[7]) && !targetName.isEmpty()) {
            builder.set("Target.Entity.SvcName", (String)params[7]);
        }
        if (JavaUtil.hasBytes((byte[])params[18])) {
            builder.set("Target.Data.Data", iManXDasNauditHelper.bTos(params));
        }
        if (params[16] != null && JavaUtil.hasString(Integer.toString((Integer)params[16]))) {
            builder.set("Target.Data.MimeHint", Integer.toString((Integer)params[16]));
        }
        if (JavaUtil.hasString((String)params[11])) {
            builder.set("Target.Data.host", (String)params[11]);
        }
    }

    private static void buildInitiator(int eventID, String component, Object[] params, iManEvent.EventBuilder builder) {
        builder.set("Initiator.Entity.SvcName", (String)params[5]);
        builder.set("Initiator.Entity.SvcComp", component);
        String initiatorHost = (String)params[20];
        if (null != initiatorHost && !initiatorHost.isEmpty()) {
            builder.set("Initiator.Entity.SysAddr", initiatorHost);
        }
    }

    private static void buildObserver(int eventID, String component, Object[] params, iManEvent.EventBuilder builder) {
    }

    private static String bTos(Object[] params) {
        String sData;
        byte[] bData = (byte[])params[18];
        if (bData == null) {
            return "";
        }
        try {
            sData = new String(bData, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException(uee);
        }
        return sData;
    }
}

