/*
 * Decompiled with CFR 0.152.
 */
package com.novell.imanager.logging.syslog.util;

import java.text.Collator;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class JavaUtil {
    private static Collator Collator;

    public static Collator getCollator() {
        if (null == Collator) {
            Collator = Collator.getInstance();
            Collator.setStrength(3);
        }
        return Collator;
    }

    public static byte[] copyByteArray(byte[] bytes, int length) {
        if (0 > length) {
            length = 0;
        }
        byte[] reply = new byte[length];
        System.arraycopy(bytes, 0, reply, 0, length);
        return reply;
    }

    public static int byteArraySize(byte[][] byteArray) {
        int size = 0;
        for (int i = 0; i < byteArray.length; ++i) {
            size += byteArray[i].length;
        }
        return size;
    }

    public static Vector<Object> alToV(List<?> al) {
        if (null == al) {
            return null;
        }
        Vector<Object> reply = new Vector<Object>();
        int count = al.size();
        for (int i = 0; i < count; ++i) {
            reply.addElement(al.get(i));
        }
        return reply;
    }

    public static boolean byteArraysAreEqual(byte[] ba1, byte[] ba2) {
        int l2;
        int l1 = null == ba1 ? 0 : ba1.length;
        int n = l2 = null == ba2 ? 0 : ba2.length;
        if (l1 != l2) {
            return false;
        }
        for (int i = 0; i < l1; ++i) {
            if (ba1[i] == ba2[i]) continue;
            return false;
        }
        return true;
    }

    public static Boolean toBoolean(boolean bool) {
        if (bool) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static boolean hasBytes(byte[] data) {
        return null != data && 0 < data.length;
    }

    public static boolean hasString(String s) {
        return null != s && 0 < s.trim().length();
    }

    public static boolean hasStringWithSpaces(String s) {
        return null != s && 0 < s.length();
    }

    public static boolean isInteger(String s) {
        boolean isInt = true;
        try {
            Integer.parseInt(s);
        }
        catch (NumberFormatException ex) {
            isInt = false;
        }
        return isInt;
    }

    public static boolean isLong(String s) {
        boolean isLong = true;
        try {
            Long.parseLong(s);
        }
        catch (NumberFormatException ex) {
            isLong = false;
        }
        return isLong;
    }

    public static boolean isReal(String s) {
        boolean isReal = true;
        try {
            Double.parseDouble(s);
        }
        catch (NumberFormatException ex) {
            isReal = false;
        }
        return isReal;
    }

    public static String parseTreeName(String dn) {
        int pos = dn.indexOf("\\", 1);
        if (pos == -1) {
            return dn.substring(1);
        }
        return dn.substring(0, pos).substring(1);
    }

    public static String parseSlashName(String dn) {
        return dn.substring(dn.lastIndexOf("\\") + 1);
    }

    public static String[] reverseSArray(String[] aIn) {
        if (null == aIn) {
            return null;
        }
        int c = aIn.length;
        String[] reply = new String[c];
        int i = 0;
        int j = c - 1;
        while (i < c) {
            reply[i] = aIn[j];
            ++i;
            --j;
        }
        return reply;
    }

    public static int sInA(String s, String[] a) {
        if (JavaUtil.hasString(s)) {
            int c = null == a ? 0 : a.length;
            for (int i = 0; i < c; ++i) {
                if (!s.equalsIgnoreCase(a[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public static int sInAL(String s, ArrayList<String> al) {
        if (JavaUtil.hasString(s)) {
            int c = null == al ? 0 : al.size();
            for (int i = 0; i < c; ++i) {
                if (!s.equalsIgnoreCase(al.get(i))) continue;
                return i;
            }
        }
        return -1;
    }

    public static int sInV(String s, Vector<String> v) {
        if (JavaUtil.hasString(s)) {
            int c = null == v ? 0 : v.size();
            for (int i = 0; i < c; ++i) {
                if (!s.equalsIgnoreCase(v.elementAt(i))) continue;
                return i;
            }
        }
        return -1;
    }

    public static int ciIndexOf(String s1, String s2) {
        if (null == s1) {
            s1 = "";
        }
        if (null == s2) {
            s2 = "";
        }
        return s1.toUpperCase().indexOf(s2.toUpperCase());
    }

    public static boolean sToB(String bString) {
        return JavaUtil.hasString(bString) && bString.equalsIgnoreCase("true");
    }

    public static void emptyAL(List<? extends Object> al) {
        if (null != al) {
            al.clear();
        }
    }

    public static boolean isNUString(String nuString) {
        if (nuString != null) {
            for (int i = 0; i < nuString.length(); ++i) {
                char ch = nuString.charAt(i);
                if (ch == ' ') continue;
                try {
                    Integer.parseInt("" + ch);
                    continue;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean isPRString(String prString) {
        if (prString != null) {
            for (int i = 0; i < prString.length(); ++i) {
                char ch = prString.charAt(i);
                if (ch >= '0' && ch <= '9' || ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z' || ch >= ' ' || ch == '\'' || ch == '(' || ch == ')' || ch >= '+' || ch >= ',' || ch >= '-' || ch >= '.' || ch >= '/' || ch >= ':' || ch >= '=' || ch >= '?') continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }
}

