/*
 * Decompiled with CFR 0.152.
 */
package javax.wbem.client;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMNameSpace;
import javax.wbem.client.CIMClientAPI;
import javax.wbem.client.CIMListener;
import javax.wbem.client.CIMTransportException;
import javax.wbem.client.ClientProperties;
import javax.wbem.client.Debug;

class CIMClientFactory {
    public static final String XML_PROTOCOL_NAME = "cim-xml";
    public static final String RMI_PROTOCOL_NAME = "cim-rmi";
    private static final String PROP_TRANSPORT = "transport";
    private static final String PROP_PROTOCOL = "protocol";
    private static final String PROP_NAME = "name";
    private static final String PROP_DEFAULT = "default";
    private static final String PROP_CLASS = "client.class";

    CIMClientFactory() {
    }

    public static CIMClientAPI getClientAPI(String version, CIMNameSpace ns, String protocol, int debug, CIMListener clientListener) throws CIMException {
        String temp;
        String propname;
        String proto_name = protocol;
        if ((protocol == null || protocol.trim().length() == 0) && (proto_name = ClientProperties.getProperty(propname = "transport.protocol.default")) == null) {
            proto_name = RMI_PROTOCOL_NAME;
        }
        if (!((proto_name = proto_name.toLowerCase()) == null || (temp = ClientProperties.getProperty(propname = "transport.protocol.name." + proto_name)) != null && proto_name.equalsIgnoreCase(temp))) {
            proto_name = null;
        }
        if (proto_name == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER", "protocol name");
        }
        Debug.trace1("Client adapter protocol name: " + proto_name);
        propname = "transport." + proto_name + "." + PROP_CLASS;
        String classname = ClientProperties.getProperty(propname);
        Class<?> cl = null;
        try {
            cl = Class.forName(classname);
        }
        catch (Exception ex) {
            throw new CIMTransportException("CIM_ERR_NOT_FOUND", (Object)"protocol class");
        }
        CIMClientAPI cc = null;
        try {
            Class[] paramTypes = new Class[]{String.class, CIMNameSpace.class, CIMListener.class, Integer.class};
            Object[] paramList = new Object[]{version, ns, clientListener, new Integer(debug)};
            Constructor<?> ctr = cl.getConstructor(paramTypes);
            cc = (CIMClientAPI)ctr.newInstance(paramList);
        }
        catch (InvocationTargetException ex) {
            Throwable ax = ex.getTargetException();
            if (ax instanceof CIMException) {
                CIMException cex = (CIMException)ax;
                throw cex;
            }
            throw new CIMTransportException("CIM_ERR_FAILED", (Object)ax);
        }
        catch (Exception ex) {
            throw new CIMTransportException("CIM_ERR_FAILED", (Object)ex);
        }
        return cc;
    }
}

