/*
 * Decompiled with CFR 0.152.
 */
package javax.wbem.client.adapter.http.transport;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import javax.wbem.client.adapter.http.transport.Header;
import javax.wbem.client.adapter.http.transport.StartLine;
import javax.wbem.client.adapter.http.transport.TimedConnection;

public class HttpConnection
implements TimedConnection {
    protected static final int HTTP_MAJOR = 1;
    protected static final int HTTP_MINOR = 1;
    protected static final int UNSTARTED = 0;
    protected static final int IDLE = 1;
    protected static final int BUSY = 2;
    protected static final int CLOSED = 3;
    protected int state;
    protected Object stateLock = new Object();
    protected Socket sock;
    protected OutputStream out;
    protected InputStream in;

    public HttpConnection(int state) {
        this.state = state;
    }

    protected void idle() {
    }

    protected void busy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shutdown(boolean force) {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == 3) {
                return true;
            }
            if (!force && this.state == 2) {
                return false;
            }
            this.state = 3;
        }
        this.disconnect();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void markBusy() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == 3) {
                throw new IOException("connection closed");
            }
            this.state = 2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void markIdle() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == 3) {
                return;
            }
            this.state = 1;
        }
        this.idle();
    }

    protected void disconnect() {
        if (this.sock != null) {
            try {
                this.sock.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.sock = null;
            this.out = null;
            this.in = null;
        }
    }

    protected static boolean supportsPersist(StartLine sline, Header header) {
        if (header.containsValue("Connection", "close", true)) {
            return false;
        }
        if (header.containsValue("Connection", "Keep-Alive", true)) {
            return true;
        }
        int c = StartLine.compareVersions(sline.major, sline.minor, 1, 1);
        return c >= 0;
    }
}

