/*
 * Decompiled with CFR 0.152.
 */
package javax.wbem.client.adapter.http.transport;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.security.AccessController;
import javax.wbem.client.adapter.http.transport.Executor;
import javax.wbem.client.adapter.http.transport.GetThreadPoolAction;
import javax.wbem.client.adapter.http.transport.Header;
import javax.wbem.client.adapter.http.transport.HttpConnection;
import javax.wbem.client.adapter.http.transport.InboundRequest;
import javax.wbem.client.adapter.http.transport.MessageReader;
import javax.wbem.client.adapter.http.transport.MessageWriter;
import javax.wbem.client.adapter.http.transport.Request;
import javax.wbem.client.adapter.http.transport.RequestHandler;
import javax.wbem.client.adapter.http.transport.StartLine;

public abstract class HttpServerConnection
extends HttpConnection {
    private static final String serverString = "Java/" + System.getProperty("java.version", "???") + " " + HttpServerConnection.class.getName();
    private static final Executor userThreadPool = (Executor)AccessController.doPrivileged(new GetThreadPoolAction());
    private RequestHandler handler;

    public HttpServerConnection(Socket sock, RequestHandler handler) throws IOException {
        super(0);
        if (handler == null) {
            throw new NullPointerException();
        }
        this.sock = sock;
        this.handler = handler;
        this.in = new BufferedInputStream(sock.getInputStream());
        this.out = new BufferedOutputStream(sock.getOutputStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void start() {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state != 0) {
                throw new IllegalStateException();
            }
            this.state = 1;
            userThreadPool.execute(new Dispatcher(), "HTTP dispatcher");
        }
    }

    protected void checkPermissions() {
    }

    protected abstract String getClientHost();

    private static boolean supportsChunking(StartLine sline, Header header) {
        int c = StartLine.compareVersions(sline.major, sline.minor, 1, 1);
        return c >= 0 && header.containsValue("TE", "trailers", true);
    }

    private static Header createResponseHeader(Header header, boolean persist) {
        long now = System.currentTimeMillis();
        header.setField("Date", Header.getDateString(now));
        header.setField("Server", serverString);
        header.setField("Connection", persist ? "Keep-Alive" : "close");
        return header;
    }

    private final class InboundRequestImpl
    extends Request
    implements InboundRequest {
        private MessageReader reader;
        private MessageWriter writer;
        private boolean corrupt = false;
        private Header header;
        private Header respondHeader = new Header();

        InboundRequestImpl(MessageReader reader, MessageWriter writer, Header header) {
            this.reader = reader;
            this.writer = writer;
            this.header = header;
        }

        public void checkPermissions() {
            HttpServerConnection.this.checkPermissions();
        }

        public String getClientHost() {
            return HttpServerConnection.this.getClientHost();
        }

        public InputStream getRequestInputStream() {
            return this.getInputStream();
        }

        public OutputStream getResponseOutputStream() {
            return this.getOutputStream();
        }

        public String getHeaderField(String name) {
            return this.header.getField(name);
        }

        public void setRespondHeaderField(String name, String value) {
            this.respondHeader.setField(name, value);
        }

        Header getRespondHeader() {
            return this.respondHeader;
        }

        boolean streamCorrupt() {
            return this.corrupt;
        }

        void startOutput() throws IOException {
        }

        void write(byte[] b, int off, int len) throws IOException {
            this.writer.writeContent(b, off, len);
        }

        void endOutput() throws IOException {
            this.writer.writeTrailer(null);
        }

        boolean startInput() throws IOException {
            return true;
        }

        int read(byte[] b, int off, int len) throws IOException {
            return this.reader.readContent(b, off, len);
        }

        int available() throws IOException {
            return this.reader.availableContent();
        }

        void endInput() throws IOException {
        }

        void done(boolean corrupt) {
            this.corrupt = corrupt;
        }
    }

    private final class Dispatcher
    implements Runnable {
        private Dispatcher() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void run() {
            try {
                while (true) {
                    StartLine sline;
                    HttpServerConnection.this.idle();
                    MessageReader reader = new MessageReader(HttpServerConnection.this.in, false);
                    try {
                        sline = reader.readStartLine();
                    }
                    catch (IOException ex) {
                        if (!ex.getMessage().equals("empty start line")) throw ex;
                        continue;
                    }
                    HttpServerConnection.this.busy();
                    Object ex = HttpServerConnection.this.stateLock;
                    // MONITORENTER : ex
                    if (HttpServerConnection.this.state == 3) {
                        // MONITOREXIT : ex
                        return;
                    }
                    HttpServerConnection.this.state = 2;
                    // MONITOREXIT : ex
                    Header header = reader.readHeader();
                    if ("POST".equals(sline.method)) {
                        this.handleRequest(sline, header, reader);
                    } else {
                        this.handleBadRequest(sline, header, reader);
                    }
                    Object object = HttpServerConnection.this.stateLock;
                    // MONITORENTER : object
                    if (HttpServerConnection.this.state == 3) {
                        // MONITOREXIT : object
                        return;
                    }
                    HttpServerConnection.this.state = 1;
                    // MONITOREXIT : object
                    continue;
                    break;
                }
            }
            catch (IOException iOException) {
                return;
            }
            finally {
                HttpServerConnection.this.shutdown(true);
            }
        }

        private void handleBadRequest(StartLine inLine, Header inHeader, MessageReader reader) throws IOException {
            inHeader.merge(reader.readTrailer());
            boolean persist = HttpConnection.supportsPersist(inLine, inHeader);
            MessageWriter writer = new MessageWriter(HttpServerConnection.this.out, false);
            if ("M-POST".equals(inLine.method)) {
                writer.writeStartLine(new StartLine(1, 1, 501, "Not Implemented."));
            } else {
                writer.writeStartLine(new StartLine(1, 1, 400, "Bad Request"));
            }
            writer.writeHeader(HttpServerConnection.createResponseHeader(new Header(), persist));
            writer.writeTrailer(null);
            if (!persist) {
                HttpServerConnection.this.shutdown(true);
            }
        }

        private void handleRequest(StartLine inLine, Header inHeader, MessageReader reader) throws IOException {
            boolean persist = HttpConnection.supportsPersist(inLine, inHeader);
            boolean chunk = HttpServerConnection.supportsChunking(inLine, inHeader);
            MessageWriter writer = new MessageWriter(HttpServerConnection.this.out, chunk);
            InboundRequestImpl req = new InboundRequestImpl(reader, writer, inHeader);
            if (!HttpServerConnection.this.handler.checkAuthentication(req)) {
                writer.writeStartLine(new StartLine(inLine.major, inLine.minor, 401, "Unauthorized"));
                Header hd = req.getRespondHeader();
                writer.writeHeader(hd);
                writer.writeTrailer(null);
                return;
            }
            HttpServerConnection.this.handler.addResponseHeaderFields(req);
            writer.writeStartLine(new StartLine(inLine.major, inLine.minor, 200, "OK"));
            writer.writeHeader(HttpServerConnection.createResponseHeader(req.getRespondHeader(), persist));
            try {
                HttpServerConnection.this.handler.handleRequest(req);
            }
            catch (Throwable th) {
                System.out.println("throwale th:");
            }
            req.finish();
            if (!persist || req.streamCorrupt()) {
                HttpServerConnection.this.shutdown(true);
            }
        }
    }
}

