/*
 * Decompiled with CFR 0.152.
 */
package javax.wbem.client.adapter.http.transport;

import java.io.DataOutputStream;
import java.io.IOException;
import javax.wbem.client.Debug;
import javax.wbem.client.adapter.http.transport.InboundRequest;
import javax.wbem.client.adapter.http.transport.RequestHandler;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class HttpServerRequestHandler
implements RequestHandler {
    protected void doErrorOutput(DataOutputStream pOut, String pTitle, String pBody) throws IOException {
        pOut.writeBytes("<HTML><HEAD><TITLE>");
        pOut.writeBytes(pTitle);
        pOut.writeBytes("</TITLE></HEAD><BODY>\n");
        pOut.writeBytes(pTitle + " - " + pBody);
        pOut.writeBytes("</BODY></HTML>");
    }

    protected void do501Error(DataOutputStream pOut) {
        try {
            String errorType = "501 Not Implemented";
            pOut.writeBytes("HTTP/1.0 " + errorType + "\r\n\r\n");
            this.doErrorOutput(pOut, errorType, "The requested METHOD is not supported");
        }
        catch (IOException e) {
            Debug.trace1("IOException: " + e.getMessage());
            e.printStackTrace();
        }
    }

    protected void do500Error(DataOutputStream pOut, String pErrorString) {
        try {
            String errorType = "500 Internal Server Error";
            pOut.writeBytes("HTTP/1.0 " + errorType + "\r\n\r\n");
            this.doErrorOutput(pOut, errorType, "An internal error occurred while processing the request<br><b>" + pErrorString + "</b>");
        }
        catch (IOException e) {
            Debug.trace1("IOException: " + e.getMessage());
            e.printStackTrace();
        }
    }

    protected void do404Error(DataOutputStream pOut, String pRequestURI) {
        try {
            String errorType = "404 Not Found";
            pOut.writeBytes("HTTP/1.0 " + errorType + "\r\n\r\n");
            this.doErrorOutput(pOut, errorType, "The requested URI was not found: " + pRequestURI);
        }
        catch (IOException e) {
            Debug.trace1("IOException: " + e.getMessage());
            e.printStackTrace();
        }
    }

    protected Document getXmlDocument(InboundRequest request) throws IOException, SAXException {
        DocumentBuilder builder = null;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            builder = dbf.newDocumentBuilder();
        }
        catch (Exception e) {
            // empty catch block
        }
        InputSource in = new InputSource();
        dbf.setNamespaceAware(true);
        in.setByteStream(request.getRequestInputStream());
        Document d = builder.parse(in);
        return d;
    }
}

