/*
 * Decompiled with CFR 0.152.
 */
package javax.wbem.security;

import java.io.Serializable;
import java.security.PublicKey;
import javax.wbem.security.SecurityUtil;

public class SecurityMessage
implements Serializable {
    static final long serialVersionUID = 200L;
    private static final int HELLO = 0;
    private static final int CHALLENGE = 1;
    private static final int RESPONSE = 2;
    private static final int RESULT = 3;
    private static final int ERROR = 4;
    private int type;
    private byte[] userDigest;
    private byte[] salt;
    private byte[] challenge;
    private byte[] response;
    private byte[] authenticator;
    private byte[] checksum;
    private byte[] sessionId;
    private byte[] nameSpace;
    private PublicKey pubkey;
    private String message;

    public boolean isHello() {
        return this.type == 0;
    }

    public boolean isChallenge() {
        return this.type == 1;
    }

    public boolean isResponse() {
        return this.type == 2;
    }

    public boolean isResult() {
        return this.type == 3;
    }

    public boolean isError() {
        return this.type == 4;
    }

    public byte[] getUserDigest() {
        return this.userDigest;
    }

    public byte[] getSalt() {
        return this.salt;
    }

    public byte[] getChallenge() {
        return this.challenge;
    }

    public byte[] getResponse() {
        return this.response;
    }

    public byte[] getAuthenticator() {
        return this.authenticator;
    }

    public String getMessage() {
        return this.message;
    }

    public byte[] getChecksum() {
        return this.checksum;
    }

    public byte[] getSessionId() {
        return this.sessionId;
    }

    public byte[] getNameSpace() {
        return this.nameSpace;
    }

    public PublicKey getPublicKey() {
        return this.pubkey;
    }

    public static SecurityMessage error(String message) {
        SecurityMessage m = new SecurityMessage();
        m.type = 4;
        m.message = message;
        return m;
    }

    public static SecurityMessage result(byte[] sessionId, PublicKey pubkey, byte[] response, byte[] checksum) {
        SecurityMessage m = new SecurityMessage();
        m.type = 3;
        m.sessionId = sessionId;
        m.response = response;
        m.pubkey = pubkey;
        m.checksum = checksum;
        return m;
    }

    public static SecurityMessage response(byte[] response, PublicKey pubkey, byte[] sessionId, byte[] checksum) {
        SecurityMessage m = new SecurityMessage();
        m.type = 2;
        m.response = response;
        m.sessionId = sessionId;
        m.pubkey = pubkey;
        m.checksum = checksum;
        return m;
    }

    public static SecurityMessage challenge(byte[] challenge, byte[] salt, byte[] sessionId, byte[] checksum) {
        SecurityMessage m = new SecurityMessage();
        m.type = 1;
        m.salt = salt;
        m.challenge = challenge;
        m.checksum = checksum;
        m.sessionId = sessionId;
        return m;
    }

    public static SecurityMessage hello(byte[] challenge, byte[] userDigest, byte[] nameSpace, byte[] checksum) {
        SecurityMessage m = new SecurityMessage();
        m.type = 0;
        m.userDigest = userDigest;
        m.challenge = challenge;
        m.nameSpace = nameSpace;
        m.checksum = checksum;
        return m;
    }

    public String toString() {
        String s;
        switch (this.type) {
            case 0: {
                s = "c->s  user(" + SecurityUtil.toHex(this.userDigest) + ")\n, challenge(" + SecurityUtil.toHex(this.challenge) + ")" + ")\n, namespace(" + SecurityUtil.toHex(this.nameSpace) + ")";
                break;
            }
            case 1: {
                s = "s->c  salt(" + SecurityUtil.toHex(this.salt) + ")\n, sessionId(" + SecurityUtil.toHex(this.sessionId) + ")" + ")\n, challenge(" + SecurityUtil.toHex(this.challenge) + ")";
                break;
            }
            case 2: {
                s = "c->s  response(" + SecurityUtil.toHex(this.response) + "),\n      sessionId(" + SecurityUtil.toHex(this.sessionId) + ")";
                break;
            }
            case 3: {
                s = "s->c  session(" + SecurityUtil.toHex(this.sessionId) + ")" + ",\n response(" + SecurityUtil.toHex(this.response) + ")";
                break;
            }
            case 4: {
                s = "s->c  error(" + this.message + ")";
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown type: " + this.type);
            }
        }
        s = s + "\nchecksum(" + SecurityUtil.toHex(this.checksum) + ")";
        return s;
    }
}

