/***************************************************************************

  $id: NetWareNamespace.java$

  Copyright (c) 1998-2000 Novell, Inc.  All Rights Reserved.

  THIS WORK IS AN UNPUBLISHED WORK AND CONTAINS CONFIDENTIAL PROPRIETARY
  AND TRADE SECRET INFORMATION OF NOVELL, INC. ACCESS  TO  THIS  WORK IS
  RESTRICTED TO (I) NOVELL, INC.  EMPLOYEES WHO HAVE A NEED TO  KNOW HOW
  TO  PERFORM  TASKS WITHIN  THE SCOPE  OF  THEIR   ASSIGNMENTS AND (II)
  ENTITIES OTHER  THAN  NOVELL, INC.  WHO  HAVE ENTERED INTO APPROPRIATE
  LICENSE   AGREEMENTS.  NO  PART  OF  THIS WORK MAY BE USED, PRACTICED,
  PERFORMED COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED, ABRIDGED,
  CONDENSED, EXPANDED, COLLECTED, COMPILED, LINKED,  RECAST, TRANSFORMED
  OR ADAPTED  WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC.  ANY USE
  OR EXPLOITATION  OF  THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE
  PERPETRATOR  TO CRIMINAL AND CIVIL LIABILITY.

****************************************************************************/
package com.novell.admin.ns.nw;

import java.util.*;
import java.text.*;

import com.novell.application.console.snapin.*;
import com.novell.application.console.snapin.scope.*;
import com.novell.application.console.snapin.context.*;
import com.novell.admin.ns.*;
import com.novell.admin.common.exceptions.*;

//============================================================================
/**
 * This class provides the utility to manage a Novell Directory Service Namespace.
 *
 * @copyright (c) 1998 Novell, Inc.
*/
//============================================================================
public abstract class NetWareNamespace implements NamespaceSnapin, NamespaceSnapinRev2
{
   /**
   * The name of the namespace.
   */
   final public static String name = new String("NetWare");
   
   protected String TREE_SEPARATOR; 


   protected final Hashtable otTable = new Hashtable(5);
   protected SimpleSPIException nsSpiException = new SimpleSPIException("com.novell.admin.ns.NSResourceBundle");

   //============================================================================
   /**
   * Constructor.
   */
   //============================================================================
   public NetWareNamespace(String separator)
   {
       TREE_SEPARATOR = separator;
      
      // setup our cache of object types
      otTable.put("Servers", new ObjectType("Servers", this, true));
      otTable.put("Server", new ObjectType("Server", this, false));
      otTable.put("Trees", new ObjectType("Trees", this, true));
      otTable.put("Tree", new ObjectType("Tree", this, false));
      otTable.put("Root", new ObjectType("Root", this, true));
   }

   //============================================================================
   /** This is used by the shell to get the snapins name.
   *
   * @return The snapin name.
   *
   **/
   //============================================================================
   public String getSnapinName()
   {
      return new String(new NWRes().getString("SNAPIN_NAME"));
   }

   //============================================================================
   /** This is used by the shell to get the snapins description.
   *
   * @return The snapin description.
   *
   **/
   //============================================================================
   public String getSnapinDescription()
   {
      return new String(new NWRes().getString("SNAPIN_DESCRIPTION"));
   }

   //============================================================================
   /** This is used by the shell to initialize the snapin.
   *
   * @param info - not used.
   * @return true - snapin initialized successfully.
   *
   **/
   //============================================================================
   public boolean initSnapin(InitSnapinInfo info)
   {
      return true;
   }

   //============================================================================
   /** This is used by the shell to shut down the snapin.
   *
   *
   **/
   //============================================================================
   public void shutdownSnapin()
   {
   }


   public ObjectEntry[] getInitialObjectEntries(ObjectEntry oe, GetChildrenContext context)
   {
      return null;
   }
   

   //============================================================================
   /** Gets the root object entry.
   *
   * @return ObjectEntry array containing the object entry.
   *
   **/
   //============================================================================
   public ObjectEntry[] getInitialObjectEntries()
   {
      return null;
   }

   //============================================================================
   /** Create an ObjectEntry for a child.
   *
   * @param parent The ObjectEntry of the childs parent.
   * @param child The name of the child.
   * @param className Not used.
   * @return The object entry for the child.
   *
   **/
   //============================================================================
   public ObjectEntry createObjectEntry(ObjectEntry parent, String child, String className)
   {
      ObjectType ot = (ObjectType)otTable.get(className);

      return (new ObjectEntry(child, ot, parent));
   }

   //============================================================================
   /** Returns all of the posible object types for this namespace.
   *
   * @return the object types for this namespace.
   *
   **/
   //============================================================================
   public ObjectType[] getObjectTypes(ObjectEntry entry)
   {
      ObjectType[] objectTypes = new ObjectType[otTable.size()];
      Enumeration enum = otTable.elements();

      for (int i=0;i<otTable.size();i++)
      {
         objectTypes[i] = (ObjectType)enum.nextElement();
      }
      return objectTypes;
   }

   //============================================================================
   /** Returns the full name of the objectEntry.
   *
   * @param obj - The object to get the full name for.
   * @return the full name of the object.
   *
   **/
   //============================================================================
   public String getFullName(ObjectEntry obj)
   {
      return getUnrootedName(obj);
   }

   //============================================================================
   /** Gets the subordinate objects from an ObjectEntry. \

   <P>There is never any child containers in this namespace.</P>
   *
   * @param <i>obj</i> The container to get children for.
   * @param <i>modifiers</i> The modifiers for creating the list of children.
   * @return An enumeration of the child objects found.
   *
   **/
   //============================================================================
   public ObjectEntryEnumeration getChildContainers(ObjectEntry parent, ResultModifier modifier)
   {
      return new NetWareObjectEntryEnumeration(new ObjectEntry[0]);
   }

   //============================================================================
   /** Gets the objects name not including the root portion.
   *
   * @param <i>obj</i> Object to get the unrooted name for.
   * @return The fully distinguished name excluding the root name.
   *
   **/
   //============================================================================
   public String getUnrootedName(ObjectEntry obj)
   {
      StringBuffer objName = new StringBuffer("");

      ObjectEntry parentOE = obj.getParent();

      while(parentOE != null)
      {
         if (parentOE.getObjectType().getNamespace() != this)
         {
             break;
         }

         //Add on the obj name.
         objName.insert(0, obj.getName());

         obj = parentOE;
         parentOE = obj.getParent();

         if(parentOE != null) // look ahead!
         {
            objName.insert(0, TREE_SEPARATOR);
         }
      }

      return objName.toString();
   }

   //============================================================================
   /** Returns a NSObject from an ObjectEntry.
   *
   * @param <i>objEntry</i> The ObjectEntry object to get details for.
   * @return null
   *
   **/
   //============================================================================
   public NSObject getDetails(ObjectEntry objEntry)
   {
      return null;
   }

   //============================================================================
   /** Returns the namespace name string.
   *
   * @return the namespace string.
   *
   **/
   //============================================================================
   public String getUniqueID()
   {
      return name;
   }

   //============================================================================
   /** Returns an ObjectEntry representation of the tree of the string passed in.
   *
   * @param <i>objEntryStr</i> The name of the object.
   * @return The ObjectEntry.
   *
   **/
   //============================================================================
   public ObjectEntry getObjectEntry(String objEntryStr)
   {
       ObjectEntry parentEntry = null;

       //Convert the object entry to the new type of naming.
       String objFDN = objEntryStr;
       int index = 0;

       //Get the objectEntry for the tree.
       parentEntry = new ObjectEntry("", (ObjectType)otTable.get("Root"), null);
       if(objFDN.equals(""))
       {
          return parentEntry;
       }

       while((index = objFDN.indexOf(TREE_SEPARATOR)) != -1)
       {
          //Parse the naming elements.
          String name = objFDN.substring(0,index);
          parentEntry = getObjectEntry(parentEntry, name);
          objFDN = objFDN.substring(index+1);
       }

       return getObjectEntry(parentEntry, objFDN);
   }

   //============================================================================
   /** Returns an ObjectEntry representation of the String passed in.
   *
   * @param <i>parentObjEntry</i> The parent object.
   * @param <i>child</i> The childe of the parent.
   * @return The ObjectEntry.
   *
   **/
   //============================================================================
   public ObjectEntry getObjectEntry(ObjectEntry parentObjEntry, String child)
   {
      ObjectType objType = null;

      // Handle Top object
      if ((child == null) || (child.equals("")))
      {
         return parentObjEntry;
      }

      if(parentObjEntry.getName().equals("Servers"))
      {
         objType = (ObjectType)otTable.get("Server");
      }
      else if(parentObjEntry.getName().equals("Trees"))
      {
         objType = (ObjectType)otTable.get("Tree");
      }
      else
      {
         objType = (ObjectType)otTable.get(child);
      }

      return new ObjectEntry(child, objType, parentObjEntry);
   }

    //============================================================================
    /**
    * This class provides the utility to enumerate over an object children.
    *
    */
    //============================================================================
   final public class NetWareObjectEntryEnumeration
      implements ObjectEntryEnumeration
   {
      int index = 0;
      ObjectEntry[] children = null;

       //============================================================================
       /**
       * Constructor
       *
       * @param children The children object entries to enumerate over.
       *
       */
       //============================================================================
      public NetWareObjectEntryEnumeration(ObjectEntry[] children)
      {
         this.children = children;
      }

       //============================================================================
       /**
       * Determins if enumeration has any more elements to iterate over.
       *
       * @return true if more elements to iterate, false otherwise.
       *
       */
       //============================================================================
      public boolean hasMoreElements()
      {
         if(index < children.length)
         {
            return true;
         }
         return false;
      }

       //============================================================================
       /**
       * Retrieve the next element in the enumeration.
       *
       * @return The next element.
       *
       */
       //============================================================================
      public Object nextElement()
      {
         return next();
      }

       //============================================================================
       /**
       * Retrieve the next element in the enumeration.
       *
       * @return The next element.
       *
       */
       //============================================================================
      public ObjectEntry next()
      {
         return children[index++];
      }
   }

   //============================================================================
   /** Converts an Exception into an SPIException.
    *
    * @param <i>x</i> The exception to convert.
    *
    * @return The SPIException
    **/
   //============================================================================
   protected SPIException resolveSPIException(Exception x)
   {
      SPIException exception = null;

      if (x == null)
      {
          exception = nsSpiException.newException((Exception)null);
      }
      else if(x instanceof SPIException)
      {
         exception = (SPIException)x;
      }
      else
      {
          exception = nsSpiException.newException(ns.UNEXPECTED_EXCEPTION);
      }

      return (exception);
   }

}