/*
   $RCSfile: MainShell.java,v $
   $Revision: 1.1.1.1 $ $Name:  $
   $Date: 2001/05/09 12:43:23 $

   $ProjectName: V:/PROJECT/houston/snapin.pj $
   $ProjectRevision: 1.172 $

   For revision information, see the history log at the end of this file.

   Copyright (c) 1997-1999 Novell, Inc.  All Rights Reserved.

   THIS WORK IS AN UNPUBLISHED WORK AND CONTAINS CONFIDENTIAL PROPRIETARY
   AND TRADE SECRET INFORMATION OF NOVELL, INC. ACCESS TO THIS WORK IS
   RESTRICTED TO (I) NOVELL, INC. EMPLOYEES WHO HAVE A NEED TO KNOW HOW
   TO PERFORM TASKS WITHIN THE SCOPE OF THEIR ASSIGNMENTS AND (II)
   ENTITIES OTHER THAN NOVELL, INC. WHO HAVE ENTERED INTO APPROPRIATE
   LICENSE AGREEMENTS. NO PART OF THIS WORK MAY BE USED, PRACTICED,
   PERFORMED COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED, ABRIDGED,
   CONDENSED, EXPANDED, COLLECTED, COMPILED, LINKED, RECAST, TRANSFORMED
   OR ADAPTED WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE
   OR EXPLOITATION OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE
   PERPETRATOR TO CRIMINAL AND CIVIL LIABILITY.
*/
package com.novell.application.console.snapin;

import java.util.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import com.novell.application.console.shell.*;
import com.novell.application.console.snapin.scope.*;
import com.novell.application.console.snapin.context.*;

/**
* Provides ConsoleOne with a default implementation of the shell interface.
*
* <p>The MainShell class contains global methods that snap-ins can
* use to find out information about the shell, or have the shell
* perform certain operations. These methods can be called by any
* snap-in at any time.
*
* @version 0.1 12 June 1997
*
* @exclude
*/
public final class MainShell implements Shell
{
   private static MainShell singleton = new MainShell();

   private Hashtable fSnapinListeners;
   private Hashtable fVetoableSnapinListeners;

   /*
   * Private constuctor, this class should not be instantiated, use getInstance().
   */
   private MainShell()
   {
      fSnapinListeners = new Hashtable();
      fVetoableSnapinListeners = new Hashtable();
   }

   /**
   * Returns The single instance of this class (MainShell).
   *
   * <p>Since there should only be one instance of this class,
   * the constructor has been made private. Use this static method
   * to get an object from which to make the method calls.
   *
   * @return  The single Instance of MainShell.
   */
   public static final Shell getInstance()
   {
      return singleton;
   }

   /*
      Implementation of the shell interface.
   */

   /**
   * Gets the console display version in the following formats:
   * M.m.r if in release mode, or
   * M.m.r (bYYMMDD{+}) if in development mode
   * The '+' appears if the build is an interim (not checkpointed)
   * build which is usually not saved and cannot be repeated.
   *
   * @return The all version info in a single string.
   */
   public String getDisplayVersion()
   {
      return ShellStubs.getDisplayVersion();
   }

   /**
   * Gets the console major version.
   *
   * @return The major version.
   */
   public String getMajorVersion()
   {
      return ShellStubs.getMajorVersion();
   }

   /**
   * Gets the console minor version.
   *
   * @return The minor version.
   */
   public String getMinorVersion()
   {
      return ShellStubs.getMinorVersion();
   }

   /**
   * Gets the console version revision.
   *
   * @return The version revision.
   */
   public String getRevision()
   {
      return ShellStubs.getRevision();
   }

   /**
   * Gets the date (YYMMDD{+}) when the console was built.
   * The '+' appears if the build is an interim (usually not saved) build.
   *
   * @return The build date.
   */
   public String getBuildDate()
   {
      return ShellStubs.getBuildDate();
   }

   /**
    * Gets the virtual enumeration limit for accessing children in NDS.
    */
   public int getNDSVirtualEnumerationLimit()
   {
      return ShellStubs.getNDSVirtualEnumerationLimit();
   }

   /**
    * Sets the virtual enumeration limit for accessing children in NDS.
    * @param val The virtual enumeration limit
    */
   public void setNDSVirtualEnumerationLimit(int val)
   {
      ShellStubs.setNDSVirtualEnumerationLimit(val);
   }

   /**
    * Sets the access method to be used to access NDS.
    * 
    * @param accessMethod  Integer representing the desired access method.
    * Supported access methods are Shell.JCLIENT_ACCESS, Shell.JNDI_ACCESS and
    * Shell.LDAP_ACCESS.
    */
   public void setDSAccessMethod(int accessMethod)
   {
      ShellStubs.setDSAccessMethod(accessMethod);
   }
   
   /**
    * Gets the access method to be used to access NDS.
    * 
    * @return  Integer representing the desired access method.
    * Supported access methods are Shell.JCLIENT_ACCESS, Shell.JNDI_ACCESS and
    * Shell.LDAP_ACCESS.
    */
   public int getDSAccessMethod()
   {
      return ShellStubs.getDSAccessMethod();
   }

   /** 
    * Gets the access confidence
    * 
    * @return  boolean true if force master replica has been set
    *          else returns false
    *
    * @exclude
    */
   public boolean getForceMasterReplica()
   {
      return ShellStubs.getForceMasterReplica();
   }

  /**
   * This method has veen depricated
   * Ensures the indexes for help files are up to date.
   *
   * <p>This should be called anytime files are added or removed
   * from the help structure to keep help indexes up to date.
   *
   * @deprecated As of ConsoleOne version 1.2
   *
   * @exclude
   */
   public void synchronizeHelp()
   {
   }

   /**
   * This method should no longer be used.
   * Returns the full, locale-sensitive path for the given help directory
   * based on the location of the shell and the current default locale.
   *
   * <p>You must pass in the name of the subdirectory (dirName)
   * containing the help content.
   *
   * @param dirName The name of the subdirectory for which to get the full path.
   * @return The full path name of the directory containing the help content.
   *
   * @exclude
   */
   public String getHelpPath(String dirName)
   {
      return ShellStubs.getHelpPath(dirName);
   }

   /**
   * Launches a message box that displays an error message without
   * help.
   *
   * @param title The message box title in the title bar.
   * @param message The message to be displayed inside the message box.
   * @param type The pre-built message box type.
   * @return The button pressed as an integer.
   *
   * @see com.novell.utility.nmsgbox.NMsgBox
   */
   public int launchMsgBox(String title, String message, int type)
   {
      return ShellStubs.launchMsgBox(title, message, type, null);
   }

   /**
   * Launches a message box that displays an error message with context sensitive
   * help.
   * <p>Your snap-in should call the launchMsgBox() method to display an error
   * message with a Details button that is linked to a help set file, and help ID.
   * Besides passing in the error message information, you should pass in the
   * help set filename and help ID for the help topic to be linked. You should only
   * pass in the base helpset filename and the Javahelp class loader will load the proper
   * helpset based off of the current locale.
   * </p>
   * <p>The message box that is launched is defined in
   * {@link com.novell.utility.nmsgbox.NMsgBox NMsgBox}.
   * </p>
   *
   * @param title    The message box title.
   * @param message  The message to be displayed inside the message box.
   * @param type     The message box type.
   * @param helpSetName The help file to be used for help
   * @param helpID	 The help id to be used for help
   * @return The button pressed as an integer.
   */
   public int launchMsgBox(String title, String message, int type,
                           String helpSetName, String helpID)
   {
      return ShellStubs.launchMsgBox(title, message, type, helpSetName, helpID);
   }

   /**
   * Launches a message box that displays an error message with help.
   * <p>Your snap-in should call the launchMsgBox() method to display an error
   * message with a Details button that is linked to a help set file.
   * Besides passing in the error message information, you should pass in the
   * help set filename. You should only	pass in the base helpset filename and
   * the Javahelp class loader will load the proper
   * helpset based off of the current locale.
   * </p>
   * <p>The message box that is launched is defined in
   * {@link com.novell.utility.nmsgbox.NMsgBox NMsgBox}.
   * </p>
   *
   * @param title    The message box title.
   * @param message  The message to be displayed inside the message box.
   * @param type     The message box type.
   * @param helpSetName The help file to be used for help
   *                 or null if none is available.
   * @return The button pressed as an integer.
   *
   */

   public int launchMsgBox(String title, String message, int type,
                           String helpSetName)
   {
      return ShellStubs.launchMsgBox(title, message, type, helpSetName);
   }

   /**
   * Launches a message box that displays an error message based on a SnapinException.
   * <p>Your snap-in should call the launchMsgBox() method to display an error
   * message with a Details button that is linked to a help set file, and help ID.
   * The help set file and help ID are obtained from the SnapinException.
   * The body of the message displayed is the String returned from the getLocalizedMessage()
   * method of the exception.
   * </p>
   * <p>The message box that is launched is defined in
   * {@link com.novell.utility.nmsgbox.NMsgBox NMsgBox}.
   * </p>
   *
   * @param exception The snapin exception to display the message for.
   * @return The button pressed as an integer.
   *
   * @see #launchMsgBox(java.lang.String, java.lang.String, int)
   * @see #launchHelp(String)
   */
   public int launchMsgBox(SnapinException exception)
   {
      return ShellStubs.launchMsgBox(exception);
   }

   /**
   * Checks if a Help ID exists in a specified HelpSet
   *
   * <p>This method can be called to determine if a help set and HelpID
   * within the help set exists
   *
   * @param helpSetName The Java HelpSet name.
   * @param helpID The Help ID for a specific topic within the helpset
   *
   * @see #launchMsgBox(String, String, int)
   */
   public boolean helpExists(String helpSetName, String helpID)
   {
      return ShellStubs.helpExists(helpSetName, helpID);
   }


   /**
   * Loads a JavaHelp help set and displays the content
   * corresponding to the helpID that is passed in
   *
   * <p>This method can be called from the various user-interface
   * contexts of your snap-in to display an appropriate help topic.
   * You should pass in the base HelpSet file name without the hs extension and
   * the help topic to be linked.
   *
   * @param helpSetName The Java HelpSet name.
   * @param helpID The Help Id for the topic you want to display.
   * @param parent The parent Window to be used for the help dialog.
   *
   * @see #launchMsgBox(String, String, int)
   */
   public void launchHelp(String helpSetName, String helpID, Window parent)
   {
      ShellStubs.launchHelp(helpSetName, helpID, parent);
   }

   /**
    * @deprecated Use the launchHelp that takes a parent window.
    */
   public void launchHelp(String helpSetName, String helpID)
   {
      ShellStubs.launchHelp(helpSetName, helpID, null);
   }
   
   /**
   * Loads a JavaHelp help set dispalying from the default topic.
   *
   * <p>This method can be called from the various user-interface
   * contexts of your snap-in to display an appropriate help topic.
   * You should pass in the base HelpSet file name without the hs extension
   *
   * @param helpSetName The Java HelpSet name.
   * @param parent The parent Window to be used for the help dialog.
   *
   */
   public void launchHelp(String helpSetName, Window parent)
   {
      ShellStubs.launchHelp(helpSetName, parent);
   }
   
   /**
    * @deprecated Use the launchHelp that takes a parent window.
    */
   public void launchHelp(String helpSetName)
   {
      ShellStubs.launchHelp(helpSetName, null);
   }

   //REMIND: put back.
   /*
   public static Vector getAvailableCollectionInfo()
   {
     return  ShellStubs.getAvailableCollectionInfo();
   }
   */

   /**
   * Returns the namespace currently being browsed by the user.
   *
   * @return The current namespace selected in the namespace tree.
   */
   public NamespaceSnapin getTreeSelectionNamespace()
   {
      return ShellStubs.getTreeSelectionNamespace();
   }

   /**
   * Returns the ObjectEntry associated with the item selected
   * in the left panel of the shell tree.
   *
   * <p>This method returns null if no item is selected.
   *
   * @return The ObjectEntry selected in the tree.
   */
   public ObjectEntry getTreeSelection()
   {
      return ShellStubs.getTreeSelection();
   }

   /**
   * Returns the ObjectEntryCollection that contains the currently
   * selected entries in the right panel of the shell view.
   *
   * <p>This method will never return null.  If no item is selected, the
   * returned ObjectEntryCollection will provide an empth enumeration.
   *
   * @return The ObjectEntryCollection that contains the currently
   * selected entries in the right panel of the shell view.
   *
   */
   public ObjectEntryCollection getViewSelections()
   {
      return ShellStubs.getViewSelections();
   }

   /**
   * Returns the ObjectEntry array in the panel that has the focus.
   *
   * <p>The ObjectEntrys selected may be in the tree or the view,
   * whichever currently has focus. This method returns a collection even
   * if the selection is empty.
   *
   * @return The ObjectEntryCollection containing the ObjectEntrys
   * that are currently selected in the panel that has the focus(tree or view).
   *
   */
   public ObjectEntryCollection getCurrentSelections()
   {
      return ShellStubs.getCurrentSelections();
   }

   /**
   * Returns the current FocusState of the Console.
   *
   * <p>This method returns an integer of type FocusState.
   *
   * @return The FocusState of the console
   */
   public int getFocusState()
   {
      return ShellStubs.getFocusState();
   }

   /**
   * Brings the tree view up to date with the actual data.
   *
   * <p>Requests the snap-in to read the data again. This is done to
   * make sure the tree represents the underlying data correctly,
   * since that since that data may have been changed outside of the shell.
   */
   public void refreshEntireTree()
   {
      ShellStubs.refreshEntireTree();
   }

   /**
   * Brings the tree view up to date with the actual data at the point
   * where the ObjectEntry exists in the tree.
   *
   * <p>Requests the snap-in to read the data again. This is done to
   * make sure the tree represents the underlying data correctly,
   * since that data may have been changed outside of the shell.
   */
	public void refreshTreeEntry(ObjectEntry refreshEntry)
	{
		ShellStubs.refreshTreeEntry(refreshEntry);
	}


   /**
   * Brings the current view up to date with the actual data.
   *
   * <p>Requests the snap-in to read the data again. This is done to
   * make sure the view represents the underlying data correctly,
   * since that data may have been changed outside of the shell.
   */
   public void refreshCurrentView()
   {
      ShellStubs.refreshCurrentView();
   }

   /**
   * Refreshes peers of the currently selected object in the tree.
   *
   * <p>This method is the same as refreshTree(), except it only refreshes the
   * current selection and its subordinates.
   */
   public void refreshParentTreeSelection()
   {
      ShellStubs.refreshParentTreeSelection();
   }


   /**
   * Refreshes the subordinates of the currently selected object in the tree.
   *
   * <p>This method is the same as refreshTree(), except it only refreshes the
   * current selection and its subordinates.
   */
   public void refreshCurrentTreeSelection()
   {
      ShellStubs.refreshCurrentTreeSelection();
   }

   /**
   * Posts an event in the shell.
   *
   * <p>The shell will then send the posted event to snap-ins
   * that are listening for that type of event.
   *
   * @param event The event that will be posted in the shell.
   *
   * @deprecated  Replaced by postShellSelectionEvent
   */
   public void postShellEvent(ShellEvent event)
   {
     ShellStubs.postShellEvent(event);
   }

   /**
   * Posts a selection event in the shell.
   *
   * <p>The shell will then send the posted event to snap-ins
   * that are listening for that type of event.
   *
   * @param event The event that will be posted in the shell.
   */
   public void postShellSelectionEvent(ShellSelectionEvent event)
   {
     ShellStubs.postShellSelectionEvent(event);
   }

   /**
   * Posts a lifecycle event in the shell.
   *
   * <p>The shell will then send the posted event to snap-ins
   * that are listening for lifecycle events.
   *
   * @param event The event that will be posted in the shell.
   */
   public void postShellLifecycleEvent(ShellLifecycleEvent event)
   {
     ShellStubs.postShellLifecycleEvent(event);
   }

   /**
   * Posts an event to all interesed property book listeners.
   *
   * <p>The shell will then send the posted event to snap-ins
   * that are listening for that type of event.
   *
   * @param event The event that will be posted.
   */
   public void postPropertyBookEvent(PropertyBookEvent event)
   {
      ShellStubs.postPropertyBookEvent(event);
   }

   /**
   * Returns the Locale in which the shell is running.
   *
   * @return The shell's Locale.
   */
   public Locale getLocale()
   {
      return ShellStubs.getLocale();
   }

   /**
   * Returns the popup menu associated with the given ObjectEntry array.
   *
   * <p>Views may use this method to get the popup menu to display when
   * the user right clicks on the ObjectEntry.
   *
   * @param entries The ObjectEntry array for which the popup menu is needed.
   *
   * @return The Popup menu associated with the 'entries'.
   */
   public JPopupMenu getPopupMenu(ObjectEntry[] entries)
   {
      return ShellStubs.getPopupMenu(entries);
   }

   /**
   * Returns the pop-up menu associated with the given ObjectEntry array.
   *
   * <p>Views may use this method to get the pop-up menu to display when
   * the user right clicks on the ObjectEntry.
   *
   * @param entries The ObjectEntryCollection which contains the
   * entries for which the pop-up menu is needed.
   *
   * @return The pop-up menu associated with the 'entries'.
   *
   * @see #getViewPopupMenu
   */
   public JPopupMenu getPopupMenu(ObjectEntryCollection entries)
   {
      return ShellStubs.getPopupMenu(entries);
   }

   /**
   * Returns the view popup menu associated with the given ObjectEntry array.
   *
   * <p>Views may use this method to get the popup menu to display when
   * the user right clicks on the ObjectEntry.
   *
   * @param namespace The namespace for which the popup menu is needed.
   *
   * @param view The view for which the popup menu is needed.
   *
   * @return The view popup menu associated with the specified namespace
   *         and view.
   */
   public JPopupMenu getViewPopupMenu(String namespace, String view)
   {
      return ShellStubs.getViewPopupMenu(namespace, view);
   }

   /**
   * Returns the snap-in icon associated with the specified namespace and
   * object type.
   *
   * <p>The MainShell interface gets this icon from DisplayIconSnapin
    snap-ins that have been registered against the passed in object type.
   *
   * @param namespace The namespace of the object type for the desired
   *                  display icon.
   * @param type The type of the desired display icon.
   *
   * @return The icon associated with the object type.
   */
   public Icon getDisplayIcon(String namespace, String type)
   {
      return ShellStubs.getDisplayIcon(namespace, type);
   }

   /**
   * Returns the snap-in icon associated with the specified
   * ObjectEntry.
   *
   * <p>The MainShell interface gets this icon from DisplayIconSnapin
   * snap-ins that have been registered against the passed in ObjectEntry.
   *
   * @param objectEntry The ObjectEntry for which to get the display icon.
   *
   * @return The icon associated with the specified ObjectEntry.
   */
   public Icon getDisplayIcon(ObjectEntry objectEntry)
   {
      return ShellStubs.getDisplayIcon(objectEntry);
   }

	/**
	* Used to implement the ConsoleOne snapin persistance mechanism.
	* This function will indicate if an object is present in the snapin persistance store.
	*
   * @param key The key of the object to check for.
	*
	*/
	public boolean containsObject( String key )
	{
		return ShellStubs.containsObject( key );
	}

	/**
	* Used to implement the ConsoleOne snapin persistance mechanism.
	* This function will remove an object from the snapin persistance store
	*
   * @param key The key of the object to remove.
	*
	*/
	public Object removeObject( String key )
	{
		return ShellStubs.removeObject( key );
	}

	/**
	* Used to implement the ConsoleOne snapin persistance mechanism.
	*
   * @param key The key of the object to serialize in the snapin persistance store.
   * @param obj The object to be serialized.  Must implement the Serializable interface.
	*
	*/
	public void setObject( String key, java.io.Serializable obj )
	{
		ShellStubs.setObject( key, obj );
	}

	/**
	* Used to implement the ConsoleOne snapin persistance mechanism.
	*
   * @param key The key of the object to deserialize from the snapin persistance store.
	*
	*/
	public Object getObject( String key )
	{
		return ShellStubs.getObject( key );
	}
   
   /**
   * Save the snapin properties to the snapin persistance store.
   */
   public void saveSnapinPreferences()
   {
      ShellStubs.saveSnapinPreferences();
   }
   
 
   // The following old-style preference property methods are now deprecated.
   
   /**
   * Sets the specified values of property indicated.
   *
   * @param name The full name of the property under which to store values.
   * @param value The values of the property to store.
   * 
   * @deprecated  see #setObject().
   */
   public void setProperty(String name, String value)
   {
      setObject(name, value);
      //ShellStubs.setProperty(name, values);
   }

   /**
   * Returns the value of property.
   *
   * @param name The full name of the property from which to read values.
   * @return The value of property stored under 'name'.
   * 
   * @deprecated  see #getObject().
   */
   public String getProperty(String name)
   {
      return (String) getObject(name);
      //return ShellStubs.getProperty(name);
   }

   /**
   * Removes the values of the specified property.
   *
   * @param name The full name of the property from which to remove values.
   * 
   * @deprecated  see #removeObject().
   */
   public void removeProperty(String name)
   {
      removeObject(name);
      //ShellStubs.removeProperty(name);
   }

   /**
   * Commits the property value changes to the persistent store.
   *
   * @deprecated  see #saveSnapinPreferences().
   */
   public void saveProperties()
   {
      saveSnapinPreferences();
      //ShellStubs.saveProperties();
   }
   
   
   /**
   * Launches a property book showing the details of an ObjectEntry array.
   *
   * @param objectCollection The ObjectEntryCollection which provides the ObjectEntrys
   *                        for which details will be shown.
   * @param modal   The boolean flag indicating whether or not the property book
   *                will be modal.
   */
   public void showDetails(ObjectEntryCollection objectCollection, boolean modal )
   {
        ShellStubs.showDetails(objectCollection, modal);
   }

   /**
   * Launches a property book page dialog showing the details of an ObjectEntry
   * array.
   *
   * @param objectCollection The ObjectEntryCollection which provides the ObjectEntrys
   *                        for which details will be shown.
   * @param pages   The PageSnapin array to display.
   * @param modal   The boolean flag indicating whether or not the property book
   *                will be modal.
   */
   public void showDetails(ObjectEntryCollection objectCollection, PageSnapin[] pages, boolean modal )
   {
        ShellStubs.showDetails(objectCollection, pages, modal);
   }
   
   /**
    * @exclude
    */
   public void showDetails(ObjectEntryCollection objectCollection, PageSnapin[] pages, boolean modal, Component parent )
   {
      ShellStubs.showDetails(objectCollection, pages, modal, parent);
   }

   /**
   * Returns the display name associated with the specified ObjectEntry.
   *
   * <p>The MainShell interface gets this name from DisplayNameSnapin
   * snap-ins that have been registered against the passed in ObjectEntry.
   *
   * @param object The ObjectEntry for which to get the display name.
   *
   * @return The display name of the specified ObjectEntry.
   */
   public String getDisplayName(ObjectEntry object)
   {
      return ShellStubs.getDisplayName(object);
   }
   
   /**
   * Returns the display name associated with the specified ObjectEntry.
   *
   * <p>The MainShell interface gets this name from DisplayNameSnapin
   * snap-ins that have been registered against the passed in ObjectEntry.
   *
   * @param object The ObjectEntry for which to get the display name.
   * @param displayStyle The format of the name to return.  See DisplayNameSnapin.
   *
   * @return The display name of the specified ObjectEntry.
   */
   public String getDisplayName(ObjectEntry object, int displayStyle)
   {
      return ShellStubs.getDisplayName(object, displayStyle);
   }

   /**
   * Returns the display name associated with the specified namespace and
   * object type.
   *
   * <p>The MainShell class gets this name from  snap-ins (that have implemented
   * the DisplayNameSnapin interface), which have been registered against the
   * passed in namespace nad object type. The shell will use the returned name to
   * display the specified ObjectEntry in the tree or view. The name of the object
   * is displayed next to an icon representing the object. You can return null if
   * there is no display name being provided and you want the default display name
   * to be used.
   *
   * @param namespace The namespace for which to get the display name.
   * @param type      The name of the ObjectType for which to get the display name.
   *
   * @return The name to be displayed, as a string, or null if no name is being provided.
   *
   * @see #getDisplayName(com.novell.application.console.snapin.ObjectEntry)
   * @see DisplayNameSnapin#getDisplayName(java.lang.String, java.lang.String)
   */
   public String getDisplayName(String namespace, String type)
   {
      return ShellStubs.getDisplayName(namespace, type);
   }

   /**
   * Adds a property book listener to the shell.
   *
   * @param l The property book listener to be added.
   */
   public void addPropertyBookListener(PropertyBookListener l)
   {
      ShellStubs.addPropertyBookListener(l);
   }

   /**
   * Removes a property book listener from the shell.
   *
   * @param l The property book listener to be removed.
   */
   public void removePropertyBookListener(PropertyBookListener l)
   {
      ShellStubs.removePropertyBookListener(l);
   }

   /**
   * Adds a shell listener to the shell.
   *
   * @param l The shell listener to be added.
   *
   * @deprecated Replaced with addShellSelectionListener
   */
   public void addShellListener(ShellListener l)
   {
      ShellStubs.addShellListener(l);
   }

   /**
   * Removes a shell listener from the shell.
   *
   * @param l The shell listener to be removed.
   *
   * @deprecated Replaced with removeShellSelectionListener
   */
   public void removeShellListener(ShellListener l)
   {
      ShellStubs.removeShellListener(l);
   }

   /**
   * Adds a shell selection listener to the shell.
   *
   * @param l The shell selection listener to be added.
   */
   public void addShellSelectionListener(ShellSelectionListener l)
   {
      ShellStubs.addShellSelectionListener(l);
   }

   /**
   * Removes a shell selection listener from the shell.
   *
   * @param l The shell selection listener to be removed.
   */
   public void removeShellSelectionListener(ShellSelectionListener l)
   {
      ShellStubs.removeShellSelectionListener(l);
   }

   /**
   * Adds a shell lifecycle listener to the shell.
   *
   * @param l The shell lifecycle listener to be added.
   */
   public void addShellLifecycleListener(ShellLifecycleListener l)
   {
      ShellStubs.addShellLifecycleListener(l);
   }

   /**
   * Removes a shell lifecycle listener from the shell.
   *
   * @param l The shell lifecycle listener to be removed.
   */
   public void removeShellLifecycleListener(ShellLifecycleListener l)
   {
      ShellStubs.removeShellLifecycleListener(l);
   }
   
   /**
   * Adds a shell focus listener to the shell.
   *
   * @param l The shell focus listener to be added.
   */
   public void addShellFocusListener(ShellFocusListener l)
   {
      ShellStubs.addShellFocusListener(l);
   }

   /**
   * Removes a shell focus listener from the shell.
   *
   * @param l The shell focus listener to be removed.
   */
   public void removeShellFocusListener(ShellFocusListener l)
   {
      ShellStubs.removeShellFocusListener(l);
   }
   

   /**
   * Adds a tree refresh listener to the shell.
   *
   * @param l The tree refresh listener to be added.
   */
   public void addInvalidateCacheListener(InvalidateCacheListener l)
   {
      ShellStubs.addInvalidateCacheListener(l);
   }

   /**
   * Removes a tree refresh listener from the shell.
   *
   * @param l The tree refresh listener to be removed.
   */
   public void removeInvalidateCacheListener(InvalidateCacheListener l)
   {
      ShellStubs.removeInvalidateCacheListener(l);
   }

   /**
   * Adds a snap-in listener to the shell.
   *
   * @param l The snap-in listener to be added.
   * @param filter The events for which to listen.
   */
   public void addSnapinListener(SnapinListener l, String filter[])
   {
      for(int i = 0; i < filter.length; i++)
      {
         Vector vector;
         if(fSnapinListeners.containsKey(filter[i]))
         {
            vector = (Vector)fSnapinListeners.get(filter[i]);
         }
         else
         {
            vector = new Vector();
            fSnapinListeners.put(filter[i], vector);
         }
         vector.addElement(l);
      }
   }

   /**
   * Removes a snap-in listener from the shell.
   *
   * @param l The snap-in listener to be removed.
   */
   public void removeSnapinListener(SnapinListener l)
   {
      // note: this is extremely inefficient
      Enumeration enum = fSnapinListeners.elements();
      while(enum.hasMoreElements())
      {
         Vector vector = (Vector)enum.nextElement();
         vector.removeElement(l);
      }
   }

   /**
   * Posts a vetoable snap-in event.
   *
   * @param event The vetoable snap-in event to be posted.
   *
   * @exception SnapinVetoException Thrown in response to a vetoable event.
   */
   public void postVetoableSnapinEvent(SnapinEvent event)
      throws SnapinVetoException
   {
      String key = (String)event.getEvent();
      Vector vector = (Vector)fVetoableSnapinListeners.get(key);
      if(vector == null)
      {
         return;
      }
      Enumeration enum = vector.elements();
      while(enum.hasMoreElements())
      {
         ((VetoableSnapinListener)enum.nextElement()).vetoableSnapinListener(event);
      }
   }

   /**
   * Posts a SnapinEvent.
   *
   * @param event The snap-in event to be posted.
   */
   public void postSnapinEvent(SnapinEvent event)
   {
      String key = (String)event.getEvent();
      Vector vector = (Vector)fSnapinListeners.get(key);
      if(vector == null)
      {
         return;
      }
      Enumeration enum = vector.elements();
      while(enum.hasMoreElements())
      {
         try
         {
            ((SnapinListener)enum.nextElement()).snapinListener(event);
         }
         catch(Exception e)
         {
            D.reportSnapinError(e);
         }
      }
   }

   /**
   * Adds a vetoable snap-in event listener to the shell.
   *
   * @param l The vetoable snap-in listener to be added.
   * @param filter The vetoable events for which to listen.
   */
   public void addVetoableSnapinListener(VetoableSnapinListener l, String filter[])
   {
      for(int i = 0; i < filter.length; i++)
      {
         Vector vector;
         if(fVetoableSnapinListeners.containsKey(filter[i]))
         {
            vector = (Vector)fVetoableSnapinListeners.get(filter[i]);
         }
         else
         {
            vector = new Vector();
            fVetoableSnapinListeners.put(filter[i], vector);
         }
         vector.addElement(l);
      }
   }

   /**
   * Removes a vetoable snap-in listener from the shell.
   *
   * @param l The vetoable snap-in listener to be removed.
   */
   public void removeVetoableSnapinListener(VetoableSnapinListener l)
   {
      Enumeration enum = fVetoableSnapinListeners.elements();
      while(enum.hasMoreElements())
      {
         // this could be inefficient
         ((Vector)enum.nextElement()).removeElement(l);
      }
   }

   /**
   * Returns the shell Frame.
   *
   * <p>The shell Frame may be needed when snap-ins create dialogs. It should not be
   * manipulated or changed directly by snap-ins.
   *
   * @return Frame of the shell.
   */
   public JFrame getShellFrame()
   {
      return ShellStubs.getShellFrame();
   }

	/**
	* Adds the specified key listener to receive key events from a particular view.
	* If l is null, no exception is thrown and no action is performed.
   *
	* @param l The key listener to be added.
	* @param viewUniqueID The unique ID of the view to add the key listener too.
   *
   * @exclude
	*/
	public void addViewKeyListener(KeyListener l, String viewUniqueID)
	{
		ShellStubs.addViewKeyListener(l, viewUniqueID);
	}

	/**
    * Removes the specified key listener to receive key events from a particular view.
    * If l is null, no exception is thrown and no action is performed.
    *
    * @param l The key listener to be removed.
    * @param viewUniqueID The unique ID of the view to remove the key listener from.
    *
    * @exclude
    */
	public void removeViewKeyListener(KeyListener l, String viewUniqueID)
	{
		ShellStubs.removeViewKeyListener(l,viewUniqueID);
	}


	/**
    * Adds the specified key listener to receive key events from the tree.
    *
    * <p>If l is null, no exception is thrown and no action is performed.
    *
    * @param l The key listener to be added.
    *
    * @exclude
    */
	public void addTreeKeyListener(KeyListener l)
	{
		ShellStubs.addTreeKeyListener(l);
	}

	/**
    * Removes the specified key listener to receive key events from the tree.
    *
    * <p>If l is null, no exception is thrown and no action is performed.
    *
    * @param l The key listener to be removed.
    *
    * @exclude
    */
	public void removeTreeKeyListener(KeyListener l)
	{
		ShellStubs.removeTreeKeyListener(l);
	}

   /**
   * Returns the current view snapin in the console.
   *
   * @return The current console view snapin.
   */
   public ViewSnapin getCurrentViewSnapin()
   {
      return ShellStubs.getCurrentViewSnapin();
   }

   /**
   * Returns the current view Component in the console.
   *
   * @return The current console view as a Component.
   *
   * @see #setCurrentView
   */
   public Component getCurrentView()
   {
      return ShellStubs.getCurrentView();
   }

   /**
   * Sets the view menu in the console.
   *
   * @param newViewMenu The new view menu for the console.
   */
   public void setViewMenu(JMenu newViewMenu)
   {
      ShellStubs.setViewMenu(newViewMenu);
   }

   /**
   * Set the current view based on its unique ID as a String name.
   *
   * <p> The view must already be in the view menu to be set. A boolean
   * flag is returned; set to <i>true</i> if the shell is able to set the
   * view, or <i>false</i> if not.
   *
   * @param viewName The uniqueID of a view that is available in the view menu.
   *
   * @return A boolean indicating whether or not the shell was able to set the view.
   *
   * @see #getCurrentView()
   */
   public boolean setCurrentView(String viewName)
   {
      return ShellStubs.setCurrentView(viewName);
   }

   /*
   * Opens the print dialog, and allows the selection to print the current view
   * (tree or both).
   */
   /*
   public void print()
   {
      ShellStubs.print();
   }
   */

   /**
   * Shuts down all snap-ins so the shell can shut down.
   *
   * <p>Use the exit() method so that the shell can properly shut down all
   * snap-ins before exiting.
   *
   * @param status The integer to be returned to the caller that instantiated the shell.
   */
   public void exit(int status)
   {
      ShellStubs.exit(status);
   }

   /**
   * Sets the current selection to a particular object in the tree.
   *
   * @param selection The object to select.
   */
   public void setTreeSelection(ObjectEntry selection)
   {
      ShellStubs.setTreeSelection(selection);
   }

   /**
   * Sets the current selection to a set of objects in the view.
   *
   * @param selections The objects selected to be set.
   */
   public void setViewSelections(ObjectEntry[] selections)
   {
      ShellStubs.setViewSelections(selections);
   }

   /**
   * Sets the current selection to a set of objects in the view.
   *
   * @param selections The objects selected to be set.
   */
   public void setViewSelections(ObjectEntryCollection selections)
   {
      ShellStubs.setViewSelections(selections);
   }

   /**
   * Adds the indicated entries to the current view selection.
   *
   * @param selections The objects to be added to the selection.
   */
   public void addViewSelections(ObjectEntry[] selections)
   {
      ShellStubs.addViewSelections(selections);
   }

   /**
   * Adds the indicated entries to the current view selection.
   *
   * @param selections The objects to be added to the selection.
   */
   public void addViewSelections(ObjectEntryCollection selections)
   {
      ShellStubs.addViewSelections(selections);
   }

   /**
   * Clears the current view selection.
   */
   public void clearViewSelection()
   {
      ShellStubs.clearViewSelection();
   }

   /**
   * Add all entries to the current view selection.
   */
   public void selectAllViewSelection()
   {
      ShellStubs.selectAllViewSelection();
   }

   /**
   * Ensures the indicated object is visible in the current view.
   *
   * @param object The object to make visible.
   */
   public void ensureViewObjectIsVisible(ObjectEntry object)
   {
      ShellStubs.ensureViewObjectIsVisible(object);
   }

   /**
   * Checks to see of an object is a container.
   *
   * <p>Use this method instead of ObjectType.isContainer because, even
   * though an object may not originally be defined as a container
   * whithin its namespace, it may be extended. This call will return
   * <i>true</i> if the entry is originally defined as a container or
   * if it has been extended to be a conatiner by another snap-in.
   *
   * @param entry The ObjectEntry about which to query.
   * @return A boolean set to <i>true</i> if the entry is a container,
   *         otherwise set to <i>false</i>.
   */
   public boolean isContainer(ObjectEntry entry)
   {
      return ShellStubs.isContainer(entry);
   }

   /**
   * Returns the enumeration of children for an ObjectEntry.
   *
   * @param entry The ObjectEntry for which to get children.
   * @return The enumeration of children object entries.
   * @deprecated As of ConsoleOne version 1.2.  Use Shell.getChildren(ObjectEntry, ResultModifier) instead.
   */
   public ObjectEntryEnumeration getChildren(ObjectEntry entry) throws SnapinException
   {
      return getChildren(entry, null);
   }

   /**
   * Returns the enumeration of children for an ObjectEntry.
   *
   * @param entry The ObjectEntry for which to get children.
	*
	* @param resultModifier the modifier for which to change an enumeration result.
   *
   * @return The enumeration of child object entries.
   */
   public ObjectEntryEnumeration getChildren(ObjectEntry entry, ResultModifier resultModifier) throws SnapinException
	{
      return ShellStubs.getChildren(entry, resultModifier);
	}

   /**
   * Returns an ObjectEntry's children that should appear in the tree.
   *
   * @param entry The ObjectEntry for which to get children that should appear in the tree.
	* @param resultModifier the modifier for which to change an enumeration result.
   * @return The enumeration of child object entries.
   */
   public ObjectEntryEnumeration getChildContainers(ObjectEntry entry, ResultModifier resultModifier) throws SnapinException
	{
      return ShellStubs.getChildContainers(entry, resultModifier);
	}

  /** Returns an array of object types contained by the name space.
   *
   * @param referenceContext An ObjectEntry providing the context from which
   * the ObjectTypes will be extracted.  The context could change the returned
   * ObjectTypes if non-global schema is encountered.
   *
   * @return An array of object types contained within a name space. Null
   *         will be handled but pick lists will display an empty set.
   *
   * @see ObjectType
   *
   */
	public ObjectType[] getObjectTypes(ObjectEntry referenceContext)
	{
		return ShellStubs.getObjectTypes(referenceContext);
	}


   /**
   * Executes the default action on an ObjectEntry.
   *
   * <p>The defualt action is defined as the popup menu item in the
   * ObjectEntry's popup menu that is a DefaultMenuItem. If more than
   * one menu item is derived from DefaultMenuItem, the first one found
   * is executed. Snap-in views can use this method to perform the default
   * action when an ObjectEntry is double clicked in the view.
   *
   * @param entry The Object on which to execute default action.
   *
   * @return A boolean set to <i>true</i> if the DefaultMenuItem has been
   *         found and executed, or <i>false</i> if no DefaultMenuItem is found.
   */
   public boolean executeDefaultPopupMenuItemAction(ObjectEntry entry)
   {
      return ShellStubs.executeDefaultPopupMenuItemAction(entry);
   }

   /**
   * Launches a generic snap-in configurator.
   *
   * <p>This allows the user to configure snap-ins based on the
   * namespace of the currently selected object in the tree and
   * the current view or the type of the currently selected object.
   */
   public void launchConfigurator()
   {
      ShellStubs.launchConfigurator();
   }

   /**
   * Asks all registationItems to load and return their snapins
   * based on a scope.  The caller is responsible for calling initSnapin()
   * and shutdownSnapin() on the snapins returned from this call.
   *
   * @param theScope The scope for this call.  This parameter allows
   * you to specify a scope that applies to this call to the registry.
   *
   * @deprecated As of ConsoleOne version 1.2. Use loadSnapins() instead.
   */
   public Vector getSnapins( Scope theScope )
   {
      Snapin[] snapins = ShellStubs.loadSnapins(new Scope[]{theScope});
      Vector vector = new Vector();

      for(int i=0; i < snapins.length; i++)
      {
         vector.addElement(snapins[i]);
      }

      return vector;
   }

   /**
   * Returns an array of snap-ins based on the Scope parameter.
   *
   * The loadSnapins() method asks all registationItems to load and
   * return their snap-ins based on a Scope. The Scope parameter allows
   * you to specify a scope that applies to this call to the registry.
   * The caller is responsible for calling initSnapin() and shutdownSnapin()
   * on the snap-ins returned from this call.
   *
   * @param theScope The scope of the snap-ins to return.
   *
   * @return The array of snapins specified by the Scope parameter.
   */
   public Snapin[] loadSnapins( Scope theScope )
   {
      return ShellStubs.loadSnapins(new Scope[]{theScope});
   }

   /**
   * Returns an array of snap-ins based on the scopes parameter.
   *
   * <p>The loadSnapins() method asks all registrationItems to load and
   * return their snap-ins based on the Scope array passed in. The scopes parameter allows
   * you to specify the array of scopes that applies to this call to the registry.
   * The caller is responsible for calling initSnapin() and shutdownSnapin()
   * on the snap-ins returned from this call.
   *
   * @param scopes The scope of the snap-ins to return.
   * @return The array of snapins specified by the scopes parameter.
   */
   public Snapin[] loadSnapins( Scope[] scopes )
   {
      return ShellStubs.loadSnapins(scopes);
   }

   /**
   * Returns an array of snap-ins based on the scopes parameter.
   *
   * <p>The loadSnapins() method asks all registrationItems to load and
   * return their snap-ins based on the Scope array passed in. The scopes parameter allows
   * you to specify the array of scopes that applies to this call to the registry.
   * The caller is responsible for calling initSnapin() and shutdownSnapin()
   * on the snap-ins returned from this call.
   * The context parameter is the context passed to all dynamic snap-ins
   * that may be queried by this call to loadSnapins().
   *
   * @param scopes The scope of the snap-ins to return.
   * @param context The snap-in context to be passed to any dynamic snap-ins loaded.
   *
   * @return The array of snapins specified by the Scope parameter.
   */
   public Snapin[] loadSnapins( Scope[] scopes, SnapinContext context )
   {
      return ShellStubs.loadSnapins(scopes, context);
   }

   /**
   * Returns an array of page snap-ins based on the object entry parameter.
   *
   * <p>The loadSnapins() method asks all registrationItems to load and
   * return their snap-ins based on the object entry passed in.
   * The caller is responsible for calling initSnapin() and shutdownSnapin()
   * on the snap-ins returned from this call.
   *
   * @param objectEntry The object entry associated with the page snap-ins.
   *
   * @return The array of snap-ins specified by the objectEntry parameter.
   */
   public Snapin[] loadPageSnapins(ObjectEntry objectEntry)
   {
      return ShellStubs.loadPageSnapins(objectEntry);
   }

	/**
	 * Checks the registry for the existance of snapins based on a scope
	 */
	public boolean checkSnapins( Scope scope )
	{
		return ShellStubs.checkSnapins( scope );
	}

   /**
   * Adds an ObjectEntry to the root level of the tree.
   *
   * <p>The ObjectEntry can be put at the root level temporarily,
   * in which case when the shell is brought down, then back up,
   * it will not be there.</p>
   *
   * <p>NOTE: The persist parameter is no longer used.</p>
   *
   * @param entry The ObjectEntry to add to the root level of the tree.
   * @param persist No longer used by ConsoleOne
   */
   public void addObjectEntryToTreeRoot(ObjectEntry entry, boolean persist)
   {
      ShellStubs.addObjectEntryToTreeRoot(entry, persist);
   }

   /**
   * Removes an ObjectEntry from the root level of the tree.
   *
   * @param entry The ObjectEntry to remove.
   */
   public void removeObjectEntryFromTreeRoot(ObjectEntry entry)
   {
      ShellStubs.removeObjectEntryFromTreeRoot(entry);
   }

   /**
   * Returns the ObjectEntry array currently making up the root
   * level of the tree.
   *
   * @return The ObjectEntry array at the root of the tree.
   */
   public ObjectEntry[] getRootTreeList()
   {
      return ShellStubs.getRootTreeList();
   }

   /**
   * Returns all namespaces that are currently loaded.
   *
   * @return The array of namespaces currently loaded.
   */
   public NamespaceSnapin[] getAllNamespaceSnapins()
   {
      return ShellStubs.getAllNamespaceSnapins();
   }

   /**
   * Returns the namespace specified by its uniqueID string.
   *
   * @param uniqueID The string identifying the namespace.
   *
   * @return The namespace specified by 'uniqueID'. Returns null if
   *         the namespace with the specified uniqueID is not found.
   */
   public NamespaceSnapin getNamespaceSnapin(String uniqueID)
   {
      return ShellStubs.getNamespaceSnapin(uniqueID);
   }

   /**
   * Launches the help index.
   *
   * <p>The help index is an alphabetical list of all the indexes in
   * the help files. Most views of help have an index button in the frame
   * that will allow you to jump to the index view. You can then click
   * on an index and jump to the HTML file. The launchHelpIndex()
   * method brings up the index view automatically without going
   * through the intermediary step of viewing a help file.
   *
   * @see #launchHelp(java.lang.String)
   *
   * @deprecated As of ConsoleOne version 1.2
   */
   public void launchHelpIndex()
   {
   }

   /**
    * This should be called by the view when it gains focus, by something
    * such as a mouse click.  This will cause the proper notifications to
    * take place and the tree will lose focus.  This should only be called
    * by the current active view snapin.
    */
   public void viewGainedFocus()
   {
      ShellStubs.viewGainedFocus();
   }

   /**
    * @exclude
    */
   public void promote(ObjectEntry oe)
   {
      ShellStubs.promote(oe);
   }

   /**
    * Adds a resource bundle to list of resource bundles to get
    * translated strings from using getTranslatedString().  These resource
    * bundles should contain items such as translated type and property names.
    *
    * @param namespace The namespace to associate this resource bundle with.
    * @param resBundleName The full package and class or file name of the resource bundle.
    * (ie. com.novell.application.console.ConsoleResourceBundle)
    */
   public void addTranslatedStringResourceBundle(String namespace, String resBundleName)
   {
      ShellStubs.addTranslatedStringResourceBundle(namespace, resBundleName);
   }

   /**
    * Adds a path to a list of paths to get icons from using getIcon(). These paths
    * should contain images such as generic type and property images.
    *
    * @param namespace The namespace to associate this resouce bundle with.
    * @param directoryName The full path to the directory which contains the icons.
    */
   public void addImagePoolDirectory(String namespace, String directoryName)
   {
      ShellStubs.addImagePoolDirectory(namespace, directoryName);
   }

   /**
    * Returns the translated strings associated with a namespace from resource bundles
    * registered with addTranslatedStringResourceBundle(). These can be translated type
    * and property names. If no translation is found, the key is returned.
    *
    * @param namespace The namespace that is associated with the desired translation.
    * @param key The key associated with the translation.  This will usually be the type or property name (User, Group, Description, etc.).
    * @return The translated string or the key if no translation was found.
    */
   public String getTranslatedString(String namespace, String key)
   {
      return ShellStubs.getTranslatedString(namespace, key);
   }

   /**
    * Returns the images associated with a namespace from directories registered with
    * {@link #addImagePoolDirectory}. These can be type and property icons (if any exist).
    * If an icon is not found, a default unknown icon is returned.
    *
    * @param namespace The namespace which is associated with the desired icon.
    * @param imageName The key associated with the icon.  This will usually be the type or property name (User, Group, Description, etc.).
    * @return The registered icon or a default icon if no icon was found.
    */
   public Icon getIcon(String namespace, String imageName)
   {
      return ShellStubs.getIcon(namespace, imageName);
   }

   /**
    * Returns the ObjectEntries that from other namespaces that this entry maps to. Returns
    * a zero length array if no ObjectEntries can be mapped to. ObjectEnries are mapped to
    * other namespaces through registered MapObjectEntrySnapins.
    *
    * @param entry The original entry that is to be mapped to other namespaces.
    * @return The array of mapped ObjectEntries or a zero length array if no entries could be mapped.
    */
   public ObjectEntry[] mapObjectEntry(ObjectEntry entry) throws SnapinException
   {
      return ShellStubs.mapObjectEntry(entry);
   }

   /**
    * Returns the ObjectEntry from a given namespace that this entry maps to. Returns null
    * if no ObjectEntry can be mapped to. ObjectEnries are mapped to
    * other namespaces through registered MapObjectEntrySnapins.
    *
    * @param entry The original entry that is to be mapped to the target namespace.
    * @param namespaceUniqueID The target namespace to map the passed in ObjectEntry to.
    * @return An entry from the target namespace that is associated with the passed in entry
    */
   public ObjectEntry mapObjectEntryToNamespace(ObjectEntry entry, String namespaceUniqueID) throws SnapinException
   {
      return ShellStubs.mapObjectEntryToNamespace(entry, namespaceUniqueID);
   }

   /**
    * @exclude
    */
   public boolean canMapObjectEntryToNamespace(ObjectEntry oe, String namespaceUniqueID)
   {
      return ShellStubs.canMapObjectEntryToNamespace(oe, namespaceUniqueID);
   }
   
   /**
    * Returns the ObjectEntry from a given namespace instance that this entry maps to.  Returns null
    * if no ObjectEntry can be mapped to.  ObjectEnries are mapped to
    * other namespaces through registered MapObjectEntrySnapins.
    *
    * @param entry The original entry that is to be mapped to the target namespace.
    * @param namespaceClassName The target namespace to map the passed in ObjectEntry to.
    * @return An entry from the target namespace that is associated with the passed in entry
    * @exception SnapinException Thrown to notify shell that mapObjectEntryToNamespace failed.
    * @see SnapinException
    *
    * @exclude
    */
   public ObjectEntry mapObjectEntryToInstanceOfNamespace(ObjectEntry entry, String namespaceClassName) throws SnapinException
   {
      return ShellStubs.mapObjectEntryToInstanceOfNamespace(entry, namespaceClassName);
   }

   /**
    * Re-roots the tree to the item currently selected. This can be the item selected in the tree or the view,
    * whichever one is the current selection. If more than one item is selected, the first item is set as root.
    */
   public void setCurrentSelectionAsRoot()
   {
      ShellStubs.setCurrentSelectionAsRoot();
   }

   /**
    * Sets MyWorld as the root of the tree. This restores MyWorld as the root of the tree.
    */
   public void setMyWorldAsRoot()
   {
      ShellStubs.setMyWorldAsRoot();
   }

   /**
    * Sets the root of the tree as the parent of the current root item.
    */
   public void goUpOneLevel()
   {
      ShellStubs.goUpOneLevel();
   }

   /**
    * Returns true if the tree has been re-rooted to an object other than My World.
    *
    * @return boolean indicating status of tree rooting.
    */
   public boolean isTreeReRooted()
   {
      return ShellStubs.isTreeReRooted();
   }

   //REMIND: Matt
   /**
    * Saves a named search result modifier for the specified namespace.
    *
    * @param namespaceUniqueID The ID of the namespace.
    * @param resultModifierName The specified search result modifier.
    * @param rm The result modifier.
    */
   public void setSearchResultModifier(String namespaceUniqueID, String resultModifierName, ResultModifier rm)
   {
      ShellStubs.setSearchResultModifier(namespaceUniqueID, resultModifierName, rm);
   }

   //REMIND: Matt
   /**
    * Saves a named filter result modifier for the specified namespace.
    *
    * @param namespaceUniqueID The specified namespace.
    * @param resultModifierName The filter result modifier.
    * @param rm The result modifier.
    */
   public void setFilterResultModifier(String namespaceUniqueID, String resultModifierName, ResultModifier rm)
   {
      ShellStubs.setFilterResultModifier(namespaceUniqueID, resultModifierName, rm);
   }

   //REMIND: Matt
   /**
    * Gets a search result modifier for the specified namespace.
    *
    * @param namespaceUniqueID The namespace ID.
    * @param resultModifierName The result modifier name.
    *
    * @return The search result modifier specified in resultModifierName.
    */
   public ResultModifier getSearchResultModifier(String namespaceUniqueID, String resultModifierName)
   {
      return ShellStubs.getSearchResultModifier(namespaceUniqueID, resultModifierName);
   }

   //REMIND: Matt
   /**
    * Gets a named filter result modifier for the specified namespace.
    *
    * @param namespaceUniqueID The namespace ID.
    * @param resultModifierName The result modifier name.
    *
    * @return The filter result modifier specified in resultModifierName.
    */
   public ResultModifier getFilterResultModifier(String namespaceUniqueID, String resultModifierName)
   {
      return ShellStubs.getFilterResultModifier(namespaceUniqueID, resultModifierName);
   }

   /**
    * Starts the search dialog to process the search requests and display results.
    * The userObject allows you to create a ResultModifier snap-in that launches its user interface in an
    * initial state other than the default.
    *
    * @param userObject The userObject that defines how the snap-in is initialized
    */
   public void launchFind(Object userObject)
   {
      ShellStubs.launchFind(userObject);
   }

   //REMIND: Drew: What is the userObject parameter?
   /**
    * Starts the filter dialog to process and apply filter requests to the current view.
    * The userObject allows you to create a ResultModifier snap-in that launches its user interface in an
    * initial state other than the default.
    *
    * @param userObject The userObject that defines how the snap-in is initialized
    */
   public void launchFilter(Object userObject)
   {
      ShellStubs.launchFilter(userObject);
   }

   //REMIND: Drew, need a description here.
   /**
   * Launches PropertyBook preferences.
   *
   *
   */
   public void launchPreferences()
   {
      ShellStubs.launchPreferences();
   }

   /**
    * Replaces an item in the tree with a new entry. This may occur because of renaming or
    * other actions. It is up to the caller to make sure that items subordinate to the entry are still valid.
    * If oldEntry cannot be found, the item is not replaced.
    *
    * @param oldEntry The ObjectEntry in the tree to be replaced.
    * @param newEntry The ObjectEntry that will replace the oldEntry in the tree.
    */
   public void replaceTreeEntry(ObjectEntry oldEntry, ObjectEntry newEntry)
   {
      ShellStubs.replaceTreeEntry(oldEntry, newEntry);
   }

   /**
    * Takes the appropriate action for a snap-in exception, such as reporting the error to
    * the user if necessary or exiting if the error is fatal. This should be called
    * by snap-ins that make any calls that throw SnapinException.
    *
    * @param exception The snapin exception to be handled.
    */
   public void handleSnapinException(SnapinException exception)
   {
      ShellStubs.handleSnapinException(exception);
   }

   /**
   * Set Cursor in ConsoleOne.
   */
   public void setCursor(Cursor cursor)
   {
      ShellStubs.setCursor(cursor);
   }

   /**
   * Gets ConsoleOne's cursor.
   */
   public Cursor getCursor()
   {
      return ShellStubs.getCursor();
   }

  /**
   * Sets the Console to the busy state.
   * 
   * @param busyObject The object that is busy. Normally, the view.
   * @param busy true if the object is entering the busy state, false otherwise.
   * @param busyCategory The type of object that is busy.  This can be any of the BUSY_CATEGORY_* Shell constants.
   */
   public void setBusy(Object busyObject, boolean busy, int busyCategory)
   {
      ShellStubs.setBusy(busyObject, busy, busyCategory);
   }

   /**
    * @exclude
    */
   public void refreshGUISnapins()
   {
      ShellStubs.refreshGUISnapins();
   }
   
   /**
    * @exclude
    */
   public void refreshGUISnapins(boolean repopulateViews)
   {
      ShellStubs.refreshGUISnapins(repopulateViews);
   }

   /**
    * Refreshes the name and icon for an object in the tree.
    *
    * @param entry The ObjectEntry of the item in the tree to be refreshed.
    */
   public void refreshTreeEntryNameAndIcon(ObjectEntry entry)
   {
      ShellStubs.refreshTreeEntryNameAndIcon(entry);
   }

   /**
    * @exclude
    */
   public boolean checkForPageSnapins(ObjectEntryCollection entries)
   {
      return ShellStubs.checkForPageSnapins(entries);
   }

   /**
    * @exclude
    */
   public NamespaceSnapin[] getInstanceOfNamespaceSnapins(String namespaceClassName)
   {
      return ShellStubs.getInstanceOfNamespaceSnapins(namespaceClassName);
   }

   public void getChildContainersAsync(ObjectEntry entry, ResultModifier modifier, GetChildrenCallback callback, Object userData)
   {
      ShellStubs.getChildContainersAsync(entry, modifier, callback, userData, true);
   }

   public void getChildrenAsync(ObjectEntry entry, ResultModifier modifier, GetChildrenCallback callback, Object userData)
   {
      ShellStubs.getChildrenAsync(entry, modifier, callback, userData, true);
   }

   /**
    * @exclude
    */
   public ObjectEntry getLastExpandedContainer()
   {
      return ShellStubs.getLastExpandedContainer();
   }

   /**
    * @exclude
    */
   public void addExtraObjectEntryToPlaceholder(String placeholder, ObjectEntry oe)
   {
      ShellStubs.addExtraObjectEntryToPlaceholder(placeholder, oe);
   }
   
   /**
    * @exclude
    */
   public void invalidateCacheOnCurrentTreeSelection()
   {
      ShellStubs.invalidateCacheOnCurrentTreeSelection();
   }
   
   /**
    * @exclude
    */
   public void setStopButton(JButton button)
   {
      ShellStubs.setStopButton(button);
   }
   
   /**
    * @exclude
    */
   public void stopBusyObjects()
   {
      ShellStubs.stopBusyObjects();
   }
   
   public boolean displayURL(String url)
   {
      return ShellStubs.displayURL(url);
   }
   
   /**
    * @exclude
    */
   public void setHideObjectTypes(String[] objectTypes, String namespace)
   {
      ShellStubs.setHideObjectTypes(objectTypes, namespace);
   }
   
   /**
    * @exclude
    */
   public String[] getHideObjectTypes(String namespace)
   {
      return ShellStubs.getHideObjectTypes(namespace);
   }
   
   /**
    * @exclude
    */
   public ObjectEntryEnumeration wrapWithHideFilterEnumeration(ObjectEntryEnumeration enum)
   {
      return ShellStubs.wrapWithHideFilterEnumeration(enum);
   }
   
   /**
    * @exclude
    */
   public void insertObjectEntryIntoTree(ObjectEntry parent, ObjectEntry child, int index)
   {
      ShellStubs.insertObjectEntryIntoTree(parent, child, index);
   }
   
   /**
    * @exclude
    */
   public void deleteObjectEntryFromTree(ObjectEntry oe)
   {
      ShellStubs.deleteObjectEntryFromTree(oe);
   }
   
   /**
    * @exclude
    */
   public void giveTreeFocus()
   {
      ShellStubs.giveTreeFocus();
   }
   
   /**
    * @exclude
    */
   public void viewSelectionChanged(ObjectEntryCollection oec)
   {
      ShellStubs.viewSelectionChanged(oec);
   }
   
   /**
    * @exclude
    */
   public void excludePage(String ns, String type, String pageSnapinClassName)
   {
      ShellStubs.excludePage(ns, type, pageSnapinClassName);
   }
   
   /**
    * @exclude
    */
   public void excludePageInheritanceForType(String ns, String type, String typeToExclude)
   {
      ShellStubs.excludePageInheritanceForType(ns, type, typeToExclude);
   }
   
   /**
    * @exclude
    */
   public void abortShutdown()
   {
      ShellStubs.abortShutdown();
   }
   
   /**
    * @exclude
    */
   public javax.swing.FocusManager getConsoleFocusManager()
   {
      return ShellStubs.getFocusManager();
   }
   
   /**
    * @exclude
    */
   public String[] getCommandLine()
   {
      return ShellStubs.getCommandLine();
   }
   
   /**
    * @exclude
    */
   public void addObjectEntryChangeListener(ObjectEntryChangeListener l)
   {
      ShellStubs.addObjectEntryChangeListener(l);
   }
   
   /**
    * @exclude
    */
   public void removeObjectEntryChangeListener(ObjectEntryChangeListener l)
   {
      ShellStubs.removeObjectEntryChangeListener(l);
   }
   
   /**
    * @exclude
    */
   public void postObjectEntryChangeEvent(ObjectEntryChangeEvent event)
   {
      ShellStubs.postObjectEntryChangeEvent(event);
   }
   
   /**
    * @exclude
    */
   public void doRefresh()
   {
      ShellStubs.doRefresh();
   }
   
   /**
    * @exclude
    */
   public void setTypesToBlockNativeChildrenOn(String[] objectTypes, String namespace)
   {
      ShellStubs.setTypesToBlockNativeChildren(objectTypes, namespace);
   }
   
   /**
    * @exclude
    */
   public String[] getTypesToBlockNativeChildrenOn(String namespace)
   {
      return ShellStubs.getTypesToBlockNativeChildren(namespace);
   }
   
   /**
    * @exclude
    */
   public ObjectEntry getPlaceholderObjectEntry(String id)
   {
      return ShellStubs.getPlaceholderObjectEntry(id);
   }
   
   /**
    * @exclude
    */
	public void refreshTreeEntryWithoutPostingSelChanged(ObjectEntry refreshEntry)
	{
		ShellStubs.refreshTreeEntryWithoutPostingSelChanged(refreshEntry);
	}
}

/*
$Log: MainShell.java,v $
Revision 1.1.1.1  2001/05/09 12:43:23  rommel
Sandbox initial version uploaded from novell cd 1/3

Revision 1.171  2000/07/26 16:54:42  DChamberlain
Discovered @@exclude was the right tag, changed back.
Revision 1.170  2000/07/24 17:53:28Z  DChamberlain
Added refreshTreeEntryWithoutPostingSelChanged() for mw.
Revision 1.169  2000/06/29 19:26:34Z  DChamberlain
Changed @@exclude javadoc tag to proper @@excluded tag.
Revision 1.168  2000/05/13 00:48:40Z  DChamberlain
Added refreshGUISnapins(boolean).
Revision 1.167  2000/04/03 23:24:21Z  DChamberlain
Added getPlaceholderObjectEntry().
Revision 1.166  2000/03/03 21:53:57Z  DChamberlain
Removed deprecated call.
Revision 1.165  2000/03/03 21:39:17Z  DChamberlain
Took out deprecated call to ShellStubs.synchronizeHelp().
Revision 1.164  2000/03/03 20:23:25Z  DChamberlain
Added get and setTypesToBlockNativeChildrenOn.
Revision 1.163  2000/02/02 00:08:34Z  DChamberlain
Removed old, broken, unused disallowInheritedPages() call.
Revision 1.162  2000/01/14 00:36:01Z  DChamberlain
Added doRefresh().
Revision 1.161  1999/12/13 23:05:48  DChamberlain
Added getCommandLine() to the Shell.
Revision 1.160  1999/12/09 18:26:56  DChamberlain
Added getConsoleFocusManager() for partition stuff to fix focus bug.  Bug# 216550.
Revision 1.159  1999/12/02 23:11:37  DChamberlain
Added abort shutdown.
Revision 1.158  1999/11/23 21:47:12  DChamberlain
Added ability to exclude pages for Zen.
Revision 1.157  1999/11/19 23:22:27  mharris
Split Preferences into ShellPreferences and SnapinPreferences
Revision 1.156  1999/11/17 15:42:02  DChamberlain
Added lanchHelp() calls that take a parent window.  Deprecated other calls.
This is part of the fix for bug 200784 and 207483.
Revision 1.155  1999/11/12 21:40:28  DChamberlain
Added viewSelectionChanged().
Revision 1.154  1999/11/05 04:12:06  DChamberlain
Add disallowInheritedPages().
Revision 1.153  1999/10/27 23:36:14  DChamberlain
Added showDetails that takes a component.
Revision 1.152  1999/10/06 22:35:52  DChamberlain
Added canMap and support for display style in DisplayName methods.
Revision 1.151  1999/09/28 20:52:30  mharris
Implemented ability to input desired NDS access method from command line
Revision 1.150  1999/09/17 14:56:00  DChamberlain
Finished hiding object methods in shell.
Revision 1.149  1999/09/02 23:34:04  DChamberlain
Added hidden stuff.
Revision 1.148  1999/08/18 18:59:16  DChamberlain
Added Shell.displayURL()
Revision 1.147  1999/08/12 23:27:14  DChamberlain
Added shell calls for focus events.
Revision 1.146  1999/07/29 20:12:19  DChamberlain
Didn't really checkin the changes last time.
Revision 1.144  1999/07/26 15:28:34  DChamberlain
Added stop button helper methods.
Revision 1.143  1999/07/01 22:28:00  DChamberlain
Renamed UpdateCache to InvalidateCache.
Revision 1.142  1999/06/28 18:02:25  DChamberlain
Added category parameter to setBusy().
Revision 1.141  1999/06/28 14:55:20  DChamberlain
Changed treeRefresh to updateCache.
Revision 1.140  1999/06/18 21:38:20  mharris
Implemented version access methods.
Revision 1.139  1999/06/14 18:42:48  DChamberlain
Added Placeholder snapin type and addExtraObjectEntryToPlaceholder().
Revision 1.138  1999/05/24 23:08:57  mharris
SPD 230672 (BQ73770)  Implemented ShellLifecycleEvents to provide various lifecycle events (including snapin shutdown)
Revision 1.137  1999/05/18 22:15:32  mharris
Added ShellSelection* stuff.  Deprecated Shell* stuff
Revision 1.136  1999/05/17 16:59:53  DChamberlain
Added getLastContainerExpanded().
Revision 1.135  1999/05/12 15:40:01  DChamberlain
Added getActionsMenu().
Revision 1.134  1999/04/26 19:02:42  DChamberlain
Added async param to ShellStubs getChildrenAsync calls.
Revision 1.133  1999/04/22 21:23:24  DChamberlain
Added getChildrenAsync() and getChildContainersAsync().
Revision 1.132  1999/04/01 21:51:56  DChamberlain
Removed dependencies on j g l.
Revision 1.131  1999/03/18 21:14:45  DChamberlain
Added getInstanceOfNamespaces().
Revision 1.130  1999/03/16 23:29:52  DChamberlain
Added refresh tree events and map instanceof calls.
Revision 1.129  1999/03/10 21:15:51  dcboyle
Updated JavaDoc
Revision 1.128  1999/03/10 17:41:50  DChamberlain
Doc changes, help changes and added tree refresh events.  SPD# 225501.
Revision 1.127  1999/03/02 18:07:23  SJENSEN
Updated to the new ViewSnapin interfaces. For refresh and stoppable.
Revision 1.126  1999/02/19 01:01:35  DChamberlain
Added checkForPageSnapins() to help fix SPD# 187291.
Revision 1.125  1999/02/18 22:32:44  DChamberlain
Added refreshTreeEntryNameAndIcon().
Revision 1.124  1999/02/09 18:28:21  dwilson
Added removeObject and containsObject to persistance store.
Revision 1.123  1999/02/09 18:16:21  dwilson
Revision 1.122  1999/02/08 20:12:17  SJENSEN
Added selectAllViewSelection().
Revision 1.121  1999/02/01 18:16:43  DChamberlain
Added refreshGUISnapins().
Revision 1.120  1999/01/20 17:04:10  llowry
Revision 1.119  1999/01/12 21:02:36  JWilliams
Further revision to launchFind and launchFilter
Revision 1.118  1999/01/12 20:55:30  JWilliams
Revised launchFind and launchFilter doc
Revision 1.117  1999/01/11 23:18:51  JWilliams
Doc review
Revision 1.116  1999/01/11 17:55:48  DChamberlain
Bug fix from last checkin.
Revision 1.115  1999/01/11 17:27:26  DChamberlain
Documented new calls.
Revision 1.114  1999/01/11 16:13:03  DChamberlain
Added handleSnapinException() and launchMsgBox() that takes a SnapinException.
Revision 1.113  1999/01/09 00:20:36  dwilson
Took out deprecated calls to showDetails( ObjectEntry[]
Revision 1.112  1999/01/08 21:43:09  dcboyle
Revision 1.111  1999/01/08 15:32:42  DChamberlain
Updated copyright to include 1999.
Revision 1.110  1999/01/07 19:28:10  DChamberlain
Updated copyright to include 1999.
Revision 1.109  1999/01/06 18:29:31  DChamberlain
Enhanced SnapinException to take severity and report the error.
Revision 1.108  1998/12/24 18:54:38  SJENSEN
Removed getCurrentSelectionCollection and getViewSelectionCollection.
Both routines will be killed, and the signature of the original will be changed
to return an ObjectEntryCollection.
Revision 1.107  1998/12/24 17:53:40  SJENSEN
Added ObjectEntryCollections.
Revision 1.106  1998/12/18 16:29:08  DChamberlain
Don't catch exceptions in post vetoable events.
Revision 1.105  1998/12/18 15:44:19  DChamberlain
Made synchelp and launchhelpindex deprecated.
Revision 1.104  1998/12/18 00:09:39  JWilliams
Doc review
Revision 1.103  1998/12/17 21:43:46  DChamberlain
Added docs, cleaned up docs.
Revision 1.102  1998/12/16 17:18:40  DChamberlain
Removed NamespaceInstanceof stuff scope.
Revision 1.101  1998/12/15 21:40:50  dcboyle
Changed to support JavaHelp
Revision 1.100  1998/12/14 22:31:12  dwilson
Added call for checkSnapins
Revision 1.99  1998/12/09 22:36:29  JWilliams
Made doc changes per Drew's list of changes.
Revision 1.98  1998/12/03 17:23:37  DChamberlain
Added back old getChildren() and marked deprecated.
Revision 1.97  1998/12/03 03:29:44  DChamberlain
Added addTreeKeyListener and removeTreeKeyListener.
Revision 1.96  1998/12/02 00:13:50  DChamberlain
Added replaceTreeEntry().
Revision 1.95  1998/11/25 15:28:59  DChamberlain
Documenting calls.
Revision 1.94  1998/11/20 23:08:10  ksondere
Added call addViewKeyListener and removeViewKeyListener to the shell.
Revision 1.93  1998/11/17 23:24:39  DChamberlain
Added getChildContainers.
Revision 1.92  1998/11/17 18:57:33  mharris
Added launchPreferences(), launchFind() and launchFilter() shell calls.
Revision 1.91  1998/11/10 01:30:07  mharris
Added get and set routines for SearchResultModifiers and FilterResultModifiers.
Revision 1.90  1998/11/03 15:59:38  DChamberlain
Added loadSnapins(Scope[] scopes, InitSnapinInfo info)
Revision 1.89  1998/10/29 23:55:32  SJENSEN
Added setViewSelections(), addViewSelections(), clearViewSelections(), and ensureViewObjectIsVisible()
Revision 1.88  1998/10/28 20:59:57  DChamberlain
Added isTreeRooted.
Revision 1.87  1998/10/27 23:18:15  DChamberlain
Added setting root calls.
Revision 1.86  1998/10/26 16:05:33  DChamberlain
Return defaults from getIcon and getTranslatedString.
Revision 1.85  1998/10/23 15:33:29  DChamberlain
Added map and NamespaceInstanceof calls.
Revision 1.84  1998/10/13 23:13:45  ksondere
Removed reference to old getChildren, now using getChildren with modifier.
Revision 1.83  1998/10/13 19:48:12  DChamberlain
Deprecated getSnapins, added loadSnapins and loadPageSnapins.
Revision 1.82  1998/10/08 22:21:03  DChamberlain
Converted Vector to Array.
Revision 1.81  1998/10/08 15:24:41  ksondere
Added getObjectTypes call.
Revision 1.80  1998/10/06 23:14:18  DChamberlain
Added translated string and getIcon stuff.
Revision 1.79  1998/10/06 22:57:35  ksondere
Added getChildren with ResultModifier.
Revision 1.78  1998/10/06 16:07:11  DChamberlain
Renamed com.sun.java.swing to javax.swing since we moved to Swing 11b3.
Revision 1.77  1998/09/24 20:41:45  DChamberlain
Added promote.
Revision 1.76  1998/09/21 20:14:56  ksondere
change method getIcon to getImage.
Revision 1.75  1998/09/21 19:21:36  ksondere
Added getIcon call.
Revision 1.74  1998/09/05 01:05:19  dwilson
Added stuff for preferences skads
Revision 1.73  1998/08/25 22:59:11  DChamberlain
Added viewGainedFocus()
Revision 1.72  1998/05/11 21:49:44  ksondere
Added call refreshTreeEntry.
Revision 1.71  1998/05/11 20:05:07  DChamberlain
Added launchHelpIndex().
Revision 1.70  1998/05/08 21:46:52  ksondere
Added getTreeParentSelection call.
Revision 1.69  1998/05/08 21:35:49  llowry
Revision 1.67  1998/04/07 15:47:52  DChamberlain
Marked internal methods and classes.
Revision 1.66  1998/04/02 21:49:40  DChamberlain
Return JFrame from getShellFrame() instead of Frame.  SPD# 187280.
Revision 1.65  1998/04/02 04:46:51  DChamberlain
Removed comment for removed method.
Revision 1.64  1998/04/01 23:44:04  dwilson
took out oe in call to launchConfig
Revision 1.63  1998/04/01 19:37:35  ksondere
Fix to SPD 185278.
Revision 1.62  1998/04/01 18:38:35  DChamberlain
Cleaned up error reporting.
Revision 1.61  1998/04/01 17:33:38  SHerrin
Revision 1.60  1998/03/19 21:17:57  ksondere
SPD 184640.
Revision 1.59  1998/03/18 23:49:22  DChamberlain
Return boolean from setCurrentView().
Revision 1.58  1998/03/18 16:03:40  DChamberlain
Removed saveSettings call.
Revision 1.57  1998/03/18 01:55:37  DChamberlain
Fixed bugs to compile properly.
Revision 1.56  1998/03/17 21:40:21  dwilson
Added call for getSnapins();
Revision 1.55  1998/03/16 17:07:37  ksondere
Fix to SPD 184164.
Revision 1.54  1998/03/13 23:34:21  ksondere
Revision 1.53  1998/03/13 21:54:03  DChamberlain
Added getDisplayName() that takes a namespace and type.  Added
namespace parameter to getDisplayIcon().
Revision 1.52  1998/03/11 23:11:51  DChamberlain
Broke out property book events from shell events. SPD 183035.
Revision 1.51  1998/03/11 21:08:06  DChamberlain
Use icons instead of images, pass host on init.
Revision 1.50  1998/03/07 02:48:31  DChamberlain
Removed name map.
Revision 1.49  1998/03/05 17:40:06  DChamberlain
Wrap calls to snapins in try catch.
Revision 1.48  1998/03/04 00:11:07  ksondere
Fix to SPD 182099.
Revision 1.47  1998/02/26 18:21:46  ksondere
Fix to SPD 178584.
Revision 1.46  1998/02/23 17:41:58  DChamberlain
New registration.
Revision 1.45  1998/02/09 21:02:55  DChamberlain
Bug fix in last checkin.
Revision 1.44  1998/02/09 20:55:11  DChamberlain
Renamed parameter - bug in last checkin.
Revision 1.43  1998/02/04 23:32:21  SHerrin
Javadoc comment corrections.
Revision 1.42  1998/02/02 18:33:57  DChamberlain
Changed getPopupMenu(ns, view) to getViewPopupMenu().
Revision 1.41  1998/01/30 18:49:06  DChamberlain
Have removeObjectEntryFromRoot take an oe instead of an index.
Revision 1.40  1998/01/30 01:57:23  DChamberlain
Added getDisplayImageIcon().
Revision 1.39  1998/01/26 22:16:56  DChamberlain
Added calls to get namespaces.
Revision 1.38  1998/01/26 17:29:56  DChamberlain
Renamed refreshTree() to refreshEntireTree().
Revision 1.37  1998/01/25 03:22:09  DChamberlain
Implemented multiple selection popup menus.
Revision 1.36  1998/01/23 17:22:24  DChamberlain
Changed getDisplayImage(ObjectType) to (String namespace, String type).
Revision 1.35  1998/01/22 22:50:36  dwilson
Took out getCurrentPageHost()
Revision 1.34  1998/01/21 21:12:35  DChamberlain
Added launchMsgBox that takes no help parameter.
Revision 1.33  1998/01/12 18:34:26  DChamberlain
Moved from ncc package to console.
Revision 1.32  1998/01/08 16:31:12  DChamberlain
Added doesTreeHaveFocus().
Revision 1.31  1998/01/07 22:36:49  SHerrin
Made Javadoc comment corrections in help methods.
Revision 1.30  1998/01/07 20:28:50  DChamberlain
Brought up to coding standards.  Fixed copyright date.
Revision 1.29  1998/01/07 15:20:50  DChamberlain
Removed unused config interfaces.
Revision 1.28  1997/12/24 17:06:50  DChamberlain
Implemented getCurrentSelections().
Revision 1.27  1997/12/22 22:13:16  dwilson
Added call for generic configurator
Revision 1.26  1997/12/19 18:16:04  DChamberlain
Changed Shell.executeDefaultPopupMenuItem() to executeDefaultPopupMenuItemAction().
Revision 1.25  1997/12/19 17:08:34  DChamberlain
Changed MainShell.getShell() to getInstance().  Removed getChildren that takes a String and Namespace.
Revision 1.24  1997/12/18 18:03:36  DChamberlain
Removed constants already defined in Shell and inherited.
Revision 1.23  1997/12/15 22:13:59  SHerrin
Revision 1.22  1997/12/15 17:31:40  SHerrin
Made corrections to Javadoc comments following technical review.
Revision 1.21  1997/12/10 21:53:54  tcaldwell
Fixed several bugs in SnapinEvents.
Revision 1.20  1997/12/09 18:39:28  tcaldwell
fixed a bug in PostSnapinEvent.
Revision 1.19  1997/12/08 19:01:24  DChamberlain
Added getCurrentSelection() to get the current items with focus that are selection.
Revision 1.18  1997/12/06 00:00:58  DChamberlain
Bug fix.  Removed return from call.
Revision 1.17  1997/12/05 23:14:50  tcaldwell
Added removeProperty.
Revision 1.16  1997/12/02 21:33:58  dwilson
Added getParticipatingSnapins with scope parameter
Revision 1.15  1997/11/24 22:45:16  DChamberlain
Removed call to show leafs on namespace.
Revision 1.14  1997/11/21 23:23:34  DChamberlain
Added setShowLeafs().
Revision 1.13  1997/11/21 23:18:56  DChamberlain
Added setShowLeafs().
Revision 1.12  1997/11/21 21:55:34  tcaldwell
Added PostVetoableSnapinEvent
Revision 1.11  1997/11/19 19:28:56  jeThatcher
Added showDetails with pages paremeter.
Revision 1.10  1997/11/19 18:33:34  DChamberlain
Cleaned up javadocs.
Revision 1.9  1997/11/17 18:56:06  jeThatcher
Added Shell parameter to shutdownSnapin, other changes for Gallup.
Revision 1.8  1997/11/13 23:27:42  dwilson
Gallup changes
Revision 1.7  1997/11/11 17:13:20  DChamberlain
Changed bar in statusbar and toolbar to uppercase.
Revision 1.6  1997/11/10 17:54:38  tcaldwell
Updated Persistence stuff.
Revision 1.5  1997/11/07 23:07:18  tcaldwell
Added Persistence stuff.
Revision 1.4  1997/11/07 16:32:46  DChamberlain
Massive package name changes.
Revision 1.3  1997/11/05 22:34:48  DChamberlain
Changed Shell to interface.
Revision 1.2  1997/11/05 18:52:34  jeThatcher
Changed name to MainShell, implements new Shell interface.
Revision 1.1  1997/11/04 21:51:59  jeThatcher
Initial Revision, all content moved from old Shell.
Revision 1.17  1997/11/04 16:47:16  DChamberlain
Kitchen changes.  Removed viewSelectionChanged(), now use postShellEvent().  Added refresh
current tree selection method.  Changed context to popup.
Revision 1.16  1997/10/10 16:18:20  DChamberlain
ShellEventListener to ShellListener.
Revision 1.15  1997/10/08 19:27:56  DChamberlain
Changed getContextMenu() to take an OE.
Revision 1.14  1997/10/03 22:01:38  DChamberlain
Added viewSelectionChanged(), removed isAvailable().
Revision 1.13  1997/10/01 20:02:12  DChamberlain
Moved to JFC menus.
Revision 1.12  1997/09/30 16:02:01  SHerrin
Made Javadoc editorial corrections.
Revision 1.11  1997/09/26 00:00:54  DChamberlain
Changed to work with getChildren() that returns an Enumeration instead of Array.
Revision 1.10  1997/09/25 22:43:16  DChamberlain
Added getChildren that takes namespace and string.
Revision 1.9  1997/09/18 22:50:40  DChamberlain
Uppercase COM to lowercase com for novell packages.
Revision 1.7  1997/09/08 19:54:04  DChamberlain
Added configurator calls.
Revision 1.6  1997/09/08 15:14:44  DChamberlain
Added getDisplayImage() taking an ObjectEntry.
Revision 1.5  1997/09/04 19:56:24  DChamberlain
Added executeDefaultPopupMenuItem().
Revision 1.4  1997/09/02 16:24:40  DChamberlain
Revision 1.3  1997/09/02 16:24:40  DChamberlain
Added setTreeSelection(), getChildren(), and isContainer().
Revision 1.2  1997/08/29 21:49:14  tcaldwell
Fixed filters on events.
Revision 2.4  1997/08/25 17:08:56  DChamberlain
Calls ShellStubs static methods instead of an instance of ShellStubs.
Revision 2.3  1997/08/08 22:10:10  DChamberlain
*/