/*
   $RCSfile: PropertyBook.java,v $
   $Revision: 1.1.1.1 $ $Name:  $
   $Date: 2001/05/09 12:43:25 $

   $ProjectName: V:/PROJECT/houston/snapin.pj $
   $ProjectRevision: 1.172 $

   For revision information, see the history log at the end of this file.

   Copyright (c) 1997-1999 Novell, Inc.  All Rights Reserved.

   THIS WORK IS AN UNPUBLISHED WORK AND CONTAINS CONFIDENTIAL, 
   PROPRIETARY AND TRADE SECRET INFORMATION OF NOVELL, INC. ACCESS TO 
   THIS WORK IS RESTRICTED TO (I) NOVELL, INC. EMPLOYEES WHO HAVE A 
   NEED TO KNOW HOW TO PERFORM TASKS WITHIN THE SCOPE OF THEIR 
   ASSIGNMENTS AND (II) ENTITIES OTHER THAN NOVELL, INC. WHO HAVE 
   ENTERED INTO APPROPRIATE LICENSE AGREEMENTS. NO PART OF THIS WORK 
   MAY BE USED, PRACTICED, PERFORMED, COPIED, DISTRIBUTED, REVISED, 
   MODIFIED, TRANSLATED, ABRIDGED, CONDENSED, EXPANDED, COLLECTED, 
   COMPILED, LINKED, RECAST, TRANSFORMED OR ADAPTED WITHOUT THE PRIOR 
   WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION OF THIS WORK 
   WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO CRIMINAL AND 
   CIVIL LIABILITY. 
*/

package com.novell.application.console.snapin;

import java.awt.*;
import java.util.Enumeration;

/**
 * Provides services for page snap-ins.
 *
 * <p>This interface is implemented by the ConsoleOne Property Book to
 * service page snap-ins. A reference to the Property Book is passed
 * at the time the page snap-in is initialized.
 *
 * @see PageSnapin
 *
 * @version 0.0 19 May 1997
 * @copyright (c) 1997-1999 Novell, Inc.
 */
public interface PropertyBook
{
   /**
   * Indicates to the Property Book that your snap-in data has changed.
   *
   * <p>Call setModified() when you want the OK and Apply Now buttons 
   * to be enabled. You should not call setModified() until after
   * successfully returning <i>true</i> from initSnapin().
   *
   * @param isDirty   Boolean set to <i>true</i> when data needs to be saved, 
   *                  or <i>false</i> when data has already been saved.
   * @param theSnapin Reference to the page snap-in. The <i>this</i> value
   *                  references the current page that has focus.
   */	
   public void setModified( boolean isDirty, PageSnapin theSnapin );

   /**
    * Sets the title of the current property page.
    *
    * <p>The setTitle() method allows you to update the title of the
    * property page.
    *
    * @param title The title of the property page.
    */
	public void setTitle( String title );

	/** 
	 * Returns the set of propertyPages in this PropertyBook
	 */
	public Enumeration getPages();

	/**
	 * Tells the PropertyBook to change the current page to thePage.
	 */
	public void showThisPage( PageSnapin thePage );
	
	/**
	 * Tells the PropertyBook to abort the startup sequence and return false from initPages().
	 */
	public void abort();
	
	/**
	 * Returns the PropertyBook Component
	 */
	public Component getComponent();


	/**
	 * Returns the pressed button 
	 */
	public int getPressedButton();


    /**
    * Set the page to be shown after canSave returns false
    */
    public void setComplainingPage(PageSnapin p);

	 /**
    * Indicates a snapin whos canSave() must be called even if not dirty.
    */
    public void mandatoryCanSave( PageSnapin p );

}


