/*
   $RCSfile: PropertyBookEvent.java,v $
   $Revision: 1.1.1.1 $ $Name:  $
   $Date: 2001/05/09 12:43:25 $

   $ProjectName: V:/PROJECT/houston/snapin.pj $
   $ProjectRevision: 1.172 $

   For revision information, see the history log at the end of this file.

   Copyright (c) 1997-1999 Novell, Inc.  All Rights Reserved.

   THIS WORK IS AN UNPUBLISHED WORK AND CONTAINS CONFIDENTIAL, 
   PROPRIETARY AND TRADE SECRET INFORMATION OF NOVELL, INC. ACCESS TO 
   THIS WORK IS RESTRICTED TO (I) NOVELL, INC. EMPLOYEES WHO HAVE A 
   NEED TO KNOW HOW TO PERFORM TASKS WITHIN THE SCOPE OF THEIR 
   ASSIGNMENTS AND (II) ENTITIES OTHER THAN NOVELL, INC. WHO HAVE 
   ENTERED INTO APPROPRIATE LICENSE AGREEMENTS. NO PART OF THIS WORK 
   MAY BE USED, PRACTICED, PERFORMED, COPIED, DISTRIBUTED, REVISED, 
   MODIFIED, TRANSLATED, ABRIDGED, CONDENSED, EXPANDED, COLLECTED, 
   COMPILED, LINKED, RECAST, TRANSFORMED OR ADAPTED WITHOUT THE PRIOR 
   WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION OF THIS WORK 
   WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO CRIMINAL AND 
   CIVIL LIABILITY. 
*/
package com.novell.application.console.snapin;

import com.novell.application.console.snapin.context.*;
import java.util.EventObject;

 /**
  * Defines a Property Book page snap-in event.
  *
  * @see PropertyBookListener
  *
  */
public class PropertyBookEvent extends EventObject
{
  /**
   *
   * The Property Book is initializing
   *
   * <p>(PROPERTYBOOK_INIT = 1)
   * </p>
   */
  public static final int PROPERTYBOOK_INIT = 1;

  /**
   *
   * The Property Book is shutting down
   *
   * <p>(PROPERTYBOOK_SHUTDOWN = 2)
   * </p>
   */
  public static final int PROPERTYBOOK_SHUTDOWN = 2;

  	public PropertyBookEvent(PageSnapinContext aPSC, int action)
	{
      super(aPSC);
      fPSC = aPSC;
		fAction = action;
	}
   
       /**
        * Returns the action performed.
        *
        * @return An integer representing the action performed.
        *
        * @see #PROPERTYBOOK_INIT
        * @see #PROPERTYBOOK_SHUTDOWN
        */
	public int getAction()
	{
		return fAction;
	}

   private PageSnapinContext fPSC;
	private int fAction;
}

/*
$Log: PropertyBookEvent.java,v $
Revision 1.1.1.1  2001/05/09 12:43:25  rommel
Sandbox initial version uploaded from novell cd 1/3

Revision 1.6  1999/01/07 19:28:14  DChamberlain
Updated copyright to include 1999.
Revision 1.5  1998/04/07 03:02:22  SHerrin
Added and corrected Javadoc comments.
Revision 1.4  1998/03/20 19:15:18  dwilson
bug fix
Revision 1.3  1998/03/12 18:29:48  DChamberlain
Use context instead of host.
Revision 1.2  1998/03/11 23:12:08  DChamberlain
Broke out property book events from shell events. (SPD 183035)
Revision 1.1  1998/03/11 22:45:35  DChamberlain
Initial revision
*/
