/*
   $RCSfile: PropertyBookListener.java,v $
   $Revision: 1.1.1.1 $ $Name:  $
   $Date: 2001/05/09 12:43:25 $

   $ProjectName: V:/PROJECT/houston/snapin.pj $
   $ProjectRevision: 1.172 $

   For revision information, see the history log at the end of this file.

   Copyright (c) 1997-1999 Novell, Inc.  All Rights Reserved.

   THIS WORK IS AN UNPUBLISHED WORK AND CONTAINS CONFIDENTIAL, 
   PROPRIETARY AND TRADE SECRET INFORMATION OF NOVELL, INC. ACCESS TO 
   THIS WORK IS RESTRICTED TO (I) NOVELL, INC. EMPLOYEES WHO HAVE A 
   NEED TO KNOW HOW TO PERFORM TASKS WITHIN THE SCOPE OF THEIR 
   ASSIGNMENTS AND (II) ENTITIES OTHER THAN NOVELL, INC. WHO HAVE 
   ENTERED INTO APPROPRIATE LICENSE AGREEMENTS. NO PART OF THIS WORK 
   MAY BE USED, PRACTICED, PERFORMED, COPIED, DISTRIBUTED, REVISED, 
   MODIFIED, TRANSLATED, ABRIDGED, CONDENSED, EXPANDED, COLLECTED, 
   COMPILED, LINKED, RECAST, TRANSFORMED OR ADAPTED WITHOUT THE PRIOR 
   WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION OF THIS WORK 
   WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO CRIMINAL AND 
   CIVIL LIABILITY. 
*/
package com.novell.application.console.snapin;

import java.util.*;

/**
 * Listens for events generated by other Property Book page snap-ins.
 *
 * <p>The PropertyBookListener interface provided for snap-in to snap-in
 * communication between page snap-ins. The snap-in generating the event
 * should publish what type of event is being generated, and the listening
 * snap-in that is implementing the PropertyBookListener interface should
 * listen for the generated event of the specified type.
 *
 * @see PropertyBookEvent
 */
public interface PropertyBookListener extends EventListener
{
  /**
   * Allows a snap-in to perform an action associated with a Property Book
   * control invocation.
   *
   * @param event The Property Book control invocation event.
   */
  public abstract void propertyBookInit(PropertyBookEvent event);

  /**
   * Allows a snap-in to perform an action associated with a Property Book
   * control shutting down.
   *
   * @param event The Property Book control shutdown event.
   */
  public abstract void propertyBookShutdown(PropertyBookEvent event);
}

/*
$Log: PropertyBookListener.java,v $
Revision 1.1.1.1  2001/05/09 12:43:25  rommel
Sandbox initial version uploaded from novell cd 1/3

Revision 1.4  1999/01/07 19:28:15  DChamberlain
Updated copyright to include 1999.
Revision 1.3  1998/04/07 03:02:06  SHerrin
Added and corrected Javadoc comments.
Revision 1.2  1998/03/11 23:12:09  DChamberlain
Broke out property book events from shell events. (SPD 183035)
Revision 1.1  1998/03/11 22:45:33  DChamberlain
Initial revision
Revision 1.10  1998/01/29 17:08:14  SHerrin
Javadoc comment corrections.
Revision 1.9  1998/01/15 23:59:31  DChamberlain
Removed treeItemAdded and treeItemRemoved.
Revision 1.8  1998/01/12 18:35:12  DChamberlain
Moved from ncc package to console.
Revision 1.7  1997/12/19 17:31:57  SHerrin
Made minor corrections to Javadoc comments.
Revision 1.6  1997/11/18 00:31:06  jeThatcher
Changes mpec events to PageHost events.
Revision 1.5  1997/11/07 16:32:46  tcaldwell
Revision 1.4  1997/11/07 16:32:46  DChamberlain
Massive package name changes.
Revision 1.3  1997/10/22 21:04:35  SHerrin
Made changes in Javadoc comments following technical review.
Revision 1.2  1997/10/10 15:46:48  DChamberlain
COM to com.
Revision 1.1  1997/10/03 20:18:38  tcaldwell
Initial revision
Revision 1.5  1997/07/01 21:10:54  tcaldwell
Updated javadoc
Revision 1.4  1997/06/30 22:23:14  DChamberlain
Changed for tree selection and view selection.
Revision 1.3  1997/06/27 22:24:58  tcaldwell
Updated javadoc
Revision 1.2  1997/06/26 15:54:40  DChamberlain
Added MKS keywords and copyright.
*/
