/*
   $RCSfile: ShellLifecycleListener.java,v $
   $Revision: 1.1.1.1 $ $Name:  $
   $Date: 2001/05/09 12:43:26 $

   $ProjectName: V:/PROJECT/houston/snapin.pj $
   $ProjectRevision: 1.172 $

   For revision information, see the history log at the end of this file.

   Copyright (c) 1997-1999 Novell, Inc.  All Rights Reserved.

   THIS WORK IS AN UNPUBLISHED WORK AND CONTAINS CONFIDENTIAL,
   PROPRIETARY AND TRADE SECRET INFORMATION OF NOVELL, INC. ACCESS TO
   THIS WORK IS RESTRICTED TO (I) NOVELL, INC. EMPLOYEES WHO HAVE A
   NEED TO KNOW HOW TO PERFORM TASKS WITHIN THE SCOPE OF THEIR
   ASSIGNMENTS AND (II) ENTITIES OTHER THAN NOVELL, INC. WHO HAVE
   ENTERED INTO APPROPRIATE LICENSE AGREEMENTS. NO PART OF THIS WORK
   MAY BE USED, PRACTICED, PERFORMED, COPIED, DISTRIBUTED, REVISED,
   MODIFIED, TRANSLATED, ABRIDGED, CONDENSED, EXPANDED, COLLECTED,
   COMPILED, LINKED, RECAST, TRANSFORMED OR ADAPTED WITHOUT THE PRIOR
   WRITTEN CONSENT OF NOVELL, INC. ANY USE OR EXPLOITATION OF THIS WORK
   WITHOUT AUTHORIZATION COULD SUBJECT THE PERPETRATOR TO CRIMINAL AND
   CIVIL LIABILITY.
*/
package com.novell.application.console.snapin;

import java.util.*;


//REMIND: John, review entire class
 /**
 * Listens for shell lifecycle events.
 *
 * <p>The ShellLifecycleListener interface is implemented for the purpose of
 * listening for shell lifecycle events.
 *
 * @see ShellLifecycleEvent
 * 
*/

public interface ShellLifecycleListener extends EventListener
{
  /**
   * Allows a participating snap-in to perform an action associated with 
   * a shell lifecycle event.
   *
   * <p>The participating snap-in is notified that a shell lifecycle status
   * has changed.
   *
   * @param event The shell lifecycle event containing the new status.
  */
	public abstract void processEvent(ShellLifecycleEvent event);
}

/*
$Log: ShellLifecycleListener.java,v $
Revision 1.1.1.1  2001/05/09 12:43:26  rommel
Sandbox initial version uploaded from novell cd 1/3

Revision 1.2  1999/05/24 23:09:04  mharris
SPD 230672 (BQ73770)  Implemented ShellLifecycleEvents to provide various lifecycle events (including snapin shutdown)
Revision 1.1  1999/05/19 20:24:56  mharris
Initial revision

*/
