#!/bin/sh
cd $(dirname $0)
if [ ! "$IMANAGER_HOME" = "" ]
then
  cd $IMANAGER_HOME/bin
fi

CHECK_VERBOSE="false"
IMANAGER_BIN_DIR=$PWD/linux
IMANAGER_BIN_NATIVE_DIR=$PWD/../tomcat/webapps/nps/WEB-INF/bin/linux
IMANAGER_OPENSSL_NATIVE_DIR=/opt/netiq/common/openssl/lib64
IMANAGER_LIBSTDC_NATIVE_DIR=/opt/novell/lib64
IMANAGER_BIN_SWT_DIR=$PWD/linux/swt
IMANAGER_BIN_MOZILLA_DIR=$PWD/linux/mozilla
MAIN_CLASS=com.novell.emframe.bootstrap.iManagerBootstrap

INSTALLED_NICI64_VERSION=`rpm -qa | grep nici64`
NICI64_INSTALL_FILE=../preinstalls/linux/nici.x86_64.rpm
REQUIRED_NICI64_VERSION=nici64-3.1.0
NICI64_VERSION=3.1.0.0

OPENSSL_INSTALL_FILE=../preinstalls/linux/netiq-openssl*.rpm
PACKAGED_OPENSSL_VERSION=1.0.2n

LIBSTDC_INSTALL_FILE=../preinstalls/linux/novell-libstdc++6*.rpm
PACKAGED_LIBSTDC_VERSION=5.3.1

INSTALLED_OPENSSL_NAME=`rpm -qa | grep netiq-openssl`
INSTALLED_OPENSSL_VERSION=${INSTALLED_OPENSSL_NAME:14:6}

INSTALLED_LIBSTDC_NAME=`rpm -qa | grep novell-libstdc++6`
INSTALLED_LIBSTDC_VERSION=${INSTALLED_LIBSTDC_NAME:18:5}

function CHECK_PERMISSIONS()
{
   echo "Test permissions" > $IMANAGER_BIN_NATIVE_DIR/perm.txt
   if [ -e $IMANAGER_BIN_NATIVE_DIR/perm.txt ]
   then
      rm $IMANAGER_BIN_NATIVE_DIR/perm.txt
   else
      echo "ERROR:  Insufficient rights to execute iManager"
      exit
   fi
}

function CHECK_OPENSSL_VERSION ()
{
   if  [ "$INSTALLED_OPENSSL_VERSION" \< "$PACKAGED_OPENSSL_VERSION" ]
   then
	echo "ERROR:    OPENSSL $PACKAGED_OPENSSL_VERSION is required by iManager"
	echo "SOLUTION: Please upgrade OPENSSL RPM as the user root"
	echo "SOLUTION: example command: rpm -Uvh $OPENSSL_INSTALL_FILE"
	echo
	exit
   else
	echo "OPENSSL upgrade is not needed!"
   fi
}

function CHECK_OPENSSL()
{
   if [ ! -z "$INSTALLED_OPENSSL_VERSION" -a "$INSTALLED_OPENSSL_VERSION" != " " ]
   then
		echo "OPENSSL rpm previously installed. Checking version..."
		CHECK_OPENSSL_VERSION;
   else
		echo "ERROR:    OPENSSL $PACKAGED_OPENSSL_VERSION is required by iManager"
		echo "SOLUTION: Please install OPENSSL RPM as the user root"
		echo "SOLUTION: example command: rpm -Uvh $OPENSSL_INSTALL_FILE"
		exit
   fi
}


function CHECK_LIBSTDC_VERSION ()
{
   if  [ "$INSTALLED_LIBSTDC_VERSION" \< "$PACKAGED_LIBSTDC_VERSION" ]
   then
	echo "ERROR:    LIBSTDC $PACKAGED_LIBSTDC_VERSION is required by iManager"
	echo "SOLUTION: Please upgrade LIBSTDC RPM as the user root"
	echo "SOLUTION: example command: rpm -Uvh $LIBSTDC_INSTALL_FILE"
	echo
	exit
   else
	echo "LIBSTDC upgrade is not needed!"
   fi
}

function CHECK_LIBSTDC()
{
   if [ ! -z "$INSTALLED_LIBSTDC_VERSION" -a "$INSTALLED_LIBSTDC_VERSION" != " " ]
   then
		echo "LIBSTDC rpm previously installed. Checking version..."
		CHECK_LIBSTDC_VERSION;
   else
		echo "ERROR:    LIBSTDC $PACKAGED_LIBSTDC_VERSION is required by iManager"
		echo "SOLUTION: Please install LIBSTDC RPM as the user root"
		echo "SOLUTION: example command: rpm -Uvh $LIBSTDC_INSTALL_FILE"
		exit
   fi
}

function CHECK_NICI64_VERSION ()
{
   if  [ "$INSTALLED_NICI64_VERSION" \< "$REQUIRED_NICI64_VERSION" ]
   then
	echo "ERROR:    $REQUIRED_NICI64_VERSION is required by iManager"
	echo "SOLUTION: Please upgrade NICI64 RPM as the user root"
	echo "SOLUTION: example command: rpm -Uvh $NICI64_INSTALL_FILE"
	echo
	echo "============================================================================================================================"
	echo "                                                 NICI(x64)  WARNING:"
	echo "----------------------------------------------------------------------------------------------------------------------------"
	echo " An older version of NICI(x64) is found. If you continue to upgrade, NICI(x64) will be upgraded to the latest version."
	echo " If another application that uses Novell's security infrastructure is installed, this upgrade might break those "
	echo " applications if they do not officially support NICI(x64) $NICI64_VERSION."
	echo "============================================================================================================================"
	echo
	exit
   else
	echo "NICI(x64) upgrade is not needed!"
   fi
}

function CHECK_NICI64()
{
   if [ ! -z "$INSTALLED_NICI64_VERSION" -a "$INSTALLED_NICI64_VERSION" != " " ]
   then
		echo "NICI(x64) previously installed. Checking version..."
		CHECK_NICI64_VERSION;
   else
		echo "ERROR:    $REQUIRED_NICI64_VERSION is required by iManager"
		echo "SOLUTION: Please install NICI(x64) RPM as the user root"
		echo "SOLUTION: example command: rpm -Uvh $NICI64_INSTALL_FILE"
		exit
   fi
}

function CHECK_JAVA_HOME()
{
   export JAVA_HOME_BAK=$JAVA_HOME
   export JAVA_HOME=
   if [ "$JAVA_HOME" = "" -o  ! -e "$JAVA_HOME/lib/tools.jar" ]
   then
      if [ ! -e "$IMANAGER_BIN_DIR/java" ]
      then
         export JAVA_HOME=$JAVA_HOME_BAK
         if [ "$JAVA_HOME" = "" -o  ! -e "$JAVA_HOME/lib/tools.jar" ]
         then
            echo "ERROR:    The JAVA_HOME environment variable is not defined correctly"
            echo "ERROR:    This environment variable is needed to run this program"
            echo "SOLUTION: example command: export JAVA_HOME=/usr/java/j2sdk1.4.2_08"
            exit
         fi
      else
         export JAVA_HOME=$IMANAGER_BIN_DIR/java
      fi
   fi
}


function CHECK_SYMBOLIC_LINKS ()
{
   WORKING_DIR=$PWD
   cd $IMANAGER_BIN_NATIVE_DIR
   if [ ! -e libJClient.so ] && [ -e libJClient.so.1.0.0 ];
   then
      ln -sf libJClient.so.1.0.0 libJClient.so
      ln -sf libJClient.so.1.0.0 libJclient_g.so
      ln -sf libJClient.so.1.0.0 libJClient.so.1
   fi
   if [ ! -e libndssdk.so ] && [ -e libndssdk.so.1.0.0 ];
   then
      ln -sf libndssdk.so.1.0.0 libn4u.so.0
      ln -sf libndssdk.so.1.0.0 libpdksa.so.0
      ln -sf libndssdk.so.1.0.0 libdclient.so.0
      ln -sf libndssdk.so.1.0.0 libndssdk.so
      ln -sf libndssdk.so.1.0.0 libndssdk.so.1
   fi
   if [ ! -e libsal.so ] && [ -e libsal.so.1.0.0 ];
   then
      ln -sf libsal.so.1.0.0 libsal.so
      ln -sf libsal.so.1.0.0 libsal.so.1
   fi
   if [ ! -e libsch.so ] && [ -e libsch.so.1.0.0 ];
   then
      ln -sf libsch.so.1.0.0 libsch.so
      ln -sf libsch.so.1.0.0 libsch.so.1
   fi
   if [ ! -e libntls.so.8 ] && [ -e libntls.so ];
   then
      ln -sf libntls.so libntls.so.8.0
      ln -sf libntls.so libntls.so.8
   fi
   if [ ! -e libspmclnt.so.8 ] && [ -e libspmclnt.so ];
   then
      ln -sf libspmclnt.so libspmclnt.so.8
   fi
   #
   # ??? libnmasclnt.so ??? does it need links
   # ??? libspmclnt.so ??? does it need links
   #

   # removed when placed in eDirExtended.npm
   #   if [ ! -e libldapsdk.so ] && [ -e libldapsdk.so.0.0.0 ];
   #   then
   #      ln -sf libldapsdk.so.0.0.0 libldapsdk.so
   #      ln -sf libldapsdk.so.0.0.0 libldapsdk.so.0
   #   fi
   #   if [ ! -e libnpkiapi.so.3.0.0 ] && [ -e libnpkiapi.so ];
   #   then
   #      mv libnpkiapi.so libnpkiapi.so.3.0.0
   #      ln -sf libnpkiapi.so.3.0.0 libnpkiapi.so
   #      ln -sf libnpkiapi.so.3.0.0 libnpkiapi.so.2
   #      ln -sf libnpkiapi.so.3.0.0 libnpkiapi.so.3
   #   fi
   #   if [ ! -e libnpkit.so.3.0.0 ] && [ -e libnpkit.so ];
   #   then
   #      mv libnpkit.so libnpkit.so.3.0.0
   #      ln -sf libnpkit.so.3.0.0 libnpkit.so
   #      ln -sf libnpkit.so.3.0.0 libnpkit.so.2
   #      ln -sf libnpkit.so.3.0.0 libnpkit.so.3
   #   fi
   cd $WORKING_DIR
}

function BUILD_CLASSPATH ()
{
   CPATH=.
   CPATH=$CPATH:$JAVA_HOME/lib/tools.jar
   CPATH=$CPATH:bootstrap.jar
   CPATH=$CPATH:iManBootstrap.jar
   CPATH=$CPATH:$IMANAGER_BIN_SWT_DIR/swt.jar
   CPATH=$CPATH:$PWD/../tomcat/bin/commons-logging-api-1.1.1.jar
   CPATH=$CPATH:$PWD/../tomcat/bin/commons-daemon.jar
   
}

function BUILD_BOOT_CLASSPATH()
{
	BPATH=$PWD/../tomcat/common/endorsed/xercesImpl.jar
	BPATH=$BPATH:$PWD/../tomcat/common/endorsed/xml-apis.jar
}

function BUILD_LD_LIBRARY_PATH ()
{
   LPATH=$IMANAGER_BIN_NATIVE_DIR
   LPATH=$LPATH:$IMANAGER_OPENSSL_NATIVE_DIR
   LPATH=$LPATH:$IMANAGER_LIBSTDC_NATIVE_DIR
   LPATH=$LPATH:$IMANAGER_BIN_SWT_DIR
   LPATH=$LPATH:$IMANAGER_BIN_MOZILLA_DIR

   export LD_LIBRARY_PATH=$LPATH:$LD_LIBRARY_PATH
   export MOZILLA_FIVE_HOME=$IMANAGER_BIN_MOZILLA_DIR
}

function START_IMANAGER ()
{
   CHECK_PERMISSIONS;
   CHECK_OPENSSL;
   CHECK_LIBSTDC;
   CHECK_NICI64;
   CHECK_SYMBOLIC_LINKS;
   CHECK_JAVA_HOME;
   BUILD_CLASSPATH;
   BUILD_LD_LIBRARY_PATH;
   BUILD_BOOT_CLASSPATH;
   EPATH=$PWD/../tomcat/common/endorsed
   XULPATH=$PWD/linux/mozilla
   export SWT_GTK3=0
}

START_IMANAGER;
linux/mozilla/xulrunner application.ini;
$JAVA_HOME/bin/java -server -Xms256m -Xmx512m -Xbootclasspath/a:$BPATH -cp $CPATH -Dorg.eclipse.swt.browser.XULRunnerPath=$XULPATH -Dorg.apache.jasper.compiler.Parser.STRICT_QUOTE_ESCAPING=false -Djava.endorsed.dir=$EPATH $DEBUG_PARAMS $MAIN_CLASS $1 $2 $3 $4 $5 $6 $7 $8 $9
linux/mozilla/xulrunner application.ini;
