//   Name:  PropertyPageExampleTask1.java
//
//   Copyright (c) 1997-2004 Novell, Inc.  All Rights Reserved.
//
//   THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND TREATIES.
//   USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE LICENSE AGREEMENT
//   ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK) THAT CONTAINS THIS WORK.
//   PURSUANT TO THE SDK LICENSE AGREEMENT, NOVELL HEREBY GRANTS TO DEVELOPER A
//   ROYALTY-FREE, NON-EXCLUSIVE LICENSE TO INCLUDE NOVELL'S SAMPLE CODE IN ITS
//   PRODUCT. NOVELL GRANTS DEVELOPER WORLDWIDE DISTRIBUTION RIGHTS TO MARKET,
//   DISTRIBUTE, OR SELL NOVELL'S SAMPLE CODE AS A COMPONENT OF DEVELOPER'S
//   PRODUCTS. NOVELL SHALL HAVE NO OBLIGATIONS TO DEVELOPER OR DEVELOPER'S
//   CUSTOMERS WITH RESPECT TO THIS CODE.

package com.company.plugins;

import com.novell.emframe.dev.*;
import javax.servlet.http.HttpServletRequest;

public class PropertyPageExampleTask1 extends DirPropertyBookPage
{
   public void show(PropertyPageContext context) throws PageException
   {
      //the show method is called when a property page is first selected.

      //get the request object so we can add values that will be sent to the JSP
      HttpServletRequest req = context.getRequest();

      //this example uses an array of strings to keep track of the different values that we'll
      //send to the JSP. This is usually done programatically, but in this example, we use
      //hard-coded strings.
      String[] values= {"Joe User","IS&T","555-5555"};

      //add the array of strings to the request. In the JSP, we can then parse through
      //the "examplePropertyPage1Values" array with the "forEach" tag.
      req.setAttribute("examplePropertyPage1Values", values);

      //only call super here if you're using eDas
      //super.show(context);
   }

   public void cache(PropertyPageContext context) throws PageException
   {
      //the cache method is called when another page has been chosen. For example, if page A is
      //visible, and the user chooses to jump to page B, page A's cache method is called before
      //page B's show method is loaded.

      //get the request object
      HttpServletRequest req=context.getRequest();

      //get the parameter that holds the packed values passed in from the JSP
      String pack=req.getParameter("examplePropertyPage1_packedValues");

      if(pack!=null&&pack.length()>0)
      {
         //read the packed values back in from the parameter.
         String[] values=eMFrameUtils.unpack(pack, context);
      }

      //at this point, you can write the unpacked values to the directory.

      //only call super here if you're using eDas
      //super.cache(context);
   }

}