//   Name:  WizardExampleTask.java
//
//   Copyright (c) 1997-2004 Novell, Inc.  All Rights Reserved.
//
//   THIS WORK IS SUBJECT TO U.S. AND INTERNATIONAL COPYRIGHT LAWS AND TREATIES.
//   USE AND REDISTRIBUTION OF THIS WORK IS SUBJECT TO THE LICENSE AGREEMENT
//   ACCOMPANYING THE SOFTWARE DEVELOPMENT KIT (SDK) THAT CONTAINS THIS WORK.
//   PURSUANT TO THE SDK LICENSE AGREEMENT, NOVELL HEREBY GRANTS TO DEVELOPER A
//   ROYALTY-FREE, NON-EXCLUSIVE LICENSE TO INCLUDE NOVELL'S SAMPLE CODE IN ITS
//   PRODUCT. NOVELL GRANTS DEVELOPER WORLDWIDE DISTRIBUTION RIGHTS TO MARKET,
//   DISTRIBUTE, OR SELL NOVELL'S SAMPLE CODE AS A COMPONENT OF DEVELOPER'S
//   PRODUCTS. NOVELL SHALL HAVE NO OBLIGATIONS TO DEVELOPER OR DEVELOPER'S
//   CUSTOMERS WITH RESPECT TO THIS CODE.


package com.company.plugins;

import com.novell.emframe.dev.*;

import javax.servlet.http.HttpServletRequest;
import java.util.*;

public class WizardExampleTask extends Task
{
   String checkboxvalue = "";
   String textboxvalue = "";

   public boolean execute(TaskContext context, Properties resultStrings)
   {
      HttpServletRequest req = context.getRequest();

      String nextState = req.getParameter("nextState");

      if (nextState == null || nextState.equals("initialState"))
      {
         req.setAttribute("wizardBodyNextState", "state1");
         req.setAttribute("wizardBodyMerge", "sdk/WizardExampleTemplate1.jsp");
         setUIPage("dev/WizardFrameSet.jsp");
      }
      else if (nextState.equals("state1"))
      {
         req.setAttribute("data", "This is the wizard example's first page.");
         req.setAttribute("checkboxvalue", checkboxvalue);
         setUIPage("sdk/WizardExampleTemplate1.jsp");
      }
      else if (nextState.equals("state2"))
      {
         checkboxvalue = req.getParameter("checkbox1");
         req.setAttribute("textboxvalue", textboxvalue);
         req.setAttribute("data", "This is the wizard example's second page.");
         setUIPage("sdk/WizardExampleTemplate2.jsp");
      }
      else if (nextState.equals("state3"))
      {
         textboxvalue = req.getParameter("textbox1");
         req.setAttribute("textboxvalue", textboxvalue);
         req.setAttribute("checkboxvalue", checkboxvalue);
         req.setAttribute("data", "This is the wizard example's third page.");
         setUIPage("sdk/WizardExampleTemplate3.jsp");
      }
      else
      {
         D.log("WizardExample: invalid state");
         eMFrameUtils.setMessage("error", "Error", "Invalid state", context);
      }

      return true;
   }
}
