<%@  page pageEncoding="utf-8" contentType="text/html;charset=utf-8" 
   import="com.novell.webaccess.common.JSPConduit" %>

<%
   JSPConduit c = JSPConduit.getJSPConduit(request);
%>

<%@ taglib uri="/WEB-INF/iman.tld" prefix="iman" %>
<%@ taglib uri="/WEB-INF/fmt.tld" prefix="fmt" %>
<%@ taglib uri="/WEB-INF/c.tld" prefix="c" %>
<%@ taglib uri="/WEB-INF/x.tld" prefix="x" %>
<iman:stringtable bundle="BaseResources" />
<iman:stringtable bundle="DevResources" />
<iman:stringtable bundle="FwResources" />

<HTML>
<HEAD>
   <TITLE><iman:string key="ProductName"/></TITLE>
   <LINK href="<iman:moduleUrl/>/dev/css/hf_dialog.css" rel="stylesheet" type="text/css">
   <iman:include page="dev/ValidateIntegerScripts_inc.jsp"/>
   <iman:stylesheet/>
   <iman:uihandlerTools/>
   <iman:pageScripts/>
   <iman:eMFrameScripts/>
   <iman:dataTableScripts/>
   <iman:osScripts/>

   <SCRIPT>
   
		/*******************************************************************************************************************
		 * onInit()
		 * - Called on page load.
		 ********************************************************************************************************************/
		function onInit()
      {
      	returnFromOS();
      } // end of onInit()

		/*******************************************************************************************************************
	 	 * isPageValid()
	 	 * What should this method do?
	 	 * -data validation
	 	 * -general page cleanup before being submitted
	 	 * -if this method returns false, the page will not be saved
	 	 * Called when user leaves this page or applys changes	 	 	 	 	 	 	 	 
		 ********************************************************************************************************************/
      function isPageValid()
      {
         var success = notifyAllOfExit();
         if(!success)
         {
            return false;
         }
      } // end of isPageValid()
      
		/*******************************************************************************************************************
	 	 * fsrMenuActionHandler()
	 	 * @param menuItemId - selected menu item
	 	 * @param  selectedIndices - selected items from list
	 	 * @param tableData - reference to the 2 dimensional Array TableCell
	 	 * Called when a Menu Item is selected
		 ********************************************************************************************************************/
      function fsrMenuActionHandler(menuItemId, selectedIndices, tableData)
      {
         if(menuItemId=="fsrNew")
         {
         	// New.. Menu Item selected
            NewMenuAction(selectedIndices, tableData);
         }
         else if(menuItemId == "fsrEdit")
         {
            // Edit.. Menu Item selected
            EditMenuAction(selectedIndices, tableData);
         }
         else if(menuItemId == "fsrDelete")
         {
         	// Delete Menu Item selected
            DeleteMenuAction(selectedIndices, tableData);
         }

         return;
      } // end of fsrMenuActionHandler()
      
		/*******************************************************************************************************************
	 	 * NewMenuAction()
	 	 * @param  selectedIndices - selected items from list
	 	 * @param tableData - reference to the 2 dimensional Array TableCell
	 	 * Called when the New Menu Item is selected through the fsrMenuActionHandler() function
		 ********************************************************************************************************************/
      function NewMenuAction(selectedIndices, tableData)
      {
          document.FSRights.newSupervisorCB.checked = false;
          document.FSRights.newReadCB.checked = false;
          document.FSRights.newWriteCB.checked = false;
          document.FSRights.newCreateCB.checked = false;
          document.FSRights.newEraseCB.checked = false;
          document.FSRights.newModifyCB.checked = false;
          document.FSRights.newFileScanCB.checked = false;
          document.FSRights.newAccessControlCB.checked = false;
      
      	// Show the New Dialog
      	showhide('NewDialog');
      	
      	// Set focus to the pathNameNewTF element
      	document.FSRights.pathNameNewTF.focus();
      	
      	// Make sure the pathNameNewTF is cleared.
      	document.FSRights.pathNameNewTF.value = "";
      } // end of NewMenuAction()
      
		/*******************************************************************************************************************
	 	 * addFSRights()
	 	 * Called when the OK button on the New Object FS Rights Dialog is selected
		 ********************************************************************************************************************/
		function addFSRights()
		{
			// Verify the text field is populated
			if(document.FSRights.pathNameNewTF.value.length == 0)
			{
				alert("<iman:string key='Template.EnterPathObjectName' />");           
				return;
			}  
					
		 	// Set up the add FS Rights request
		 	document.FSRights.operation.value = "addFSRights";
			document.FSRights.nextState.value = "show";
			document.FSRights.target = "bookBody";
			document.FSRights.submit();
		} // end of addFSRights()
	
		/*******************************************************************************************************************
	 	 * EditMenuAction()
	 	 * @param  selectedIndices - selected items from list
	 	 * @param tableData - reference to the 2 dimensional Array TableCell
	 	 * Called when the Edit Menu Item is selected through the fsrMenuActionHandler() function
		 ********************************************************************************************************************/
      function EditMenuAction(selectedIndices, tableData)
      {
      	// Clear all check boxes
          document.FSRights.editSupervisorCB.checked = false;
          document.FSRights.editReadCB.checked = false;
          document.FSRights.editWriteCB.checked = false;
          document.FSRights.editCreateCB.checked = false;
          document.FSRights.editEraseCB.checked = false;
          document.FSRights.editModifyCB.checked = false;
          document.FSRights.editFileScanCB.checked = false;
          document.FSRights.editAccessControlCB.checked = false;
                                                                                
      	// Verify 1 or more items have been selected
     		if(selectedIndices.length > 0)
     		{
     		   // Supervisor
     			var set = "true";
	         for(var i = 0; i < selectedIndices.length; i++)
	         {
	           	var index = selectedIndices[i];
     				var rights = tableData[index][4];
     				if(rights.charAt(0) != 'S')
     				{
     					set = "false";
     					break;
     				}
     			}
     			if(set == "true")
     			{
     				document.FSRights.editSupervisorCB.checked = true;
     			}
 
     			// Read
      		set = "true";     			     			
	         for(var i = 0; i < selectedIndices.length; i++)
	         {
	           	var index = selectedIndices[i];
     				var rights = tableData[index][4];
     				if(rights.charAt(1) != 'R')
     				{
     					set = "false";
     					break;
     				}
     			}
     			if(set == "true")
     			{
     				document.FSRights.editReadCB.checked = true;
     			}
     			
     			// Write
      		set = "true";     			
	         for(var i = 0; i < selectedIndices.length; i++)
	         {
	           	var index = selectedIndices[i];
     				var rights = tableData[index][4];
     				if(rights.charAt(2) != 'W')
     				{
     					set = "false";
     					break;
     				}
     			}
     			if(set == "true")
     			{
     				document.FSRights.editWriteCB.checked = true;
     			}
     			
      		// Create
      		set = "true";     			
	         for(var i = 0; i < selectedIndices.length; i++)
	         {
	           	var index = selectedIndices[i];
     				var rights = tableData[index][4];
     				if(rights.charAt(3) != 'C')
     				{
     					set = "false";
     					break;
     				}
     			}
     			if(set == "true")
     			{
     				document.FSRights.editCreateCB.checked = true;
     			}
     			
     		   // Erase
     			var set = "true";
	         for(var i = 0; i < selectedIndices.length; i++)
	         {
	           	var index = selectedIndices[i];
     				var rights = tableData[index][4];
     				if(rights.charAt(4) != 'E')
     				{
     					set = "false";
     					break;
     				}
     			}
     			if(set == "true")
     			{
     				document.FSRights.editEraseCB.checked = true;
     			}
 
     			// Modify
      		set = "true";     			     			
	         for(var i = 0; i < selectedIndices.length; i++)
	         {
	           	var index = selectedIndices[i];
     				var rights = tableData[index][4];
     				if(rights.charAt(5) != 'M')
     				{
     					set = "false";
     					break;
     				}
     			}
     			if(set == "true")
     			{
     				document.FSRights.editModifyCB.checked = true;
     			}
     			
     			// File Scan
      		set = "true";     			
	         for(var i = 0; i < selectedIndices.length; i++)
	         {
	           	var index = selectedIndices[i];
     				var rights = tableData[index][4];
     				if(rights.charAt(6) != 'F')
     				{
     					set = "false";
     					break;
     				}
     			}
     			if(set == "true")
     			{
     				document.FSRights.editFileScanCB.checked = true;
     			}
     			
      			// Access Control
      		set = "true";     			
	         for(var i = 0; i < selectedIndices.length; i++)
	         {
	           	var index = selectedIndices[i];
     				var rights = tableData[index][4];
     				if(rights.charAt(7) != 'A')
     				{
     					set = "false";
     					break;
     				}
     			}
     			if(set == "true")
     			{
     				document.FSRights.editAccessControlCB.checked = true;
     			}
     			
     			var selectedVolumeTD = document.getElementById("selectedVolumeTD");
     			removeChildrenRecursively(selectedVolumeTD);
     			var volumesToEdit = new Array(selectedIndices.length);
     			var pathsToEdit = new Array(selectedIndices.length);
     			// If we have more the 7 selected objects then setup the display differently
     			if(selectedIndices.length > 7)
     			{
	         	for(var i = 0; i < selectedIndices.length; i++)
	         	{
	            	var index = selectedIndices[i];
	            	volumesToEdit[i] = tableData[index][1];
	            	pathsToEdit[i] = tableData[index][3];
	            }
	            
	            var volumeDiv = document.createElement('div');
	            var objectsSelected="<iman:string key='Template.ObjectsSelected' />";
					volumeDiv.innerHTML=toDisplay(formatMessage(objectsSelected, [selectedIndices.length]));
					selectedVolumeTD.appendChild(volumeDiv);	            
     			}
     			else
     			{
	         	for(var i = 0; i < selectedIndices.length; i++)
	         	{
	            	var index = selectedIndices[i];
	     				var volumeDiv = document.createElement('div');
	     				if(tableData[index][1] == "Home Directory")
	     				{
	     					volumeDiv.innerHTML=toDisplay(tableData[index][3]);
	     				}
	     				else
	     				{
							volumeDiv.innerHTML=toDisplay(tableData[index][1] + ":" + tableData[index][3]);
						}
						selectedVolumeTD.appendChild(volumeDiv);
	            	volumesToEdit[i] = tableData[index][1];
	            	pathsToEdit[i] = tableData[index][3];
	            }
	         }
            		
            // Pack the array
            document.FSRights.packedVolumesToEdit.value = pack(volumesToEdit);  			
            document.FSRights.packedPathsToEdit.value = pack(pathsToEdit); 
             			
       		// Show the New Dialog
     		 	showhide('EditDialog');
       	}
      	else
         {
            // No objects selected
            alert("<iman:string key='Template.CheckOneOrMoreObjectsToPerformOperation' />");           
         }
      } // end of EditMenuAction()

		/*******************************************************************************************************************
	 	 * editFSRights()
	 	 * Called when the OK button on the Edit FS Rights Dialog is selected
	 	 * The selected objects are setup in the EditMenuAction() function in packedVolumesToEdit
	 	 * and packedPathsToEdit
		 ********************************************************************************************************************/
		function editFSRights()
		{
			// Set up the edit FS Rights request
			document.FSRights.operation.value = "editFSRights";
			document.FSRights.nextState.value = "show";
			document.FSRights.target = "bookBody";
			document.FSRights.submit();
		} // end of editFSRights()

		/*******************************************************************************************************************
	 	 * DeleteMenuAction()
	 	 * @param  selectedIndices - selected items from list
	 	 * @param tableData - reference to the 2 dimensional Array TableCell
	 	 * Called when the Delete Menu Item is selected through the fsrMenuActionHandler() function
		 ********************************************************************************************************************/
      function DeleteMenuAction(selectedIndices, tableData)
      {
      	// Verify 1 or more items have been selected
      	if(selectedIndices.length > 0)
      	{
      		var confirmMessage = "<iman:string key='Template.ConfirmationDeleteFSRights' />";
      		if(selectedIndices.length == 1)
      		{
           		var index = selectedIndices[0];
           		if(tableData[index][1] == "Home Directory")
           		{
           			alert("<iman:string key='Template.CantRemoveHomeDirectory' />");
           			return;
           		}
     			}
      		else
      		{
          		for(var i = 0; i < selectedIndices.length; i++)
         		{
         			var index = selectedIndices[i];
            		if(tableData[index][1] == "Home Directory")
            		{
            			confirmMessage = "<iman:string key='Template.ConfirmationDeleteFSRightsWithHomeDir' />";
            			break;
            		}
            	}
      		}

      		if(confirm(confirmMessage))      		
            {
					var volumesToDelete = new Array(selectedIndices.length);
					var pathsToDelete = new Array(selectedIndices.length);
         		for(var i = 0; i < selectedIndices.length; i++)
         		{
            		var index = selectedIndices[i];
            		volumesToDelete[i] = tableData[index][1];
            		pathsToDelete[i] = tableData[index][3];
            	}
            		
 					// Set up the delete FS Rights request
            	document.FSRights.packedVolumesToDelete.value = pack(volumesToDelete);
            	 document.FSRights.packedPathsToDelete.value = pack(pathsToDelete);
            	document.FSRights.operation.value = "deleteFSRights";
					document.FSRights.nextState.value = "show";
					document.FSRights.target = "bookBody";
					document.FSRights.submit();
            }      		
      	}
      	else
         {
         	// No objects selected
            alert("<iman:string key='Template.CheckOneOrMoreObjectsToPerformOperation' />");
         }
      } // end of DeleteMenuAction()
      
		/*******************************************************************************************************************
	 	 * fsrLinkActionHandler()
	 	 * @param column - selected column
	 	 * @param row - selected row
	 	 * @param tableData - reference to the 2 dimensional Array TableCell
	 	 * Called when a Volume link Item is selected
		 ********************************************************************************************************************/
      function fsrLinkActionHandler(column, row, tableData)
      {
         if(column == 1)
         {
         	var selectedIndices = Array(1);
         	selectedIndices[0] = row;
				EditMenuAction(selectedIndices, tableData)
         }
		} // end of fsrLinkActionHandler()
      
       function objectSortHandler(tableName, column, direction, tableData)
      {
      	document.FSRights.sortColumn.value = column;
      	document.FSRights.sortDirection.value = direction;      	
		 	document.FSRights.operation.value = "changeSortColumnDirection";
			document.FSRights.nextState.value = "show";
			document.FSRights.target = "bookBody";
			document.FSRights.submit();
      }
      
		/*******************************************************************************************************************
	 	 * showhide()
	 	 * Shows or hides the div depending on the current state
		 ********************************************************************************************************************/
		function showhide(divID)
		{
			var element;
			element = document.getElementById(divID);
			
		   if(element.style.display == "none")
		  	{
				element.style.display = "block";
			}
			else
			{
				element.style.display = "none";
			} 
		} // end of showhide()
	
		/*******************************************************************************************************************
	 	 * cancelCloseDialog()
	 	 * Calls showhide() with the current div
		 ********************************************************************************************************************/
	function cancelCloseDialog(div)
	{
		showhide(div);
	} // end of cancelCloseDialog()

		/*******************************************************************************************************************
	 	 * removeChildrenRecursively()
	 	 * @param node - the node to remove all children
	 	 * This function removes all child elements of the given node
		 ********************************************************************************************************************/
		function removeChildrenRecursively(node)
		{
			if (node != null)
	    	{
		   	while (node.hasChildNodes())
				{
		      	removeChildrenRecursively(node.firstChild);
		       	node.removeChild(node.firstChild);
				}
			}
		} // end of removeChildrenRecursively()

   </SCRIPT>
</HEAD>
<BODY onLoad="onInit();">
<FORM name="FSRights" method="post" action="webacc" >
	<input type=hidden name="operation" value="">
	<input type=hidden name="packedVolumesToDelete" value="">
	<input type=hidden name="packedPathsToDelete" value="">
	<input type=hidden name="packedVolumesToEdit" value="">
	<input type=hidden name="packedPathsToEdit" value="">
   <input type="hidden" name="sortColumn" value="<c:out value="${sortColumn}"/>">
   <input type="hidden" name="sortDirection" value="<c:out value="${sortDirection}"/>">	
	
   <iman:messagebar />
   <iman:bookvars/>
 	<iman:dataTable id="FSRights" tableData="${tableData}" menuActionHandler="fsrMenuActionHandler" linkActionHandler="fsrLinkActionHandler" sortHandler="objectSortHandler" sortedColumn="${sortColumn}" sortedDirection="${sortDirection}">
	   <iman:menuItem textKey="Template.New" id="fsrNew"/>
	   <iman:menuItem textKey="Template.Edit" id="fsrEdit"/>
	  	<iman:menuItem textKey="Template.Delete" id="fsrDelete"/>
	  	<iman:columnHeader textKey="Template.Type" sortable="false"/>
	   <iman:columnHeader textKey="Template.VolumeName" sortable="true"/>
	   <iman:columnHeader textKey="Template.Type" sortable="true"/>
	   <iman:columnHeader textKey="Template.Path" sortable="true"/>
	   <iman:columnHeader textKey="Template.Rights" sortable="true"/>
	</iman:dataTable>
	<% /* New Dialog */ %>
	<span id="NewDialog" style="display: none">
		<div class="dialog" id="newdialogcontent">
			<div class="title">
				<a onclick="cancelCloseDialog('NewDialog')" href="#">
					<img class="closebutton" src="<iman:moduleUrl/>/dev/images/nl_close_16.gif" title="<iman:string key="Template.Close.Alt"/>" alt="<iman:string key="Template.Close.Alt"/>" align="absmiddle" border="0">
				</a>
				<iman:string key="Template.NewDialogTitle.FSRight"/>
			</div>
			<div class="instructions"><iman:string key="Template.FSRights.New.Instructions"/></div>
			<div class="content">
				<table border="0" cellspacing="0" cellpadding="2">
					<tr>
						<td>
							<label><iman:string key="Template.Path.Label"/></label>
						</td>
						<td colspan="2">
							<div style="overflow:auto">
								<input type="text" name="pathNameNewTF" size="30">
								<iman:os typeFilter="Volume,Directory,File" control="pathNameNewTF" history="true"/>
								&nbsp;
							</div>
						</td>
					</tr>
					<tr>
						<td valign="top">
							<label><iman:string key="Template.Rights.Label"/></label>
						</td>
						<td>
							<div><input type="checkbox" name="newSupervisorCB"><label><iman:string key="Template.Rights.Supervisor"/></label></div>
							<div><input type="checkbox" name="newReadCB"><label><iman:string key="Template.Rights.Read"/></label></div>
							<div><input type="checkbox" name="newWriteCB"><label><iman:string key="Template.Rights.Write"/></label></div>
							<div><input type="checkbox" name="newCreateCB"><label><iman:string key="Template.Rights.Create"/></label></div>
						</td>
						<td>
							<div><input type="checkbox" name="newEraseCB"><label><iman:string key="Template.Rights.Erase"/></label></div>
							<div><input type="checkbox" name="newModifyCB"><label><iman:string key="Template.Rights.Modify"/></label></div>
							<div><input type="checkbox" name="newFileScanCB"><label><iman:string key="Template.Rights.FileScan"/></label></div>
							<div><input type="checkbox" name="newAccessControlCB"><label><iman:string key="Template.Rights.AccessControl"/></label></div>
						</td>
					</tr>
				</table>
			</div>		
			<div class="footer">
				<a onclick="cancelCloseDialog('NewDialog')" href="#">
					<img  src="<iman:moduleUrl/>/dev/images/<iman:string key='Button.Cancel2.image'/>" title="<iman:string key="Template.Cancel.Alt"/>" alt="<iman:string key="Template.Cancel.Alt"/>" border="0">
				</a>
				<a onclick="addFSRights()" href="#" >
					<img src="<iman:moduleUrl/>/dev/images/<iman:string key='Button.OK2.image'/>" title="<iman:string key="Template.OK.Alt"/>" alt="<iman:string key="Template.OK.Alt"/>" border="0">
				</a>
				<div>&nbsp;</div>
			</div>
		</div>
	</span>	
	<% /* Edit Dialog */ %>
	<span id="EditDialog" style="display: none">
		<div class="dialog" id="editdialogcontent">
			<div class="title">
				<a onclick="cancelCloseDialog('EditDialog')" href="#">
					<img class="closebutton" src="<iman:moduleUrl/>/dev/images/nl_close_16.gif" title="<iman:string key="Template.Close.Alt"/>" alt="<iman:string key="Template.Close.Alt"/>" align="absmiddle" border="0">
				</a>
				<iman:string key="Template.EditDialogTitle.FSRight"/>
			</div>
			<div class="instructions"><iman:string key="Template.FSRights.Edit.Instructions"/></div>
			<div class="content">
				<table border="0" cellspacing="0" cellpadding="2">
					<tr>
						<td valign="top">
							<label><iman:string key="Template.Path.Label"/></label>
						</td>
						<td colspan="2" id="selectedVolumeTD">
						</td>
					</tr>
					<tr>
						<td valign="top">
							<label><iman:string key="Template.Rights.Label"/></label>
						</td>
						<td>
							<div><input type="checkbox" name="editSupervisorCB"><label><iman:string key="Template.Rights.Supervisor"/></label></div>
							<div><input type="checkbox" name="editReadCB"><label><iman:string key="Template.Rights.Read"/></label></div>
							<div><input type="checkbox" name="editWriteCB"><label><iman:string key="Template.Rights.Write"/></label></div>
							<div><input type="checkbox" name="editCreateCB"><label><iman:string key="Template.Rights.Create"/></label></div>
						</td>
						<td>
							<div><input type="checkbox" name="editEraseCB"><label><iman:string key="Template.Rights.Erase"/></label></div>
							<div><input type="checkbox" name="editModifyCB"><label><iman:string key="Template.Rights.Modify"/></label></div>
							<div><input type="checkbox" name="editFileScanCB"><label><iman:string key="Template.Rights.FileScan"/></label></div>
							<div><input type="checkbox" name="editAccessControlCB"><label><iman:string key="Template.Rights.AccessControl"/></label></div>
						</td>
					</tr>
				</table>
			</div>		
			<div class="footer">
				<a onclick="cancelCloseDialog('EditDialog')" href="#">
					<img  src="<iman:moduleUrl/>/dev/images/<iman:string key='Button.Cancel2.image'/>" title="<iman:string key="Template.Cancel.Alt"/>" alt="<iman:string key="Template.Cancel.Alt"/>" border="0">
				</a>
				<a onclick="editFSRights()" href="#" >
					<img src="<iman:moduleUrl/>/dev/images/<iman:string key='Button.OK2.image'/>" title="<iman:string key="Template.OK.Alt"/>" alt="<iman:string key="Template.OK.Alt"/>" border="0">
				</a>
				<div>&nbsp;</div>
			</div>
		</div>
	</span>	
	
</FORM>
<iman:osFooter/>
</BODY>
</HTML>
