<%@  page pageEncoding="utf-8" contentType="text/html;charset=utf-8"  %>
<%@ taglib uri="/WEB-INF/iman.tld" prefix="iman" %>
<%@ taglib uri="/WEB-INF/fmt.tld" prefix="fmt" %>
<%@ taglib uri="/WEB-INF/c.tld" prefix="c" %>
<%@ taglib uri="/WEB-INF/x.tld" prefix="x" %>
<iman:stringtable bundle="BaseResources" />
<iman:stringtable bundle="DevResources" />
<iman:stringtable bundle="FwResources" />

<HTML>
<HEAD>
   <TITLE><iman:string key="ProductName"/></TITLE>
   <LINK href="<iman:moduleUrl/>/dev/css/hf_dialog.css" rel="stylesheet" type="text/css">
   <iman:include page="dev/ValidateIntegerScripts_inc.jsp"/>
   <iman:stylesheet/>
   <iman:uihandlerTools/>
   <iman:pageScripts/>
   <iman:eMFrameScripts/>
   <iman:dataTableScripts/>
   <iman:osScripts/>

   <SCRIPT>
   
		/*******************************************************************************************************************
		 * onInit()
		 * - Called on page load.
		 ********************************************************************************************************************/
		function onInit()
      {
      	returnFromOS();
      } // end of onInit()

		/*******************************************************************************************************************
	 	 * isPageValid()
	 	 * What should this method do?
	 	 * -data validation
	 	 * -general page cleanup before being submitted
	 	 * -if this method returns false, the page will not be saved
	 	 * Called when user leaves this page or applys changes	 	 	 	 	 	 	 	 
		 ********************************************************************************************************************/
      function isPageValid()
      {
         var success = notifyAllOfExit();
         if(!success)
         {
            return false;
         }
      } // end of isPageValid()
      
		/*******************************************************************************************************************
	 	 * vsrMenuActionHandler()
	 	 * @param menuItemId - selected menu item
	 	 * @param  selectedIndices - selected items from list
	 	 * @param tableData - reference to the 2 dimensional Array TableCell
	 	 * Called when a Menu Item is selected
		 ********************************************************************************************************************/
      function vsrMenuActionHandler(menuItemId, selectedIndices, tableData)
      {
         if(menuItemId=="vsrNew")
         {
         	// New.. Menu Item selected
            NewMenuAction(selectedIndices, tableData);
         }
         else if(menuItemId == "vsrEdit")
         {
            // Edit.. Menu Item selected
            EditMenuAction(selectedIndices, tableData);
         }
         else if(menuItemId == "vsrDelete")
         {
         	// Delete Menu Item selected
            DeleteMenuAction(selectedIndices, tableData);
         }

         return;
      } // end of vsrMenuActionHandler()
      
		/*******************************************************************************************************************
	 	 * NewMenuAction()
	 	 * @param  selectedIndices - selected items from list
	 	 * @param tableData - reference to the 2 dimensional Array TableCell
	 	 * Called when the New Menu Item is selected through the vsrMenuActionHandler() function
		 ********************************************************************************************************************/
      function NewMenuAction(selectedIndices, tableData)
      {
      	// Show the New Dialog
      	showhide('NewDialog');
      	
      	// Set focus to the volumeNameNewTF element
      	document.VolumeSpaceRestrictions.volumeNameNewTF.focus();
      	
      	// Make sure the text fields are cleared.
      	document.VolumeSpaceRestrictions.volumeNameNewTF.value = "";
			document.VolumeSpaceRestrictions.limitNewTF.value = "";
      } // end of NewMenuAction()
      
		/*******************************************************************************************************************
	 	 * addVolumeSpaceRestriction()
	 	 * Called when the OK button on the New Volume Restrictions Dialog is selected
		 ********************************************************************************************************************/
		function addVolumeSpaceRestriction()
		{
			// Verify the text field is populated
			if(document.VolumeSpaceRestrictions.volumeNameNewTF.value.length == 0)
			{
				alert("<iman:string key='Template.EnterVolumeObjectName' />");           
				return;
			}  
					
			// Verify the text field is populated
			if(document.VolumeSpaceRestrictions.limitNewTF.value.length == 0)
			{
            alert("<iman:string key='Template.EnterLimit' />");           
				return;
			}  
		 	
		 	// Set up the add Volume Space Restriction request
		 	document.VolumeSpaceRestrictions.operation.value = "addVolumeSpaceRestriction";
			document.VolumeSpaceRestrictions.nextState.value = "show";
			document.VolumeSpaceRestrictions.target = "bookBody";
			document.VolumeSpaceRestrictions.submit();
		} // end of addVolumeSpaceRestriction()
	
		/*******************************************************************************************************************
	 	 * EditMenuAction()
	 	 * @param  selectedIndices - selected items from list
	 	 * @param tableData - reference to the 2 dimensional Array TableCell
	 	 * Called when the Edit Menu Item is selected through the vsrMenuActionHandler() function
		 ********************************************************************************************************************/
      function EditMenuAction(selectedIndices, tableData)
      {
      	// Verify 1 or more items have been selected
     		if(selectedIndices.length > 0)
     		{
     			var selectedVolumeTD = document.getElementById("selectedVolumeTD");
     			removeChildrenRecursively(selectedVolumeTD);
     			var itemsToEdit = new Array(selectedIndices.length);
     			// If we have more the 7 selected objects then setup the display differently
     			if(selectedIndices.length > 7)
     			{
	         	for(var i = 0; i < selectedIndices.length; i++)
	         	{
	            	var index = selectedIndices[i];
	            	itemsToEdit[i] = tableData[index][1];
	            }
	            
	            var volumeDiv = document.createElement('div');
	            var objectsSelected="<iman:string key='Template.ObjectsSelected' />";
					volumeDiv.innerHTML=formatMessage(objectsSelected, [selectedIndices.length]);
					selectedVolumeTD.appendChild(volumeDiv);	            
     			}
     			else
     			{
	         	for(var i = 0; i < selectedIndices.length; i++)
	         	{
	            	var index = selectedIndices[i];
	     				var volumeDiv = document.createElement('div');
						volumeDiv.innerHTML=tableData[index][1];
						selectedVolumeTD.appendChild(volumeDiv);
	            	itemsToEdit[i] = tableData[index][1];
	            }
	         }
            		
            // Pack the array
            document.VolumeSpaceRestrictions.packedItemsToEdit.value = pack(itemsToEdit);  			
 
       		// Show the New Dialog
     		 	showhide('EditDialog');
     		 	
     		 	// Set focus to the limitEditTF element
     		 	document.VolumeSpaceRestrictions.limitEditTF.focus();
      	
      		// Make sure the text field is cleared.
				document.VolumeSpaceRestrictions.limitEditTF.value = "";
     		 	
       	}
      	else
         {
            // No objects selected
            alert("<iman:string key='Template.CheckOneOrMoreObjectsToPerformOperation' />");           
         }
      } // end of EditMenuAction()

		/*******************************************************************************************************************
	 	 * editVolumeSpaceRestriction()
	 	 * Called when the OK button on the Edit Volume Restrictions Dialog is selected
	 	 * The selected objects are setup in the EditMenuAction() function in packedItemsToEdit
		 ********************************************************************************************************************/
		function editVolumeSpaceRestriction()
		{
			// Verify the text field is populated
			if(document.VolumeSpaceRestrictions.limitEditTF.value.length == 0)
			{
            alert("<iman:string key='Template.EnterLimit' />");           
				return;
			}  
		
			// Set up the edit Volume Space Restriction request
			document.VolumeSpaceRestrictions.operation.value = "editVolumeSpaceRestriction";
			document.VolumeSpaceRestrictions.nextState.value = "show";
			document.VolumeSpaceRestrictions.target = "bookBody";
			document.VolumeSpaceRestrictions.submit();
		} // end of editVolumeSpaceRestriction()

		/*******************************************************************************************************************
	 	 * DeleteMenuAction()
	 	 * @param  selectedIndices - selected items from list
	 	 * @param tableData - reference to the 2 dimensional Array TableCell
	 	 * Called when the Delete Menu Item is selected through the vsrMenuActionHandler() function
		 ********************************************************************************************************************/
      function DeleteMenuAction(selectedIndices, tableData)
      {
      	// Verify 1 or more items have been selected
      	if(selectedIndices.length > 0)
      	{
      		if(confirm("<iman:string key='Template.ConfirmationDeleteVolumeSpaceRestrictions' />"))      		
            {
					var itemsToDelete = new Array(selectedIndices.length);
         		for(var i = 0; i < selectedIndices.length; i++)
         		{
            		var index = selectedIndices[i];
            		itemsToDelete[i] = tableData[index][1];
            	}
            		
 					// Set up the delete Volume Space Restriction request
            	document.VolumeSpaceRestrictions.packedItemsToDelete.value = pack(itemsToDelete);
            	document.VolumeSpaceRestrictions.operation.value = "deleteVolumeSpaceRestriction";
					document.VolumeSpaceRestrictions.nextState.value = "show";
					document.VolumeSpaceRestrictions.target = "bookBody";
					document.VolumeSpaceRestrictions.submit();
            }      		
      	}
      	else
         {
         	// No objects selected
            alert("<iman:string key='Template.CheckOneOrMoreObjectsToPerformOperation' />");
         }
      } // end of DeleteMenuAction()
      
		/*******************************************************************************************************************
	 	 * vsrLinkActionHandler()
	 	 * @param column - selected column
	 	 * @param row - selected row
	 	 * @param tableData - reference to the 2 dimensional Array TableCell
	 	 * Called when a Volume link Item is selected
		 ********************************************************************************************************************/
      function vsrLinkActionHandler(column, row, tableData)
      {
         if(column == 1)
         {
         	var selectedIndices = Array(1);
         	selectedIndices[0] = row;
				EditMenuAction(selectedIndices, tableData)
         }
		} // end of vsrLinkActionHandler()
      
       function objectSortHandler(tableName, column, direction, tableData)
      {
      	document.VolumeSpaceRestrictions.sortColumn.value = column;
      	document.VolumeSpaceRestrictions.sortDirection.value = direction;      	
		 	document.VolumeSpaceRestrictions.operation.value = "changeSortColumnDirection";
			document.VolumeSpaceRestrictions.nextState.value = "show";
			document.VolumeSpaceRestrictions.target = "bookBody";
			document.VolumeSpaceRestrictions.submit();
      }
      
		/*******************************************************************************************************************
	 	 * showhide()
	 	 * Shows or hides the div depending on the current state
		 ********************************************************************************************************************/
		function showhide(divID)
		{
			var element;
			element = document.getElementById(divID);
			
		   if(element.style.display == "none")
		  	{
				element.style.display = "block";
			}
			else
			{
				element.style.display = "none";
			} 
		} // end of showhide()
	
		/*******************************************************************************************************************
	 	 * cancelCloseDialog()
	 	 * Calls showhide() with the current div
		 ********************************************************************************************************************/
	function cancelCloseDialog(div)
	{
		showhide(div);
	} // end of cancelCloseDialog()

		/*******************************************************************************************************************
	 	 * removeChildrenRecursively()
	 	 * @param node - the node to remove all children
	 	 * This function removes all child elements of the given node
		 ********************************************************************************************************************/
		function removeChildrenRecursively(node)
		{
			if (node != null)
	    	{
		   	while (node.hasChildNodes())
				{
		      	removeChildrenRecursively(node.firstChild);
		       	node.removeChild(node.firstChild);
				}
			}
		} // end of removeChildrenRecursively()

   </SCRIPT>
</HEAD>
<BODY onLoad="onInit();">
<FORM name="VolumeSpaceRestrictions" method="post" action="webacc" >
	<input type=hidden name="operation" value="">
	<input type=hidden name="packedItemsToDelete" value="">
	<input type=hidden name="packedItemsToEdit" value="">
   <input type="hidden" name="sortColumn" value="<c:out value="${sortColumn}"/>">
   <input type="hidden" name="sortDirection" value="<c:out value="${sortDirection}"/>">	
	
   <iman:messagebar />
   <iman:bookvars/>
 	<iman:dataTable id="VolumeSpaceRestrictions" tableData="${tableData}" menuActionHandler="vsrMenuActionHandler" linkActionHandler="vsrLinkActionHandler" sortHandler="objectSortHandler" sortedColumn="${sortColumn}" sortedDirection="${sortDirection}">
	   <iman:menuItem textKey="Template.New" id="vsrNew"/>
	   <iman:menuItem textKey="Template.Edit" id="vsrEdit"/>
	  	<iman:menuItem textKey="Template.Delete" id="vsrDelete"/>
	  	<iman:columnHeader textKey="Template.Type" sortable="false"/>
	   <iman:columnHeader textKey="Template.VolumeName" sortable="true"/>
	   <iman:columnHeader textKey="Template.Type" sortable="false"/>
	   <iman:columnHeader textKey="Template.PhysicalName" sortable="true"/>
	   <iman:columnHeader textKey="Template.Limit" sortable="true"/>
	</iman:dataTable>
	<% /* New Dialog */ %>
	<span id="NewDialog" style="display: none">
		<div class="dialog" id="newdialogcontent">
			<div class="title">
				<a onclick="cancelCloseDialog('NewDialog')" href="#">
					<img class="closebutton" src="<iman:moduleUrl/>/dev/images/nl_close_16.gif" title="<iman:string key="Template.Close.Alt"/>" alt="<iman:string key="Template.Close.Alt"/>" align="absmiddle" border="0">
				</a>
				<iman:string key="Template.NewDialogTitle.VolumeSpaceRestrictions"/>
			</div>
				<div>&nbsp;</div>
			<div class="content">
				<table border="0" cellspacing="0" cellpadding="2">
					<tr>
						<td>
							<label><iman:string key="Template.Volume.Label"/></label>
						</td>
						<td>
							<div style="overflow:auto">
								<input type="text" name="volumeNameNewTF" size="30">
								<iman:os typeFilter="Volume" control="volumeNameNewTF" history="true"/>
								&nbsp;
							</div>
						</td>
					</tr>
					<tr>
						<td>
							<label><iman:string key="Template.Limit.Label"/></label>
						</td>
						<td>
							<div style="overflow:auto">
								<input type="text" name="limitNewTF" size="9" maxlength="9" onChange='if(!validateIntegerField(this,0,999999999)){this.focus();return false;}'>
								<span class="instructions">
									<iman:string key="Template.KB4"/>
								</span>
							</div>
						</td>
					</tr>
				</table>
			</div>		
			<div class="footer">
				<a onclick="cancelCloseDialog('NewDialog')" href="#">
					<img  src="<iman:moduleUrl/>/dev/images/<iman:string key='Button.Cancel2.image'/>" title="<iman:string key="Template.Cancel.Alt"/>" alt="<iman:string key="Template.Cancel.Alt"/>" border="0">
				</a>
				<a onclick="addVolumeSpaceRestriction()" href="#" >
					<img src="<iman:moduleUrl/>/dev/images/<iman:string key='Button.OK2.image'/>" title="<iman:string key="Template.OK.Alt"/>" alt="<iman:string key="Template.OK.Alt"/>" border="0">
				</a>
				<div>&nbsp;</div>
			</div>
		</div>
	</span>	
	<% /* Edit Dialog */ %>
	<span id="EditDialog" style="display: none">
		<div class="dialog" id="editdialogcontent">
			<div class="title">
				<a onclick="cancelCloseDialog('EditDialog')" href="#">
					<img class="closebutton" src="<iman:moduleUrl/>/dev/images/nl_close_16.gif" title="<iman:string key="Template.Close.Alt"/>" alt="<iman:string key="Template.Close.Alt"/>" align="absmiddle" border="0">
				</a>
				<iman:string key="Template.EditDialogTitle.VolumeSpaceRestrictions"/>
			</div>
				<div>&nbsp;</div>
			<div class="content">
				<table border="0" cellspacing="0" cellpadding="2">
					<tr>
						<td valign="top">
							<label><iman:string key="Template.Volume.Label"/></label>
						</td>
						<td id="selectedVolumeTD">
						</td>
					</tr>
					<tr>
						<td>
							<label><iman:string key="Template.Limit.Label"/></label>
						</td>
						<td>
							<div style="overflow:auto">
								<input type="text" name="limitEditTF" size="9" maxlength="9" onChange='if(!validateIntegerField(this,0,999999999)){this.focus();return false;}'>
								<span class="instructions">
									<iman:string key="Template.KB4"/>
								</span>
							</div>
						</td>
					</tr>
				</table>
			</div>		
			<div class="footer">
				<a onclick="cancelCloseDialog('EditDialog')" href="#">
					<img  src="<iman:moduleUrl/>/dev/images/<iman:string key='Button.Cancel2.image'/>" title="<iman:string key="Template.Cancel.Alt"/>" alt="<iman:string key="Template.Cancel.Alt"/>" border="0">
				</a>
				<a onclick="editVolumeSpaceRestriction()" href="#" >
					<img src="<iman:moduleUrl/>/dev/images/<iman:string key='Button.OK2.image'/>" title="<iman:string key="Template.OK.Alt"/>" alt="<iman:string key="Template.OK.Alt"/>" border="0">
				</a>
				<div>&nbsp;</div>
			</div>
		</div>
	</span>	
	
</FORM>
<iman:osFooter/>
</BODY>
</HTML>
