<%@  page pageEncoding="utf-8" contentType="text/html;charset=utf-8" import="com.novell.webaccess.common.JSPConduit, com.novell.emframe.dev.eMFrameUtils, java.util.Locale" %>
<%   JSPConduit c = JSPConduit.getJSPConduit(request);
   c.stringTable("DevResources");
   c.stringTable("FwResources");
   c.stringTable("BaseResources"); %>
<HTML>
<HEAD>
<TITLE><%= c.toHTML(c.string("PartitionReplica.ReplicaAdministration")) %></TITLE>
<link   rel='stylesheet'
        href='<%= c.getModulesUrl() + "/dev/css/hf_style.css" %>'>

<jsp:include page='<%= c.getPath("dev/eMFrameScripts_inc.jsp") %>' flush="true" />
<jsp:include page='<%= c.getPath("dev/OSScripts_inc.jsp") %>' flush="true" />

<script language="JavaScript">

    var replicaImages = new Array();


    // pre-cache replica images
    if(document.images)
    {
        replicaImages["readwrite"] = new Image(24, 24);
        replicaImages["readwrite"].src = "<%= c.getModulesUrl() + "/dev/images/" + c.string("ReplicaReadWrite24.image") %>";

        replicaImages["readonly"] = new Image(24, 24);
        replicaImages["readonly"].src = "<%= c.getModulesUrl() + "/dev/images/" + c.string("ReplicaReadOnly24.image") %>";

        replicaImages["filteredreadwrite"] = new Image(24, 24);
        replicaImages["filteredreadwrite"].src = "<%= c.getModulesUrl() + "/dev/images/" + c.string("ReplicaFilteredReadWrite24.image") %>";

        replicaImages["filteredreadonly"] = new Image(24, 24);
        replicaImages["filteredreadonly"].src = "<%= c.getModulesUrl() + "/dev/images/" + c.string("ReplicaFilteredReadOnly24.image") %>";
    }

    /*******************
     * FUNCTION HEADER *
     *******************/
    function onPageLoad()
    {
        document.AddReplicaForm.selectedName.focus();
        changeReplicaType("ReplicaImage");
    }


    /*******************
     * FUNCTION HEADER *
     *******************/
    function okSelected()
    {
        if(checkRequiredFields() == false)
        {
            return false;
        }

        if(checkDuplicateNames() == false)
        {
            return false;
        }

        var form = document.AddReplicaForm;
        var replicaType;

        if(form.ReplicaTypeRadio[3].checked == true)
        {
            replicaType = form.ReplicaTypeRadio[3].value;
        }
        else if(form.ReplicaTypeRadio[2].checked == true)
        {
            replicaType = form.ReplicaTypeRadio[2].value;
        }
        else if(form.ReplicaTypeRadio[1].checked == true)
        {
            replicaType = form.ReplicaTypeRadio[1].value;
        }
        else
        {
            replicaType = form.ReplicaTypeRadio[0].value;
        }

        <% if (session.getAttribute("DeviceType").equals("default")) { %>
            form.elements["SelectedTableName"].value = form.selectedName.value;
            form.elements["ReplicaType"].value = replicaType;
            form.elements["merge"].value="base.partition.ReplicaTable";
            form.elements["nextState"].value="addReplica";

            form.submit();
        <% } else { %>
            window.opener.addReplicaInfo(form.selectedName.value, replicaType);
            window.close();
        <% } %>
    }


    /*******************
     * FUNCTION HEADER *
     *******************/
    function cancelSelected()
    {
        <% if (session.getAttribute("DeviceType").equals("default")) { %>
            var form = document.AddReplicaForm;

            form.elements["merge"].value="base.partition.ReplicaTable";
            form.elements["nextState"].value="cancelReplicaOperation";

            form.submit();
        <% } else { %>
            window.close();
        <% } %>
    }


    /*******************
     * FUNCTION HEADER *
     *******************/
    function checkRequiredFields()
    {
        var pageName = document.AddReplicaForm.selectedName.value;

        if ((pageName == null) || (pageName.length == 0))
        {
            <% if (c.var("Replica.TableType").equals("Replica.PartitionView")) { %>
                alert("<%= c.toScript(c.string("PartitionReplica.PartitionNameRequired")) %>");
            <% } else { %>
                alert("<%= c.toScript(c.string("PartitionReplica.ServerNameRequired")) %>");
            <% } %>

            return false;
        }
        return true;
    }


    /*******************
     * FUNCTION HEADER *
     *******************/
    function checkDuplicateNames()
    {
        var form = document.AddReplicaForm;

        var selectedName = form.selectedName.value;
        <% if (c.var("Replica.TableType").equals("Replica.PartitionView")) { %>
            var first = selectedName.charAt(0);
            var last = selectedName.charAt(selectedName.length-1);
            if((first == ".") && (last == "."))
            {
                selectedName = "[Root]";
            }
        <% } %>


        var replicaArray = unpack(form.Replica_List_Name.value);

        var replicaTypeArray = unpack(form.Replica_Type_Name.value);

        if(replicaArray.length > 0)
        {
            for (i = 0; i < replicaArray.length; i++)
            {
                var replicaName = replicaArray[i];
                var theType = replicaTypeArray[i];
                if(selectedName.toUpperCase() == replicaName.toUpperCase())
                {
                	var replicaType="<%= eMFrameUtils.getLocalizedString("BaseResources", "PartitionReplica.Reference", Locale.getDefault(),"")%>";
                    if(theType.toUpperCase().indexOf(replicaType.toUpperCase()) != -1)
                    {
                        return true;
                    }
                    else
                    {
                        <% if (c.var("Replica.TableType").equals("Replica.PartitionView")) { %>
                            alert("<%= c.toScript(c.string("PartitionReplica.PartitionAlreadyReplica")) %>");
                        <% } else { %>
                            alert("<%= c.toScript(c.string("PartitionReplica.ServerAlreadyReplica")) %>");
                        <% } %>
                        return false;
                    }
                }
            }
        }
        return true;
    }


    /*******************
     * FUNCTION HEADER *
     *******************/
    function changeReplicaType(imgName)
    {
        if(document.images)
        {
            var form = document.AddReplicaForm;
            var replicaType;

            if(form.ReplicaTypeRadio[3].checked == true)
            {
                replicaType = form.ReplicaTypeRadio[3].value;
            }
            else if(form.ReplicaTypeRadio[2].checked == true)
            {
                replicaType = form.ReplicaTypeRadio[2].value;
            }
            else if(form.ReplicaTypeRadio[1].checked == true)
            {
                replicaType = form.ReplicaTypeRadio[1].value;
            }
            else
            {
                replicaType = form.ReplicaTypeRadio[0].value;
            }

            document.images[imgName].src = replicaImages[replicaType].src;

        }
        return true;
    }


    /*******************
     * FUNCTION HEADER *
     *******************/
    function changeReplicaTypeLabel(imgName, num)
    {
        var form = document.AddReplicaForm;
        form.ReplicaTypeRadio[num].checked = true;
        changeReplicaType(imgName);
        return true;
    }


</SCRIPT>
</HEAD>

<BODY   TEXT="#000000" LINK="#000000" VLINK="#000000" ALINK="#000000" bgcolor="#FFFFFF"
        onLoad="returnFromOS();onPageLoad()">
<form   name="AddReplicaForm"
        method="post"
        action="webacc"
        onSubmit="return(okSelected())">


        <input  type=hidden
                name="taskId"
                value="<%= c.var("taskId") %>">

        <input  type=hidden
                name="merge"
                value="">

        <input  type=hidden
                name="error"
                value="dev.GenErr">

        <input  type=hidden
                name="User.context"
                value="<%= c.var("User.context") %>">

        <input  type=hidden
                name="nextState"
                value="">

        <input  type=hidden
                name="SelectedTableName"
                value="">

        <input  type=hidden
                name="ReplicaType"
                value="">

        <input  type=hidden
                name="Replica_List_Name"
                value="<%= c.var("Replica_List_Value") %>">

        <input  type=hidden
                name="Replica_Type_Name"
                value="<%= c.var("Replica_Type_Value") %>">

	<!-- ************ -->
	<!-- HEADER TABLE -->
	<!-- ************ -->
   <% c.set("TaskHeader.title", c.string("PartitionReplica.AddReplica"));
      c.set("TaskHeader.helpFile", "base/addreplica.html"); %>
   <jsp:include page='<%= c.getPath("dev/TaskHeader_inc.jsp") %>' flush="true" /><BR>

    <!-- ************* -->
    <!-- CONTENT TABLE -->
    <!-- ************* -->
    <TABLE>
        <TR>
            <% if (c.var("Replica.TableType").equals("Replica.ServerView")) { %>
                <TD class="mediumtext" width="0*">
                    <%= c.toHTML(c.string("PartitionReplica.PartitionName")) %>
                </TD>
            <% } else { %>
                <TD class="mediumtext" width="0*">
                    <%= c.toHTML(c.string("PartitionReplica.ServerName")) %>
                </TD>
            <% } %>
            <TD class="mediumtext">
                <%= c.toHTML(c.var("Replica.SelectedObjectName")) %>
            </TD>
        </TR>
        <TR>
            <TD height="10" colspan="2">
            </TD>
        </TR>
        <TR>
            <% if (c.var("Replica.TableType").equals("Replica.ServerView")) { %>
                <TD class="mediumtext" width="0*">
                    <%= c.toHTML(c.string("PartitionReplica.ServerName")) %>
                </TD>
            <% } else { %>
                <TD class="mediumtext" width="0*">
                    <%= c.toHTML(c.string("PartitionReplica.PartitionName")) %>
                </TD>
            <% } %>
            <TD>
                <input   type=text
                            name="selectedName"
                            style="width:<%= c.string("UI.textboxPixel") %>" size="<%= c.string("UI.textboxSize") %>
                            value="">
                            <% if (c.var("Replica.TableType").equals("Replica.ServerView")) {
                                   c.set("OS.TypeFilter", "NCP Server");
                               } else {
                                   c.set("OS.TypeFilter", "[partitions],[root]");
                               }
                               c.set("OS.Mode", "Browse");
                               c.set("OS.Control", "selectedName");
                               c.set("OS.History", "true"); %>
                            <jsp:include page='<%= c.getPath("dev/OS_inc.jsp") %>' flush="true" />
            </TD>
        <TR>
            <TD height="10" colspan="2">
            </TD>
        </TR>
        </TR>
    </TABLE>

    <TABLE width="100%" border="0" cellspacing="0" cellpadding="0">
        <TR>
            <TD width="25">
                <IMG src="<%= c.getModulesUrl() + "/dev/images/" + c.string("ReplicaReadWrite24.image") %>" name="ReplicaImage" border=0>
            </TD>
            <TD>
                <TABLE width="100%" border="0" cellspacing="0" cellpadding="0">
                    <TR>
                        <TD width="25" valign="middle">
                            <input  type="radio"
                                    name="ReplicaTypeRadio"
                                    value="readwrite"
                                    onClick="return changeReplicaType('ReplicaImage')"
                                    checked>
                        </TD>
                        <TD valign="middle" class="mediumtext">
                            <a href="#" style="color: #039; text-decoration: none" onClick="return changeReplicaTypeLabel('ReplicaImage', 0)">
                            <%= c.toHTML(c.string("PartitionReplica.ReadWrite")) %>
                        </TD>
                    </TR>
                    <TR>
                        <TD width="25" valign="middle">
                            <input  type="radio"
                                    name="ReplicaTypeRadio"
                                    value="readonly"
                                    onClick="return changeReplicaType('ReplicaImage')">
                        </TD>
                        <TD valign="middle" class="mediumtext">
                            <a href="#" style="color: #039; text-decoration: none" onClick="return changeReplicaTypeLabel('ReplicaImage', 1)">
                            <%= c.toHTML(c.string("PartitionReplica.ReadOnly")) %>
                        </TD>
                    </TR>
                    <TR>
                        <TD width="25" valign="middle">
                            <input  type="radio"
                                    name="ReplicaTypeRadio"
                                    value="filteredreadwrite"
                                    onClick="return changeReplicaType('ReplicaImage')">
                        </TD>
                        <TD valign="middle" class="mediumtext">
                            <a href="#" style="color: #039; text-decoration: none" onClick="return changeReplicaTypeLabel('ReplicaImage', 2)">
                            <%= c.toHTML(c.string("PartitionReplica.FilteredReadWrite")) %>
                        </TD>
                    </TR>
                    <TR>
                        <TD width="25" valign="middle">
                            <input  type="radio"
                                    name="ReplicaTypeRadio"
                                    value="filteredreadonly"
                                    onClick="return changeReplicaType('ReplicaImage')">
                        </TD>
                        <TD valign="middle" class="mediumtext">
                            <a href="#" style="color: #039; text-decoration: none" onClick="return changeReplicaTypeLabel('ReplicaImage', 3)">
                            <%= c.toHTML(c.string("PartitionReplica.FilteredReadOnly")) %>
                        </TD>
                    </TR>
                </TABLE>
            </TD>
        </TR>
        <tr>
            <td>&nbsp;</td>
        </tr>
    </TABLE>

	<!-- ************ -->
	<!-- BUTTON TABLE -->
	<!-- ************ -->
    <jsp:include page='<%= c.getPath("dev/Bar_inc.jsp") %>' flush="true" />

    <a href="#" onClick="javascript:okSelected();return false">
        <IMG    src="<%= c.getModulesUrl() + "/dev/images/" + c.string("Button.OK.image") %>"
                alt="<%= c.string("Button.OK.alt") %>"
                title="<%= c.string("Button.OK.alt") %>"
                border=0></a>
    <a href="#" onClick="javascript:cancelSelected();return false">
        <IMG    src="<%= c.getModulesUrl() + "/dev/images/" + c.string("Button.Cancel.image") %>"
                alt="<%= c.string("Button.Cancel.alt") %>"
                title="<%= c.string("Button.Cancel.alt") %>"
                border=0></a>
</form>
<jsp:include page='<%= c.getPath("dev/OSFooter_inc.jsp") %>' flush="true" />
</BODY></HTML>
