// Public AS code -- can be called by the developer's javascript.  Developer must create
// an object which contains the following member variables.  Every variable must be defined
// in the structure.

function doDynamicAS(userContext, AS)
{
   //make sure we have an entry for the required parameters
   if ( (AS.types!=null || AS.typesCallBack) &&         //do we have a valid type or type callback
        (AS.control!=null || AS.controlCallBack) )  //do we have a control or callback to handle results
   {
      //make sure we at least have default values for all parameters
      if (AS.types==null)                       AS.types="";
      if (AS.typesCallBack==null)               AS.typesCallBack="";
      if (AS.control==null)                     AS.control="";
      if (AS.controlCallBack==null)             AS.controlCallBack="";
      
      if (AS.auxTypes==null)                    AS.auxTypes="";
      if (AS.auxTypesCallBack==null)            AS.auxTypesCallBack="";
      if (AS.initialCriterion==null)            AS.initialCriterion="";
      if (AS.initialCriterionCallBack==null)    AS.initialCriterionCallBack="";
      if (AS.isASAllowed==null)                 AS.isASAllowed="";
      if (AS.typeInfoCallBack==null)            AS.typeInfoCallBack="";
      if (AS.helpFile==null)                    AS.helpFile="";

      //is window being sized dynamically?
      if (AS.windowWidth!=null)   window.asWidth=AS.windowWidth;
      if (AS.windowHeight!=null)  window.asHeight=AS.windowHeight;

      //are the widths of the input well being sized dynamically?
      if (AS.attributeWidth!=null)  window.asAPercent=AS.attributeWidth;
      if (AS.operationWidth!=null)  window.asOPercent=AS.operationWidth;
      if (AS.valueWidth!=null)      window.asVPercent=AS.valueWidth;

      //call the private doAS routine
      doAS(AS.types,
           AS.typesCallBack,
           AS.control,
           AS.controlCallBack,
           
           AS.auxTypes,
           AS.auxTypesCallBack,
           AS.initialCriterion,
           AS.initialCriterionCallBack,
           AS.isASAllowed,
           AS.typeInfoCallBack,
           AS.helpFile);
   }
}

// Private AS code -- not intended for eMFrame developer use.
// The following APIs are not public and are subject to change without notice.

function doAS( types,               // types for which criterion can be set, or
               typesCallBack,       // routine that will return types for which criterion can be set
               control,             // HTML control that will receive xml criterion, or
               controlCallBack,     // routine to process final selection criterion
               
               auxTypes,            // opt - a comma-separated string of of aux class names
               auxTypesCallBack,    // opt - a routine that will return a comma-separate string array of class names
               initialCriterion,    // opt - initial xml definition of selection criterion
               initCritCallBack,    // opt - routine to retrieve initial criterion
               isASAllowed,         // opt - routine to determine if Advanced Selection widget should run at all
               typeInfoCallBack,    // opt - java routine that will return a AdvSelTypeInfo class with type/syntax/op/value info
               helpFile)            // opt - name of the html help file
{
   var doAS=true;   //assume we will be running the advanced selection widget
   if (exists(isASAllowed))
   {
      //execute specified routine to determine if search should proceed
      doAS=eval(isASAllowed+"()");
   }

   if (doAS)
   {
      //retrieve types from types callback, if callback is specified
      if (exists(typesCallBack))
      {
         types=eval(typesCallBack+"()");
      }
      
      //retrieve auxtypes from types callback, if callback is specified
      if (exists(auxTypesCallBack))
      {
         auxTypes=eval(auxTypesCallBack+"()");
      }

      if (types==null)              types="";
      if (auxTypes==null)           auxTypes="";
      if (control==null)            control="";
      if (controlCallBack==null)    controlCallBack="";

      //make we have a type
      if (types.length>0)
      {
         //should we retrieve initial criterion from criterion callback?
         if (exists(initCritCallBack))
         {
            var command = initCritCallBack+"(types)";
            initialCriterion = eval(command);
         }
         
         if (initialCriterion==null)   initialCriterion="";
         if (typeInfoCallBack==null)   typeInfoCallBack="";
         if (helpFile==null)           helpFile=="";

         var urlParms = "&AS.Types="+urlEncode(types)+
                        "&AS.AuxTypes="+urlEncode(auxTypes)+
                        "&AS.InitialCriterion="+urlEncode(initialCriterion)+
                        "&AS.Control="+urlEncode(control)+
                        "&AS.ControlCallBack="+controlCallBack+
                        "&AS.TypeInfoCallBack="+typeInfoCallBack+
                        "&AS.HelpFile="+urlEncode(helpFile);

         var url = 'webacc?taskId=fw.AdvancedSelection&merge=fw.AdvSel&error=dev.GenErr&nextState=initialState&onComplete=close'+urlParms;
         var leftPos = (screen.availWidth-window.asWidth)/2;
         var topPos =  (screen.availHeight-window.asHeight)/3;
         var winOpts = 'toolbar=no,location=no,directories=no,menubar=no,scrollbars=no,resizable=yes,left='+leftPos+',top='+topPos+',width='+window.asWidth+',height='+window.asHeight;
         var w = window.open( url, 'AdvancedSelectionWindow', winOpts);
         if (w != null)
         {
            // make sure the new advanced selection window has focus.
            w.focus();
         }
      }
      else
      {
         alert("doAS: ERROR -- No type parameter."+
               "\n\nEnter the type of object for which selection criterion is to be entered.") ;
      }
   }
}

function returnFromAS(asControl, asCallBack, asTypes, asCriterion)
{
   //alert("returnFromAS: control="+asControl+"\ncallback="+asCallBack+"\ntypes="+asTypes+"\ncriterion="+asCriterion);
   if (arguments.length==0)
   {
      return;  //no parameters -- nothing to do
   }

   //make sure parameters aren't null
   if (asControl==null)    asControl="";
   if (asCallBack==null)   asCallBack="";
   if (asTypes==null)      asTypes="";
   if (asCriterion==null)  asCriterion="";

   if ( (asControl.length==0 && asCallBack.length==0) )     //no place to send the result?
   {
      alert("returnFromAS:  ERROR -- Neither a control nor a controlCallBack routine has been specified."+
            "\n\nCannot return the '"+asTypes+"' selection criterion = "+asCriterion);
      return;  //just return
   }

   //process the selection criterion that has been returned
   if (asCallBack.length>0)
   {
      if (exists(asCallBack))
      {
         //let the callback routine process the as selection criterion
         var command = asCallBack+"(asControl,asTypes,asCriterion)";
         eval( command );
      }
      else
      {
         //specified callback does not exist
         alert("returnFromAS:  ERROR -- Specified controlCallBack '"+asCallBack+"' does not exist."+
               "\n\nCannot return the '"+asTypes+"' selection criterion = "+asCriterion);
      }
   }
   else
   {
      //just store the as results in the specified control
      if (!setASElementValue(asControl, asCriterion))
      {
         alert("returnFromAS:  ERROR -- Attempt to save the selection criterion in control '"+asControl+"' failed."+
         "\n\nCannot return the '"+asTypes+"' selection criterion = "+asCriterion);
      }
   }
}

//search all forms for the specified named element and return its value
function getASElementValue(elementName)
{
   if (elementName!=null && elementName.length>0)
   {
      for (var i=0; i<document.forms.length; i++)
      {
         if (document.forms[i].elements[elementName]!= null)
         {
            return document.forms[i].elements[elementName].value;
         }
      }
   }
   return null;
}

//search all forms for the specified named element and set its value
function setASElementValue(elementName, elementValue)
{
   if (elementName!=null && elementName.length>0)
   {
      for (var i=0; i<document.forms.length; i++)
      {
         if (document.forms[i].elements[elementName]!= null)
         {
            document.forms[i].elements[elementName].value = elementValue;
            return true;
         }
      }
   }
   return false;
}