//=================================================================================
// MVStringEditor - sel expanded
// NOTE: all methods are private unless otherwise specified
//=================================================================================

//length of strings to be shown in mvsel but now we have removed truncation in mozilla also
var truncateLength = 30;

// should be called everytime list content is changed
function mvselOnChange(mvse)
{
   var list = getValuesAsArray(mvse);
   document.getElementById(mvse.m_name+"_packedValues").value = pack(list);

   var textbox = document.getElementById(mvse.m_name + "_countBox");
   if(textbox)
   {
      textbox.value = mvse.m_sel.options.length;
   }

   mvCallOnChange(mvse);
}

// loads the values found in the xml into the mved
function mvselLoadFromXml(name,x,childName, isList)
{
   var l = document.getElementById("mvid_" + name);
   l.length = 0;
   initMooMode(name, x);

   if (!x) return;
   var xml = parseXml(x);
   var children = xml.getChildren();
   if (children == null || children.length == 0)
      return;
   var text;
   for (var i=0; i<children.length; i++)
   {
      text=children[i].getText();
      l[l.length] = new Option(text,text);
      l[l.length-1].title=text;
   }	   	
   l.selectedIndex = 0;

   var mvse = eval("window.mv" + name);
   mvselOnChange(mvse);
}

// loads the values from the packed string into the mved
function mvselLoadFromPack(name,packedString)
{
   var l = document.getElementById("mvid_" + name);
   l.length = 0;
   var list = unpack(packedString);
  
   for(var i=0; i<list.length; i++)
   {
      l[l.length] = new Option(list[i], list[i]);
      l[l.length-1].title=list[i];
   }    	
   var mvse = eval("window.mv" + name);
   mvselOnChange(mvse);
}

// disables the mved, so users cannot add to the list
function mvselDisable(name)
{
   var mvse = eval("window.mv" + name);
   mvse.m_disabled=true;

   mvse.m_sel.style.backgroundColor = "#cccccc";

   if(mvse.m_tb)
   {
      mvse.m_tb.style.backgroundColor = "#cccccc";
   }
}

// enables the mved that has been disabled
function mvselEnable(name)
{
   var mvse = eval("window.mv" + name);
   mvse.m_disabled=false;

   mvse.m_sel.style.backgroundColor = "#ffffff";

   if(mvse.m_tb)
   {
      mvse.m_tb.style.backgroundColor = "#ffffff";
   }
}

// ObjectSelector calls this with results of a search/browse
function mvselReturnFromOS(controlName, results)
{
   var mvse = eval("window.mv" + controlName);
   var list = document.getElementById("mvid_" + controlName);

   //----------------------------------------------
   // -improve the speed of checking for duplicates
   //  when returning from OS
   // -build has table to be used in isDuplicate
   //----------------------------------------------
   mvse.m_hash = new Array();
   var size = list.length;
   if(mvse.m_ignoreCase)
   {
      for(var i=0; i<size; i++)
      {
         mvse.m_hash[list[i].value.toLowerCase()] = 1;
      }
   }
   else
   {
      for(var i=0; i<size; i++)
      {
         mvse.m_hash[list[i].value] = 1;
      }
   }


   if(results.length==1)
   {
      if(mvse.m_useRootedName)
      {
         // special case: append treename to dn from Object selector
         mvselAdd(mvse, results[0] + "." + mv_treeName);
      }
      else
      {
         mvselAdd(mvse, results[0]);
      }
   }
   else
   {
      for(var i=0;i<results.length;i++)
      {
         var dn = results[i];

         // special case: append treename to dn from Object selector
         if(mvse.m_useRootedName)
         {
            dn = dn + "." + mv_treeName;
         }
		 
         // add if not dup
         if(!mvIsDuplicate(mvse, dn, true))
         {
            
            list[list.length] = new Option(dn, dn);
            list[list.length-1].title=dn;
         }
      }
   }

   //----------------------------------------------
   // set the hash to null, so mvIsDuplicate won't use it.
   // reason: it can become invalid by adding or chaning list manually
   // Didn't wan't to change edit, add, and remove code to update hash
   //----------------------------------------------
   mvse.m_hash = null;

   mvselOnChange(mvse);
}

// Called when the user clicks the edit button and the mved is in HEX mode
function mvselEditInHex(mvse, prompt)
{
  
   if(mvse.m_disabled==true)
   {
      alert(rc_widgeDisabled);
      return;
   }
   
    if(mvse.m_disableEdit==true)
 	{
  		return; 
    }

   if (mvse.m_sel.selectedIndex>=0 && mvse.m_sel[mvse.m_sel.selectedIndex]!=null)
   {
      var value = mvse.m_sel[mvse.m_sel.selectedIndex].value;
      var leftPos = (screen.availWidth-600)/2;
      var topPos =  (screen.availHeight-430)/3;
      var url = "webacc?taskId=dev.Empty&merge=fw.OctetStringEditor&mvedName="+mvse.m_name + "&edit=true";
      window.open(url,"","HEIGHT=550,WIDTH=600,resizable,scrollbars,left="+leftPos+",top="+topPos);
   }
}

// Called when the user clicks the add button and the mved is in HEX mode
function mvselAddFromHex(mvse)
{
   if(mvse.m_disabled==true)
   {
      alert(rc_widgeDisabled);
      return;
   }

   var leftPos = (screen.availWidth-600)/2;
   var topPos =  (screen.availHeight-430)/3;
 	var url = "webacc?taskId=dev.Empty&merge=fw.OctetStringEditor&osaction=add&mvedName="+mvse.m_name;
   window.open(url,"","HEIGHT=550,WIDTH=600,resizable,scrollbars,left="+leftPos+",top="+topPos);
}

// Called when the user clicks the add button
function mvselAddFromPrompt(mvse)
{
   if(mvse.m_disabled==true)
   {
      alert(rc_widgeDisabled);
      return;
   }

   mvselAdd(mvse, prompt(window.rc_addItemMsg,""));
}

// Called when the user clicks the add button and the value is multi-line
// I don't think this is actually being used anymore.
function mvselAddFromPromptBox(mvse, promptText)
{
   if(mvse.m_disabled==true)
   {
      alert(rc_widgeDisabled);
      return;
   }

   var leftPos = (screen.availWidth-350)/2;
   var topPos =  (screen.availHeight-265)/3;
   var url = "webacc?taskId=dev.Empty&merge=fw.MVStringEditorPromptBox&mved="+mvse.m_name + "&prompt="+promptText;
   window.open(url,"","HEIGHT=265,WIDTH=350,resizable,scrollbars,left="+leftPos+",top="+topPos);
}

// onKeyDown handler for expaned mode textfield
function mvselKeyDown(mvse, event, ignoreDelete)
{
   if(!event.keyCode)
   {
      return;
   }


   if(mvse.m_disabled==true)
   {
      alert(rc_widgeDisabled);
      return false;
   }

   var keyCode = event.keyCode;

   if(keyCode==13)  // enter key
   {
      if (mvse.m_isEditing)
      {
         var val = mvse.m_tb.value;
         if (!mvIsValidValue(mvse,mvse.m_tb.value) || mvIsDuplicate(mvse, val, true))
         return false;

         var i = window.sIndex;
         mvse.m_sel[window.sIndex] = new Option(val, val);
         mvse.m_sel[window.sIndex].title =val;
         mvse.m_sel.selectedIndex = i;
         mvse.m_tb.value="";
         mvse.m_tb.focus();
         mvse.m_isEditing = false;
         mvselOnChange(mvse);
      }
      else
      {
         var success = mvselAdd(mvse, mvse.m_tb.value);
         if(success)
         {
            mvse.m_tb.value="";
            mvse.m_tb.focus();
         }
      }

      return false;
   }
   else if(!ignoreDelete && keyCode==46) // delete key
   {
      if(mvse.m_tb.value!="")
      {
         return true;
      }
      mvselRemove(mvse);
      return false;
   }
   else
   {
      return true;
   }
}


// Called when the user dbl clicks or pressed the edit button in expanded mode
function mvselEditOnPage(mvse)
{
   if(mvse.m_disableEdit==true)
 	{
  		return; 
    }
   
    //if(mvse.m_isEditing==true)
 	//{
  		//return; 
    //}
   //The  above change has been done for bug No:269079 the above code was preventing the value from being editable
   if(mvse.m_disabled==true)
   {
      alert(rc_widgeDisabled);
      return;
   }

   if(mvse.m_sel.length < 1)
   {
      alert(window.rc_noValuesToEdit);
      return;
   }

   mvse.m_sel[mvse.m_sel.selectedIndex].style.backgroundColor='red';
   mvse.m_sel[mvse.m_sel.selectedIndex].style.color='white';
   mvse.m_selectedRow=mvse.m_sel.selectedIndex;

	mvse.m_isEditing = true;
	mvse.m_tb.value = mvse.m_sel[mvse.m_sel.selectedIndex].value;
	window.sIndex=mvse.m_sel.selectedIndex;
	mvse.m_sel.selectedIndex=-1;
	mvse.m_tb.focus();
   mvselOnChange(mvse);
}

// expanded mode - resets the color of an item to normal (it was set to red while it was being edited)
function mvselResetColor(mvse)
{
   if(mvse.m_selectedRow>=0)
   {
      mvse.m_sel[mvse.m_selectedRow].style.backgroundColor='white';
      mvse.m_sel[mvse.m_selectedRow].style.color='black';
   }
}

// one-line mode - edits the current item using a prompt box
function mvselEdit(mvse)
{
   if(mvse.m_disabled==true)
   {
      alert(rc_widgeDisabled);
      return;
   }
   
   if(mvse.m_disableEdit==true)
   {
      return; 
   }

   if (mvse.m_sel.selectedIndex>=0 && mvse.m_sel[mvse.m_sel.selectedIndex]!=null)
   {
      var val = prompt(window.rc_editItemMsg,mvse.m_sel[mvse.m_sel.selectedIndex].value);
      if(val == null)
      {
          return;
      }
      val = mvedtrim.trim(val);
      if (val!=null && mvIsValidValue(mvse, val))
      {
         var i = mvse.m_sel.selectedIndex;
         mvse.m_sel[mvse.m_sel.selectedIndex] = new Option(val,val);
         mvse.m_sel.selectedIndex = i;
      }
   }

	mvse.m_isEditing = false;
   mvselOnChange(mvse);
}

function mvselEditInPrompt(mvse, prompt)
{	
   if(mvse.m_disabled==true)
   {
      alert(rc_widgeDisabled);
      return;
   }
   
    if(mvse.m_disableEdit==true)
 	{
  		return; 
    }

   if (mvse.m_sel.selectedIndex>=0 && mvse.m_sel[mvse.m_sel.selectedIndex]!=null)
   {
      //n = prompt(window.rc_editItemMsg);
      var leftPos = (screen.availWidth-350)/2;
      var topPos =  (screen.availHeight-265)/3;
      var url = "webacc?taskId=dev.Empty&merge=fw.MVStringEditorPromptBox&mved="+mvse.m_name + "&prompt="+prompt+"&command=edit";
      window.open(url,"","HEIGHT=265,WIDTH=350,resizable,scrollbars,left="+leftPos+",top="+topPos);
   }

   mvselOnChange(mvse);
}

// Sets the value for the currently selected item to text
function mvselSetValue(mvse, text)
{
   if(text==null || text=="") return false;

   if(mvse.m_enforceUnique && mvIsDuplicate(mvse, text, false))
   {
		return false;
   }
   if(!mvIsValidValue(mvse,text))
   {
      return false;
   }
   
   var i = mvse.m_sel.selectedIndex;
   if(i == -1 || i == null || isNaN(parseInt(i)))
   {
      i = 0;
   }
   var trimText = mvedtrim.trim(text);
   mvse.m_sel[i] = new Option(text,trimText);
   mvse.m_sel[i].title=trimText;
   mvse.m_sel.selectedIndex = i;
}

function mvselSetValueForEdit(mvse, text)
{
   if(text==null || text=="") return false;
   
   if(!mvIsValidValue(mvse,text))
   {
      return false;
   }
   var i = mvse.m_sel.selectedIndex;
   if(i == -1 || i == null || isNaN(parseInt(i)))
   {
      i = 0;
   }
   
   var trimText = mvedtrim.trim(text);
   mvse.m_sel[i] = new Option(text,trimText);
   mvse.m_sel[i].title=trimText;
   mvse.m_sel.selectedIndex = i;
}


// adds an string to the list
function mvselAdd(mvse,val)
{
	if(val==null || val=="") return false;

   if(mvse.m_enforceUnique && mvIsDuplicate(mvse, val, false))
   {
		return false;
   }
   if(!mvIsValidValue(mvse,val))
      return false;

   if(mvse.m_sel.length>0)
	{
	  var tmp = mvse.m_sel[mvse.m_sel.length-1].value;
      mvse.m_sel[mvse.m_sel.length] = new Option(tmp, tmp);
      mvse.m_sel[mvse.m_sel.length-1].title = tmp;
	}

   for(var j=mvse.m_sel.length-2; j>=0; --j)
   {
      mvse.m_sel[j+1].value = mvse.m_sel[j].value;
      mvse.m_sel[j+1].text = mvse.m_sel[j].text;
      mvse.m_sel[j+1].title = mvse.m_sel[j].title;
   }
   
   mvse.m_sel.selectedIndex = 0;
   mvselSetValue(mvse, val);
   mvselOnChange(mvse);
   return true;
}

// removes the currently selected item from the list
function mvselRemove(mvse)
{
   if(mvse.m_disabled==true)
   {
      alert(rc_widgeDisabled);
      return;
   }

	if (mvse.m_sel.selectedIndex<0) return;
   var old = mvse.m_sel.selectedIndex;
   var opts = mvse.m_sel.options;


   // Mark items for deletion
   for(var i=0; i<opts.length; i++)
   {
      if(opts[i].selected)
      {
         opts[i].value = "[FW_DELETE]";
      }
   }

   // Remove all selected items
   var i=opts.length-1;
   while(i>=0)
   {
      if(opts[i].value=="[FW_DELETE]")
      {
         opts[i] = null;
      }
      i--;
   }


   mvse.m_sel.selectedIndex = (old>=mvse.m_sel.length?mvse.m_sel.length-1:old);

   // MOZILLA_HACK: still shows text for last item
   if(mvse.m_sel.length==0)
   {
      mvse.m_sel.options[0] = new Option("","");
      mvse.m_sel.options[0] = null;
   }

   if(mvse.m_tb)
   {
      mvse.m_tb.values="";

      if(!isGecko)
      {
         // MOZILLA_HACK: focus in mozilla causes the event
         // that is currently being processed to fire on
         // the textbox that receives focus.  Thus the event
         // gets processed twice.  To stop this from happening
         // we don't set the focus in mozilla
         mvse.m_tb.focus();
      }
   }

    mvselOnChange(mvse);
   //if(mvse.m_selectedRow>=mvse.m_sel.length)
   //   mvse.m_selectedRow=0;
}

