// Private Code: These methods are not public and are subject to change without notice.

function checkHexInput(evt)
{
   var charCode = (evt.which) ? evt.which : event.keyCode;
   if (charCode > 32 && (charCode < 48 || charCode > 70 || (charCode > 57 && charCode < 65)))
   if (charCode > 96 && charCode < 103)
   {
      (evt.which) ? true : evt.keyCode = charCode - 32;
      return true;
   }
   else
   {
      return false;
   }
}

function MVOSEdit(l,n)
{
   if (l.selectedIndex>-1 && n!=null)
   {
      l[l.selectedIndex].text = n;
      l[l.selectedIndex].value = n;
   }
}

function MVOctetStringAdd(controlString)
{
   var url = "webacc?taskId=dev.Empty&merge=fw.OctetStringEditor&controlString="+controlString+"&osaction=add";
   var winOpts = "toolbar=no,location=no,directories=no,menubar=no,scrollbars=no,resizable=no,width=600,height=500";
   var w = window.open( url, "Add", winOpts);
}

function MVOctetStringEdit(control,controlString)
{
	if (control.selectedIndex > -1)
	{
   	var url = "webacc?taskId=dev.Empty&merge=fw.OctetStringEditor&controlString="+controlString+"&osaction=edit";
	   var winOpts = "toolbar=no,location=no,directories=no,menubar=no,scrollbars=no,resizable=no,width=600,height=500";
	   var w = window.open( url, "Edit", winOpts);
	}
}

function OctetStringEdit(control,controlString)
{
   var url = "webacc?taskId=dev.Empty&merge=fw.OctetStringEditor&controlString="+controlString+"&osaction=svedit";
   var winOpts = "toolbar=no,location=no,directories=no,menubar=no,scrollbars=no,resizable=no,width=600,height=500";
   var w = window.open( url, "Edit", winOpts);
}

function T_MVOctetStringEdit(l)
{
	if (l.selectedIndex > -1)
	{
		n = prompt("edit item",l[l.selectedIndex].value);

		if (n!=null)
		{
			var i = l.selectedIndex;
			l[l.selectedIndex] = new Option(n,n);
			l.selectedIndex = i;
		}
	}
}

var curHexVal;

function initHexValue()
{
   document.forms[0].reset();
   updateFormTextBoxes();
}

function fixText( text )
{
   var myRegExp = /\s/g;
   text = text.replace ( myRegExp, "" )
   return text;
}

function updateAsciiTextBox(e)
{
   updateFormTextBoxes();
   if (document.forms[0].HexTextBox.value == "")
      document.forms[0].AsciiTextBox.value = "";
}

function updateFormTextBoxes()
{
   changeBack=false;
   curHexVal = document.forms[0].HexTextBox.value;
   var input = fixText(document.forms[0].HexTextBox.value.toUpperCase());
   var token = "";
   var asciiVal ="";
   var hexVal = "";
   var dataSize = 0;


   while (input.length > 0)
   {
      token = input.substring(0,2);
      input = input.substring(2,input.length);

      if(token=="00")
      {
        asciiVal += toAscii(HexToDec("01"));
      }
      else
      {
        asciiVal += toAscii(HexToDec(token));
      }

      hexVal += token + " ";
      dataSize++;
   }

   if (document.forms[0].AutoSpacing.checked)
   {
      if (token.length == 1)
         hexVal = hexVal.substring(0, hexVal.length - 1);
      document.forms[0].HexTextBox.value = hexVal;
   }

   document.forms[0].AsciiTextBox.value = asciiVal;
   document.forms[0].HexValue.value = fixText(document.forms[0].HexTextBox.value.toUpperCase());
   document.getElementById("DecDataSize").innerHTML = dataSize;
   document.getElementById("HexDataSize").innerHTML = DecToHex(dataSize);
   document.forms[0].HexTextBox.focus();
}

var asciiSymbols =  " !\"#$%&'***+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~";

function toAscii (asciiVal)
{
    return String.fromCharCode(asciiVal);
}

function DecToHex(dec)
{
   dec = Math.abs(dec);
   var hex = "";
   var a = "" + dec;
   a = a.length;

   var h = "0123456789ABCDEF";
   for (n=0; n<a; n++)
   {
      he = h.charAt(dec-Math.floor(dec/16)*16);
      dec = (dec - h.indexOf(he)) / 16;
      hex = he + hex;
   }

   if (hex.charAt(0) == "0")
   {
      hex = hex.substring(1,hex.length);
   }

   return hex;
}

function HexToDec(hex)
{
   hex = hex.toUpperCase();
   var h = "0123456789ABCDEF";
   var dec = 0;
   var a = 0;
   for (n=hex.length; n>0; n--)
   {
      dec += h.indexOf(hex.charAt(n-1)) * Math.pow(16,a);
      a++
   }
   return dec;
}

function asciiToHex(asciiString) // returns hexString
{
   var hexString="";
   for(var i=0; i<asciiString.length; i++)
   {
      var character = asciiString.substr(i,1);
      hexString += character.charCodeAt(0).toString(16);
   }
   return hexString;
}

function hexToAscii(hexString) // returns asciiString
{
   var asciiString = "";
   for(var i=0; i<hexString.length; i+=2)
   {
      asciiString += String.fromCharCode(parseInt("0x" + hexString.substr(i,2)));
   }
   return asciiString;
}

function checkAsciiInput()
{
	//don't know how this could fail.
	return true;
}

//Update the HexTextBox when the Ascii box is edited
function updateHexTextBox()
{
	
	var curAscii = document.forms[0].AsciiTextBox.value;
	var curChar = "";
	var ascii = 0;	
	var hexText = "";	
	var curIndex = 0;
	
	var dataSize = curAscii.length;
	while (curIndex < curAscii.length)
	{
		// -- This Expression work in Mozilla But fail in IE browsers(IE6/IE 7).IE does not recognize
		//the  index of var data type.It is safe to use charAt().It work in all the Browser.
		//Commenting the following line and adding the new line after that to fix the bug # 334007
		
		//curChar = curAscii[curIndex]; 
		curChar = curAscii.charAt(curIndex);
		ascii = curChar.charCodeAt(0);
		hexText += DecToHex(ascii) + " ";
		curIndex++;
	}
	
	//The HexValue  was not being updated on updating the ascii textbox,so updating it here.
	//bug 72741 and bug #326992
	document.forms[0].HexTextBox.value = hexText;	
	document.forms[0].HexValue.value = fixText(document.forms[0].HexTextBox.value.toUpperCase());
	document.getElementById("DecDataSize").innerHTML = dataSize;
   	document.getElementById("HexDataSize").innerHTML = DecToHex(dataSize);	
	document.forms[0].AsciiTextBox.focus();

}


