
//Defines the structure of a QueryObject
function QueryObject()
{
   var id;
	var container = "";  //root
	var subcontainerSearch = "false";
	var nameFilter = "*";
	var typeFilter = "*";
	var subClasses = "false";
	//array of criterion
	var criteria;
}

function f(xmlCrit)
{
   var xmlDoc = parseXml(xmlCrit);
   var types = xmlDoc.getChild("types");
   var ids = null;
   var typeNames = new Array();
   if (types!=null)
   {
      ids = types.getChildren("id");
      for (var i=0; i<ids.length; i++)
      {
         typeNames[i] = iman.trim(ids[i].getText());
      }
   }
   return typeNames;
}

function getCriteriaTypes(queryXml)
{
   if( queryXml == null || queryXml == '')
   	return null;
   		
   var xmlDoc = parseXml(queryXml);
   if(xmlDoc == null)
      return null;
   
   typesXml = xmlDoc.getChild("types");
   
   if(typesXml == null)
      return null;
   return typesXml.getChildrenTextTrim("id");
}

function doLoadQuery(loadFunctionName)
{
   var winWidth = 450;
   var winHeight = 400;
   var leftPos = (screen.availWidth-winWidth)/2;
   var topPos =  (screen.availHeight-winHeight)/3;
   var winOpts = 'dependent, toolbar=no,location=no,directories=no,menubar=no,scrollbars=yes,resizable=yes,left='+leftPos+',top='+topPos+',width='+winWidth+',height='+winHeight;
   
   window.open("frameservice?NPService=fw.LaunchService&NPAction=Launch&launch=fw.SaveAdvancedSelection&launcher=fw.LaunchService&lifecycle=new&nextState=load&loadFunctionName="+loadFunctionName, "loadQuery", winOpts);
}

//The xml query will be built from the object argument and passed into the save function
function doSaveQuery(queryObject)
{	

	//dumpObject("doSaveQueryObject", queryObject);
	var xml="";
   xml += "<query>";
   xml += "<id>"+xmlEncode(queryObject.id)+"</id>";
   xml += "<container>"+xmlEncode(queryObject.container)+"</container>";
   xml += "<subcontainer-search>"+queryObject.subcontainerSearch+"</subcontainer-search>";
   xml += "<name-filter>"+xmlEncode(queryObject.nameFilter)+"</name-filter>";
   xml += "<type-filter>"+xmlEncode(queryObject.typeFilter)+"</type-filter>";
   xml += "<subclasses>"+queryObject.subClasses+"</subclasses>";
   for (var i=0; i<queryObject.criteria.length; i++)
	{
		xml += queryObject.criteria[i];
   }
	xml += "</query>";
	//alert("doSaveQuery: xmlQuery = "+xml);
	save(xml);
}

var myWindow;
var myHTML;
//opens save window.
function save(queryString)
{
   //alert("queryString = "+queryString);
   var sHTML = "";
   sHTML += '<html><head></head><body>';
   sHTML += '<form name="SaveQuery" method=post action="frameservice?NPService=fw.LaunchService">';
   sHTML += '<input type=hidden name="NPService" value="fw.LaunchService">';
   sHTML += '<input type=hidden name="NPAction" value="Launch">';
   sHTML += '<input type=hidden name="launch" value="fw.SaveAdvancedSelection">';
   sHTML += '<input type=hidden name="launcher" value="fw.LaunchService">';
   sHTML += '<input type=hidden name="lifecycle" value="new">';
   sHTML += '<input type=hidden name="query" value="'+toScript(xmlEncode(queryString))+'">';
   sHTML += '</form></body></html>';
   //alert("sHTML = "+sHTML);

   var winWidth = 400;
   var winHeight = 200;
   var leftPos = (screen.availWidth-winWidth)/2;
   var topPos =  (screen.availHeight-winHeight)/3;
   var winOpts = 'dependent, toolbar=no,location=no,directories=no,menubar=no,scrollbars=yes,resizable=yes,left='+leftPos+',top='+topPos+',width='+winWidth+',height='+winHeight;
   var w = window.open("/nps/Query.html", "saveQuery", winOpts);
  
   myWindow = w;
   myHTML = sHTML;
   
   window.setTimeout('writeToTop()', 500);
   
}

function writeToTop()
{
  if (myWindow!=null)
  {
     if(myWindow.loaded)
     {
        myWindow.document.writeln(myHTML);
        if(myWindow.document.SaveQuery)
        {
           myWindow.document.SaveQuery.submit();
        }else
        {
           window.setTimeout('writeToTop', 500);
        }
     }
     else
     {
        window.setTimeout('writeToTop', 500);
     }
  }else
  {
  	alert('window is null');
  }
}

//Builds a query of object from the xml string 
function buildQueryObject(queryXml)
{
   //alert("buildQueryObject: queryXml = \n"+queryXml);
	var queryObject = new QueryObject();
	if (queryXml==null || queryXml.length==0 || queryXml.indexOf('<query>')==-1)
	{
	   //find everything from root
	   queryObject.id="<id>ALL</id>";
		queryObject.container = "";
		queryObject.subContainer = "false";
		queryObject.subClasses = "false";
		queryObject.nameFilter = "*";
		queryObject.typeFilter = "*";
		queryObject.criteria = null;		
	}	
	else
	{
      var xmlDoc = parseXml(queryXml);
      queryObject.id = xmlDoc.getChildTextTrim("id");
      queryObject.container = xmlDoc.getChildTextTrim("container");
      queryObject.subcontainerSearch = xmlDoc.getChildTextTrim("subcontainer-search");
      queryObject.nameFilter = xmlDoc.getChildTextTrim("name-filter");
      queryObject.typeFilter = xmlDoc.getChildTextTrim("type-filter");
      queryObject.subClasses = xmlDoc.getChildTextTrim("subclasses");
      queryObject.criteria = xmlDoc.getChildrenStrings("selection-criterion");
      
	} 
	
	//dumpObject("buildQueryObject", queryObject);
	return queryObject;
}

function dumpObject(title,obj)
   {
      var s = "";
      s  = title+": query object = \n";
      s += "   id = "+obj.id+"\n";
      s += "   container = "+obj.container+"\n"; 
      s += "   subcontainerSearch = "+obj.subcontainerSearch+"\n"; 
      s += "   nameFilter = "+obj.nameFilter+"\n"; 
      s += "   typeFilter = "+obj.typeFilter+"\n"; 
      s += "   subclasses = "+obj.subClasses+"\n"; 
      for (var i=0; i<obj.criteria.length; i++)
      {
         s += "   criteria["+i+"] = "+obj.criteria[i]+"\n";
      }
      alert(s);
   }