<%@  page pageEncoding="utf-8" contentType="text/html;charset=utf-8" import="com.novell.webaccess.common.JSPConduit, com.novell.emframe.dev.eMFrameUtils, com.novell.emframe.dev.MUtils,
                                                                             com.novell.emframe.dev.eMFrameFactory,
                                                                             java.util.*" %>

<%@ taglib uri="/WEB-INF/iman.tld" prefix="iman" %>
<%@ taglib uri="/WEB-INF/c.tld" prefix="c" %>
<%@ taglib uri="/WEB-INF/c-rt.tld" prefix="c-rt" %>
<%@ taglib uri="/WEB-INF/x.tld" prefix="x" %>
<iman:stringtable bundle="DevResources" />
<iman:stringtable bundle="FwResources" />

<%  JSPConduit c = new JSPConduit(request); %>

<%--
   MVStringEditor.inc

   Notes:
   -Allows single source for mved
   -Will show one control on ie; another on NS; another on pocketpc
   -Will automatically detect the current browser an set appropriate mode
   -Can override mode
   -Current limitation: must be on form[0] (pocket pc only)

   Modes:
      -mvie:   Fancy mved for holding and editing multiple values; normal mved for ie
               -Default mode when running in "browser"

      -mvsel:  Contorl based on HTML SELECT control; Has two modes
               1. One line - less realestate
                  -Default mode when running in "simple"
                  -Can only see first value until click down arrow on drop down.
               2. Combobox - takes up more realestate
                  -Text entry field and expanded select box;
                  -to be used (in browser or simple) when only control on the page
                  -To force to this mode (in browser and simple):
                  -{SET MVStringEditor_mode="sel"} before both {INCLUDE ..devMVStringEditor.inc} and {INCLUDE ..devMVStringEditorScripts.inc}
                  -{SET MVStringEditor_size="10"} before {INCLUDE ..devMVStringEditor.inc}

      -mvtxt:  Only mode supported on pocket pc;


   Supports:
      Browser (IE5+)
      Simple  (NN62+)
      Pocket  (2002+)

   Parameters:
      Name                             Description                            Default
      -------------------------------- -------------------------------------- -----------------------
     -MVStringEditor_name              (Required)
     -MVStringEditor_mode              ["mvie" || "mvsel" || "mvtxt"]         device detection

     -MVStringEditor_size              in mvsel; number of rows               1
     -MVStringEditor_width             width in pixels                        DevRes/UI.textboxWidth
     -MVStringEditor_bgColor           ex. #232323 or blue                    #ffffff

     -MVStringEditor_readonly          disables control                       false
     -MVStringEditor_enforceUnique                                            false
     -MVStringEditor_ignoreCase        only applys to enforceUnique           false

     -MVStringEditor_objectTypeName    Show OS using this as filter
     -MVStringEditor_history           Show history button when showing OS?   false

     -MVStringEditor_numbersOnly       user can only enter numbers
     -MVStringEditor_upperBound        upperbound for intergers
     -MVStringEditor_lowerBound        lowerbound for intergers
     -MVStringEditor_minLength         min length of strings
     -MVStringEditor_maxLength         max length of strings

     -MVStringEditor_xml               xml as a string
     -MVStringEditor_xmlNodeSet        xml as a nodeset (parsed using <x:parse ...>)


   Requires:
      include ../dev/MVStringEditorScripts.inc
      include ../dev/eMFrameScripts.inc


   ==== JavaScript API ==============================================================

      mvLoadFromPack (String name, String packedString)
         -name: must be the same name as MVStringEditor_name used for MVStringEditor_inc
      mvGetValuesAsPack (String name) : String (packed)
         -name: must be the same name as MVStringEditor_name used for MVStringEditor_inc
         -returns: packed string safe to be posted
      mvGetValuesAsXml String name) : String (xml content)
         -name: must be the same name as MVStringEditor_name used for MVStringEditor.inc
         -returns: xml in string format
      mvLoadFromXml (String name, String xml)
         -name: must be the same name as MVStringEditor_name used for MVStringEditor.inc
      mvEnable(String name)
      mvDisable(String name)

      Note: the javascript methods mvLoadFromPack and mvGetValuesAsPack interact with packed Strings
            "" is NOT a valid packed string.  If you want an empty packed string, call  "pack(new Array())"
            There are methods in eMFrameScripts (javascript) and eMFrameUtils (java) to pack and unpack these strings

   ==== Examples: Packed Strings  ==============================================================

         In Javascripts Header
            oninit: mvLoadFromPack ("myControl", "{VAR myPackedString}")
            onexit: document.myForm.myHiddenField.value = mvGetValuesAsPack ("myControl")

         In HTML body
            {SET MVStringEditor_name="myControl"}
            {SET MVStringEditor_ignoreCase="true"}
            {SET MVStringEditor_enforceUnique="true"}
            {INCLUDE ../dev/MVStringEditor_inc}

   ==== Examples: XML  =========================================================================

         XML 1 level deep:
            oninit: mvLoadFromXml("mycontrol", "<root><value>...</value></root>");
            onexit: hiddenField = mvGetValuesAsXml("mycontrol");
            <root>
               <value>test1</value>
               <value>test2</value>
               <value>test3</value>
            </root>

   ==== Known Isuses  ==========================================================================

      -MVIE: Hitting escape will close the dropdown without replacing the data; fixed as soon as another control receives focus
      -MVIE: Clicking on the textbox after it already has focus also causes the above problem
      -Unique validation doesn't work in editing mode or OS (basically only works in adding by typing)
      -Control must be on forms[0]

   ==== Private files  =========================================================================

      -browser/dev/MVStringEditor.inc
      -browser/dev/MVStringEditorScripts.inc
      -javascripts/dev/MVStringEditorShared.js
--%>

<%-- -------------------------------------- --%>
<%-- Default Values                         --%>
<%-- -------------------------------------- --%>


<c:if test="${MVStringEditor_hex=='true'}">
   <c:set var="MVStringEditor_mode" value="mvsel"/>
   <c:set var="MVStringEditor_size" value="1"/>
</c:if>


<c:if test="${MVStringEditor_name==null ||  MVStringEditor_name==''}"><c:set var="MVStringEditor_name" value="mvDefaultName"/></c:if>
<c:if test="${MVStringEditor_readonly==null ||  MVStringEditor_readonly==''}"><c:set var="MVStringEditor_readonly" value="false"/></c:if>
<c:if test="${MVStringEditor_disableEdit==null ||  MVStringEditor_disableEdit==''}"><c:set var="MVStringEditor_disableEdit" value="false"/></c:if>
<c:if test="${MVStringEditor_formName==null ||  MVStringEditor_formName==''}"><c:set var="MVStringEditor_formName" value="forms[0]"/></c:if>
<c:if test="${MVStringEditor_enforceUnique==null ||  MVStringEditor_enforceUnique==''}"><c:set var="MVStringEditor_enforceUnique" value="true"/></c:if>
<c:if test="${MVStringEditor_numbersOnly==null ||  MVStringEditor_numbersOnly==''}"><c:set var="MVStringEditor_numbersOnly" value="false"/></c:if>
<c:if test="${MVStringEditor_ignoreCase==null ||  MVStringEditor_ignoreCase==''}"><c:set var="MVStringEditor_ignoreCase" value="false"/></c:if>
<c:if test="${MVStringEditor_upperBound==null ||  MVStringEditor_upperBound==''}"><c:set var="MVStringEditor_upperBound" value="NaN"/></c:if>
<c:if test="${MVStringEditor_lowerBound==null ||  MVStringEditor_lowerBound==''}"><c:set var="MVStringEditor_lowerBound" value="NaN"/></c:if>
<c:if test="${MVStringEditor_maxLength==null ||  MVStringEditor_maxLength==''}"><c:set var="MVStringEditor_maxLength" value="NaN"/></c:if>
<c:if test="${MVStringEditor_minLength==null ||  MVStringEditor_minLength==''}"><c:set var="MVStringEditor_minLength" value="NaN"/></c:if>
<c:if test="${MVStringEditor_bgColor==null ||  MVStringEditor_bgColor==''}"><c:set var="MVStringEditor_bgColor" value="white"/></c:if>
<c:if test="${MVStringEditor_onChangeCallback==null ||  MVStringEditor_onChangeCallback==''}"><c:set var="MVStringEditor_onChangeCallback" value="null"/></c:if>
<c:if test="${MVStringEditor_useRootedName==null ||  MVStringEditor_useRootedName==''}"><c:set var="MVStringEditor_useRootedName" value="false"/></c:if>


<%-- Support depricated param --%>
<c:if test="${MVStringEditor_size==''}">
   <c:choose>
      <c:when test="${MVStringEditor_fixedHeight != ''}"><c:set var="MVStringEditor_size" value="${MVStringEditor_fixedHeight}"/></c:when>
      <c:otherwise><c:set var="MVStringEditor_size" value="1"/></c:otherwise>
   </c:choose>
</c:if>

<%-- support depricated way of passing in XML values --%>
<%-- Load values from XML (old way; keeping for backward compatibility) --%>
<c:if test="${not empty MVStringEditor_xml}">
   <x:parse xml="${MVStringEditor_xml}" var="tmpXml"/>
   <x:set select="$tmpXml/*" var="MVStringEditor_xmlNodeSet"/>
</c:if>

<%-- default value comes from resource file --%>
<c:if test="${MVStringEditor_width==null || MVStringEditor_width==''}">
   <c:set var="MVStringEditor_width"><iman:string key="UI.textboxPixel"/></c:set>
</c:if>

<%-- Device detection --%>
<c:if test="${MVStringEditor_mode==null || MVStringEditor_mode==''}">
   <c:choose>
      <c:when test="${DEVICE_TYPE=='browser'}"><c:set var="MVStringEditor_mode" value="mvie"/></c:when>
      <c:when test="${DEVICE_TYPE=='pocket'}"><c:set var="MVStringEditor_mode" value="mvtxt"/></c:when>
      <c:otherwise><c:set var="MVStringEditor_mode" value="mvsel"/></c:otherwise>
   </c:choose>
</c:if>

<%-- Variables --%>
<c:choose>
   <c:when test="${DeviceType=='pocket'}"><c:set var="MVStringEditor_objectName" value="mv${MVStringEditor_name}"/></c:when>
   <c:otherwise><c:set var="MVStringEditor_objectName" value="window.mv${MVStringEditor_name}"/></c:otherwise>
</c:choose>




<%--

   The initial values in the mved can be passed in 4 ways:
   1. MVStringEditor_xmlNodeSet
   2. MVStringEditor_xml
   3. MVStringEditor_pack
   4. MVStringEditor_values

   Here we convert MVStringEditor_xmlNodeSet and MVStringEditor_pack to  MVStringEditor_values.
   This way the each implementation of the MVED only has to interact with MVStringEditor_values.

   Could convert MVStringEditor_xmlNodeSet to String[].  Stupid tag library strips out whitespace.

--%>

<%-- Convert MVStringEditor_pack to MVStringEditor_values--%>
<c:if test="${not empty MVStringEditor_pack}">
   <%
      String pack = (String)request.getAttribute("MVStringEditor_pack");
      String[] sValues = eMFrameUtils.unpack(pack, eMFrameFactory.getMContext(request));
      pageContext.setAttribute("MVStringEditor_values", sValues);
   %>
</c:if>

<%-- Create HashSet of index number strings representing initial selections from MVStringEditor_selections --%>
<c:if test="${not empty MVStringEditor_selections}">
   <%
      String pack = (String)request.getAttribute("MVStringEditor_selections");
      String[] tmp = eMFrameUtils.unpack(pack, eMFrameFactory.getMContext(request));
      HashSet selections = new HashSet();
      for (int i=0; i<tmp.length; i++)
      {
         selections.add(tmp[i]);
      }
      pageContext.setAttribute("MVStringEditor_selectedValues", selections);
   %>
</c:if>

<%--For bug 357261, if ie readonly, make it mvsel so that it will have firefox control. --%>
<c:if test="${MVStringEditor_mode=='mvie'}">
   <c:if test="${MVStringEditor_readonly=='true'}">
   <c:set var="MVStringEditor_mode" value="mvsel"/>
   </c:if>
</c:if>

<c:choose>
   <%-- -------------------------------------------------------------------------------------------------------------- --%>
   <%-- MVIE IMPL                                                                                                      --%>
   <%-- -------------------------------------------------------------------------------------------------------------- --%>
   <c:when test="${MVStringEditor_mode=='mvie'}">

      <c:choose>
         <c:when test="${MVStringEditor_readonly=='true'}">
            <A href="#" id="<c:out value="${MVStringEditor_name}"/>FocusImage" style="width:0" tabindex="-1"><iman:spacer/></A><%--
            --%>
            <INPUT disabled="disabled" id="mvid_<c:out value="${MVStringEditor_name}"/>" type="text" name="<c:out value="${MVStringEditor_name}"/>" style="width:<c:out value="${MVStringEditor_width}"/>;">
         </c:when>
         <c:otherwise>
            <TABLE bgcolor="<c:out value="${MVStringEditor_bgColor}"/>" cellpadding="0" cellspacing="1">
            <TR>
               <TD><SPAN id="<c:out value="${MVStringEditor_name}"/>FocusImage" style="width:0"></SPAN><%--
               --%> <INPUT id="mvid_<c:out value="${MVStringEditor_name}"/>"
                           name="<c:out value="${MVStringEditor_name}"/>"
                           type="text"
                           style="width:<c:out value="${MVStringEditor_width}"/>;"
                           onBlur="mvieBlur(<c:out value="${MVStringEditor_objectName}"/>)"
                           onFocus="mvieFocus(<c:out value="${MVStringEditor_objectName}"/>)"
                           onKeydown="return mvieCheckKey(<c:out value="${MVStringEditor_objectName}"/>)"
                           maxlength="<c:out value="${MVStringEditor_maxLength}"/>">
               </TD>
               <TD valign="middle"><img id="<c:out value="${MVStringEditor_name}"/>ImgUp" tabindex="-1" style="display:none"  onClick="return false;" src="<%= c.getModulesUrl() %>/dev/images/drop_up.gif" border=0><img style="display:inline" onClick="document.getElementById('mvid_<c:out value="${MVStringEditor_name}"/>').focus(); return false;" tabindex="-1" id="<c:out value="${MVStringEditor_name}"/>ImgDown" src="<%= c.getModulesUrl() %>/dev/images/drop_down.gif" border=0></TD>

               <c:if test="${not empty MVStringEditor_objectTypeName}">
                  <TD valign="middle">
                     <iman:os control="${MVStringEditor_name}"
                              typeFilter="${MVStringEditor_objectTypeName}"
                              history="${MVStringEditor_history}"
                              multiSelect="true"
                              typeFilterCallBack="${MVStringEditor_TypesCallBack}"
                              isOSAllowed="mvIsOSAllowed"
                              callBack="mvieReturnFromOS" />
                  </TD>

                  <%-- order button --%>
                  <c:if test="${MVStringEditor_order=='true'}">
                     <TD valign="middle"><A href="javascript:mvShowOrderDlg(<c:out value="${MVStringEditor_objectName}"/>);"><IMG alt="<iman:string key="Widgets.editItem"/>" title="<iman:string key="Widgets.editItem"/>" src="<%= c.getModulesUrl() %>/dev/images/iconorder.gif" border="0"></A></TD>
                  </c:if>

               </c:if>
            </TR>
            </TABLE>
         </c:otherwise>
      </c:choose>
   </c:when>


   <%-- -------------------------------------------------------------------------------------------------------------- --%>
   <%-- MVSEL IMPL                                                                                                     --%>
   <%-- -------------------------------------------------------------------------------------------------------------- --%>
   <c:when test="${MVStringEditor_mode=='mvsel'}">

      <%-- Default values --%>
      <c:if test="${MVStringEditor_size==null ||  MVStringEditor_size==''}"><c:set var="MVStringEditor_size" value="${MVStringEditor_fixedHeight}"/></c:if>
      <c:if test="${MVStringEditor_size=='default'}"><c:set var="MVStringEditor_size" value="10"/></c:if>
      <c:set var="MVStringEditor_textboxName" value="${MVStringEditor_name}TB"/>

      <TABLE bgcolor="<c:out value="${MVStringEditor_bgColor}"/>" cellpadding="0" cellspacing="0">

      <c:choose>
      	      
         <%-- ------------ --%>
         <%-- Expanded     --%>
         <%-- ------------ --%>
         <c:when test="${MVStringEditor_size!=null && MVStringEditor_size>1 && MVStringEditor_biggerBox!='true'}">
            <TR>
              <TD><INPUT id="mvid_<c:out value="${MVStringEditor_textboxName}"/>"
                         name="<c:out value="${MVStringEditor_textboxName}"/>"
                         type="text"
                         onfocus="closeTooltip('<c:out value="${MVStringEditor_name}"/>');"
                         onkeypress="return mvselKeyDown(<c:out value="${MVStringEditor_objectName}"/>, event, true);"
                         style="width:<c:out value="${MVStringEditor_width}"/>;"
                         maxlength="<c:out value="${MVStringEditor_maxLength}"/>" <c:if test="${MVStringEditor_readonly=='true'}">readOnly</c:if>>
       			
              </TD>
           
            <%-- Buttons to allow to change list --%>
            <c:if test="${MVStringEditor_readonly != 'true'}">
               <c:choose>
                  <c:when test="${not empty MVStringEditor_objectTypeName}">
                     <TD><iman:spacer/></TD>
                       <TD>
                           <iman:os control="${MVStringEditor_name}"
                                    windowed="true"
                                    typeFilter="${MVStringEditor_objectTypeName}"
                                    history="${MVStringEditor_history}"
                                    multiSelect="true"
                                    typeFilterCallBack="${MVStringEditor_TypesCallBack}"
                                    isOSAllowed="mvIsOSAllowed"
                                    callBack="mvselReturnFromOS" />
                     </TD>
                  </c:when>
                  <c:otherwise>
                     <c:if test="${MVStringEditor_disableEdit != 'true'}"><TD><A href="javascript:mvselEditOnPage(<c:out value="${MVStringEditor_objectName}"/>);"><IMG alt="<iman:string key="Widgets.editItem"/>" title="<iman:string key="Widgets.editItem"/>" src="<%= c.getModulesUrl() %>/dev/images/iconedit.gif" border=0></A></TD> </c:if>
                  </c:otherwise>
               </c:choose>

               <%-- order button --%>
               <c:if test="${MVStringEditor_order=='true'}">
                  <TD><A href="javascript:mvShowOrderDlg(<c:out value="${MVStringEditor_objectName}"/>);"><IMG alt="<iman:string key="Widgets.editItem"/>" title="<iman:string key="Widgets.editItem"/>" src="<%= c.getModulesUrl() %>/dev/images/iconorder.gif" border="0"></A></TD>
               </c:if>
               
               <%-- help button and tooltip --%>
                   	
               <c:if test="${MVStringEditor_disableHelp != 'true' }">
               <% 
               	String isMoo = (String)pageContext.findAttribute("Task.moo");
         		if(!(isMoo!=null && isMoo.equalsIgnoreCase("true")))
         		{ %>      
                  <td><iman:spacer/></td>
                  <td><iman:spacer/></td>
                  <td><a href="javascript:toggleTooltip('<c:out value="${MVStringEditor_name}"/>');"><IMG image src='<%= MUtils.getModulesUrl(request) %>/dev/images/help_16.gif' border=0 width=18 height=18 alt="<iman:string key="Button.Help.alt" />" title="<iman:string key="Button.Help.alt" />"></a></td>
				  <tr>
				  <td colspan=10>
				     <span id="<c:out value="${MVStringEditor_name}"/>_tooltip" style="position:relative; display:none; width:100%">
       			        <div id="tooltip" style="z-index:100; height:80px; width:100%; position:relative; border:1px solid black; background-color:#EFEEEC; overflow:auto;">
       			           <a href="javascript:closeTooltip('<c:out value="${MVStringEditor_name}"/>');"><IMG src="<%= MUtils.getModulesUrl(request) %>/dev/images/<iman:string key="Icon.Close.image"/>" alt="<iman:string key="Icon.Close.alt"/>" title="<iman:string key="Icon.Close.alt"/>" style="border:none; float:right;"></a>
       			           <div style="height:0px; clear:both; visibility:hidden; line-height:0px"><!-- hidden div --></div>
              	           <pre style="font-size:12px; margin:4px;"><iman:string key="Widgets.toolTip"/></pre>
              	        </div>
              	     </span>
				  </td>
				<%} %>
				</c:if>  
				
				  </tr>
            </c:if>
				
            </TR>
            <TR>
               <TD colspan="4">
                  <SELECT id="mvid_<c:out value="${MVStringEditor_name}"/>"
                          name="<c:out value="${MVStringEditor_name}"/>" style="width:<c:out value="${MVStringEditor_width}"/>;" size="<c:out value="${MVStringEditor_size}"/>" multiple
                          onClick="<c:out value="${MVStringEditor_objectName}"/>.m_editing=false;<c:out value="${MVStringEditor_objectName}"/>.m_tb.value=''"
                          onkeydown="return mvselKeyDown(<c:out value="${MVStringEditor_objectName}"/>, event, false);"
                          onMouseDown="mvselResetColor(<c:out value="${MVStringEditor_objectName}"/>);"
                          onDblClick="mvselEditOnPage(<c:out value="${MVStringEditor_objectName}"/>);">
                          
	                <%-- The above onDblClick was added as fix for bug No:269079 to take care of dbl click for objects aded later from OS --%>
                 
                     <% int count = 0; %>
                     <%-- Load values from XML --%>
                     <c:if test="${not empty MVStringEditor_xmlNodeSet}">
                           <x:forEach select="$MVStringEditor_xmlNodeSet/value">
                               <c:set var="text">
                                   <x:out select="."/>
                               </c:set>   
                               <jsp:useBean id="text" type="java.lang.String"/>
                               <OPTION value="<c:out value="${text}"/>" title="<c:out value="${text}"/>">
                               <c:out value="${text}"/>
                               <% count++; %>
                           </x:forEach>
                     </c:if>
                     <%-- Load values from String[] --%>
                     <% int i = 0;  HashSet selections = (HashSet) pageContext.getAttribute("MVStringEditor_selectedValues"); %>
                     <c:if test="${not empty MVStringEditor_values}">
                           <c:forEach items="${MVStringEditor_values}" var="values">
                               <% String num = ""+i; %>
                               <jsp:useBean id="values" type="java.lang.String"/>
                               <OPTION value="<c:out value="${values}"/>" title="<c:out value="${values}"/>" <%= ((selections!=null && selections.contains(num))?"selected ":"") %> >
                               <c:out value="${values}"/>
                               <% i++; count++; %>
                           </c:forEach>
                     </c:if>

                  </SELECT>
               </TD>
            </TR>
            <TR>
               <TD colspan="4">
                  <c:if test="${MVStringEditor_showCount=='true'}">
                     <label><iman:string key="MVStringEditor.count"/></label> <INPUT type="text" id="<c:out value="${MVStringEditor_name}"/>_countBox" value="<%= count %>" style="border:none;background:white;color:black;" disabled="true">
                  </c:if>
               </TD>
            </TR>
         </c:when>

         <%-- ------------ --%>
         <%-- One line     --%>
         <%-- ------------ --%>
         <c:otherwise>
            <TR>
               <TD>
               		<c:choose>
        			<c:when test="${MVStringEditor_biggerBox=='true'}">
                     <SELECT id="mvid_<c:out value="${MVStringEditor_name}"/>" name="<c:out value="${MVStringEditor_name}"/>" style="width:<c:out value="${MVStringEditor_width}"/>;" size="<c:out value="${MVStringEditor_size}"/>">
        			</c:when>
        			<c:otherwise>
                  	<SELECT id="mvid_<c:out value="${MVStringEditor_name}"/>" name="<c:out value="${MVStringEditor_name}"/>" style="width:<c:out value="${MVStringEditor_width}"/>;">
        			</c:otherwise>
    				</c:choose>
                  
                     <%-- Load values from XML --%>
                     <%-- &nbsp; is for Mozilla.  Stupid broswer makes the select box's height to small (by 3px) if not there --%>

                     <c:if test="${not empty MVStringEditor_xmlNodeSet}">
                        <% List XMLSelections = new ArrayList();%>
                        <x:forEach select="$MVStringEditor_xmlNodeSet/value">
                           <x:set var="node" select="string(.)"/>
                           <jsp:useBean id="node" type="java.lang.String"/>
                           <% XMLSelections.add(node); %>
                        </x:forEach>&nbsp;
                        <% pageContext.setAttribute("MVStringEditor_values", XMLSelections); %>
                     </c:if>
   
                     <%-- Load values from String[] --%>
                     <% int i = 0; HashSet selections = (HashSet) pageContext.getAttribute("MVStringEditor_selectedValues"); %>
                     <c:if test="${not empty MVStringEditor_values}">
                           <c:forEach items="${MVStringEditor_values}" var="item">
                              <% String num = ""+i; %>
                              <jsp:useBean id="item" type="String"/>
                              <OPTION value="<c:out value="${item}"/>" <%= ((selections!=null && selections.contains(num))?"selected ":"") %>>
                              <c:out value="${item}"/>
                              <% i++; %>
                           </c:forEach>
                     </c:if>

                   </SELECT><iman:spacer/>
                </TD>


               <c:if test="${MVStringEditor_readonly != 'true'}">
                  <c:choose>
                     <c:when test="${not empty MVStringEditor_objectTypeName}">
                        <TD><iman:spacer/></TD>
                        <TD nowrap>
                           <%-- OS --%>
                           <iman:os control="${MVStringEditor_name}"
                                    windowed="true"
                                    typeFilter="${MVStringEditor_objectTypeName}"
                                    history="${MVStringEditor_history}"
                                    multiSelect="true"
                                    typeFilterCallBack="${MVStringEditor_TypesCallBack}"
                                    isOSAllowed="mvIsOSAllowed"
                                    callBack="mvselReturnFromOS" />
                           <A href="javascript:mvselAddFromPrompt(<c:out value="${MVStringEditor_objectName}"/>);"><IMG alt="<iman:string key="Widgets.addItem"/>" title="<iman:string key="Widgets.addItem"/>"  src="<%= c.getModulesUrl() %>/dev/images/iconadd.gif" border="0" align="absmiddle"></a>
                           <A href="javascript:mvselRemove(<c:out value="${MVStringEditor_objectName}"/>);"><IMG alt="<iman:string key="Widgets.removeItem"/>" title="<iman:string key="Widgets.removeItem"/>" src="<%= c.getModulesUrl() %>/dev/images/iconremove.gif" border="0" align="absmiddle"></A>

                           <%-- order button --%>
                           <c:if test="${MVStringEditor_order=='true'}">
                              <A href="javascript:mvShowOrderDlg(<c:out value="${MVStringEditor_objectName}"/>);"><IMG alt="<iman:string key="Widgets.editItem"/>" title="<iman:string key="Widgets.editItem"/>" src="<%= c.getModulesUrl() %>/dev/images/iconorder.gif" border="0" align="absmiddle"></A>
                           </c:if>

                        </td>
                     </c:when>
                     <c:otherwise>
                        <%-- buttons: add, remove, edit --%>

                        <c:choose>
                           <c:when test="${MVStringEditor_bigEditBox=='true'}">
                              <TD VALIGN=TOP ALIGN=CENTER><A href="javascript:mvselAddFromPromptBox(<c:out value="${MVStringEditor_objectName}"/>, '<iman:string key="MVStringEditor.AddValue"/>');"><IMG alt="<iman:string key="Widgets.addItem"/>" title="<iman:string key="Widgets.addItem"/>" src="<%= c.getModulesUrl() %>/dev/images/iconadd.gif" border=0></a><iman:spacer/></TD>
                              <TD VALIGN=TOP ALIGN=CENTER><A href="javascript:mvselRemove(<c:out value="${MVStringEditor_objectName}"/>);"><IMG alt="<iman:string key="Widgets.removeItem"/>" title="<iman:string key="Widgets.removeItem"/>" src="<%= c.getModulesUrl() %>/dev/images/iconremove.gif" border=0></A><iman:spacer/></TD>
                              <c:if test="${MVStringEditor_disableEdit != 'true'}"><TD VALIGN=TOP ALIGN=CENTER><A href="javascript:mvselEditInPrompt(<c:out value="${MVStringEditor_objectName}"/>, '<iman:string key="MVStringEditor.EditValue"/>');"><IMG alt="<iman:string key="Widgets.editItem"/>" title="<iman:string key="Widgets.editItem"/>" src="<%= c.getModulesUrl() %>/dev/images/iconedit.gif" border=0></A><iman:spacer/></TD></c:if>
                           </c:when>
                           <c:when test="${MVStringEditor_hex=='true'}">
                              <TD VALIGN=TOP><A href="javascript:mvselAddFromHex(<c:out value="${MVStringEditor_objectName}"/>, '<iman:string key="MVStringEditor.AddValue"/>');"><IMG alt="<iman:string key="Widgets.addItem"/>" title="<iman:string key="Widgets.addItem"/>" src="<%= c.getModulesUrl() %>/dev/images/iconadd.gif" border=0></a><iman:spacer/></TD>
                              <TD VALIGN=TOP><A href="javascript:mvselRemove(<c:out value="${MVStringEditor_objectName}"/>);"><IMG alt="<iman:string key="Widgets.removeItem"/>" title="<iman:string key="Widgets.removeItem"/>" src="<%= c.getModulesUrl() %>/dev/images/iconremove.gif" border=0></A><iman:spacer/></TD>
                              <c:if test="${MVStringEditor_disableEdit != 'true'}"><TD VALIGN=TOP><A href="javascript:mvselEditInHex(<c:out value="${MVStringEditor_objectName}"/>, '<iman:string key="MVStringEditor.EditValue"/>');"><IMG alt="<iman:string key="Widgets.editItem"/>" title="<iman:string key="Widgets.editItem"/>" src="<%= c.getModulesUrl() %>/dev/images/iconedit.gif" border=0></A><iman:spacer/></TD></c:if>
                           </c:when>
                           <c:otherwise>
                              <TD VALIGN=TOP><A href="javascript:mvselAddFromPrompt(<c:out value="${MVStringEditor_objectName}"/>);"><IMG alt="<iman:string key="Widgets.addItem"/>"  title="<iman:string key="Widgets.addItem"/>" src="<%= c.getModulesUrl() %>/dev/images/iconadd.gif" border=0></a><iman:spacer/></TD>
                              <TD VALIGN=TOP><A href="javascript:mvselRemove(<c:out value="${MVStringEditor_objectName}"/>);"><IMG alt="<iman:string key="Widgets.removeItem"/>" title="<iman:string key="Widgets.removeItem"/>" src="<%= c.getModulesUrl() %>/dev/images/iconremove.gif" border=0></A><iman:spacer/></TD>
                              <c:if test="${MVStringEditor_disableEdit != 'true'}"><TD VALIGN=TOP><A href="javascript:mvselEdit(<c:out value="${MVStringEditor_objectName}"/>);"><IMG alt="<iman:string key="Widgets.editItem"/>" title="<iman:string key="Widgets.editItem"/>" src="<%= c.getModulesUrl() %>/dev/images/iconedit.gif" border=0></A><iman:spacer/></TD></c:if>
                           </c:otherwise>
                        </c:choose>


                     <%-- order button --%>
                     <c:if test="${MVStringEditor_order=='true'}">
                        <TD><A href="javascript:mvShowOrderDlg(<c:out value="${MVStringEditor_objectName}"/>);"><IMG alt="<iman:string key="Widgets.editItem"/>" title="<iman:string key="Widgets.editItem"/>" src="<%= c.getModulesUrl() %>/dev/images/iconorder.gif" border="0"></A><iman:spacer/></TD>
                     </c:if>

                     </c:otherwise>
                  </c:choose>


               </c:if>
            </TR>
         </c:otherwise>
      </c:choose>
      </TABLE>
   </c:when>

   <%-- -------------------------------------------------------------------------------------------------------------- --%>
   <%-- MVTXT IMPL                                                                                                     --%>
   <%-- -------------------------------------------------------------------------------------------------------------- --%>
   <c:when test="${MVStringEditor_mode=='mvtxt'}">

      <%-- textfield shorter on pocket if showing OS --%>
      <c:choose>
         <c:when test="${MVStringEditor_objectTypeName==null || MVStringEditor_objectTypeName==''}">
            <c:set var="mvTextFieldSize"><iman:string key="PocketUI.textboxSizeTwoButtons"/></c:set>
         </c:when>
         <c:otherwise>
            <c:set var="mvTextFieldSize"><iman:string key="PocketUI.textboxSizeThreeButtons"/></c:set>
         </c:otherwise>
      </c:choose>

      <%-- textfield --%>
      <INPUT name="__<c:out value="${MVStringEditor_name}"/>" type=hidden value="">
      <INPUT name="<c:out value="${MVStringEditor_name}"/>" type=text value="" size=<c:out value="${mvTextFieldSize}"/> onFocus="alert('<iman:string key="Widgets.modifyThroughButtons"/>')">
      <A href="javascript:mvtxtAdd('<c:out value="${MVStringEditor_name}"/>')"><IMG alt="<iman:string key="Widgets.addItem"/>"  title="<iman:string key="Widgets.addItem"/>" src="<%= c.getModulesUrl() %>/dev/images/iconadd.gif" border=0></A>
      <A href="javascript:mvtxtRemove('<c:out value="${MVStringEditor_name}"/>')"><IMG alt="<iman:string key="Widgets.removeItem"/>" title="<iman:string key="Widgets.removeItem"/>" src="<%= c.getModulesUrl() %>/dev/images/iconremove.gif" border=0></A>

      <%-- OS --%>
      <c:if test="${MVStringEditor_objectTypeName!=null && MVStringEditor_objectTypeName!=''}">
          <c:set var="OS.MultiSelect" value="true"/>
          <c:set var="OS.TypeFilter" value="${MVStringEditor_objectTypeName}"/>
          <c:set var="OS.Control" value="${MVStringEditor_name}"/>
          <c:set var="OS.CallBack" value="mvtxtReturnFromOS"/>
         <iman:include page="dev/OS_inc.jsp"/>
      </c:if>
   </c:when>

   <c:otherwise>
      Invalid MVStringEditor_mode: [<c:out value="${MVStringEditor_mode}"/>]
   </c:otherwise>
</c:choose>


<%-- hidden input for posting packed values --%>
<%
   String[] values = new String[0];
   Object valuesObject =  pageContext.findAttribute("MVStringEditor_values");
   if(valuesObject!=null && valuesObject instanceof String[])
   {
      values = (String[]) valuesObject;
   }

   String pack = eMFrameUtils.pack(values, eMFrameFactory.getTaskContext(request));
%>

<INPUT name="<c:out value="${MVStringEditor_name}"/>_packedValues" id="<c:out value="${MVStringEditor_name}"/>_packedValues" type="hidden" value="<%= pack %>">

<%-- -------------------------------------- --%>
<%-- Javascript object                      --%>
<%-- -------------------------------------- --%>
<SCRIPT>
   <c:choose>
      <c:when test="${MVStringEditor_mode=='mvie'}">
         <c:out value="${MVStringEditor_objectName}"/> = new MVStringEditorIE(document.getElementById('mvid_<c:out value="${MVStringEditor_name}"/>'));
      </c:when>
      <c:when test="${MVStringEditor_mode=='mvsel'}">
         <c:out value="${MVStringEditor_objectName}"/> = new MVStringEditorSel(document.getElementById("mvid_<c:out value="${MVStringEditor_textboxName}"/>"), document.getElementById("mvid_<c:out value="${MVStringEditor_name}"/>"));
      </c:when>
      <c:when test="${MVStringEditor_mode=='mvtxt'}">
         <c:out value="${MVStringEditor_objectName}"/> = new MVStringEditorTxt(document.<c:out value="${MVStringEditor_formName}"/>.<c:out value="${MVStringEditor_name}"/>, document.<c:out value="${MVStringEditor_formName}"/>.__<c:out value="${MVStringEditor_name}"/>);
      </c:when>
   </c:choose>

   <c:out value="${MVStringEditor_objectName}"/>.m_name = "<c:out value="${MVStringEditor_name}"/>";
   <c:out value="${MVStringEditor_objectName}"/>.m_numbersOnly = <c:out value="${MVStringEditor_numbersOnly}"/>;
   <c:out value="${MVStringEditor_objectName}"/>.m_upperBound = <c:out value="${MVStringEditor_upperBound}"/>;
   <c:out value="${MVStringEditor_objectName}"/>.m_lowerBound = <c:out value="${MVStringEditor_lowerBound}"/>;
   <c:out value="${MVStringEditor_objectName}"/>.m_enforceUnique = <c:out value="${MVStringEditor_enforceUnique}"/>;
   <c:out value="${MVStringEditor_objectName}"/>.m_maxLength = <c:out value="${MVStringEditor_maxLength}"/>;
   <c:out value="${MVStringEditor_objectName}"/>.m_minLength = <c:out value="${MVStringEditor_minLength}"/>;
   <c:out value="${MVStringEditor_objectName}"/>.m_ignoreCase = <c:out value="${MVStringEditor_ignoreCase}"/>;
   <c:out value="${MVStringEditor_objectName}"/>.m_disabled = <c:out value="${MVStringEditor_readonly}"/>;
   <c:out value="${MVStringEditor_objectName}"/>.m_disableEdit = <c:out value="${MVStringEditor_disableEdit}"/>;
   <c:out value="${MVStringEditor_objectName}"/>.m_onChangeCallback = <c:out value="${MVStringEditor_onChangeCallback}"/>;
   <c:out value="${MVStringEditor_objectName}"/>.m_hex = "<c:out value="${MVStringEditor_hex}"/>";
   <c:out value="${MVStringEditor_objectName}"/>.m_useRootedName = <c:out value="${MVStringEditor_useRootedName}"/>;


   <c:choose>
      <c:when test="${empty MVStringEditor_regExpression}">
         <c:out value="${MVStringEditor_objectName}"/>.m_regExpression = null;
      </c:when>
      <c:otherwise>
         <c:out value="${MVStringEditor_objectName}"/>.m_regExpression = "<c:out value="${MVStringEditor_regExpression}"/>";
      </c:otherwise>
   </c:choose>

   <c:out value="${MVStringEditor_objectName}"/>.m_regExpressionMsg = "<c:out value="${MVStringEditor_regExpressionMsg}"/>";





   <%-- Load values from String[] --%>
   <c:if test="${not empty MVStringEditor_values && MVStringEditor_mode=='mvie'}">
      var list = new Array();

      <c:forEach items="${MVStringEditor_values}" var="item" >
          list[list.length] = "<iman:toScript><c:out value="${item}" escapeXml="false"/></iman:toScript>";
      </c:forEach>

      <c:out value="${MVStringEditor_objectName}"/>.m_list = list;
      mvieShowListInBox(<c:out value="${MVStringEditor_objectName}"/>);
   </c:if>
   <c:if test="${not empty MVStringEditor_values && MVStringEditor_mode=='mvtxt'}">
      var list = new Array();

      <c:forEach items="${MVStringEditor_values}" var="item" >
          list[list.length] = "<iman:toScript><c:out value="${item}" escapeXml="false"/></iman:toScript>";
      </c:forEach>

      document.forms[0].__<c:out value="${MVStringEditor_name}"/>.value = pack(list);
      mvtxtUpdateTextbox("<c:out value="${MVStringEditor_name}"/>");
   </c:if>

   <%-- Load values from XML --%>
   <c:if test="${not empty MVStringEditor_xmlNodeSet && MVStringEditor_mode=='mvie'}">
      var list = new Array();
      <x:forEach select="$MVStringEditor_xmlNodeSet/value">
          list[list.length] = "<iman:toScript><x:out select="." escapeXml="false"/></iman:toScript>";
      </x:forEach>

      <c:out value="${MVStringEditor_objectName}"/>.m_list = list;

      mvieShowListInBox(<c:out value="${MVStringEditor_objectName}"/>);
   </c:if>
   <c:if test="${not empty MVStringEditor_xmlNodeSet && MVStringEditor_mode=='mvtxt'}">
      var list = new Array();
      <x:forEach select="$MVStringEditor_xmlNodeSet/value">
          list[list.length] = "<iman:toScript><x:out select="." escapeXml="false"/></iman:toScript>";
      </x:forEach>

      document.forms[0].__<c:out value="${MVStringEditor_name}"/>.value = pack(list);
      mvtxtUpdateTextbox("<c:out value="${MVStringEditor_name}"/>");
   </c:if>
</SCRIPT>


<%-- -------------------------------------- --%>
<%-- clear values for next control          --%>
<%-- -------------------------------------- --%>
<c:remove var="MVStringEditor_formName"/>
<c:remove var="MVStringEditor_width"/>
<c:remove var="MVStringEditor_bgColor"/>
<c:remove var="MVStringEditor_name"/>
<c:remove var="MVStringEditor_readonly"/>
<c:remove var="MVStringEditor_objectTypeName"/>
<c:remove var="MVStringEditor_fixedHeight"/>
<c:remove var="MVStringEditor_size"/>
<c:remove var="MVStringEditor_tempBoxName"/>
<c:remove var="MVStringEditor_numbersOnly"/>
<c:remove var="MVStringEditor_upperBound"/>
<c:remove var="MVStringEditor_lowerBound"/>
<c:remove var="MVStringEditor_enforceUnique"/>
<c:remove var="MVStringEditor_minLength"/>
<c:remove var="MVStringEditor_maxLength"/>
<c:remove var="MVStringEditor_ignoreCase"/>
<c:remove var="MVStringEditor_isList"/>
<c:remove var="MVStringEditor_xml"/>
<c:remove var="MVStringEditor_xmlNodeSet"/>
<c:remove var="MVStringEditor_mode"/>
<c:remove var="MVStringEditor_pack"/>
<c:remove var="MVStringEditor_values"/>
<c:remove var="MVStringEditor_onChangeCallback"/>
<c:remove var="MVStringEditor_useRootedName"/>
<c:remove var="MVStringEditor_disableEdit"/>
<c:remove var="MVStringEditor_disableHelp"/>
<c:remove var="MVStringEditor_biggerBox"/>
<c:remove var="OS.Windowed"/>


