<%@  page pageEncoding="utf-8" contentType="text/html;charset=utf-8" import="com.novell.webaccess.common.JSPConduit, com.novell.emframe.dev.eMFrameUtils" %>
<%   JSPConduit c = JSPConduit.getJSPConduit(request);
   c.stringTable("DevResources");
   c.stringTable("FwResources"); %>

<HTML>
<HEAD>
<TITLE><%= c.string("NetAddrUIHandler.NetworkAddress") %></TITLE>
<LINK rel='stylesheet' href='<%= c.getModulesUrl() + "/dev/css/hf_style.css" %>'>
<jsp:include page='<%= c.getPath("dev/eMFrameScripts_inc.jsp") %>' flush="true" />
<jsp:include page='<%= c.getPath("dev/ValidateIntegerScripts_inc.jsp") %>' flush="true" />
<jsp:include page='<%= c.getPath("dev/HelpScripts_inc.jsp") %>' flush="true" />

<SCRIPT LANGUAGE="JavaScript">

// globals 
var addressString = null;


function getSelectionStart(field) {
	if (field.createTextRange) {
	var range = document.selection.createRange();
	range.moveEnd('character', field.value.length);
	if (range.text == '') 
		return field.value.length;
	return field.value.lastIndexOf(range.text);
	} else return field.selectionStart;
	}
	
function getSelectionEnd(field) {
	if (field.createTextRange) {
	var range = document.selection.createRange();
	range.moveStart('character', -field.value.length);
	return range.text.length;
	} else return field.selectionEnd
	}
function showIPAddr(sel)
{
	toggleDivAddr('IPv4Div', 'none');
	toggleDivAddr('IPv6Div', 'none');

	if (sel.checked == true)
	{
		toggleDivAddr('IPv6Div', 'block');
	}
	else
	{
		toggleDivAddr('IPv4Div', 'block');
	}
}

function showAddr(sel)
{
	toggleDivAddr('IPDiv', 'none');
	toggleDivAddr('IPXDiv', 'none');
	toggleDivAddr('SDLCDiv', 'none');
	toggleDivAddr('ETHDiv', 'none');
	toggleDivAddr('OSIDiv', 'none');
	toggleDivAddr('APPLEDiv', 'none');
	toggleDivAddr('UDPDiv', 'none');
	toggleDivAddr('TCPDiv', 'none');
	toggleDivAddr('UDP6Div', 'none');
	toggleDivAddr('TCP6Div', 'none');

	if (sel.selectedIndex == 0)
	{
		toggleDivAddr('IPDiv', 'block');
	}
	else if (sel.selectedIndex == 1)
	{
		toggleDivAddr('IPXDiv', 'block');
	}
	else if (sel.selectedIndex == 2)
	{
		toggleDivAddr('SDLCDiv', 'block');
	}
	else if (sel.selectedIndex == 3)
	{
		toggleDivAddr('ETHDiv', 'block');
	}
	else if (sel.selectedIndex == 4)
	{
		toggleDivAddr('OSIDiv', 'block');
	}
	else if (sel.selectedIndex == 5)
	{
		toggleDivAddr('APPLEDiv', 'block');
	}
	else if (sel.selectedIndex == 6)
	{
		toggleDivAddr('UDPDiv', 'block');
	}
	else if (sel.selectedIndex == 7)
	{
		toggleDivAddr('TCPDiv', 'block');
	}
	else if (sel.selectedIndex == 8)
	{
		toggleDivAddr('UDP6Div', 'block');
	}
	else if (sel.selectedIndex == 9)
	{
		toggleDivAddr('TCP6Div', 'block');
	}
	
}

function toggleDivAddr(id, hideOrShow)
{
   document.getElementById(id).style.display = hideOrShow;
}

function buildTheAddress(sel)
{
	if (sel.selectedIndex == 0)
	{
		addressString = buildIP();
	}
	else if (sel.selectedIndex == 1)
	{
		addressString = buildIPX();
	}
	else if (sel.selectedIndex == 2)
	{
		addressString = buildSDLC();
	}
	else if (sel.selectedIndex == 3)
	{
		addressString = buildETH();
	}
	else if (sel.selectedIndex == 4)
	{
		addressString = buildOSI();
	}
	else if (sel.selectedIndex == 5)
	{
		addressString = buildAPPLE();
	}
	else if (sel.selectedIndex == 6)
	{
		addressString = buildUDP();
	}
	else if (sel.selectedIndex == 7)
	{
		addressString = buildTCP();
	}
	else if (sel.selectedIndex == 8)
	{
		addressString = buildUDP6();
	}
	else if (sel.selectedIndex == 9)
	{
		addressString = buildTCP6();
	}

//	alert("Address will be built: " + document.addrform.selbox.options[document.addrform.selbox.selectedIndex].value);
//	alert("address string: " + addressString);
}

function setFocusToFormElement()
{
   // Since we default to IP, set the initial focus on the first IP input.
   document.addrform.IPfield1.focus();
}

function addStringAndClose(sel)
{
	var stat = checkIPv6(); 
	if(stat == 1) {
		alert("Please enter IPv6 address between square brackets and without port");
		return;
	} else if(stat == 2) {
		alert("Please enter valid IPv6 address");
		return;
	}
	buildTheAddress(sel);
	top.opener.MVNetAdd('document.<%= c.var("control") %>', addressString);
	window.close();
}


function pad(control, length)
{
    var value = control.value;
	var tmpone = "";
	for (var i= 0; i < (length - value.length); i++)
	{
	   tmpone += "0";
	}
	tmpone = tmpone + value;
	control.value = tmpone;
}

function checkIPv6()
{	
	//retun 0(Valid IPv6 address if present), 1(IPv6 without Square Brackets or with port, 2(Invalid IPv6 address)))
	var format = false; 
	if (document.addrform.selbox.selectedIndex == 0 && document.addrform.EnableIPv6.checked == true && document.addrform.IPv6field1.value != "") {
		if (document.addrform.IPv6field1.value.indexOf("[") == 0 && document.addrform.IPv6field1.value.lastIndexOf("]") == document.addrform.IPv6field1.value.length-1) {
			format = (/^\s*((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))(%.+)?\s*$/.test(document.addrform.IPv6field1.value.substring(document.addrform.IPv6field1.value.indexOf("[")+1, document.addrform.IPv6field1.value.lastIndexOf("]"))));
		} else
			return 1;
	} else if (document.addrform.selbox.selectedIndex == 8 && document.addrform.UDP6field1.value != "") {
		if (document.addrform.UDP6field1.value.indexOf("[") == 0 && document.addrform.UDP6field1.value.lastIndexOf("]") == document.addrform.UDP6field1.value.length-1)
			format = (/^\s*((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))(%.+)?\s*$/.test(document.addrform.UDP6field1.value.substring(document.addrform.UDP6field1.value.indexOf("[")+1, document.addrform.UDP6field1.value.lastIndexOf("]"))));
		else
			return 1;
	} else if (document.addrform.selbox.selectedIndex == 9 && document.addrform.TCP6field1.value != "") {
		if (document.addrform.TCP6field1.value.indexOf("[") == 0 && document.addrform.TCP6field1.value.lastIndexOf("]") == document.addrform.TCP6field1.value.length-1)
			format = (/^\s*((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))(%.+)?\s*$/.test(document.addrform.TCP6field1.value.substring(document.addrform.TCP6field1.value.indexOf("[")+1, document.addrform.TCP6field1.value.lastIndexOf("]"))));
		else
			return 1;
	} else {
		return 0;
	}
	if(format == true)
		return 0;
	else
		return 2;
}


function buildIP()
{
	if (document.addrform.EnableIPv6.checked == true)
	{
		if (document.addrform.IPv6field1.value == "")
		{
			document.addrform.IPv6field1.value = "[::]";
		}
		var addr = "IP: " + document.addrform.IPv6field1.value;
	} else {
		if (document.addrform.IPfield1.value == "")
		{
			pad(document.addrform.IPfield1, 1);
		}
		if (document.addrform.IPfield2.value == "")
		{
			pad(document.addrform.IPfield2, 1);
		}
		if (document.addrform.IPfield3.value == "")
		{
			pad(document.addrform.IPfield3, 1);
		}
		if (document.addrform.IPfield4.value == "")
		{
			pad(document.addrform.IPfield4, 1);
		}
		var addr = "IP: " + document.addrform.IPfield1.value + "." + document.addrform.IPfield2.value + "." + document.addrform.IPfield3.value + "." + document.addrform.IPfield4.value;
	}
	return addr;
}

function buildIPX()
{
	if (document.addrform.IPXfield1.value == "")
	{
		pad(document.addrform.IPXfield1, 8);
	}
	if (document.addrform.IPXfield2.value == "")
	{
		pad(document.addrform.IPXfield2, 12);
	}
	if (document.addrform.IPXfield3.value == "")
	{
		pad(document.addrform.IPXfield3, 4);
	}
	var addr = " IPX:" + document.addrform.IPXfield1.value + ":" + document.addrform.IPXfield2.value + ":" + document.addrform.IPXfield3.value;
	return addr;
}

function buildSDLC()
{
	if (document.addrform.SDLCfield1.value == "")
	{
		pad(document.addrform.SDLCfield1, 1);
	}
	if (document.addrform.SDLCfield2.value == "")
	{
		pad(document.addrform.SDLCfield2, 1);
	}
	if (document.addrform.SDLCfield3.value == "")
	{
		pad(document.addrform.SDLCfield3, 1);
	}
	var addr = "SDLC: " + document.addrform.SDLCfield1.value + ":" + document.addrform.SDLCfield2.value + ":" + document.addrform.SDLCfield3.value;
	return addr;
}

function buildETH()
{
	if (document.addrform.ETHfield1.value == "")
	{
		pad(document.addrform.ETHfield1, 1);
	}
	if (document.addrform.ETHfield2.value == "")
	{
		pad(document.addrform.ETHfield2, 1);
	}
	if (document.addrform.ETHfield3.value == "")
	{
		pad(document.addrform.ETHfield3, 1);
	}
	var addr = "ETHERNET/TOKENRING: " + document.addrform.ETHfield1.value + ":" + document.addrform.ETHfield2.value + ":" + document.addrform.ETHfield3.value;
	return addr;
}

function buildOSI()
{
	if (document.addrform.OSIfield1.value == "")
	{
		pad(document.addrform.OSIfield1, 1);
	}
	var addr = "OSI: " + document.addrform.OSIfield1.value;
	return addr;
}

function buildAPPLE()
{
	if (document.addrform.APPLEfield1.value == "")
	{
		pad(document.addrform.APPLEfield1, 4);
	}
	if (document.addrform.APPLEfield2.value == "")
	{
		pad(document.addrform.APPLEfield2, 4);
	}
	if (document.addrform.APPLEfield3.value == "")
	{
		pad(document.addrform.APPLEfield3, 12);
	}
	var tmp = document.addrform.HType.selectedIndex + 3;
	var type = "";
	type += "0" + tmp;

	var addr = "APPLETALK: " + "03" + document.addrform.APPLEfield1.value + document.addrform.APPLEfield2.value + type + "06" + document.addrform.APPLEfield3.value;
	return addr;
}

function buildUDP()
{
	if (document.addrform.UDPfield0.value == "")
	{
		pad(document.addrform.UDPfield0, 1);
	}
	if (document.addrform.UDPfield1.value == "")
	{
		pad(document.addrform.UDPfield1, 1);
	}
	if (document.addrform.UDPfield2.value == "")
	{
		pad(document.addrform.UDPfield2, 1);
	}
	if (document.addrform.UDPfield3.value == "")
	{
		pad(document.addrform.UDPfield3, 1);
	}
	if (document.addrform.UDPfield4.value == "")
	{
		pad(document.addrform.UDPfield4, 1);
	}
	var addr = "UDP: " + document.addrform.UDPfield1.value + "." + document.addrform.UDPfield2.value + "." + document.addrform.UDPfield3.value + "." + document.addrform.UDPfield4.value + ":" + document.addrform.UDPfield0.value;
	return addr;
}

function buildTCP()
{
	if (document.addrform.TCPfield0.value == "")
	{
		pad(document.addrform.TCPfield0, 1);
	}
	if (document.addrform.TCPfield1.value == "")
	{
		pad(document.addrform.TCPfield1, 1);
	}
	if (document.addrform.TCPfield2.value == "")
	{
		pad(document.addrform.TCPfield2, 1);
	}
	if (document.addrform.TCPfield3.value == "")
	{
		pad(document.addrform.TCPfield3, 1);
	}
	if (document.addrform.TCPfield4.value == "")
	{
		pad(document.addrform.TCPfield4, 1);
	}
	var addr = "TCP: " + document.addrform.TCPfield1.value + "." + document.addrform.TCPfield2.value + "." + document.addrform.TCPfield3.value + "." + document.addrform.TCPfield4.value + ":" + document.addrform.TCPfield0.value;
	return addr;
}

function buildUDP6()
{
	if (document.addrform.UDP6field1.value == "")
	{
		document.addrform.UDP6field1.value = "[::]";
	}
	var addr = "UDP6: " + document.addrform.UDP6field1.value + ":" + document.addrform.UDP6field0.value;
	return addr;
}

function buildTCP6()
{
	if (document.addrform.TCP6field1.value == "")
	{
		document.addrform.TCP6field1.value = "[::]";
	}
	var addr = "TCP6: " + document.addrform.TCP6field1.value + ":" + document.addrform.TCP6field0.value;
	return addr;
}
// Check the validity of the IP field at each key press.
// If it's a '.' or 3 digits have been entered, advance to the next field.
// If it's a non-digit, display an error.
// If it's a <CR> and allowCR is true, submit the form.
//    field - The input element 
//    nextField - The next input element to advance to.
//    allocCR - True allows <CR> to submit the form.
//    e - The event
function checkIPField(field, nextField, allowCR, e)
{
	var tempFieldVal;
   var key;
   if (window.event)
      key = window.event.keyCode;
   else if (e)
   {
      key = e.which;
   }
   else
      return true;
      
   //alert("key = " + key);
   
   if (key == 46 || key == 9)   // If '.' or TAB, move focus to next field.
   {
      if (field.value.length > 0)   // Require at least 1 digit before '.' or TAB advances.
         nextField.focus();
         
      return false;           // Don't store the dot.
   }
   
   //remove entry if backspace is keyed in 
   //let other special keys as arrow, DEL etc. do their normal function
   if(key == 8 || key ==0) 
   {
     return true;
   } 

   if (key == 13)   // Allow Enter to submit the form when allowCR is true.
   {
      if(allowCR)
      {
        addStringAndClose(addrform.selbox)
      }
      else
      {
       if (field.value.length > 0)   // Require at least 1 digit before <CR> advances to next field.
         nextField.focus();
         return false;
      }
        
   }
   
   //validate integer only for integers
   if(key >= 48 && key <= 57)
   {
    var oldVal = field.value;
    var startPos = getSelectionStart(field);
    var endPos = getSelectionEnd(field);
    
    tempFieldVal=oldVal;  
   
    tempFieldVal = tempFieldVal.substring(0, startPos) +
    String.fromCharCode(key) + tempFieldVal.substring(endPos, tempFieldVal.length);
  
    
    if(!validateInteger(tempFieldVal, 0, 255))
    {
    	tempFieldVal = oldVal;   // If bad, restore old value after alert.
      return false;
    }
    // If this is the 3rd digit, change focus to next field.
    
    if (tempFieldVal.length >= 3) 
  	{ 
    	  field.value=tempFieldVal; 
  	 		nextField.focus();
    	  return false;
  	 
  	 }    
    return true;
   }
   

   
   //all other characters are invalid ..ignore 
   return false;
}

function checkIPv6Full(field, nextField, allowCR, e)
{
	var tempFieldVal;
   var key;
   if (window.event)
      key = window.event.keyCode;
   else if (e)
   {
      key = e.which;
   }
   else
      return true;
   
 //alert("key = " + key);
 
 if (key == 9)   // If TAB, move focus to next field.
 {
    if (field.value.length > 0)   // Require at least 1 digit before '.' or TAB advances.
       nextField.focus();
       
    return false;           // Don't store the dot.
 }
 
 //remove entry if backspace is keyed in 
 //let other special keys as arrow, DEL etc. do their normal function
 if(key == 8 || key == 0) 
 {
   return true;
 } 

 if (key == 13)   // Allow Enter to submit the form when allowCR is true.
 {
    if(allowCR)
    {
      addStringAndClose(addrform.selbox)
    }
    else
    {
     if (field.value.length > 0)   // Require at least 1 digit before <CR> advances to next field.
       nextField.focus();
       return false;
    }
      
 }
 
 //validate integer only for integers 
 if((key >= 48 && key <= 57)||(key >= 97 && key <= 102)||(key >= 65 && key <= 70)||key == 91||key == 93||key == 58)
 {
  var oldVal = field.value;
 
 var startPos = getSelectionStart(field);
  var endPos = getSelectionEnd(field);
  
  tempFieldVal=oldVal;   
 
  tempFieldVal = tempFieldVal.substring(0, startPos) +
  String.fromCharCode(key) + tempFieldVal.substring(endPos, tempFieldVal.length);
  
  // If this is the 41th key, change focus to next field.
	    if (tempFieldVal.length >= 41) 
	  {
	    	field.value=tempFieldVal;  
	     	nextField.focus();
	  }    
  
	return true;
  }
 
 
 //all other characters are invalid ..ignore 
 return false;
}

</SCRIPT>
</HEAD>

<BODY TEXT="#000000" LINK="#000000" VLINK="#000000" ALINK="#000000" bgcolor="#FFFFFF" onLoad="setFocusToFormElement();">

<br>

<left>
<form name=addrform  method=post action="webacc" onSubmit= >
	<input type=hidden name="taskId" value="<%= c.var("taskId") %>">
	<input type=hidden name="merge" value="dev.GenConf">
	<input type=hidden name="error" value="dev.GenErr">
	<input type=hidden name="User.context" value="<%= c.var("User.context") %>">
	<input type=hidden name="addressString" value="">
	<input type=hidden name="control" value="">
   <br>
   <% c.set("TaskHeader.title", c.string("NetAddrUIHandler.NetworkAddress"));
      c.set("TaskHeader.helpFile", "base/network_address.html"); %>
   <jsp:include page='<%= c.getPath("dev/TaskHeader_inc.jsp") %>' flush="true" />
   <br>

	<table cellspacing="0" cellpadding="2" border="0">
	<tr><td class="mediumtext"><%= c.string("NetAddrUIHandler.Addresstype") %></td></tr>
	<tr><td class="mediumtext" style="text-indent: 2;">
		<select name=selbox size=1 onChange='showAddr(this.form.selbox);'>
			<option class="mediumtext" value="IP">IP
			<option class="mediumtext" value="IPX">IPX
			<option class="mediumtext" value="SDLC">SDLC
			<option class="mediumtext" value="Ethernet/Tokenring">Ethernet/Tokenring
			<option class="mediumtext" value="OSI">OSI
			<option class="mediumtext" value="AppleTalk">AppleTalk
			<option class="mediumtext" value="UDP">UDP
			<option class="mediumtext" value="TCP">TCP
			<option class="mediumtext" value="UDP6">UDP6
			<option class="mediumtext" value="TCP6">TCP6
		</select>
	</td></tr>
	</table>

<div align="left" id="IPDiv" style="background-color: White; margin-top: 45; text-indent: 2; display:block; width:480; height:220;" title="<%= c.string("NetAddrUIHandler.IPNetworkAddress") %>">
	<input type="checkbox" name="EnableIPv6" value="" onChange='showIPAddr(this.form.EnableIPv6);'> Enter IPv6 Address</br>
	<div align="left" id="IPv4Div" style="background-color: White; margin-top: 45; text-indent: 2; display:block; width:480; height:220;" title="<%= c.string("NetAddrUIHandler.IPNetworkAddress") %>">
		<table cellspacing="0" cellpadding="2" border="0">
			<tr><td class="mediumtext"><%= c.string("NetAddrUIHandler.IPaddress") %></td></tr>
			<tr><td><input type=text name="IPfield1" value="" size=5 maxlength='3' onKeyPress='return checkIPField(this, IPfield2, false, event);'>&nbsp;.&nbsp;
            	    <input type=text name="IPfield2" value="" size=5 maxlength='3' onKeyPress='return checkIPField(this, IPfield3, false, event);'>&nbsp;.&nbsp;
                	<input type=text name="IPfield3" value="" size=5 maxlength='3' onKeyPress='return checkIPField(this, IPfield4, false, event);'>&nbsp;.&nbsp;
                	<input type=text name="IPfield4" value="" size=5 maxlength='3' onKeyPress='return checkIPField(this, document.getElementById("AddButton"), true, event);'>
        	</td></tr>
		</table>
	</div>
	<div align="left" id="IPv6Div" style="background-color: White; margin-top: 45; text-indent: 2; display:none; width:480; height:220;" title="<%= c.string("NetAddrUIHandler.IPv6NetworkAddress") %>">
		<table cellspacing="0" cellpadding="2" border="0">
			<tr><td class="mediumtext"><%= c.string("NetAddrUIHandler.IPv6address") %></td>
			<tr><td><input type=text id="IPv6field1"  name="IPv6field1"  maxlength="41" size=41 onKeyPress='return checkIPv6Full(this, document.getElementById("AddButton"), true, event);'>
        	</td></tr>
		</table>
	</div>
</div>

<div align="left" id="IPXDiv" style="background-color: White; margin-top: 45; text-indent: 2; display:none; width:480; height:220;" title="<%= c.string("NetAddrUIHandler.IPXNetworkAddress") %>">
	<table cellspacing="0" cellpadding="2" border="0">
		<tr><td class="mediumtext"><%= c.string("NetAddrUIHandler.Network4bytes") %></td></tr>
		<tr><td><input type=text name="IPXfield1" value="" size=<%= c.string("UI.textboxSize") %> maxlength='8' onBlur='pad(this.form.IPXfield1, 8); validateHex(this.form.IPXfield1, "<%= c.string("UIHandler.OnlyHex") %>");'></td></tr>
		<tr><td class="mediumtext"><%= c.string("NetAddrUIHandler.Node6bytes") %></td></tr>
		<tr><td><input type=text name="IPXfield2" value="" size=<%= c.string("UI.textboxSize") %> maxlength='12' onBlur='pad(this.form.IPXfield2, 12); validateHex(this.form.IPXfield2, "<%= c.string("UIHandler.OnlyHex") %>");'></td></tr>
		<tr><td class="mediumtext"><%= c.string("NetAddrUIHandler.Socket2bytes") %></td></tr>
		<tr><td><input type=text name="IPXfield3" value="" size=<%= c.string("UI.textboxSize") %> maxlength='4' onBlur='pad(this.form.IPXfield3, 4); validateHex(this.form.IPXfield3, "<%= c.string("UIHandler.OnlyHex") %>");'></td></tr>
	</table>
</div>

<div align="left" id="SDLCDiv" style="background-color: White; margin-top: 45; text-indent: 2; display:none; width:480; height:220;" title="<%= c.string("NetAddrUIHandler.SDLCNetworkAddress") %>">
	<table cellspacing="0" cellpadding="2" border="0">
		<tr><td class="mediumtext"><%= c.string("NetAddrUIHandler.CUA2bytes") %></td></tr>
		<tr><td><input type=text name="SDLCfield1" value="" size=<%= c.string("UI.textboxSize") %> maxlength='4' onBlur='pad(this.form.SDLCfield1, 4); validateHex(this.form.SDLCfield1, "<%= c.string("UIHandler.OnlyHex") %>");'></td></tr>
		<tr><td class="mediumtext"><%= c.string("NetAddrUIHandler.BlockID3bytes") %></td></tr>
		<tr><td><input type=text name="SDLCfield2" value="" size=<%= c.string("UI.textboxSize") %> maxlength='6' onBlur='pad(this.form.SDLCfield2, 6); validateHex(this.form.SDLCfield2, "<%= c.string("UIHandler.OnlyHex") %>");'></td></tr>
		<tr><td class="mediumtext"><%= c.string("NetAddrUIHandler.PUID5bytes") %></td></tr>
		<tr><td><input type=text name="SDLCfield3" value="" size=<%= c.string("UI.textboxSize") %> maxlength='10' onBlur='pad(this.form.SDLCfield3, 10); validateHex(this.form.SDLCfield3, "<%= c.string("UIHandler.OnlyHex") %>");'></td></tr>
	</table>
</div>

<div align="left" id="ETHDiv" style="background-color: White; margin-top: 45; text-indent: 2; display:none; width:480; height:220;" title="<%= c.string("NetAddrUIHandler.EthernetTokenRingNetworkAddress") %>">
	<table cellspacing="0" cellpadding="2" border="0">
		<tr><td class="mediumtext"><%= c.string("NetAddrUIHandler.SAP2bytes") %></td></tr>
		<tr><td><input type=text name="ETHfield1" value="" size=<%= c.string("UI.textboxSize") %> maxlength='4' onBlur='pad(this.form.ETHfield1, 4); validateHex(this.form.ETHfield1, "<%= c.string("UIHandler.OnlyHex") %>");'></td></tr>
		<tr><td class="mediumtext"><%= c.string("NetAddrUIHandler.BlockID3bytes") %></td></tr>
		<tr><td><input type=text name="ETHfield2" value="" size=<%= c.string("UI.textboxSize") %> maxlength='6' onBlur='pad(this.form.ETHfield2, 6); validateHex(this.form.ETHfield2, "<%= c.string("UIHandler.OnlyHex") %>");'></td></tr>
		<tr><td class="mediumtext"><%= c.string("NetAddrUIHandler.PUID5bytes") %></td></tr>
		<tr><td><input type=text name="ETHfield3" value="" size=<%= c.string("UI.textboxSize") %> maxlength='10' onBlur='pad(this.form.ETHfield3, 10); validateHex(this.form.ETHfield3, "<%= c.string("UIHandler.OnlyHex") %>");'></td></tr>
	</table>
</div>

<div align="left" id="OSIDiv" style="background-color: White; margin-top: 45; text-indent: 2; display:none; width:480; height:220;" title="<%= c.string("NetAddrUIHandler.OSINetworkAddress") %>">
	<table cellspacing="0" cellpadding="2" border="0">
		<tr><td class="mediumtext"><%= c.string("NetAddrUIHandler.HEXaddress") %></td></tr>
		<tr><td><input type=text name="OSIfield1" value="" size=50 maxlength='256' onBlur='validateHex(this.form.OSIfield1, "<%= c.string("UIHandler.OnlyHex") %>");'></td></tr>
	</table>
</div>

<div align="left" id="APPLEDiv" style="background-color: White; margin-top: 45; text-indent: 2; display:none; width:480; height:220;" title="<%= c.string("NetAddrUIHandler.AppleTalkNetworkAddress") %>">
	<table cellspacing="0" cellpadding="2" border="0">
		<tr><td class="mediumtext"><%= c.string("NetAddrUIHandler.Networkbegin") %></td></tr>
		<tr><td><input type=text name="APPLEfield1" value="" size=<%= c.string("UI.textboxSize") %> maxlength='5' onBlur='validateWholeIntegerField(this.form.APPLEfield1, 0, 65535); this.form.APPLEfield1.value=convertDecToHex(this.form.APPLEfield1.value); pad(this.form.APPLEfield1, 4);'><BR></td></tr>
		<tr><td class="mediumtext"><%= c.string("NetAddrUIHandler.Networkend") %></td></tr>
		<tr><td><input type=text name="APPLEfield2" value="" size=<%= c.string("UI.textboxSize") %> maxlength='5' onBlur='validateWholeIntegerField(this.form.APPLEfield2, 0, 65535); this.form.APPLEfield2.value=convertDecToHex(this.form.APPLEfield2.value); pad(this.form.APPLEfield2, 4);'><BR></td></tr>
		<tr><td class="mediumtext"><%= c.string("NetAddrUIHandler.Hardwareaddress") %></td></tr>
		<tr><td><input type=text name="APPLEfield3" value="" size=<%= c.string("UI.textboxSize") %> maxlength='12' onBlur='validateHex(this.form.APPLEfield3, "<%= c.string("UIHandler.OnlyHex") %>"); pad(this.form.APPLEfield3, 12);'><BR></td></tr>
		<tr><td class="mediumtext"><%= c.string("NetAddrUIHandler.Hardwaretype") %></td></tr>
		<tr><td>
			<select name="HType" size="1" style="width:100; text-indent: 2;">
				<option align="left" class="mediumtext" value="Type3" SELECTED><%= c.string("NetAddrUIHandler.Type3") %></option>
				<option align="left" class="mediumtext" value="Type4"><%= c.string("NetAddrUIHandler.Type4") %></option>
				<option align="left" class="mediumtext" value="Type5"><%= c.string("NetAddrUIHandler.Type5") %></option>
				<option align="left" class="mediumtext" value="Type6"><%= c.string("NetAddrUIHandler.Type6") %></option>
			</select></td>
		</tr>
	</table>
</div>

<div align="left" id="UDPDiv" style="background-color: White; margin-top: 45; text-indent: 2; display:none; width:480; height:220;" title="<%= c.string("NetAddrUIHandler.UDPNetworkAddress") %>">
	<table cellspacing="0" cellpadding="2" border="0">
		<tr>
			<td class="mediumtext"><%= c.string("NetAddrUIHandler.Portnumber") %></td><tr><td><input type=text name="UDPfield0" value="" size=5 maxlength='5' onBlur='validateWholeIntegerField(this.form.UDPfield0, 0, 65535);'></td>
		</tr>
		<tr><td class="mediumtext"><%= c.string("NetAddrUIHandler.IPaddress") %></td>
		<tr><td><input type=text name="UDPfield1" value="" size=5 maxlength='3' onKeyPress='return checkIPField(this, UDPfield2, false, event);'>&nbsp;.&nbsp;
                <input type=text name="UDPfield2" value="" size=5 maxlength='3' onKeyPress='return checkIPField(this, UDPfield3, false, event);'>&nbsp;.&nbsp;
                <input type=text name="UDPfield3" value="" size=5 maxlength='3' onKeyPress='return checkIPField(this, UDPfield4, false, event);'>&nbsp;.&nbsp;
                <input type=text name="UDPfield4" value="" size=5 maxlength='3' onKeyPress='return checkIPField(this, document.getElementById("AddButton"), true, event);'>
        </td></tr>
        
	</table>
</div>

<div align="left" id="TCPDiv" style="background-color: White; margin-top: 45; text-indent: 2; display:none; width:480; height:220;" title="<%= c.string("NetAddrUIHandler.TCPNetworkAddress") %>">
	<table cellspacing="0" cellpadding="2" border="0">
		<tr><td class="mediumtext"><%= c.string("NetAddrUIHandler.Portnumber") %></td><tr><td><input type=text name="TCPfield0" value="" size=5 maxlength='5' onBlur='validateWholeIntegerField(this.form.TCPfield0, 0, 65535);'></td>
		</tr>
		<tr><td class="mediumtext"><%= c.string("NetAddrUIHandler.IPaddress") %></td>
		<tr><td><input type=text name="TCPfield1" value="" size=5 maxlength='3' onKeyPress='return checkIPField(this, TCPfield2, false, event);'>&nbsp;.&nbsp;
                <input type=text name="TCPfield2" value="" size=5 maxlength='3' onKeyPress='return checkIPField(this, TCPfield3, false, event);'>&nbsp;.&nbsp;
                <input type=text name="TCPfield3" value="" size=5 maxlength='3' onKeyPress='return checkIPField(this, TCPfield4, false, event);'>&nbsp;.&nbsp;
                <input type=text name="TCPfield4" value="" size=5 maxlength='3' onKeyPress='return checkIPField(this, document.getElementById("AddButton"), true, event);'>
        </td></tr>
	</table>
</div>

<div align="left" id="UDP6Div" style="background-color: White; margin-top: 45; text-indent: 2; display:none; width:480; height:220;" title="<%= c.string("NetAddrUIHandler.UDP6NetworkAddress") %>">
	<table cellspacing="0" cellpadding="2" border="0">
		<tr>
			<td class="mediumtext"><%= c.string("NetAddrUIHandler.Portnumber") %></td><tr><td><input type=text name="UDP6field0" value="" size=5 maxlength='5' onBlur='validateWholeIntegerField(this.form.UDP6field0, 0, 65535);'></td>
		</tr>
		<tr><td class="mediumtext"><%= c.string("NetAddrUIHandler.IPv6address") %></td>
		<tr><td><input type=text name="UDP6field1" value="" size=41 onKeyPress='return checkIPv6Full(this, document.getElementById("AddButton"), true, event);'>
        </td></tr>
        
	</table>
</div>

<div align="left" id="TCP6Div" style="background-color: White; margin-top: 45; text-indent: 2; display:none; width:480; height:220;" title="<%= c.string("NetAddrUIHandler.TCP6NetworkAddress") %>">
	<table cellspacing="0" cellpadding="2" border="0">
		<tr><td class="mediumtext"><%= c.string("NetAddrUIHandler.Portnumber") %></td><tr><td><input type=text name="TCP6field0" value="" size=5 maxlength='5' onBlur='validateWholeIntegerField(this.form.TCP6field0, 0, 65535);'></td>
		</tr>
		<tr><td class="mediumtext"><%= c.string("NetAddrUIHandler.IPv6address") %></td>
		<tr><td><input type=text name="TCP6field1" value="" size=41 onKeyPress='return checkIPv6Full(this, document.getElementById("AddButton"), true, event);'>
        </td></tr>
	</table>
</div>



<jsp:include page='<%= c.getPath("dev/Bar_inc.jsp") %>' flush="true" />
		<a href="#" name="AddButton" id="AddButton"
			onClick="javascript:addStringAndClose(addrform.selbox);return false">
			<IMG name="AddButtonImg"
			src="<%= c.getModulesUrl() + "/dev/images/" + c.string("Button.Add.image") %>"
			alt="<%= c.string("Button.Add.alt") %>"
			title="<%= c.string("Button.Add.alt") %>" border=0>
		</a> &nbsp;
<a href="#" onClick="javascript:	window.close();return false">
<IMG src="<%= c.getModulesUrl() + "/dev/images/" + c.string("Button.Cancel.image") %>" alt="<%= c.string("Button.Cancel.alt") %>" title="<%= c.string("Button.Cancel.alt") %>" border=0></a>

</form>
</left>
</BODY>
</HTML>