var RIGHTS_COMPARE =     0x00000001;
var RIGHTS_READ =        0x00000002;
var RIGHTS_WRITE =       0x00000004;
var RIGHTS_SELF =        0x00000008;
var RIGHTS_SUPERVISOR =  0x00000020;
var RIGHTS_INHERITABLE = 0x00000040;
var RIGHTS_DYNAMIC =     0x20000000;

var ENTRY_RIGHTS_BROWSE =      0x00000001;
var ENTRY_RIGHTS_ADD =         0x00000002;
var ENTRY_RIGHTS_DELETE =      0x00000004;
var ENTRY_RIGHTS_RENAME =      0x00000008;
var ENTRY_RIGHTS_SUPERVISOR =  0x00000010;
var ENTRY_RIGHTS_INHERITABLE = 0x00000040;
var ENTRY_RIGHTS_DYNAMIC =     0x20000000;

var entryRightsName = ["Browse","Create","Rename","Delete","Supervisor", "Dynamic"];
var entryRightsMask = [ENTRY_RIGHTS_BROWSE, ENTRY_RIGHTS_ADD, ENTRY_RIGHTS_RENAME, ENTRY_RIGHTS_DELETE, ENTRY_RIGHTS_SUPERVISOR, ENTRY_RIGHTS_DYNAMIC];

var attrRightsName = ["Supervisor","Compare","Read","Write","Self", "Dynamic"];
var attrRightsMask = [RIGHTS_SUPERVISOR,RIGHTS_COMPARE,RIGHTS_READ,RIGHTS_WRITE,RIGHTS_SELF, RIGHTS_DYNAMIC];

// Only show the inhert checkbox if target object is container
if(opener.isTargetContainer)
{
   entryRightsMask[entryRightsMask.length] = ENTRY_RIGHTS_INHERITABLE;
   entryRightsName[entryRightsName.length] = "Inherit";

   attrRightsMask[attrRightsMask.length] = RIGHTS_INHERITABLE;
   attrRightsName[attrRightsName.length] = "Inherit";
}

function onInit(priv, attr)
{
   // stupid bit means off if on for [All Attributes Rights]
   if(attr=="[All Attributes Rights]")
   {
      priv ^= RIGHTS_INHERITABLE;  // flip the bit
   }
   else if(attr=="[Entry Rights]")
   {
      priv ^= ENTRY_RIGHTS_INHERITABLE;  // flip the bit
   }
   startingPriv = priv;


   showPrivilages();
   if(priv) updatePrivilages(priv);
}

function onOk()
{
   var subjectName = document.form.subjectName.value;
   if(subjectName==null)
   {
   	  alert(AclNullSubjectWarning);
      return false;
   }
   else
   {
   	  subjectName = iman.trimLeft(subjectName);
  	  subjectName = iman.trimRight(subjectName);
  	  if(subjectName=='')
  	  {
  	  	alert(AclNullSubjectWarning);
  	  	return false;
  	  }
   }

   var attrName = document.form.protectedAttributeName.value;
   
   if(attrName == null || attrName=='')
   {
   	  alert(AclNoPropertySelected);
   	  return false;
   }
   
   var rights = startingPriv;
   var names = attrName == "[Entry Rights]" ? entryRightsName : attrRightsName;
   var masks = attrName == "[Entry Rights]" ? entryRightsMask : attrRightsMask;

   for(var i=0; i < names.length; i++)
   {
   	 if(document.getElementById(names[i])!=null)
   	 {
	      if(document.getElementById(names[i]).checked)
	      {
	         rights |= masks[i];
	      }
	      else
	      {
	         rights &= ~masks[i];
	      }
   	 }
   }

   var priv;
   // stupid bit means off if on for [All Attributes Rights]
   if(attrName=="[All Attributes Rights]")
   {
      priv ^= RIGHTS_INHERITABLE;  // flip the bit
   }
   else if(attrName=="[Entry Rights]")
   {
      priv ^= ENTRY_RIGHTS_INHERITABLE;  // flip the bit
   }


   var subjectName = document.form.subjectName.value;
   var list = [rights, attrName, subjectName];
   var acl = pack(list);

   eval("opener." + returnMethodName + "(\"" + acl + "\")");
   window.close();
}

function updatePrivilages(priv)
{
   var attrName = document.form.protectedAttributeName.value;

   var names = attrName == "[Entry Rights]" ? entryRightsName : attrRightsName;
   var masks = attrName == "[Entry Rights]" ? entryRightsMask : attrRightsMask;

   for(var i=0; i < names.length; i++)
   {
      document.getElementById(names[i]).checked = ((priv & masks[i]) > 0);
   }
}

function addCheckbox(div, label, name)
{
   var cb = document.createElement("INPUT");
   cb.setAttribute("type", "checkbox");
   cb.setAttribute("name", name);
   cb.setAttribute("id", name);
   div.appendChild( cb );

   div.appendChild( document.createTextNode(name) );
   div.appendChild( document.createElement("BR") );
}

function showPrivilages()
{
   var attrName = document.form.protectedAttributeName.value;
   var div = document.getElementById("privilagesDiv");

   while(div.firstChild != null) div.removeChild(div.firstChild);

   var names = attrName == "[Entry Rights]" ? entryRightsName : attrRightsName;
   var masks = attrName == "[Entry Rights]" ? entryRightsMask : attrRightsMask;

   for(var i=0; i < names.length; i++)
   {
      addCheckbox(div, names[i], names[i]);
   }
}