// This file contains javascript used by the ACL Uihandler

function uih_acl(name, uiControl, xmlControl)
{
   var sel = document.getElementById("ACL_Editor");

   var xml = "<attribute>";

   for(var i=0; i<sel.options.length; i++)
   {
      var list = unpack(sel.options[i].value);
      xml += "<value><privileges>"+list[0]+"</privileges><protected-attr-name>"+list[1]+"</protected-attr-name><subject>"+list[2]+"</subject></value>";
   }

   xml += "</attribute>";
   xmlControl.value = xml;
   return true;
}

function openAclPopup(mode, returnMethodName, priv, attr, subj)
{
   var width = 450;
   var height = 550;
   var x = (screen.availWidth-width)/2;
   var y =  (screen.availHeight-height)/3;
   var params = "left="+x+",top="+y+",height="+height+",width="+width+",resizable,scrollbars";
   var url = "webacc?taskId=dev.Empty&merge=fw.ACLEditorPopup&mode="+mode + "&returnMethodName=" + returnMethodName;

   if(mode == "edit")
   {
      url += "&priv=" + priv + "&attr=" + attr + "&subj=" + subj;
   }
   var w = window.open(url,"ACLEditor", params);
}

function addAclItem()
{
   openAclPopup("add", "returnFromAdd");
}

function deleteAclItem()
{
   var sel = document.forms[0].ACL_Editor;
   if(sel.selectedIndex == -1)
   {
   		alert(selectToDel);
   		return;
   }
   sel.options[sel.selectedIndex] = null;
}

function editAclItem()
{
   var sel = document.forms[0].ACL_Editor;
   editingIndex = sel.selectedIndex;
   
   if(editingIndex==-1)
   {
   	  alert(selectToEdit);
   	  return;
   }
   
   var list = unpack(sel.value);
   openAclPopup("edit", "returnFromEdit", list[0], list[1], list[2]);
}

function returnFromAdd(packedAcl)
{
   if(packedAcl==null || packedAcl.length==0) return;

   var list = unpack(packedAcl);
   var displayAcl = list[2] + " - " + list[1]  + " - " + list[0];
   var sel = document.forms[0].ACL_Editor;
   sel.options[sel.options.length] = new Option(displayAcl, packedAcl);
}

function returnFromEdit(packedAcl)
{
   if(editingIndex<0) return;
   if(packedAcl==null || packedAcl.length==0) return;

   var list = unpack(packedAcl);
   var displayAcl = list[2] + " - " + list[1]  + " - " + list[0];
   var sel = document.forms[0].ACL_Editor;
   sel.options[editingIndex] = new Option(displayAcl, packedAcl);
}