// ********************************************************************
// %name:  ModalDialog.js %
// Copyright (c) 2006-2007 Novell, Inc. All Rights Reserved.
// THIS WORK IS AN UNPUBLISHED WORK AND CONTAINS CONFIDENTIAL PROPRIETARY
// AND TRADE SECRET INFORMATION OF NOVELL, INC. ACCESS TO THIS WORK IS
// RESTRICTED TO (I) NOVELL, INC. EMPLOYEES WHO HAVE A NEED TO KNOW HOW
// TO PERFORM TASKS WITHIN THE SCOPE OF THEIR ASSIGNMENTS AND (II)
// ENTITIES OTHER THAN NOVELL, INC. WHO HAVE ENTERED INTO APPROPRIATE
// LICENSE AGREEMENTS. NO PART OF THIS WORK MAY BE USED, PRACTICED,
// PERFORMED COPIED, DISTRIBUTED, REVISED, MODIFIED, TRANSLATED, ABRIDGED,
// CONDENSED, EXPANDED, COLLECTED, COMPILED, LINKED, RECAST, TRANSFORMED
// OR ADAPTED WITHOUT THE PRIOR WRITTEN CONSENT OF NOVELL, INC. ANY USE
// OR EXPLOITATION OF THIS WORK WITHOUT AUTHORIZATION COULD SUBJECT THE
// PERPETRATOR TO CRIMINAL AND CIVIL LIABILITY.
// ********************************************************************


// Global variables.

// Define the dialog tracking variables we need in topmost frame.
ModalDialog_dlgVar_dialogWindow			= null;	//
ModalDialog_dlgVar_ieDisabledElements	= null;	//
ModalDialog_dlgVar_ieLinkOnclicks		= null;	//



// ---------------------------------------------------------------- //
// Called to activate a dialog window whose reference is stored in  //
// ModalDialog_dlgVar_dialogWindow.                                         //
//                                                                  //
// While a dialog window is open, the onfocus event handler of the  //
// main window invokes ModalDialog_activateDialogWindow.                        //
//                                                                  //
// The setTimeout is used to get around a timing issue that trips   //
// up IE/Windows frequently when multiple windows (including        //
// alerts, ...) are used.                                           //
// ---------------------------------------------------------------- //
function ModalDialog_activateDialogWindow()
{
	// Are we tracking an open dialog window?
	if (ModalDialog_isDialogWindowOpen())
	{
		// Yes!  Give it the focus.
		setTimeout( "ModalDialog_activateDialogWindow_Impl()", 50 );
	} // if


	// Return true so that onfocus handling is performed correctly.
	return( true );
} // activateDialogWindow



// ---------------------------------------------------------------- //
// Called to activate a dialog window whose reference is stored in  //
// ModalDialog_dlgVar_dialogWindow.                                         //
// ---------------------------------------------------------------- //
function ModalDialog_activateDialogWindow_Impl()
{
	// Are we tracking an open dialog window?
	if (ModalDialog_isDialogWindowOpen())
	{
		// Yes!  Give it the focus.
		ModalDialog_dlgVar_dialogWindow.focus();
	} // if
} // activateDialogWindow_Impl



// ---------------------------------------------------------- //
// Event handler to inhibit Netscape form element and IE link //
// activity when a dialog window is active.                   //
// ---------------------------------------------------------- //
function ModalDialog_blockedEventHandler()
{
	// Are we tracking an open dialog window?
	if (ModalDialog_isDialogWindowOpen())
	{
		// Yes!  Give it the focus and return false.
		ModalDialog_dlgVar_dialogWindow.focus()
		return( false );
	} // if
} // blockedEventHandler



// ------------------------------------------------------- //
// Block events in the main window while a dialog is open. //
// ------------------------------------------------------- //
function ModalDialog_blockEvents()
{
	// If we can disable the form elements...
	if (ModalDialog_blockEvents_Impl())
	{
		// ...force the focus back to the dialog when the main window
		// ...gets it.
		window.onfocus = ModalDialog_activateDialogWindow;
	} // if
} // blockEvents;



// ---------------------------------------------------------------- //
// Disable form elements and links.                                 //
//                                                                  //
// Grab all Netscape events that might get through to form elements //
// while the dialog is open.  For IE, disable form elements.        //
// ---------------------------------------------------------------- //
function ModalDialog_blockEvents_Impl()
{
	// Are we running on Netscape?
	if(navigator.appName == "Netscape")
	{
		// Yes!  Capture the events we care about...
		window.captureEvents(
			Event.CLICK     |
			Event.MOUSEDOWN |
			Event.MOUSEUP   |
			Event.FOCUS );

		// ...and setup the blockedEventHandler should the window get
		// ...clicked on.
		window.onclick = ModalDialog_blockedEventHandler;


		// If we get here, return true to indicate events were blocked.
		return( true );
	} // if


	// Are we running on IE?
//	if (gCommon_isIE)
	if(navigator.appName == "Microsoft Internet Explorer")
	{
		var	fE;
		var	h;
		var	i;
		var	j;


		// Yes!  Since links in Internet Explorer can't be disabled,
		// we preserve all link's onclick event handlers while they're
		// disabled.  We'll restore them when reenabling the main
		// window.
		//
		// Allocate arrays to hold the Elements we disable and the
		// links whose onclick handler's we capture.
		ModalDialog_dlgVar_ieDisabledElements = new Array();
		ModalDialog_dlgVar_ieLinkOnclicks     = new Array();


		// Scan the frames.
		for (h = 0; h < frames.length; h += 1)
		{
			// Is this a hidden frame?
			if (0 <=  ModalDialog_ciIndexOf( frames[h].name, "HiddenFrame" ))
			{
				// Yes!  Skip it.
				continue;
			} // if


			// Scan this frame's forms...
			for (i = 0; i < frames[h].document.forms.length; i += 1)
			{
				// ...scan this form's Element's.
				for (j = 0; j < frames[h].document.forms[i].elements.length; j += 1)
				{
					// Is this Element a hidden INPUT widget?
					fE = frames[h].document.forms[i].elements[j];
					if (ModalDialog_isInput( fE ) && ModalDialog_isHidden( fE ))
					{
						// Yes!  Then we don't disable it.
						continue;
					} // if


					// Is this Element enabled?
					if (!(fE.disabled))
					{
						// Yes!  Track and disable it.
						ModalDialog_dlgVar_ieDisabledElements[ModalDialog_dlgVar_ieDisabledElements.length] = fE;
						fE.disabled                                                         = true
					} // if
				} // for
			} // for


			// Scan the links...
			for (i = 0; i < frames[h].document.links.length; i += 1)
			{
				// ...tracking each and block onclick events to it.
				fE = frames[h].document.links[i];
				ModalDialog_dlgVar_ieLinkOnclicks[ModalDialog_dlgVar_ieLinkOnclicks.length] =
					new ModalDialog_IELinkOnclick(
						fE,				// Element.
						fE.onclick );	// Original onclick handler.
	         	fE.onclick = ModalDialog_blockedEventHandler;
			} // for
		} // for


		// If we get here, return true to indicate events were blocked.
		return( true );
	} // if


	// If we get here, return false to indicate events were not
	// blocked.
	return( false );
} // blockEvents_Impl



// --------------------------------------- //
// Called when a dialog window is closing. //
// --------------------------------------- //
function ModalDialog_closeDialogWindow()
{
	// Are we tracking an open dialog window?
	if (ModalDialog_isDialogWindowOpen())
	{
		// Yes!  Unblock events into the main window and forget about
		// the dialog.
		ModalDialog_unblockEvents();
		ModalDialog_dlgVar_dialogWindow = null;

		return;
	} // if


	// If we get here, no dialog window was open.  We don't generate an
	// assertion failure, as you might expect, because based on the
	// ordering of things as a dialog window closes, we may get here
	// when it really doesn't matter.
} // closeDialogWindow



// --------------------------------- //
// IELinkOnclick constructor method. //
// --------------------------------- //
function ModalDialog_IELinkOnclick(
	element,	// The link Element whose onclick is being tracked.
	onclick)	// element's onclick handler.
{
	// ...and simply store the parmenters.
	this.m_element = element;
	this.m_onclick = onclick;
} // IELinkOnclick



// -------------------------------------------------------- //
// Returns true if we've got a dialog window open and false //
// otherwise.                                               //
// -------------------------------------------------------- //
function ModalDialog_isDialogWindowOpen()
{
	// Are we tracking a dialog window that's been closed?
	if (ModalDialog_dlgVar_dialogWindow && ModalDialog_dlgVar_dialogWindow.closed)
	{
		var	c;
		var	i;


		// Yes!  Forget about the window.
		ModalDialog_dlgVar_dialogWindow = null;


		// Are we running on IE?
		if(navigator.appName == "Microsoft Internet Explorer")
		{
			// Yes!  Forget about any disabled Elements...
			c = ((null == ModalDialog_dlgVar_ieDisabledElements) ? 0 : ModalDialog_dlgVar_ieDisabledElements.length);
			for (i = 0; i < c; i += 1)
			{
				ModalDialog_dlgVar_ieDisabledElements[i] = null;
			} // for
			ModalDialog_dlgVar_ieDisabledElements = null;

			// ...and forget about any saved onclick handlers.
			c = ((null == ModalDialog_dlgVar_ieLinkOnclicks) ? 0 : ModalDialog_dlgVar_ieLinkOnclicks.length);
			for (i = 0; i < c; i += 1)
			{
				ModalDialog_dlgVar_ieLinkOnclicks[i].m_element = null;
				ModalDialog_dlgVar_ieLinkOnclicks[i].m_onclick = null;
				ModalDialog_dlgVar_ieLinkOnclicks[i]           = null;
			} // for
			ModalDialog_dlgVar_ieLinkOnclicks = null;
		} // if
	} // if


	// Return true if we're still tracking a dialog window.
	return( null != ModalDialog_dlgVar_dialogWindow );
} // isDialogWindowOpen



// -------------------------------------------------------------- //
// Opens a window as a dialog.                                    //
//                                                                //
// If successful, the window opened is returned.  Otherwise, null //
// is returned.                                                   //
// -------------------------------------------------------------- //
function ModalDialog_openDialogWindow(
	dlgURL,			// The URL to open the window with.
	dlgName,		// The name of the window to open.
	dlgFeatures)	// The window features to open the window with.
{
	// Are we already tracking an open dialog window?
	if (ModalDialog_isDialogWindowOpen())
	{
		return( null );
	} // if


	// Can we open the dialog window?
	ModalDialog_dlgVar_dialogWindow = window.open(
		dlgURL,
		dlgName,
		dlgFeatures );

	if (ModalDialog_dlgVar_dialogWindow)
	{
		// Yes!  Block events into the opener.
		ModalDialog_blockEvents();
	} // if


	// If we get here, ModalDialog_dlgVar_dialogWindow refers to the dialog
	// window that we opened or is null.  Return it.
	return( ModalDialog_dlgVar_dialogWindow );
} // openDialogWindow



// ------------------------------------------------------- //
// Unblock events in the main window when a dialog closes. //
// ------------------------------------------------------- //
function ModalDialog_unblockEvents()
{
	// Re-enable the form elements and kill the focus handler.
	ModalDialog_unblockEvents_Impl();
	window.onfocus = null;
} // unblockEvents



// ------------------------------------------------------------- //
// Restore form elements and links to normal behavior.           //
//                                                               //
// As a dialog closes, restores the main window's original event //
// mechanisms.                                                   //
// ------------------------------------------------------------- //
function ModalDialog_unblockEvents_Impl()
{
	// Are we running on Netscape?
	if(navigator.appName == "Netscape")
	{
		// Yes!  Simply release the events we have captured...
		window.releaseEvents(
			Event.CLICK     |
			Event.MOUSEDOWN |
			Event.MOUSEUP   |
			Event.FOCUS );

		// ...and release any window onclick and onfocus handler's we
		// ...set.
		window.onclick = null;
		window.onfocus = null;


		// If we get here, return true to indicate events were
		// unblocked.
		return( true );
	} // if


	// Are we running on IE?
	if(navigator.appName == "Microsoft Internet Explorer")
	{	
		var	c;
		var	i;


		// Yes!  Scan the disabled Element's array...
		c = ((null == ModalDialog_dlgVar_ieDisabledElements) ? 0 : ModalDialog_dlgVar_ieDisabledElements.length);
		for (i = 0; i < c; i += 1)
		{
			// ...enabling each Element that we disabled.
			ModalDialog_dlgVar_ieDisabledElements[i].disabled = false;
			ModalDialog_dlgVar_ieDisabledElements[i]          = null;
		} // for
		ModalDialog_dlgVar_ieDisabledElements = null;


		// Scan the IELinkOnclick's array...
		c = ((null == ModalDialog_dlgVar_ieLinkOnclicks) ? 0 : ModalDialog_dlgVar_ieLinkOnclicks.length);
		for (i = 0; i < c; i += 1)
		{
			// ...restoring each link's onclick handler.
			ModalDialog_dlgVar_ieLinkOnclicks[i].m_element.onclick = ModalDialog_dlgVar_ieLinkOnclicks[i].m_onclick;
			ModalDialog_dlgVar_ieLinkOnclicks[i].m_element         = null;
			ModalDialog_dlgVar_ieLinkOnclicks[i].m_onclick         = null;
			ModalDialog_dlgVar_ieLinkOnclicks[i]                   = null;
		} // for
		ModalDialog_dlgVar_ieLinkOnclicks = null;


		// If we get here, return true to indicate events were
		// unblocked.
		return( true );
	} // if


	// If we get here, return false to indicate events were not
	// unblocked.
	return( false );
} // unblockEvents_Impl



// -------------------------------------------------------------- //
// Use as the onunload handler through windows opened as dialogs. //
// -------------------------------------------------------------- //
function ModalDialog_unloadDialogWindow()
{
	// Is there a closeDialogWindow function to be called?
	if (top.opener &&
	  (!top.opener.closed) &&
	    top.opener.ModalDialog_closeDialogWindow)
	{
//		alert("Closing Dialog...");
		// Yes!  Call it.
		top.opener.ModalDialog_closeDialogWindow();
	} // if
} // unloadDialogWindow

// ----------------------------------------------------------- //
// Performs a case insensitive index of one String in another. //
// ----------------------------------------------------------- //
function ModalDialog_ciIndexOf(
	sContainer,	// The String to check for the index of sContains.
	sContains)	// The String to return the index of in sContainer.
{
	// Do we have a container String to check?
	sContainer = String( sContainer );
	if (!(ModalDialog_hasString( sContainer )))
	{
		// No!  Then it can't contain the contains String.
		return( -1 );
	} // if


	// Do we have a contains String to check?
	sContains = String( sContains );
	if (!(ModalDialog_hasString( sContains )))
	{
		// No!  An empty String matches index 0 of the container.
		return( 0 );
	} // if


	// Convert the Strings to uppercase and check the index.
	sContainer = sContainer.toUpperCase();
	sContains  = sContains.toUpperCase();
	return( sContainer.indexOf( sContains ));
} // ciIndexOf

// ------------------------------ //
// Does a string contain a value? //
// ------------------------------ //
function ModalDialog_hasString(
	sValue)	// Does this string contain a value?
{
	return(
		(null != sValue) &&
		(0    <  sValue.length) );
} // hasString

// --------------------- //
// Is an element hidden? //
// --------------------- //
function ModalDialog_isHidden(
	e)	// Element to check for being hidden.
{
	return( e.type && ("hidden" == e.type) );
} // isHidden



// ------------------------------ //
// Is an element an INPUT widget? //
// ------------------------------ //
function ModalDialog_isInput(
	e)	// Element to check for being an INPUT widget.
{
	return( ModalDialog_isElementTag( e, "INPUT" ));
} // isInput

// -------------------------------- //
// Is an element of a specific tag? //
// -------------------------------- //
function ModalDialog_isElementTag(
	e,	// Element to check for being a specific tag.
	t)	// The tag to check e for.
{
	var	bReply;

	// Were we given an element to check?
	bReply = (null != e);
	if (bReply)
	{
		var	sT;

		// Yes!  Does it have a tagName?
		sT     = e.tagName;
		bReply = ModalDialog_hasString( sT );
		if (bReply)
		{
			// Yes!  Is it the tag in question?
			bReply = ModalDialog_ciEquals( t, sT );
		} // if
	} // if


	// If we get here, bReply is true if e it tag t and false
	// otherwise.  Return it.
	return( bReply );
} // isElementTag

// ---------------------------------------------------- //
// Performs a case insensitive compare of two String's. //
// ---------------------------------------------------- //
function ModalDialog_ciEquals(
	s1,	// The first  String to compare.
	s2)	// The second String to compare.
{
	var	b1;
	var	b2;
	var	bEQ;


	// Do we have both String's or have neither?
	s1  = String( s1 ); b1  = ModalDialog_hasString( s1 );
	s2  = String( s2 ); b2  = ModalDialog_hasString( s2 );
	bEQ = (b1 == b2)
	if (bEQ)
	{
		// Yes!  Do we have them?
		bEQ = (!b1);
		if (!bEQ)
		{
			// Yes!  Are they equal, discounting case?
			bEQ = (s1.toUpperCase() == s2.toUpperCase());
		} // if
	} // if


	// If we get here, bEQ contains true if the String's are equal
	// (discounting case) and false otherwise.  Return it.
	return( bEQ );
} // ciEquals

						   // * * * * * * //
						   // End of File //
						   // * * * * * * //
