/**
* This file contains javascript used by the MultiValued TypedName Uihandler
*
* helps to build XML for Multiple Object Opperations
**/

function uih_multivaluedTypedName(name, uiControl, xmlControl)
{ 
   var sel = document.getElementById("MultiValuedTypedName_Editor");

   var xml = "<attribute "+getMooMode(name)+">";

   for(var i=0; i<sel.options.length; i++)
   {
      var list = unpack(sel.options[i].value);
      var level = Number(list[1]);
      var interval = Number(list[2]);
      
      if(isNaN(level))
      {
         level = 0;
      } 

      if(isNaN(interval))
      {
         interval = 0;
      }
      
      xml += "<value><distinguished-name>"+list[0]+"</distinguished-name><level>"+level+"</level><interval>"+interval+"</interval></value>";
   }

   xml += "</attribute>";
   xmlControl.value = xml;
   return true;
}

function openMVTypedNamePopup(mode, returnMethodName, distinguishedName, level, interval)
{
   var width = 450;
   var height = 450;
   var x = (screen.availWidth-width)/2;
   var y =  (screen.availHeight-height)/3;
   var params = "left="+x+",top="+y+",height="+height+",width="+width+",resizable,scrollbars";
   var url = "webacc?taskId=dev.Empty&merge=fw.MultivaluedTypeNamedEditorPopup&mode="+mode + "&returnMethodName=" + returnMethodName;

   if(mode == "edit")
   {
     url += "&distinguishName=" + distinguishedName + "&level=" + level + "&interval=" + interval;
   }
   var w = window.open(url,"MultiValuedTypedName_Editor", params);
}

function addMVTypedNameItem()
{
   openMVTypedNamePopup("add", "returnFromAdd");
}

function deleteMVTypedNameItem()
{
   var sel = document.forms[0].MultiValuedTypedName_Editor;
    if(sel.selectedIndex == -1){
   		alert(selectToDel);
   		return;
	}else{
	   sel.options[sel.selectedIndex] = null;
    }
}

function editMVTypedNameItem()
{
   var sel = document.forms[0].MultiValuedTypedName_Editor;
   editingIndex = sel.selectedIndex;
  
   if(editingIndex == -1){
   	alert(selectToEdit);
   	return;
   }
  
   var list = unpack(sel.value);
   openMVTypedNamePopup("edit", "returnFromEdit", list[0], list[1], list[2]);
}

function returnFromAdd(packedMVPath)
{
   if(packedMVPath==null || packedMVPath.length==0) return;

   var list = unpack(packedMVPath);
   var displayMVPath = list[0] + " - " + list[1] + " - " + list[2];
   var sel = document.forms[0].MultiValuedTypedName_Editor;
   sel.options[sel.options.length] = new Option(displayMVPath, packedMVPath);
   sel.options[sel.options.length-1].value = packedMVPath;
}

function returnFromEdit(packedMVPath)
{
   if(editingIndex<0) return;
   if(packedMVPath==null || packedMVPath.length==0) return;

   var list = unpack(packedMVPath);
   var displayMVPath = list[0] + " - " + list[1] + " - " + list[2];
   var sel = document.forms[0].MultiValuedTypedName_Editor;
   sel.options[editingIndex] = new Option(displayMVPath, packedMVPath);
   //displayMVPath = list[0] + " - " + list[1]  + " - " + list[2];
   sel.options[editingIndex].value = packedMVPath;
}