


//=================================== Methods for Left Boxes =====================================


// Colors for right boxes
var COLOR_HL       = "#e0e0e0";
var COLOR_NHL      = "#f5f5f5";
var COLOR_SEL      = "#a0a0a0";
var COLOR_TEXT     = "#000000";
var COLOR_TEXT_SEL = "#ffffff";

var addedAttributeCount = 0;

// Other Globals
var lastRow = null; // used for unselect last row


var isIE = navigator.userAgent.indexOf("MSIE") > -1;

if(isIE)
{
   psPopup = window.createPopup();
   var popStyle = psPopup.document.body.style;
   popStyle.cursor = "default";
   popStyle.backgroundColor = "white";
   popStyle.border = "1 solid black";
   popStyle.fontSize = "11px";
   popStyle.fontFamily = '"Trebuchet MS", Arial, Helvetica';
   //psPopup.document.body.title = window.rc_mvieToolTip;
}
 

function getSrcRow(event)
{
   if(!event) event = window.event;
   return getSrc(event, "TR")
}

function sel(event)
{
   if(doingDragDrop) return;
   var row = getSrcRow(event);

   if(row.bgColor!=COLOR_SEL)
   {
      row.bgColor = COLOR_HL;
      row.style.color = COLOR_TEXT;
   }
}

function unsel(event)
{
   if(doingDragDrop) return;
   var row = getSrcRow(event);

   if(row.bgColor==COLOR_HL)
   {
      row.bgColor = COLOR_NHL;
      row.style.color = COLOR_TEXT;
   }
}

function toggleRow(event)
{
   if(doingDragDrop) return;
   var row = getSrcRow(event);

   if(lastRow != null)
   {
      lastRow.bgColor = COLOR_NHL;
      lastRow.style.color = COLOR_TEXT;
   }

   row.bgColor = COLOR_SEL;
   row.style.color = COLOR_TEXT_SEL;
   lastRow = row;
}


//============================= Methods for Drag N Drop (right side) =================================

// Colors for left box
var COLOR_BAR    = "#000000";
var COLOR_BAR_HL = "#ff0000";
var COLOR_ROW    = "#ffffff";
var COLOR_ROW_HL = "#cccccc";

// Other globals
var d=document;               // convience
var doingDragDrop = false;    // ignore mouseovers when doing drag drop
var setDragMark=true;
var setDragScroll=true;
var sideSpace=3;
var sideSpaceGutter=0;
var cX,cY;
var oldElement = null;
var rowDragged = null;
var destination = null;

function initDragDrop()
{
   this.ie4 = document.all && !document.getElementById;
   this.ns4 = document.layers;
   this.ie5 = this.ie6 = document.all && document.getElementById;
   this.ns6 = document.getElementById && !document.all;

   winObj=null;
   //d.onclick=handleClicks;
   d.onmousedown=startDrag;
   d.onmousemove=doDrag;
   d.onmouseup=release;
   d.onkeypress=keyRelease;

   //Set global size values
   browserWidth=d.body.clientWidth;
   browserHeight=d.body.clientHeight;
   yScroll=browserHeight/2-(browserHeight/3);
   widgetWidth=parseInt((browserWidth-sideSpace*2-9)/2);
   sideSpaceGutter=0;
}


function keyRelease(event)
{
   if(!event) event = window.event;

   var keyCode = event.keyCode;
   if(keyCode==27 && winObj)
   {
      exitDragMode();
   }
}

// Called onmousedown
function startDrag(event)
{
   if(!event) event = window.event;
  
   var targetNodeObject = getSrcNode(event);

   if(!isIE && ('undefined' != targetNodeObject && targetNodeObject.id != 'changeControlBox_Scroll_Id' ))
   {
      document.getElementById("changeControlBox").style.display="none";
   }


   rowDragged = getSrc(event, "TR");


   var srcId = "";
   if(event.srcElement && event.srcElement.id)
   {
      srcId = event.srcElement.id;
   }
   else if(event && event.target && event.target.id && event.target.id!="")
   {
      srcId = event.target.id;
   }

   //if(srcId==""){return;}


   if(srcId.indexOf("xBtn_") != -1)
   {
      removeAttribute(event);

      // non-movable element
      winObj=null;
      return false;
   }
   else if(srcId.indexOf("disabledButton_") != -1)
   {
      alert(window.rc_requiredField);
      return false;
   }
   else if(srcId.indexOf("editBtn_") != -1)
   {
      var attrName = srcId.substring(8, srcId.length);
      var xml = selectedFields[attrName].m_controlXml;

      var x = window.screenLeft + (window.document.body.clientWidth-550)/2;
      var y = window.screenTop + (window.document.body.clientHeight-400)/2 - 100;

      var objectTypeName = document.pluginProperties.objectTypeNameReg.value;
      var params = "left="+x+",top="+y+",height=550,width=850,resizable,scrollbars";
      //window.open('webacc?taskId=fw.Create iManager Task&nextState=attributeDetails&merge=fw.Studio_params&attributeName='+attrName+'&xml=' + xml + '&objectTypeName='+objectTypeName,"controlParams",params);
      window.open("","controlParams",params);

      var form = document.controlPropertiesForm;
      form.attributeName.value = attrName;
      form.xml.value = xml;
      form.objectTypeName.value = objectTypeName;
      form.submit();



      // non-movable element
      winObj=null;
      return false;
   }
   else if(srcId.indexOf("changeBtn_") != -1)
   {
      var attrName = srcId.substring(10, srcId.length);
      var controlNames = unpack(attrInfoMap[attrName].m_controlNames);
      var controlIds = unpack(attrInfoMap[attrName].m_controlIds);

      var str = "<DIV id='changeControlBox_Scroll_Id' style='height:120px; overflow:auto'><TABLE width='100%'>";

      if(!isIE)
      {
         str += "<TR class=\"formhead1\"><TD>"+window.rc_changeControlTo+"</TD></TR>";
      }

      for(var i=0; i<controlNames.length; i++)
      {
         if(isIE)
            str += "<TR onmousedown=\"parent.changeControl('"+ controlIds[i] +"', '"+ attrName +"'); parent.psPopup.hide()\"><TD style='font-size:11px'>" + controlNames[i] + "</TD></TR>";
         else
            str += "<TR onmousedown=\"changeControl('"+ controlIds[i] +"', '"+ attrName +"'); document.getElementById('changeControlBox').style.display='none'\"><TD style='font-size:11px'>" + controlNames[i] + "</TD></TR>";
      }
      str += "</TABLE></DIV>";


      if(isIE)
      {
         psPopup.document.body.innerHTML = str;
         psPopup.show(0, 20, 150, 120, event.srcElement);
      }
      else
      {
         var box = d.getElementById("changeControlBox");
         box.style.display = "block";
         box.style.left = event.clientX;
         box.style.top = event.clientY;
         box.innerHTML = str;
      }

      // non-movable element
      winObj=null;
      return false;
   }
   else if(!rowDragged | !rowDragged.id || rowDragged.id.indexOf("move_")==-1)
   {
      // non-movable element
      winObj=null;
      return true;
   }

   rowDragged.bgColor = COLOR_ROW_HL;
   doingDragDrop = true;

   orgLeft=offsetX=event.clientX;
   if (event.clientX>(widgetWidth+sideSpace+sideSpaceGutter))
   {
      orgLeft=event.clientX-widgetWidth-sideSpace-sideSpaceGutter;
   }
   offsetY=event.clientY+d.body.scrollTop;

   // Move box with mouse
   winObj=d.getElementById('winDrag').style;
   winObj.left = event.clientX-orgLeft+sideSpace*2+sideSpaceGutter;
   winObj.top = offsetY;
   winObj.width=widgetWidth;
   winObj.height=25;
   winObj.display="";
   return false;
}

function doDrag(event)
{
   if(!event){event = window.event}

   if (winObj)
   {
      cX=event.clientX;
      cY=event.clientY;

      winObj.left=event.clientX-orgLeft+sideSpace*2+sideSpaceGutter
      winObj.top=event.clientY+d.body.scrollTop+2;

      if (cY<10||cY>browserHeight-10||cX<10||cX>browserWidth-10)
      {
         winObj.display="none";
         winObj=null;
         //alert(dragErr); tell user not to drag off screen
         setDragScroll=true;
         return false;
      }

      if (setDragScroll)
      {
         setDragScroll=false;
         scrollIt();
      }

      if (setDragMark&&setDragScroll)
      {
         dragMarker(event);
      }

      //prevent further system response to dragging
      return false;
   }
}

function scrollIt()
{
   if (winObj && (cY>browserHeight-yScroll&&d.body.scrollTop+browserHeight<d.body.scrollHeight)||(cY<yScroll+50&&d.body.scrollTop!=0))
   {
      yInt=25;
      if (cY<yScroll+50)
      {
         yInt=-25;
      }

      winObj.display="none";
      scrollBy(0,yInt);
      winObj.display="";
      setTimeout("scrollIt()",5);
      winObj.display="";
   }
   else
   {
      setDragScroll=true;
   }
}

function getSrcNode(event)
{
   var node = null;

   if(event.srcElement)
   {
      node = event.srcElement;
   }
   else
   {
      node = event.target;
   }
 
   return node;
}


function getSrc(event, tagName)
{
   var node = null;

   if(event.srcElement)
   {
      node = event.srcElement;
   }
   else
   {
      node = event.target;
   }

   if(tagName && node!=null)
   {
      while((!node.tagName || node.tagName != tagName) && node.parentNode)
      {
         if(node.tagName && node.tagName=="body")
         {
            return null;
         }

         node = node.parentNode;
      }
   }

   return node;
}


// doesn't work in NN
// doesn't work in NN on MyNetscape.com
// event doesn't tell us what td we are over
function dragMarker(event)
{
   var node = getSrc(event, "TR");

   if(!node || !node.id || (node.id.indexOf("drop")==-1 && node.id.indexOf("move")==-1 && node.id.indexOf("firstRow")==-1))
   {
      return;
   }

   if(node.id.indexOf("move")!=-1 || node.id.indexOf("firstRow")!=-1)
   {
      node = node.nextSibling;
   }

   if(oldElement != null)
   {
      oldElement.bgColor = oldColor;
      oldElement.height = "1px";
   }

   oldColor = node.bgColor;
   oldElement = node;
   node.bgColor = COLOR_BAR_HL; //"#000000";
   node.height = "5px";

   destination = node;

   setDragMark=false;
   setTimeout("setDragMark=true",10);//limit the invocation rate of this function
   return false;
}

function release(event)
{
   if(destination==null || (destination.previousSibling && destination.previousSibling==rowDragged))
   {
      exitDragMode();

      if(oldElement)
      {
         oldElement.bgColor = oldColor;
         oldElement.height = "1px";
      }

      return;
   }

   // Move Row
   var parent = rowDragged.parentNode;
   var bar = rowDragged.nextSibling;

   parent.removeChild(bar);
   parent.removeChild(rowDragged);

   if(oldElement != null)
   {
      oldElement.bgColor = oldColor;
      oldElement.height = "1px";
   }


   parent.insertBefore(bar, destination);
   parent.insertBefore(rowDragged, destination);

   exitDragMode();
}

function exitDragMode()
{
   doingDragDrop = false;
   setDragScroll=true;

   if(oldElement != null)
   {
      oldElement.bgColor = oldColor;
   }

   if(rowDragged!=null)
   {
      rowDragged.bgColor = COLOR_ROW;
      rowDragged = null;
   }

   if(destination != null)
   {
      destination.bgColor = COLOR_BAR;
      destination = null;
   }

   if(winObj)
   {
      winObj.display = "none";
      winObj=null;
   }
}

// For Debugging DOM
function printTree(node, indent)
{
   if(!indent){indent = "";}
   var str = indent + "[" + node.nodeName + "," + node.tagName + "," + node.id + "]\n";
   for(var i=0; i<node.childNodes.length; i++){str += printTree(node.childNodes[i], indent + "   ");}
   return str;
}


function PluginField(attributeName, controlId, controlXml)
{
   this.m_attributeName = attributeName;
   this.m_controlId = controlId;
   this.m_controlXml = controlXml;
}

function addSelectedField(table, attrName, controlId, controlXml, isMandatory)
{
   addedAttributeCount++;
   selectedFields[attrName] = new PluginField(attrName, controlId, controlXml);


   // label of control
   var row = table.insertRow(table.rows.length);
   var cell = row.insertCell(0);
   cell.appendChild(document.createTextNode(attrInfoMap[attrName].m_displayName));
   row.className = "nitem";
   row.id = "move_" + attrName;

   // image of control
   var pictureCell = row.insertCell(1);
   pictureCell.id = "ctrlTd_" + attrName;
   var gifName = controlId.substring(controlId.indexOf(".")+1, controlId.length);
   var img = document.createElement("IMG");
   img.src = filePathMap[gifName];
   pictureCell.appendChild(img);
   img.id = "controlImage_" + attrName;

   // Buttons (params & remove)
   var pictureCell = row.insertCell(2);
   pictureCell.noWrap = "true";
   pictureCell.align = "right";


   var allMandatoryParamsValued = areAllMandatoryParamsValued(selectedFields[attrName].m_controlXml);
   var imageName = (!allMandatoryParamsValued ? "viewdetails_warn.gif" : "viewdetails.gif");
   var altText = (!allMandatoryParamsValued ? window.rc_enterRequiredParams : window.rc_modifyParams);

   pictureCell.appendChild(makeButton("editBtn_" + attrName, "dev", imageName, altText));
   pictureCell.appendChild(document.createTextNode(" "));
   pictureCell.appendChild(makeButton("changeBtn_" + attrName, "dev", "drop_down.gif", window.rc_changeControl));
   pictureCell.appendChild(document.createTextNode(" "));

   if(isMandatory)
   {
      pictureCell.appendChild(makeButton("disabledButton_" + Math.random(), "dev", "delete16.gif", window.rc_removeField));
   }
   else
   {
      pictureCell.appendChild(makeButton("xBtn_" + Math.random(), "dev", "delete16.gif", window.rc_removeField));
   }


   // dividing bar
   var row = table.insertRow(table.rows.length);
   var cell = row.insertCell(0);
   row.id = "drop_" + Math.random();
   cell.colSpan = "3";
   cell.innerHTML='<hr style="background-color: #000000;"> ';
   
   if(window.event)
   {
      window.event.cancelBubble = true;
   }

   return false;
}



var paramValues = new Array();

function changeControl(controlId, attrName)
{
   var attrInfo = attrInfoMap[attrName];
   var ids = unpack(attrInfo.m_controlIds);
   var controlXml = null;

   for(var i=0; i<ids.length; i++)
   {
      if(ids[i] == controlId)
      {
         controlXml = unpack(attrInfo.m_controlXmls)[i];
      }
   }

   //----------------------------------
   // Persistant values across controls
   //----------------------------------
   var oldControl = parseXml(selectedFields[attrName].m_controlXml);
   var newControl = parseXml(controlXml);

   if(paramValues[attrName] == null)
   {
      paramValues[attrName] = new Array(); 
   }

   // Save off values from old control
   for(var i=0; i<oldControl.children.length; i++)
   {
      var paramName = oldControl.children[i].getAttributeValue("name");
      paramValues[attrName][paramName] = oldControl.children[i].children;
   }

   // Replace new values with old values
   for(var i=0; i<newControl.children.length; i++)
   {
      var paramName = newControl.children[i].getAttributeValue("name");
      var oldValue = paramValues[attrName][paramName];
      if(oldValue!=null && newControl.children[i].getAttributeValue("changeable")=="true")
      {
         newControl.children[i].children = oldValue;
      }
   }

   controlXml = newControl.toString();


   // change data
   selectedFields[attrName] = new PluginField(attrName, controlId, controlXml);

   // change control image
   var gifName = controlId.substring(controlId.indexOf(".")+1, controlId.length);
   var newImg = document.createElement("IMG");
   newImg.src = filePathMap[gifName];
   newImg.id = "controlImage_" + attrName;
   var oldImg = document.getElementById("controlImage_" + attrName);

   var td = document.getElementById("ctrlTd_" + attrName);
   td.replaceChild(newImg, oldImg);


   // Update image (for mandatory attributes)
   var allMandatoryParamsValued = areAllMandatoryParamsValued(controlXml);
   var imageName = (!allMandatoryParamsValued ? "viewdetails_warn.gif" : "viewdetails.gif");
   var altText = (!allMandatoryParamsValued ? window.rc_enterRequiredParams : window.rc_modifyParams);

   var element = document.getElementById("editBtn_"+attrName);
   element.src = "/nps/portal/modules/dev/images/" + imageName;
   element.alt = altText;
}


// helper
// Discover if all params a valued
// This would be much easier if we had a decent xml parser to use
function areAllMandatoryParamsValued(controlXml)
{
   var allMandatoryParamsValued = true;
   var index = controlXml.indexOf("required=\"true\"");
   while(index > 0)
   {
      // move index to end if opening param tag <param ... required="true" ...>
      // index = controlXml.indexOf(">", index);
      //Bug -136737, instead of '>' better to get index for '<', 'coz you can have '\n', spaces between '>' and '<', which is causing this bug
      index = controlXml.indexOf("<", index);

      // what is after the opening tag
      var nextTag = controlXml.substring(index, index+7);
      if(nextTag!="<value>")
      {
         allMandatoryParamsValued = false;
      }

      // moved index to next required param
      index = controlXml.indexOf("required=\"true\"", index);
   }

   return allMandatoryParamsValued;
}


function makeButton(id, module, gifName, altText)
{
   var img = document.createElement("IMG");
   img.src = "/nps/portal/modules/" + module + "/images/" + gifName;
   img.id = id;
   img.alt = altText;
   img.title = altText;
   return img;
}

function removeAttribute(event)
{
   addedAttributeCount--;
   if(!event) event = window.event;
   var node = getSrc(event, "TR");

   var attrName = node.id.substring(5, node.id.length);
   selectedFields[attrName] = null;

   node.parentNode.removeChild(node.nextSibling);
   node.parentNode.removeChild(node);

   var row = d.getElementById("attr_" + attrName);
   row.className = "nitem";
   row.cells[1].childNodes[0].style.color = "#000000";

   paramValues[attrName] = null;

   // refresh the Controls selection box
   showControls(selectedAttribute);
}


//===================================  =====================================




// Double clicked on attribute (used default control)
function addDefaultControl(index)
{
   addDefaultControlImpl(availableAttributes[index], false, null);
}


function addDefaultControlImpl(attrSafeName, isMandatory, controlId)
{
   var plugin = selectedFields[attrSafeName];
   if(plugin == null)
   {
      var attrInfo = attrInfoMap[attrSafeName];
      var controlIds = unpack(attrInfo.m_controlIds);
      var controlXmls = unpack(attrInfo.m_controlXmls);


      if(controlId==null)
      {
         // for mandatory we just want to use the default control
         addSelectedField(document.getElementById("items"), attrSafeName, controlIds[0], controlXmls[0], isMandatory);
      }
      else
      {
         // for copy plugin; we don't want to use just the first control
         var index = 0;
         for(var i=0; i<controlIds.length; i++)
         {
            if(controlId == controlIds[i])
            {
               index = i;
            }
         }

         addSelectedField(document.getElementById("items"), attrSafeName, controlIds[index], controlXmls[index], isMandatory);
      }


      var row = document.getElementById("attr_" + attrSafeName);
      row.className = "nonclickable";
      row.cells[1].childNodes[0].style.color = "#aaaaaa";
      clearTable(document.getElementById("ControlsTable"));
   }
}


// Double clicked on Control (lower right box)
function addAttribute(event)
{
   if(!event) event = window.event;

   var attrSafeName = availableAttributes[selectedAttribute];
   var attrInfo = attrInfoMap[attrSafeName];

   var plugin = selectedFields[attrSafeName];
   if(plugin == null)
   {
      var row = d.getElementById("attr_" + attrSafeName);
      row.cells[1].childNodes[0].style.color = "#aaaaaa";
      row.className = "nonclickable";

      var id = getSrc(event, "TR").id;
      if(id.substring(0, 4)!="row_") return;

      // Use the id (ex: cell_4) to get an index into the control list
      var index = Number(id.substring(6, id.length-1));

      var attrInfo = attrInfoMap[attrSafeName];
      var controlIds = unpack(attrInfo.m_controlIds);
      var controlXmls = unpack(attrInfo.m_controlXmls);

      addSelectedField(document.getElementById("items"), attrSafeName, controlIds[index], controlXmls[index], false);

      clearTable(document.getElementById("ControlsTable"));
   }
}


// single click on attribute, show available controls
function showControls(index)
{
   if(!index || index<0)
   {
      return;
   }

   var attrSafeName = availableAttributes[index];
   var table = document.getElementById("ControlsTable");

   var plugin = selectedFields[attrSafeName];
   if(plugin == null)
   {
      var attrInfo = attrInfoMap[attrSafeName];
      currentControlNames = unpack(attrInfo.m_controlNames);
      currentControlIds = unpack(attrInfo.m_controlIds);


      if(currentControlNames==null || currentControlNames.length==0)
      {
         alert("There are not controls available");
         return false;
      }



      selectedAttribute = index;

      //remove old rows
      while(table.rows.length>0)
      {
         table.deleteRow(0);
      }


      // add new rows
      for(var i=0; i < currentControlNames.length; i++)
      {
         var row = table.insertRow(table.rows.length);
         var cell = row.insertCell(0);

         cell.appendChild(document.createTextNode(currentControlNames[i]));
         cell.id = "cell_" + i;

         row.onclick = ignoreClick;
         row.className = "nitem";
         row.onmouseover = sel;
         row.onmouseout = unsel;
         row.id = "row_" + i;
         //row.setAttribute("id", "row_" + i);
         row.ondblclick = addAttribute;
      }

      // To take up extra space
      var cell = table.insertRow(table.rows.length).insertCell(0);
      cell.height = "100%";
   }
   else
   {
      clearTable(table);
   }

   return false;
}


function clearTable(table)
{
   // remove old rows
   while(table.rows.length>0)
   {
      table.deleteRow(0);
   }
}

function ignoreClick()
{
   return false;
}


// DOM way
function addRow(table, text)
{
   var tr = document.createElement("TR");
   var td = document.createElement("TD");
   td.appendChild(document.createTextNode(text));
   tr.appendChild(td);
   table.appendChild(tr);
}


function gatherData()
{
   var attributeNames = new Array();
   var controlIds = new Array();
   var controlXmls = new Array();


   var rows = document.getElementById("items").rows;
   var j=0;
   for(var i=0; i<rows.length; i++)
   {
      var id = rows[i].id;

      if(id.indexOf("move_") != -1)
      {
         var key = id.substring(5, id.length);
         attributeNames[j] = key;
         controlIds[j] = selectedFields[key].m_controlId;
         controlXmls[j] = selectedFields[key].m_controlXml;
         j++;

         if(document.getElementById("editBtn_" + key).src.indexOf("warn") != -1)
         {
            alert(window.rc_mustEnterParams);
            return false;
         }
      }
   }


   document.pluginProperties.attributeNames.value = pack(attributeNames);
   document.pluginProperties.attributeHandlerXmls.value = pack(controlXmls);
   document.pluginProperties.attributeHandlerIds.value = pack(controlIds);
   return true;
}

function copyName()
{
   document.pluginProperties.displayName.value = document.pluginProperties.pluginName.value;
}

var safeChars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ01234567890";
function getSafeName(str)
{
   if(str==null || str.length==0)
   {
      return str;
   }

   var result = "";
   for(var i=0; i < str.length; i++)
   {
      var ch = str.charAt(i);
      result += (safeChars.indexOf(ch) != -1 ? ch : "_");
   }

   return result;
}

function init()
{
   doLayout();
   initDragDrop();

   for(var i=0; i < initialAttrs.length; i++)
   {
      var isMandatory = mandatoryAttrs[initialAttrs[i]] == "true";
      addDefaultControlImpl(initialAttrs[i], isMandatory, initialFieldsMap[initialAttrs[i]]);
   }
}

function preview()
{
   var ok = gatherData();
   if(ok)
   {
      document.pluginProperties.nextState.value = "doPreview";
      document.pluginProperties.merge.value = "fw.GoUrl";

      var objectTypeNames = unpack(document.pluginProperties.objectTypeNameReg.value);
      var objectTypeName = urlEncode(objectTypeNames[0]);
      var safeName = getSafeName(objectTypeNames[0]);

      document.pluginProperties.nextUrl.value = "webacc?mode="+window.var_pluginType+"&taskId=dev.Empty&merge=fw.TemplateBuilder_previewFrameset&objectTypeName=" + objectTypeName + "&safeObjectTypeName="+safeName+"&parentId=" + window.var_taskId;
      document.pluginProperties.target = "previewWindow";
      document.pluginProperties.submit();
   }
}

function pagePreview()
{
   var ok = gatherData();
   if(ok)
   {
      document.pluginProperties.nextState.value = "doPreview";
      document.pluginProperties.merge.value = "fw.GoUrl";
      document.pluginProperties.nextUrl.value = "webacc?mode="+window.var_pluginType+"&taskId=dev.Empty&merge=fw.TemplateBuilder_previewFrameset&objectTypeName=" + objectTypeName + "&parentId=" + window.var_taskId;
      document.pluginProperties.target = "previewWindow";
      document.pluginProperties.submit();
   }
}


function setBounds(id, top, left, width, height)
{
   var div = document.getElementById(id);
   div.style.top = top;
   div.style.left = left;

   if(width>=0)
   {
      div.style.width = width;
   }

   if(height>=0)
   {
      div.style.height = height;
   }

   div.style.visibility = "visible";
}

function setSubBounds(id)
{
   var contentHeight = parseInt(document.getElementById(id).style.height) - document.getElementById(id + "Title").offsetHeight;
   if(contentHeight>=0)
   {
      document.getElementById(id + "Content").style.height = contentHeight;
   }
}

function doLayout()
{
   var yStart = document.getElementById("title").offsetHeight;
   var margin = 15;
   var width = document.body.clientWidth - 3*margin;
   var height = document.body.clientHeight - 3*margin - yStart - 10;
   var width2 = 250;    // width of col 2
   var width1 = width - width2;    // width of col 1

   var height2 = 170;  // height of row 2
   var height1 = height - height2;  // height of row 1

   setBounds("topLeft", yStart + margin, margin, width1, height1);
   setBounds("topRight", yStart + margin, width1 + 2*margin, width2, height1);
   setBounds("bottomLeft", yStart + height1 + 2*margin, margin, width1, height2);
   setBounds("bottomRight", yStart + height1 + 2*margin, width1 + 2*margin, width2, height2);

   setSubBounds("topLeft");
   setSubBounds("topRight");
   setSubBounds("bottomLeft");
   setSubBounds("bottomRight");
}


function changeXml(paramToChange, value)
{
   for(name in selectedFields)
   {
      if(name && selectedFields[name])
      {
         var root = parseXml(selectedFields[name].m_controlXml);

         for(var i=0; i < root.children.length; i++)
         {
            var paramName = root.children[i].getAttributeValue("name");
            var changeable = root.children[i].getAttributeValue("changeable");

            if(paramName==paramToChange && changeable=="true")
            {
               root.children[i].children[0] = new XmlElement("value", value);
            }
         }

         selectedFields[name].m_controlXml = root.toString();
      }
   }
}

function makeAllMandatory()
{
   changeXml("mandatory", "true");
}

function makeAllReadOnly()
{
   changeXml("readOnly", "true");
}
