//===================================================
// TimeRestrictions.js
// Shared - for Time Restriction Table
//===================================================

function uih_timegrid(name, uiControl, xmlControl)
{
   xmlControl.value = "<attribute "+ getMooMode(name) + "><value>" + calculateSubmittedRestriction() + "</value></attribute>";
   return true;
}

function doSelectObject(obj, altMode)
{
   var strClass = document.getElementById("rb1").checked ?  "restricted" : "available";

   indx = obj.id.replace('RD','');
   if (altMode || rangeMode)
   {
      if (!rangeMode)
      {
         rangeMode = true;
         rangeStart = indx;
         setCellClass(indx, strClass);
      }
      else
      {
         selectEntryRange(rangeStart, indx);
         //redisplayRowColors();
         //top.SelectedObjectsTitle.displaySelectedObjects();
         rangeMode = false;
         lastRow = -1;
         rangeStart = -1;
      }
   }
   else
   {
      setCellClass(indx, strClass);
   }
}

function setCellClass(index, className)
{
   document.getElementById('RD' + index).className = className;
}

function selectEntryRange(start,stop)
{
   var strClass = document.getElementById("rb1").checked ?  "restricted" : "available";

   startDay = Math.floor(start / 48);
   stopDay = Math.floor(stop / 48);
   start = start % 48;
   stop = stop % 48;

   if (stop<start)
   {
      tmp = stop;
      stop = start;
      start = tmp;
   }

   if (stopDay<startDay)
   {
      tmp = stopDay;
      stopDay = startDay;
      startDay = tmp;
   }

   for (day=startDay ; day<=stopDay; day++)
   {
      for (i=start; i<=stop; i++)
      {
         setCellClass(i + day * 48, strClass);
      }
   }
}

function setSelectionColors(obj)
{
   if (rangeMode)
   {
      row = obj.id.replace('RD','');
      selectEntryRange(rangeStart, row);
   }
}

function resetSelectionColors(obj)
{
   if(!rangeMode) return;

   var indx;

   start = rangeStart;
   stop = obj.id.replace('RD','');

   startDay = Math.floor(start / 48);
   stopDay = Math.floor(stop / 48);
   start = start % 48;
   stop = stop % 48;

   if (stop<start)
   {
      tmp = stop;
      stop = start;
      start = tmp;
   }

   if (stopDay<startDay)
   {
      tmp = stopDay;
      stopDay = startDay;
      startDay = tmp;
   }

   for (day = startDay; day <= stopDay; day++)
   {
      for (i=start; i<=stop; i++)
      {
         indx = day * 48 + i;
         if (currentTimeMap.charAt(indx) == '1')
            document.getElementById('RD' + indx).className = "restricted";
         else
            document.getElementById('RD' + indx).className = "available";
      }
   }
}

function init508TimeRestrictions()
{
   var form = document.forms[0];
   form.SUNDAYTB.value = get508TimeRestrictions(0);
   form.MONDAYTB.value = get508TimeRestrictions(1);
   form.TUESDAYTB.value = get508TimeRestrictions(2);
   form.WEDNESDAYTB.value = get508TimeRestrictions(3);
   form.THURSDAYTB.value = get508TimeRestrictions(4);
   form.FRIDAYTB.value = get508TimeRestrictions(5);
   form.SATURDAYTB.value = get508TimeRestrictions(6);
}

function resetTimeRestrictions()
{
   currentTimeMap = originalTimeMap;
   drawTimeRestrictionsTable();
}

function print508TimeRestrictions(d)
{
   currentTimeMap = document.forms[0].eDir$target$Login_Allowed_Time_Map.value;
   document.write(get508TimeRestrictions(d));
}

function get508TimeRestrictions(day)
{
   var result = "";
   daySubstring = currentTimeMap.substring(day*48, day*48+48) + '0';
   i = 0;
   j = 0;

   while (1)
   {
      i = j;
      i = j = daySubstring.indexOf('1', i);
      j = daySubstring.indexOf('0', i);
      if (i < 0 || j < 0) break;
      result = result + getMappedTimeString(i) + '-' + getMappedTimeString(j) + ', ';
   }

   result = result.substring(0, result.length - 2);
   return result;
}

function getMappedTimeString(i)
{
   if (i == 48)
      return timeTable[0];
   else
      return timeTable[i];
}

function calculateSubmittedRestriction()
{
   var result ="";
   for (i=0; i<336; i++)
   {
      if (document.getElementById('RD' + i).className == "restricted")
         result = result + "1"
      else
         result = result + "0";
   }
   return result;
}
