//
// Launch Menu Tree code
// 

// Portions Copyright (c) 2001, Morten Wang & contributors
// All rights reserved.

// global member variables
var m_itemCnt = 1;      //number for next item entered in menu tree
var m_lastRole = 0;     //number of last active role
var m_lastTask = "";    //number of last active task

//iManageMenu class
function iManageMenu()
{
   this.items   = new Array();
   this.addItem = addItem;
   
   function addItem(item)
   {
      this.items[this.items.length] = item;
   }
}

//menuItem class
function menuItem(text, url, target)
{
   this.text = text;
   this.url = url ? url : "";
   this.target = target ? target : "";
   this.number = m_itemCnt++;
   this.submenu = null;
   this.expanded = false;
   this.addSubMenu = addSubMenu;
   
   function addSubMenu(menu, exp)
   {
      this.submenu = menu;
      this.expanded = exp;
   }
}

function doSubMenu(subMenu)
{
   if (subMenu)
   {
      subMenu.expanded = !subMenu.expanded;     //invert subMenu flag
      m_lastRole = subMenu.number;                //remember m_lastRole
      displayMenu();                            //redisplay entire menu
   }
}

// generates the html to display the menu in the 'menu' FRAME
function displayMenu()
{
   //create dynamic HTML to display menu
   var strHTML="";
   strHTML += '<html>\n';
   strHTML += '<head>\n';
   strHTML += '   <title>Launcher</title>\n';
// strHTML += '   <link rel="stylesheet" href="/nps/portal/modules/fw/css/HF_style1.css">\n';
   strHTML += '   <link rel="stylesheet" href="/nps/portal/modules/dev/css/sideNavMenu.css">\n';
   strHTML += '   <link rel="stylesheet" href="/nps/portal/modules/dev/css/font-awesome.min.css">\n';
   strHTML += '   <link rel="stylesheet" href="/nps/portal/modules/dev/css/bootstrap.min.css">\n';
   strHTML += '   <script src="/nps/portal/modules/dev/common/jQuery/jquery.js"></script>\n';
   strHTML += '   <script src="/nps/portal/modules/dev/common/jQuery/bootstrap.min.js"></script>\n';
   strHTML += '   <style> .selected { background-color: #dddddd !important; }</style>\n';
   strHTML += '   <script> $(document).ready(function(){ $("span").click(function () { $("ul a li").removeClass(\'selected\'); $(this).children(\'li\').addClass(\'selected\'); });}); </script>\n';
 //  strHTML += '   <script> $(document).ready(function(){ $("ul").click(function () { $("ul").removeClass(\'show\'); $("li").addClass(\'collapsed\'); $(this).addClass(\'show\'); });}); </script>\n';
   strHTML += '</head>\n';
   strHTML += '<body scroll="no" style="overflow: hidden; border-right: 1px solid #ccc;">\n';
   strHTML += '\n';
   
   if(menu.items.length == 0)
   {
      //no menu display; display empty menu message
      strHTML += '   <table style="margin-top:8px" align="center" border="0" cellpadding="5">\n';
      strHTML += '      <tr>\n';
      strHTML += '         <td align="center">\n';
      strHTML += '            <b>';
      strHTML += noRolesText;
      strHTML += '            </b>\n';
      strHTML += '         </td>\n';
      strHTML += '      </tr>\n';
      strHTML += '   </table>\n\n';
   }
   else
   {
      //display menu
      strHTML += '<div class="nav-side-menu"> <div class="menu-list"> <ul id="menu-content" class="menu-content collapse out">';
      strHTML += listItems(menu,0);
      strHTML += '</ul> </div> </div>';
   }
   
   strHTML += '</body>\n';
   strHTML += '</html>\n';
   
   //get original position
   var scrollY = 0;
   if (m_lastRole)
   {
      var item = "mItem" + m_lastRole;
      if (exists("parent.menu.document.getElementById(\"" + item + "\").offsetParent.scrollTop"))
      {
         scrollY = parent.menu.document.getElementById(item).offsetParent.scrollTop;
      }
      if (scrollY == 0)
         scrollY = parent.menu.document.body.scrollTop;
   }
   
   //write out the new menu data to the innerHTML span

   var d = parent.menu.document;
   d.open("text/html", "replace");
   d.writeln(strHTML);
   d.close();

   //scroll the menu to the original position
   if (m_lastRole)
   {
      var item = "mItem" + m_lastRole;
	  if (exists("parent.menu.document.getElementById(\"" + item + "\").offsetParent.offsetTop"))
	  {
//	     var yVal = parent.menu.document.getElementById(item).offsetParent.offsetTop;
//	     var winSize = parent.menu.document.body.clientHeight;
//		 if(yVal > (winSize - 60))
//		 {
//		    parent.menu.scrollBy(0, parseInt(yVal - (winSize * 1/3)));
		    parent.menu.scrollTo(0, scrollY);
//		 }
      }
	   m_lastRole=0;
   }
} //displayMenu

//generate HTML to display menu items (recursive)
function listItems(menu, level)
{
   var str = "";
   var i;
   //str += '<p>start listItems</p>';
   for (i=0; i<menu.items.length; i++)
   {
      var item = menu.items[i];
      if (item)
      {
         str += displayItem(item, i, level);

         if (item.submenu )
         {
            str += listItems(item.submenu, level+1);  //recursively display submenu
         }
      }
   }
   if (level!=0)
   {
       str += '</ul>';
   }
   return (str);
}//listItems

//display a menu item and any submenu items
function displayItem(item, mIndex, level)
{
   var str = "";
   if (item)
   {
      if (item.submenu)
      {
         //item is a submenu; make link for +- icon
          str += '<a href="#"><li style="background-color: #555555; color: #ffffff;" data-toggle="collapse" data-target="#'+item.number+'" class="collapsed"> <h3> &nbsp;&nbsp;' + item.text + ' <span class="arrow"></span> </h3> </li></a> ';
          str += '<ul class="sub-menu collapse" id="'+item.number+'">';
      }
      else
      {
         //display leaf (task)
         str += '<a href="'+item.url+'" target="'+item.target+'"><span><li>' + item.text + '</li></span></a>';
      }

   }
   return (str);
}//displayItem

//===================== utility routines ========================
//create a string of p spaces to help indent generated HTML for readability
function pad(p)
{
   var ret = "";
   for (i=0; i<p; i++)
   {
      ret += " ";
   }
   return ret;
}

//output a string in an html window
function htmlAlert(msg)
{
   var w = window.open("","htmlAlert");
   var d = w.document;
   d.open();
   d.writeln("<html><body>\n"+toDisplay(msg)+"\n</body></html>");
   d.close();
}