<%@  page pageEncoding="utf-8" contentType="text/html;charset=utf-8" import="com.novell.webaccess.common.JSPConduit, com.novell.emframe.dev.eMFrameUtils" %>
<%   JSPConduit c = JSPConduit.getJSPConduit(request);
   c.stringTable("DevResources");
   c.stringTable("FwResources"); %>
<HTML>
<HEAD>
<TITLE><%= c.toHTML(c.string("")) %></TITLE>
<LINK   href="<%= c.getModulesUrl() + "/dev/css/hf_style.css" %>"
        rel="styleSheet"
        type="text/css">

<jsp:include page='<%= c.getPath("dev/MoveListItems_inc.jsp") %>' flush="true" />
<jsp:include page='<%= c.getPath("dev/eMFrameScripts_inc.jsp") %>' flush="true" />

<SCRIPT language="JavaScript">

   function detectBrowser()
   {
        var appVer = navigator.appVersion;
        var iePos = appVer.indexOf('MSIE');
        if (iePos != -1)
        {
            document.CategoryRoleForm.AvailableRoles.attachEvent('ondblclick',addSelectedItems);
            document.CategoryRoleForm.AssignedRoles.attachEvent('ondblclick',removeSelectedItems);
        }

        var availAttrOpt = document.CategoryRoleForm.AvailableRoles.options;
        var optAttrOpt = document.CategoryRoleForm.AssignedRoles.options;
        sortAvailList(availAttrOpt);
        sortAssignedList(optAttrOpt);
    }

    function onPageLoad()
    {
        var form = document.CategoryRoleForm;

        if (form.AvailableRoles.length != 0)
        {
            form.AvailableRoles.focus();
            form.AvailableRoles[0].selected = true;
            form.AvailableRoles.selectedIndex = 0; // For Mozilla
            form.Description.value = parseDescription(form.AvailableRoles.options[0].value);
            form.Path.value = parseName(form.AvailableRoles.options[0].value);
        }

        return;
    }


   /*******************
    * FUNCTION HEADER *
    *******************/
   // Set the focus to only the selected list and avoid the problem of both lists showing selected items
    function setListFocus(list)
    {
        if (list.name == "AssignedRoles")
        {
            document.CategoryRoleForm.AvailableRoles.selectedIndex=-1;
        }
        else
        {
            document.CategoryRoleForm.AssignedRoles.selectedIndex=-1;
        }
    }

   /*******************
    * FUNCTION HEADER *
    *******************/
    function addSelectedItems(event)
    {
	   var availOpt      = document.CategoryRoleForm.AvailableRoles.options;
	   var optOpt        = document.CategoryRoleForm.AssignedRoles.options;
      var selectedNum   = 0;

      if (document.CategoryRoleForm.AvailableRoles.selectedIndex == -1)
      {
         // Nothing is selected in the Available Roles List when the user clicked on the add button. Just return.
         return;
      }

      for (var i=(availOpt.length-1); i>=0; i--)
	   {
		   if(availOpt[i].selected)
		   {
            optOpt[optOpt.length] = new Option(availOpt[i].text, availOpt[i].value, false, availOpt[i].selected);
            availOpt[i] = null;
            selectedNum = i;
		   }
	   }

      document.CategoryRoleForm.elements["CategoryRoleFormChanged"].value = "true";
	   sortAssignedList(optOpt);
      setAvailableListFocus(availOpt,selectedNum);
    }

   /*******************
    * FUNCTION HEADER *
    *******************/
   function removeSelectedItems(event)
   {
      var availAttrOpt  = document.CategoryRoleForm.AvailableRoles.options;
      var optAttrOpt    = document.CategoryRoleForm.AssignedRoles.options;
      var selectedNum   = 0;

      if (document.CategoryRoleForm.AssignedRoles.selectedIndex == -1)
      {
         // Nothing is selected in the Assigned Roles List when the user clicked on the add button. Just return.
         return;
      }

      for (var i=(optAttrOpt.length-1); i>=0; i--)
      {
         if(optAttrOpt[i].selected)
         {
            availAttrOpt[availAttrOpt.length] = new Option(optAttrOpt[i].text, optAttrOpt[i].value, false, false);
            optAttrOpt[i] = null;
            selectedNum = i;
         }
      }

      document.CategoryRoleForm.elements["CategoryRoleFormChanged"].value = "true";
      sortAvailList(availAttrOpt);
      setAssignedListFocus(optAttrOpt,selectedNum);
   }

   /*******************
    * FUNCTION HEADER *
    *******************/
   function setAssignedListFocus(list,num)
   {
      if(list.length > 0)
      {
         if(list[num] == null)
         {
           document.CategoryRoleForm.AssignedRoles.selectedIndex = num - 1;
         }
         else
         {
           document.CategoryRoleForm.AssignedRoles.selectedIndex = num;
         }
         getDescription(document.CategoryRoleForm.AssignedRoles);
         getPath(document.CategoryRoleForm.AssignedRoles);
      }
      else
      {
         document.CategoryRoleForm.AvailableRoles.selectedIndex = 0;
         getDescription(document.CategoryRoleForm.AvailableRoles);
         getPath(document.CategoryRoleForm.AvailableRoles);
      }
   }

   /*******************
    * FUNCTION HEADER *
    *******************/
   function setAvailableListFocus(list,num)
   {
      if(list.length > 0)
      {
         if(list[num] == null)
         {
           document.CategoryRoleForm.AvailableRoles.selectedIndex = num - 1;
         }
         else
         {
           document.CategoryRoleForm.AvailableRoles.selectedIndex = num;
         }
         getDescription(document.CategoryRoleForm.AvailableRoles);
         getPath(document.CategoryRoleForm.AvailableRoles);
      }
      else
      {
         document.CategoryRoleForm.AssignedRoles.selectedIndex = 0;
         getDescription(document.CategoryRoleForm.AssignedRoles);
         getPath(document.CategoryRoleForm.AssignedRoles);
      }
   }

   function sortAssignedList(x)
   {
        var iePos = navigator.appVersion.indexOf('MSIE');
        sortedArray = new Array();

        for (var i=0; i<x.length; i++) {
            sortedArray[i] = new Array(x[i].text, x[i].value, false, false);
        }

        sortedArray.sort(sortBYtext);

        for (var i=0; i<x.length; i++) {
            x[i] = new Option(sortedArray[i][0], sortedArray[i][1], sortedArray[i][2], sortedArray[i][3]);
            if (iePos == -1)
                x[i].addEventListener("dblclick",removeSelectedItems, false);
            x[i].selected = sortedArray[i][3];
        }

        return;
    }


    function sortAvailList(x)
    {
        var iePos = navigator.appVersion.indexOf('MSIE');
        sortedArray = new Array();

        for (var i=0; i<x.length; i++) {
            sortedArray[i] = new Array(x[i].text, x[i].value, false, x[i].selected);
        }

        sortedArray.sort(sortBYtext);

      for (var i=0; i<x.length; i++)
      {
         x[i] = new Option(sortedArray[i][0], sortedArray[i][1], sortedArray[i][2], sortedArray[i][3]);

         if (iePos == -1)
         {
            x[i].addEventListener("dblclick",addSelectedItems, false);
            if (x[i].selected == true)
            {
               x.selectedIndex = i;
            }
         }

         x[i].selected = sortedArray[i][3];

         if (iePos == -1)
         {
            if (x[i].selected == true)
            {
               x.selectedIndex = i;
            }
         }
      }

      return;
    }


    function sortBYtext(a,b)
    {
        if(a[0].toLowerCase() < b[0].toLowerCase())
        {
            return -1;
        }

        if(a[0].toLowerCase() > b[0].toLowerCase())
        {
            return 1;
        }

        return 0;
    }


   /*******************
    * FUNCTION HEADER *
    *******************/
    function getAssignedRoles()
    {
        var boxLength = document.CategoryRoleForm.AssignedRoles.length;

        // Get everything in the AssignedRoles list
        ShortName = new Array(boxLength);
        FullName = new Array(boxLength);
        Description = new Array(boxLength);

        for (i = 0; i < boxLength; i++)
        {
            if (document.CategoryRoleForm.AssignedRoles.options[i].text != emptyListBracket)
            {
                ShortName[i] = urlEncode(document.CategoryRoleForm.AssignedRoles.options[i].text);
                FullName[i] = urlEncode(parseName(document.CategoryRoleForm.AssignedRoles.options[i].value));
                Description[i] = urlEncode(parseDescription(document.CategoryRoleForm.AssignedRoles.options[i].value));
            }
        }

        // Convert array into delimited string to be passed into the java file
        document.CategoryRoleForm.elements["AssignedRoleFullName"].value = FullName.join(";");
        document.CategoryRoleForm.elements["AssignedRoleShortName"].value = ShortName.join(";");
        document.CategoryRoleForm.elements["AssignedRoleDescription"].value = Description.join(";");

        return true;
    }


   /*******************
    * FUNCTION HEADER *
    *******************/
    function getAvailableRoles()
    {
        var boxLength = document.CategoryRoleForm.AvailableRoles.length;

        // Get everything in the AssignedRoles list
        ShortName = new Array(boxLength);
        FullName = new Array(boxLength);
        Description = new Array(boxLength);

        for (i = 0; i < boxLength; i++)
        {
            if (document.CategoryRoleForm.AvailableRoles.options[i].text != emptyListBracket)
            {
                ShortName[i] = urlEncode(document.CategoryRoleForm.AvailableRoles.options[i].text);
                FullName[i] = urlEncode(parseName(document.CategoryRoleForm.AvailableRoles.options[i].value));
                Description[i] = urlEncode(parseDescription(document.CategoryRoleForm.AvailableRoles.options[i].value));
            }
        }

        // Convert array into delimited string to be passed into the java file
        document.CategoryRoleForm.elements["AvailableRoleFullName"].value = FullName.join(";");
        document.CategoryRoleForm.elements["AvailableRoleShortName"].value = ShortName.join(";");
        document.CategoryRoleForm.elements["AvailableRoleDescription"].value = Description.join(";");

        return true;
    }


   /*******************
    * FUNCTION HEADER *
    *******************/
    function onPageSubmit()
    {
        if (document.CategoryRoleForm.AssignedRoles.length == 1)
        {
            if (document.CategoryRoleForm.AssignedRoles.options[0].text == emptyListBracket)
            {
                var message = "<%= c.toScript(c.string("BookSummary.NoRoleAssignment")) %>";
                message += "\n";
                message += "<%= c.toScript(c.string("BookSummary.Continue")) %>";

                if (!confirm(message))
                {
                    onPageLoad();
                    return false;
                }
            }
        }

        getAvailableRoles();
        getAssignedRoles();

        return;
    }


   /*******************
    * FUNCTION HEADER *
    *******************/
    function getDescription(list)
    {
        if ((list != null) && (list.selectedIndex != -1))
        {
            var desc = parseDescription(list.options[list.selectedIndex].value);
            document.CategoryRoleForm.Description.value = desc;
        }
    }


   /*******************
    * FUNCTION HEADER *
    *******************/
    function getPath(list)
    {
        if ((list != null) && (list.selectedIndex != -1))
        {
            var path = parseName(list.options[list.selectedIndex].value);
            document.CategoryRoleForm.Path.value = path;
        }
    }


   /*******************
    * FUNCTION HEADER *
    *******************/
    function parseDescription(nameAndDescription)
    {
        var nameDescArray = nameAndDescription.split("$");
        var desc = nameDescArray[1];
        if(desc == null)
        {
            return "";
        }

        return urlDecode(desc);
    }


   /*******************
    * FUNCTION HEADER *
    *******************/
    function parseName(nameAndDescription)
    {
        var nameDescArray = nameAndDescription.split("$");
        var path = nameDescArray[0];
        if(path == null)
        {
            return "";
        }

        return urlDecode(path);
    }


   /*******************
    * FUNCTION HEADER *
    *******************/
    function backButtonSelected()
    {
        getAvailableRoles();
        getAssignedRoles();
        document.CategoryRoleForm.elements["merge"].value="fw.CreateCategory";
        document.CategoryRoleForm.elements["nextState"].value="backRoleSelection";
        document.CategoryRoleForm.submit();
    }


</SCRIPT>
</HEAD>
<BODY   TEXT="#000000" LINK="#000000" VLINK="#000000" ALINK="#000000" bgcolor="#FFFFFF"
        onload="onPageLoad(),detectBrowser();">

<FORM   name="CategoryRoleForm"
        method=post
        action="webacc"
        onSubmit="return(onPageSubmit())">

   <input   type=hidden
            name="taskId"
            value="<%= c.var("taskId") %>">

   <input   type=hidden
            name="merge"
            value="fw.CategorySummary">

   <input   type=hidden
            name="error"
            value="dev.GenErr">

   <input   type=hidden
            name="nextState"
            value="nextSummary">

   <input   type=hidden
            name="AssignedRoleFullName"
            value="">
   <input   type=hidden
            name="AssignedRoleShortName"
            value="">

   <input   type=hidden
            name="AssignedRoleDescription"
            value="">

   <input   type=hidden
            name="AvailableRoleFullName"
            value="">

   <input   type=hidden
            name="AvailableRoleShortName"
            value="">

   <input   type=hidden
            name="AvailableRoleDescription"
            value="">

   <input   type=hidden
            name="CategoryRoleFormChanged"
            value="false">

   <!-- End of hidden tags -->

    <% c.set("WizardHeader.title", c.toHTML(c.string("CreateCategory.WizardTitle")));
       c.set("WizardHeader.subtitle", c.toHTML(c.string("General.Step2")));
       c.set("WizardHeader.instruction", c.toHTML(c.string("CreateCategory.Roles")));
       c.set("WizardHeader.helpFile", ""); %>
    <jsp:include page='<%= c.getPath("dev/WizardHeader_inc.jsp") %>' flush="true" />

    <TABLE width="100%" border="0" cellspacing="0" cellpadding="3">
        <TR>
            <TD class="mediumtext">
                <B><%= c.toHTML(c.string("CreateCategory.CategoryName")) %></B>&nbsp;<%= c.toHTML(c.var("CategoryName")) %>
            </td>
        </tr>
        <TR>
            <TD class="mediumtext">
                &nbsp;
            </td>
        </TR>
        <TR>
            <TD class="formdescriptext">
                <%= c.toHTML(c.string("AddRoleToCategory.Instruction")) %>
            </td>
        </tr>
            <TD class="mediumtext">
                &nbsp;
            </td>
    </table>
    <TABLE name="Taskstable" >
        <TR>
            <TD align="left" class="mediumtext" valign="bottom">
                <%= c.toHTML(c.string("CreateCategory.AvailableRoles")) %>
            </TD>
            <TD align="left"></TD>
            <TD align="left" class="mediumtext" valign="bottom">
                <%= c.toHTML(c.string("CreateCategory.AssignedRoles")) %>
            </TD>
        </TR>
        <TR>
            <TD>
                <SELECT name="AvailableRoles" size=10 WIDTH="250" style="WIDTH: 250px"
                        multiple
                        onchange="getDescription(this);getPath(this);setListFocus(this)">
                    <% c.set("j", "0");
                       while (c.lt(c.var("j"), c.var("AvailableRole.Count"))) { %>
                        <OPTION value="<%= c.urlEncode(c.var("AvailableRoles."+c.var("j")+ ".FullName")) %>$<%= c.urlEncode(c.var("AvailableRoles."+c.var("j")+ ".Description")) %>"><%= c.toHTML(c.var("AvailableRoles."+c.var("j")+ ".ShortName")) %>
                        <% c.inc("j");
                       } %>
                </SELECT>
            </TD>
            <TD>
                <a href="#" onClick="javascript:addSelectedItems();return false"><IMG src="<%= c.getModulesUrl() + "/dev/images/" + c.string("Button.ArrowRight.image") %>" alt="<%= c.toHTML(c.string("Button.ArrowRight.alt")) %>" title="<%= c.toHTML(c.string("Button.ArrowRight.alt")) %>" border=0></a>
                <BR>
                <a href="#" onClick="javascript:removeSelectedItems();return false"><IMG src="<%= c.getModulesUrl() + "/dev/images/" + c.string("Button.ArrowLeft.image") %>" alt="<%= c.toHTML(c.string("Button.ArrowLeft.alt")) %>" title="<%= c.toHTML(c.string("Button.ArrowLeft.alt")) %>" border=0></a>
                <BR>
            </TD>
            <TD>
                <SELECT name="AssignedRoles" size=10 WIDTH="250" style="WIDTH: 250px"
                        multiple
                        onchange="getDescription(this);getPath(this);setListFocus(this)">
                    <% c.set("i", "0");
                       while (c.lt(c.var("i"), c.var("AssignedRole.Count"))) { %>
                        <OPTION value="<%= c.urlEncode(c.var("AssignedRoles."+c.var("i")+ ".FullName")) %>$<%= c.urlEncode(c.var("AssignedRoles."+c.var("i")+ ".Description")) %>"><%= c.toHTML(c.var("AssignedRoles."+c.var("i")+ ".ShortName")) %>
                        <% c.inc("i");
                       } %>
                </SELECT>
            </TD>
		</TR>
        <TR>
            <TD>&nbsp;</TD>
        </TR>
        <TR>
            <TD class="mediumtext" colspan="3">
                <%= c.toHTML(c.string("BookRole.Path")) %><BR>
                <INPUT type="text" name="Path" value="" size=<% if (c.var("Browser.mjrVer").equals("4") && c.var("Browser.name").equals("NSN")) { %>37<% } else { %>74<% } %> maxlength=128 readonly disabled="true">
            </TD>
        </TR>
        <TR>
            <TD>&nbsp;</TD>
        </TR>
        <TR>
            <TD class="mediumtext" colspan="3">
                <%= c.toHTML(c.string("BookRole.Description")) %><BR>
                <TEXTAREA name="Description" rows="3" cols="32" readonly></TEXTAREA>
            </TD>
        <TR>
            <TD class="mediumtext">
                &nbsp;
            </td>
        </TR>
    </TABLE>
    <jsp:include page='<%= c.getPath("dev/Bar_inc.jsp") %>' flush="true" />
    <a href="#" onClick="javascript:backButtonSelected();return false"><IMG src="<%= c.getModulesUrl() + "/dev/images/" + c.string("Button.Back.image") %>" alt="<%= c.toHTML(c.string("Button.Back.alt")) %>" title="<%= c.toHTML(c.string("Button.Back.alt")) %>" border=0></a>
    <INPUT type=image name="Next" alt="<%= c.toHTML(c.string("Button.Next.alt")) %>" title="<%= c.toHTML(c.string("Button.Next.alt")) %>" src="<%= c.getModulesUrl() + "/dev/images/" + c.string("Button.Next.image") %>" border=0>
    <jsp:include page='<%= c.getPath("dev/Cancel_inc.jsp") %>' flush="true" />
</FORM>
</BODY></HTML>
