<%@  page pageEncoding="utf-8" contentType="text/html;charset=utf-8" import="com.novell.webaccess.common.JSPConduit, com.novell.emframe.dev.eMFrameUtils" %>
<%   JSPConduit c = JSPConduit.getJSPConduit(request);
   c.stringTable("DevResources"); 
   c.stringTable("FwResources"); %>

<HTML>
<HEAD>
<TITLE><%= JSPConduit.toHTML(c.string("RBSManagement.ModifyRoleTasksTitle")) %></TITLE>
<LINK href="<%= c.getModulesUrl() + "/dev/css/hf_style.css" %>" rel="styleSheet" type="text/css">
<jsp:include page='<%= c.getPath("dev/MoveListItems_inc.jsp") %>' flush="true" />
<jsp:include page='<%= c.getPath("dev/eMFrameScripts_inc.jsp") %>' flush="true" />
<SCRIPT language="JavaScript">

   // Global variables
   var originalAssignedTasks 		   = new Array()
   var allTasksInTreeSelectedIndex 	= 0;
   var supervisorySecondary			= "<%= c.toHTML(c.string("RBSManagement.SupervisorySecondary")) %>";
   var supervisory					   = "<%= c.toHTML(c.string("RBSManagement.Supervisory")) %>";
   var secondary					      = "<%= c.toHTML(c.string("RBSManagement.Secondary")) %>";

   function detectBrowser()
   {
      var appVer = navigator.appVersion;
      var iePos = appVer.indexOf('MSIE');

      if (iePos != -1)
      {
         document.ShowTasksForm.AllTasksInTree.attachEvent('ondblclick',addSelectedItems);
         document.ShowTasksForm.AssignedTasks.attachEvent('ondblclick',removeSelectedItems);
      }

      sortAvailList(document.ShowTasksForm.AllTasksInTree.options);
      sortAssignedList(document.ShowTasksForm.AssignedTasks.options);
   }


   //==================================
   // onPageLoad()
   //==================================
   function onPageLoad()
   {
   	removeDuplicatesFromList();
      setGeneralMsgUrl();
      setFocusToFormElement();
   }

   //==================================
   // setWaitCursor()
   //==================================
   function setWaitCursor()
   {
	  document.body.style.cursor="wait";
   }

   //==================================
   // setFocusToFormElement()
   //==================================
   function setFocusToFormElement()
   {
      if (document.ShowTasksForm.AllTasksInTree.length != 0)
      {
         document.ShowTasksForm.AllTasksInTree.focus();
         document.ShowTasksForm.AllTasksInTree[0].selected = true;
         document.ShowTasksForm.AllTasksInTree.selectedIndex = 0;

         var taskInformationArray		= document.ShowTasksForm.AllTasksInTree.options[0].value.split(":");
         var selectedTaskPath 			= parseName(taskInformationArray);
         var selectedTaskDescription 	= parseDescription(taskInformationArray);
         var eguideAttributesArray 		= parseEguideAttributes(taskInformationArray);
         var selectedTaskTranslatedName= parseTranslatedName(taskInformationArray);
         var assignedRights				= parseRights(taskInformationArray);

         addTaskInformation(selectedTaskPath, selectedTaskDescription, selectedTaskTranslatedName, eguideAttributesArray, assignedRights);
      }
      else
      {
         // The AllTasksInTree box is empty, ask user if he wants to continue
         alert("<%= c.toHTML(c.string("ModifyRoleTasks.NoTasksAvailable")) %>");
      }
   }

   //==================================
   // setListFocus()
   // Set the focus to only the selected list and avoid the problem of both lists showing selected items
   //==================================
   function setListFocus(list)
   {
      if (list.name == "AssignedTasks")
      {
      	document.ShowTasksForm.AllTasksInTree.selectedIndex=-1;
      }
      else
      {
      	document.ShowTasksForm.AssignedTasks.selectedIndex=-1;
      }
   }

   //==================================
   // setGeneralMsgUrl()
   //==================================
	function setGeneralMsgUrl()
   {
      <% if (c.var("RBSAdmin_TaskDelegate").equals("taskDelegate") == false) { %>
         <% if (c.var("RBSAdmin_RoleType").equals("eGuide")) { %>
            document.ShowTasksForm.elements["GeneralMsg.Url"].value = "webacc?taskId=<%= c.var("taskId") %>&merge=fw.EguideRoleTaskSummary&nextState=getEguideRolesAndAssignedTasks&User.context=<%= c.var("User.context") %>";
         <% } else { %>
            document.ShowTasksForm.elements["GeneralMsg.Url"].value = "webacc?taskId=<%= c.var("taskId") %>&merge=fw.RoleTaskSummary&nextState=getRolesAndAssignedTasks&User.context=<%= c.var("User.context") %>";
         <% } %>
      <% } %>
   }

   //==================================
   // addSelectedItems()
   //==================================
   function addSelectedItems(event)
   {
      var availOpt      = document.ShowTasksForm.AllTasksInTree.options;
	   var optOpt        = document.ShowTasksForm.AssignedTasks.options;
      var selectedNum   = 0;

      if (document.ShowTasksForm.AllTasksInTree.selectedIndex == -1)
      {
         // Nothing is selected in the All Tasks List when the user clicked on the add button. Just return.
         return;
      }

	   for (var i=(availOpt.length-1); i>=0; i--)
	   {
		   if(availOpt[i].selected)
		   {
            optOpt[optOpt.length] = new Option(availOpt[i].text, availOpt[i].value, false, availOpt[i].selected);
			   availOpt[i] = null;
            selectedNum = i;
		   }
	   }

      document.ShowTasksForm.elements["AssignedTasksChanged"].value = "true";
      sortAssignedList(optOpt);
      setAvailableListFocus(availOpt,selectedNum);
   }

    //==================================
    // removeSelectedItems()
    //==================================
    function removeSelectedItems(event)
    {
       var availAttrOpt = document.ShowTasksForm.AllTasksInTree.options;
       var optAttrOpt   = document.ShowTasksForm.AssignedTasks.options;
       var selectedNum  = 0;

       if (document.ShowTasksForm.AssignedTasks.selectedIndex == -1)
       {
         // Nothing is selected in the Assigned Tasks List when the user clicked on the remove button. Just return.
         return;
       }

       for (var i=(optAttrOpt.length-1); i>=0; i--)
       {
          if(optAttrOpt[i].selected)
          {
             availAttrOpt[availAttrOpt.length] = new Option(optAttrOpt[i].text, optAttrOpt[i].value, false, false);
             optAttrOpt[i] = null;
             selectedNum = i;
          }
       }

       document.ShowTasksForm.elements["AssignedTasksChanged"].value = "true";
       sortAvailList(availAttrOpt);
       setAssignedListFocus(optAttrOpt,selectedNum);
    }

    //==================================
    // setAssignedListFocus()
    //==================================
    function setAssignedListFocus(list,num)
    {
       if(list.length > 0)
       {
          if(list[num] == null)
          {
            document.ShowTasksForm.AssignedTasks.selectedIndex = num - 1;
          }
          else
          {
            document.ShowTasksForm.AssignedTasks.selectedIndex = num;
          }
          getDescription(document.ShowTasksForm.AssignedTasks);
       }
       else
       {
         document.ShowTasksForm.AllTasksInTree.selectedIndex = 0;
         getDescription(document.ShowTasksForm.AllTasksInTree);
       }
    }

    //==================================
    // setAvailableListFocus()
    //==================================
    function setAvailableListFocus(list,num)
    {
       if(list.length > 0)
       {
          if(list[num] == null)
          {
            document.ShowTasksForm.AllTasksInTree.selectedIndex = num - 1;
          }
          else
          {
            document.ShowTasksForm.AllTasksInTree.selectedIndex = num;
          }
          getDescription(document.ShowTasksForm.AllTasksInTree);
       }
       else
       {
         document.ShowTasksForm.AssignedTasks.selectedIndex = 0;
         getDescription(document.ShowTasksForm.AssignedTasks);
       }
    }

   //==================================
   // sortAssignedList()
   //==================================
   function sortAssignedList(x)
   {
       var iePos = navigator.appVersion.indexOf('MSIE');
       sortedArray = new Array();

       for (var i=0; i<x.length; i++) {
           sortedArray[i] = new Array(x[i].text, x[i].value, false, false);
       }

       sortedArray.sort(sortBYtext);

       for (var i=0; i<x.length; i++) {
           x[i] = new Option(sortedArray[i][0], sortedArray[i][1], sortedArray[i][2], sortedArray[i][3]);
           if (iePos == -1)
               x[i].addEventListener("dblclick",removeSelectedItems, false);
           x[i].selected = sortedArray[i][3];
       }

       return;
   }


   function sortAvailList(x)
   {
       var iePos = navigator.appVersion.indexOf('MSIE');
       sortedArray = new Array();

       for (var i=0; i<x.length; i++)
       {
          sortedArray[i] = new Array(x[i].text, x[i].value, false, x[i].selected);
       }

       sortedArray.sort(sortBYtext);

       for (var i=0; i<x.length; i++)
       {
           x[i] = new Option(sortedArray[i][0], sortedArray[i][1], sortedArray[i][2], sortedArray[i][3]);
           if (iePos == -1)
           {
              x[i].addEventListener("dblclick",addSelectedItems, false);
           }

           x[i].selected = sortedArray[i][3];
           if (iePos == -1)
           {
              if (x[i].selected == true)
              {
                 x.selectedIndex = i;
              }
           }
       }

       return;
   }


   function sortBYtext(a,b)
   {
       if(a[0].toLowerCase() < b[0].toLowerCase())
       {
           return -1;
       }

       if(a[0].toLowerCase() > b[0].toLowerCase())
       {
          return 1;
       }

       return 0;
   }

	//==================================
   // removeDuplicatesFromList()
   //==================================
   function removeDuplicatesFromList()
   {
      var assignedBoxLength = document.ShowTasksForm.AssignedTasks.length;

      if (assignedBoxLength > 0)
      {
         // Need to get each item in assigned list and remove from AllTasks list
			for (var i = 0; i < assignedBoxLength; i++)
		   {
            thisitem = parseName(document.ShowTasksForm.AssignedTasks.options[i].value.split(":"));

            for (var j = 0; j < document.ShowTasksForm.AllTasksInTree.length; j++)
            {

               if (thisitem == parseName(document.ShowTasksForm.AllTasksInTree.options[j].value.split(":")))
               {
               	document.ShowTasksForm.AllTasksInTree.options[j] = null;
               }
            }
			}

         sortLists(document.ShowTasksForm.AllTasksInTree.options);
	     document.ShowTasksForm.AllTasksInTree.selectedIndex=-1;
      }
   }

   //==================================
   // getAssignedTasks()
   //==================================
   function getAssignedTasks()
   {
      var boxLength     = document.ShowTasksForm.AssignedTasks.length;
      var emptyBracket	= "<%= c.toHTML(c.string("Generic.EmptyListBracket")) %>";
      
      // Get everything in the AssignedTasks list
	  if (document.ShowTasksForm.elements["AssignedTasksChanged"].value == "true")
      {
			document.ShowTasksForm.elements["AssignedTasksCount"].value = boxLength;
			assignedTasks = new Array(boxLength)
         
         for (i = 0; i < boxLength; i++) 
	     {
		    if (document.ShowTasksForm.AssignedTasks.options[i].text != emptyBracket)
            {
            	// This needs to be the full name
               assignedTasks[i] = parseName(document.ShowTasksForm.AssignedTasks.options[i].value.split(":"));
            }
		 }
         
         // Convert array into delimited string to be passed into the java file
         var strAssignedTasks = assignedTasks.join(";");
         document.ShowTasksForm.elements["Role.AssignedTasks"].value = strAssignedTasks;
		}
      else // Nothing has changed. Go back to the main summary page
      {
         setWaitCursor();
         
         <% if (c.var("RBSAdmin_RoleType").equals("eGuide")) { %>
         	document.ShowTasksForm.elements["merge"].value="fw.EguideRoleTaskSummary";
			   document.ShowTasksForm.elements["nextState"].value="getEguideRolesAndAssignedTasks";
			   document.ShowTasksForm.submit();
         <% } else { %>
	         document.ShowTasksForm.elements["merge"].value="fw.RoleTaskSummary";
			   document.ShowTasksForm.elements["nextState"].value="getRolesAndAssignedTasks";
			   document.ShowTasksForm.submit();
         <% } %>

         return false;
      }

      setGeneralMsgUrl();
      setWaitCursor();
      return true;
   }

   //==================================
   // getDescription()
   //==================================
   function getDescription(list)
   {
      var selectedDescription    = "";
      var nameAndDescription 	   = "";
      var taskTranslatedName 	   = "";
      var taskFullName			   = "";
      var grantsSupervisorRights = "";
      var superAndSecondaryRights= "";
      var secondaryRights 		   = "";
      var assignedRights 		   = "";
      var m_iSelectedIndex		   = 0;
      var boxLength 			      = 0;
      var eguideAttributesArray  = new Array();

      if (list != null)
      {
      	var listName   = list.name;
         boxLength      = document.ShowTasksForm.elements[listName].length;

         if (boxLength != 0)
	      {
            m_iSelectedIndex = document.ShowTasksForm.elements[listName].selectedIndex;

            if (boxLength == 1)
            {
               nameAndDescription = document.ShowTasksForm.elements[listName].options[m_iSelectedIndex].text;

               if (nameAndDescription != "<%= c.toHTML(c.string("Generic.EmptyListBracket")) %>")
               {
               	nameAndDescription = document.ShowTasksForm.elements[listName].options[m_iSelectedIndex].value;
               }
            }
            else
            {
               nameAndDescription = document.ShowTasksForm.elements[listName].options[m_iSelectedIndex].value;
            }

            if (nameAndDescription != "<%= c.toHTML(c.string("Generic.EmptyListBracket")) %>")
            {
					var taskInformationArray		= nameAndDescription.split(":");
		         
		         taskFullName 				= parseName(taskInformationArray);
               selectedDescription 		= parseDescription(taskInformationArray);
               taskTranslatedName 		= parseTranslatedName(taskInformationArray);
               eguideAttributesArray 	= parseEguideAttributes(taskInformationArray);
               assignedRights				= parseRights(taskInformationArray);
            }
         }
      }
      
      addTaskInformation(taskFullName, selectedDescription, taskTranslatedName, eguideAttributesArray, assignedRights);
	}

	//==================================
   // addTaskInformation()
   //==================================
   function addTaskInformation(path, description, translatedName, eguideAttrArray, assignedRights)
   {
      ModifyTaskFrame.document.writeln('<LINK href="<%= c.getModulesUrl() + "/dev/css/hf_style.css" %>" rel="styleSheet" type="text/css">');

      ModifyTaskFrame.document.writeln("<TABLE width='100%' border='0' cellspacing='0' cellpadding='1'>");
      ModifyTaskFrame.document.writeln("<TR class='tablesubhead1' bgcolor='#EFEEE9'><TD class='mediumtext2a'><%= c.toHTML(c.string("ChooseTasks.TranslatedName")) %></TD>");
      ModifyTaskFrame.document.writeln("<TD class='mediumtext' align='right' nowrap>&nbsp;</TD></TR>");
      ModifyTaskFrame.document.writeln("<TR><TD valign='bottom' class='smalltext' nowrap>");
      ModifyTaskFrame.document.writeln(translatedName);
      ModifyTaskFrame.document.writeln("<TR><TD>&nbsp;</TD></TR>");
      
      ModifyTaskFrame.document.writeln("<TR class='tablesubhead1' bgcolor='#EFEEE9'><TD class='mediumtext2a'><%= c.toHTML(c.string("ChooseTasks.Path")) %></TD>");
      ModifyTaskFrame.document.writeln("<TD class='mediumtext' align='right' nowrap>&nbsp;</TD></TR>");
      ModifyTaskFrame.document.writeln("<TR><TD valign='bottom' class='smalltext' nowrap>");
      ModifyTaskFrame.document.writeln(path);
      ModifyTaskFrame.document.writeln("<TR><TD>&nbsp;</TD></TR>");
      
      ModifyTaskFrame.document.writeln("<TR class='tablesubhead1' bgcolor='#EFEEE9'><TD class='mediumtext2a'><%= c.toHTML(c.string("ChooseTasks.RightsAdvisory")) %></TD>");
      ModifyTaskFrame.document.writeln("<TD class='mediumtext' align='right' nowrap>&nbsp;</TD></TR>");
      ModifyTaskFrame.document.writeln("<TR><TD valign='bottom' class='smalltext' nowrap>");
      ModifyTaskFrame.document.writeln(assignedRights);
      ModifyTaskFrame.document.writeln("<TR><TD>&nbsp;</TD></TR>");
      
      ModifyTaskFrame.document.writeln("<TR class='tablesubhead1' bgcolor='#EFEEE9'><TD class='mediumtext2a'><%= c.toHTML(c.string("ChooseTasks.Description")) %></TD>");
      ModifyTaskFrame.document.writeln("<TD class='mediumtext' align='right' nowrap>&nbsp;</TD></TR>");
      ModifyTaskFrame.document.writeln("<TR><TD valign='bottom' class='smalltext'>");
      ModifyTaskFrame.document.writeln(description);
	  ModifyTaskFrame.document.writeln("<TR><TD>&nbsp;</TD></TR>");
      
      <% if (c.var("RBSAdmin_RoleType").equals("eGuide")) { %>
	      ModifyTaskFrame.document.writeln("<TR class='tablesubhead1' bgcolor='#EFEEE9'><TD class='mediumtext2a'><%= c.toHTML(c.string("ChooseTasks.AssignedAttributes")) %></TD>");
	      ModifyTaskFrame.document.writeln("<TD class='mediumtext' align='right' nowrap>&nbsp;</TD></TR>");
         ModifyTaskFrame.document.writeln("<TR><TD valign='bottom' class='smalltext'>");

         if (eguideAttrArray != null)
         {
	         for( var i = 0; i < eguideAttrArray.length; i++)
	         {
	            var attribute = eguideAttrArray[i];
	            ModifyTaskFrame.document.writeln(attribute);
	            ModifyTaskFrame.document.writeln("<BR>");
	         }
         }
      <% } %>

      ModifyTaskFrame.document.writeln("</TD></TR></TABLE>");
      ModifyTaskFrame.document.close();
   }

   //==================================
   // parseDescription()
   //==================================
   function parseDescription(taskInfoArray)
   {
      return urlDecode(taskInfoArray[1]);
   }

   //==================================
   // parseName()
   //==================================
   function parseName(taskInfoArray)
   {
      return (urlDecode(taskInfoArray[0]));
   }

   //==================================
   // parseTranslatedName()
   //==================================
   function parseTranslatedName(taskInfoArray)
   {
      return urlDecode(taskInfoArray[6]);
   }

   //==================================
   // parseEguideAttributes()
   //==================================
   function parseEguideAttributes(taskInfoArray)
   {
	  var eguideAttributes = urlDecode(taskInfoArray[2]);
	  var eguideAttrArray 	= eguideAttributes.split(";");
      return eguideAttrArray;
   }

   //==================================
   // parseSupervisorRights()
   //==================================
   function parseSupervisorRights(taskInfoArray)
   {
      return urlDecode(taskInfoArray[3]);
   }

   //==================================
   // parseSecondaryRights()
   //==================================
   function parseSecondaryRights(taskInfoArray)
   {
      return urlDecode(taskInfoArray[4]);
   }

   //==================================
   // parseSuperSecondaryRights()
   //==================================
   function parseSuperSecondaryRights(taskInfoArray)
   {
      return urlDecode(taskInfoArray[5]);
   }

   //==================================
   // parseRights()
   //==================================
   function parseRights(taskInfoArray)
   {
      if (parseSuperSecondaryRights(taskInfoArray) == "true")
      {
      	return supervisorySecondary;
      }

      if (parseSupervisorRights(taskInfoArray) == "true")
      {
      	return supervisory;
      }

      if (parseSecondaryRights(taskInfoArray) == "true")
      {
      	return secondary;
      }

      return "";
   }

   //==================================
   // setListOptionFocus()
   //==================================
   function setListOptionFocus(list)
	{
      var index = list.selectedIndex;

      for( var i = 0; i < list.options.length; i++ )
	   {
	      list.focus();

         if( i == index )
         {
           list.options[i].selected = true;
         }
         else
         {
            list.options[i].selected = false;
         }
	   }
	}

</SCRIPT>
</HEAD>
<BODY TEXT="#000000" LINK="#000000" VLINK="#000000" ALINK="#000000" bgcolor="#FFFFFF" onload="onPageLoad(),detectBrowser();">
<FORM name="ShowTasksForm" method=post action="webacc" onSubmit="return(getAssignedTasks())">
   <input type=hidden name="taskId" value="<%= c.var("taskId") %>">
   <input type=hidden name="merge" value="dev.GenConf">
   <input type=hidden name="error" value="dev.MooGenErr">
   <input type=hidden name="User.context" value="<%= c.var("User.context") %>">
   <input type=hidden name="nextState" value="addTasksToRole">
   <input type=hidden name="Alltasks.Count" value="<%= c.var("Alltasks.Count") %>">
   <input type=hidden name="TaskDescription" value="">
   <input type=hidden name="Role.AssignedTasks" value="">
   <input type=hidden name="AssignedTasksCount" value="">
   <input type=hidden name="AssignedTasksChanged" value="false">
   <input type=hidden name="RBSAdmin_RoleType" value="<%= c.var("RBSAdmin_RoleType") %>">
   <input type=hidden name="RBSAdmin_TaskDelegate" value="<%= c.var("RBSAdmin_TaskDelegate") %>">
   <input type=hidden name="GeneralMsg.Url" value="">
   <!-- End of hidden tags -->
   
   <% if (c.var("RBSAdmin_RoleType").equals("iManager")) { 
   	   c.set("TaskHeader.title", c.toHTML(c.string("ModifyRoleTasks.ModifyImanagerTasks"))); 
      } else { 
   	   c.set("TaskHeader.title", c.toHTML(c.string("ModifyRoleTasks.ModifyEguideTasks"))); 
      } 
      c.set("TaskHeader.helpFile", "base/modifyroletasks.html"); 
	   c.set("TaskHeader.HelpWindowWidth", "500"); 
	   c.set("TaskHeader.HelpWindowHeight", "500"); %>
   <jsp:include page='<%= c.getPath("dev/TaskHeader_inc.jsp") %>' flush="true" />

   <P><NOBR><B><%= c.toHTML(c.string("ModifyRoleAssociations.RoleName")) %></B>&nbsp;<%= c.toHTML(c.var("RoleDisplayName")) %></NOBR><BR><BR></P>	
   <TABLE>
	   <TR>
		   <TH class="mediumtext" align="left"><%= c.toHTML(c.string("ModifyRoleTasks.AllTasks")) %>
		   <TH class="mediumtext" align="left">
		   <TH class="mediumtext" align="left"><%= c.toHTML(c.string("ModifyRoleTasks.AssignedTasks")) %>
      </TR>
	  <TR>
		 <TD>
			   <SELECT name="AllTasksInTree" size=8 WIDTH="250" style="WIDTH: 250px" multiple onchange="getDescription(this);setListFocus(this)">
			      <% c.set("j", "0"); 
                  while (c.lt(c.var("j"), c.var("Alltasks.Count"))) { %>
			         <OPTION title="<%= c.toHTML(c.var("Role.Alltasks."+c.var("j")+ ".TaskTranslatedName")) %>" value="<%= c.urlEncode(c.var("Role.Alltasks."+c.var("j")+ ".FullName")) %>:<%= c.urlEncode(c.var("Role.Alltasks."+c.var("j")+ ".Description")) %>:<%= c.urlEncode(c.var("Role.Alltasks."+c.var("j")+ ".EguideAttributes")) %>:<%= c.urlEncode(c.var("Role.Alltasks."+c.var("j")+ ".SupervisorRights")) %>:<%= c.urlEncode(c.var("Role.Alltasks."+c.var("j")+ ".SecondaryRights")) %>:<%= c.urlEncode(c.var("Role.Alltasks."+c.var("j")+ ".SuperAndSecondaryRights")) %>:<%= c.toHTML(c.var("Role.Alltasks."+c.var("j")+ ".TaskTranslatedName")) %>"><%= c.toHTML(c.var("Role.Alltasks."+c.var("j")+ ".TaskTranslatedName")) %>
			         <% c.inc("j"); 
			     	   } %>			  
			  	</SELECT>
		 <TD>
			   <a href="#" onClick="javascript:addSelectedItems();return false"><IMG src="<%= c.getModulesUrl() + "/dev/images/" + c.string("Button.ArrowRight.image") %>" alt="<%= c.toHTML(c.string("Button.ArrowRight.alt")) %>" title="<%= c.toHTML(c.string("Button.ArrowRight.alt")) %>" border=0></a>
			   <BR>
				<a href="#" onClick="javascript:removeSelectedItems();return false"><IMG src="<%= c.getModulesUrl() + "/dev/images/" + c.string("Button.ArrowLeft.image") %>" alt="<%= c.toHTML(c.string("Button.ArrowLeft.alt")) %>" title="<%= c.toHTML(c.string("Button.ArrowLeft.alt")) %>" border=0></a>
			   <BR>
         </TD>
	     <TD>
			   <SELECT name="AssignedTasks" size=8 WIDTH="250" style="WIDTH: 250px" multiple onchange="getDescription(this);setListFocus(this)">
			      <% c.set("i", "0"); 
                  while (c.lt(c.var("i"), c.var("Role.Tasks.Count"))) { %>
			         <OPTION title="<%= c.toHTML(c.var("Role.Task."+c.var("i")+ ".TaskTranslatedName")) %>" value="<%= c.urlEncode(c.var("Role.Task."+c.var("i")+ ".FullName")) %>:<%= c.urlEncode(c.var("Role.Task."+c.var("i")+ ".Description")) %>:<%= c.urlEncode(c.var("Role.Task."+c.var("i")+ ".EguideAttributes")) %>:<%= c.urlEncode(c.var("Role.Task."+c.var("i")+ ".SupervisorRights")) %>:<%= c.urlEncode(c.var("Role.Task."+c.var("i")+ ".SecondaryRights")) %>:<%= c.urlEncode(c.var("Role.Task."+c.var("i")+ ".SuperAndSecondaryRights")) %>:<%= c.toHTML(c.var("Role.Task."+c.var("i")+ ".TaskTranslatedName")) %>"><%= c.toHTML(c.var("Role.Task."+c.var("i")+ ".TaskTranslatedName")) %>
			         <% c.inc("i"); 
			     	   } %>
			  	</SELECT>
         </TD>
	  </TR>
   </TABLE>
   <BR>
   <!-- iFrame section -- The Translated Name, Task Path, and Description will be written to this frame -->
   <DIV align="left">
   <IFRAME src="webacc?taskId=dev.Empty&merge=fw.Empty" name="ModifyTaskFrame" width="550" height="300" scrolling="auto" frameborder="0"></IFRAME>
   </DIV>
   <BR>
   <TABLE width="100%" border="0" cellspacing="0" cellpadding="0">
      <TR>
      	 <TD align="left" class="ruleabove">
         	<INPUT type=image name="Ok" alt="<%= c.toHTML(c.string("Button.OK.alt")) %>" title="<%= c.toHTML(c.string("Button.OK.alt")) %>" src="<%= c.getModulesUrl() + "/dev/images/" + c.string("Button.OK.image") %>" border=0>
            <% if (c.var("RBSAdmin_TaskDelegate").equals("taskDelegate") == false) { %>
               <% if (c.var("RBSAdmin_RoleType").equals("iManager")) { %>
                  <a href="webacc?taskId=<%= c.toHTML(c.var("taskId")) %>&merge=fw.RoleTaskSummary&User.context=<%= c.toHTML(c.var("User.context")) %>&nextState=getRolesAndAssignedTasks"><IMG name="Cancel" alt="<%= c.toHTML(c.string("Button.Cancel.alt")) %>" title="<%= c.toHTML(c.string("Button.Cancel.alt")) %>" src="<%= c.getModulesUrl() + "/dev/images/" + c.string("Button.Cancel.image") %>" border=0></a>
               <% } else { %>
                  <a href="webacc?taskId=<%= c.toHTML(c.var("taskId")) %>&merge=fw.EguideRoleTaskSummary&User.context=<%= c.toHTML(c.var("User.context")) %>&nextState=getEguideRolesAndAssignedTasks"><IMG name="Cancel" alt="<%= c.toHTML(c.string("Button.Cancel.alt")) %>" title="<%= c.toHTML(c.string("Button.Cancel.alt")) %>" src="<%= c.getModulesUrl() + "/dev/images/" + c.string("Button.Cancel.image") %>" border=0></a>
               <% } %>
            <% } else { %>
               <jsp:include page='<%= c.getPath("dev/Cancel_inc.jsp") %>' flush="true" />
            <% } %>
         </TD>
      </TR>
   </TABLE>
</FORM>
</BODY></HTML>
