<%@  page pageEncoding="utf-8" contentType="text/html;charset=utf-8" import="com.novell.webaccess.common.JSPConduit,
                                                                             com.novell.emframe.fw.FwUtils,
                                                                             com.novell.emframe.fw.studio.CreateCustomPlugin,
                                                                             com.novell.admin.ns.AttributeDefinition,
                                                                             com.novell.admin.ns.ClassDefinition,
                                                                             com.novell.emframe.dev.*,
                                                                             com.novell.admin.ns.NamespaceException" %>

<%@ taglib uri="/WEB-INF/iman.tld" prefix="iman" %>
<%@ taglib uri="/WEB-INF/c.tld" prefix="c" %>
<%@ taglib uri="/WEB-INF/x.tld" prefix="x" %>

<iman:stringtable bundle="FwResources"/>
<iman:stringtable bundle="DevResources"/>
<x:parse xml="${param.xml}" var="xml"/>

<%
   MContext context = eMFrameFactory.getMContext((HttpServletRequest)pageContext.getRequest());
   JSPConduit c = JSPConduit.getJSPConduit(request);
%>

<HTML>
<HEAD>
   <LINK rel="stylesheet" href="<c:out value="${ContextPath}" />/portal/modules/dev/css/hf_style.css">
      <script language="javascript" type="text/javascript" src="<c:out value="${ModulesPath}"/>/fw/javascripts/tiny_mce/tiny_mce.js"></script>
   <SCRIPT src="<c:out value="${ContextPath}" />/portal/modules/fw/javascripts/Studio.js"></SCRIPT>
   <iman:eMFrameScripts/>
   <iman:mvedScripts/>
   <iman:osScripts/>

   <STYLE>
      .nitem {cursor:'pointer'}
      .nonclickable {background-color: #f5f5f5}
      .WINDOWDRAG{border-color:#000000;border-width:3;border-style:solid;position:absolute;}
   </STYLE>

   <SCRIPT>
      function onExit()
      {
         var xml = "<control>";
         var allRequiredHaveValues = true;
         var readOnly = false;
         var mandatory = false;
         //for copy field attribute
         var hidden = false;
         var hiddenValue = false;
         
         //bug 344452
         var syntax = "Case Ignore String";
         if(document.form.attSyntax)
         {
		  syntax = document.form.attSyntax.value;
		 }
		 
         <x:forEach select="$xml/control/param" >

            var required = "<x:out select="./@required"/>";
            var hasValue = false;
            xml += '<param name="<x:out select="./@name"/>" type="<x:out select="./@type"/>" changeable="<x:out select="./@changeable"/>" required="<x:out select="./@required"/>" resourceFile="<x:out select="./@resourceFile"/>" helpTextKey="<x:out select="./@helpTextKey"/>" displayNameKey="<x:out select="./@displayNameKey"/>" >';
            <x:choose>
            <x:when select="./@name='readOnly'" >
               readOnly = document.form.<x:out select="./@name"/>.checked ? true : false;
            </x:when>
            <x:when select="./@name='mandatory'" >
               mandatory = document.form.<x:out select="./@name"/>.checked ? true : false;
            </x:when>
            <x:when select="./@name='hidden'" >
               hidden = document.form.<x:out select="./@name"/>.checked ? true : false;
            </x:when>
            </x:choose>
            <x:choose>
               <x:when select="./@type='boolean'" >
                  xml += '<value>' + (document.form.<x:out select="./@name"/>.checked ? "true" : "false") + '</value>';
               </x:when>
               <x:when select="./@type='mvstring'" >
                  var list = unpack(mvGetValuesAsPack("<x:out select="./@name"/>"));
                  var hiddenValuesCount = 0;
                  for(var i=0; i < list.length; i++)
                  {
                     xml += "<value>" + xmlEncode(list[i]) + "</value>";
                     hasValue = true;
                     
                     <x:if select="./@name='values'">
                     if(hiddenValuesCount == 0)
                     {
                     	hiddenValue = true;
                     	hiddenValuesCount = 1;
                     }
                     else
                     	hiddenValue = false;	//'coz should have only one value
                     </x:if>                     	
                  }

               </x:when>
               <x:when select="./@type='mvstring-container'" >
                  var list = unpack(mvGetValuesAsPack("<x:out select="./@name"/>"));
                  for(var i=0; i < list.length; i++)
                  {
                     xml += "<value>" + xmlEncode(list[i]) + "</value>";
                     hasValue = true;
                  }
               </x:when>
               <x:when select="./@type='string'" >
                  xml += '<value>' + xmlEncode(document.form.<x:out select="./@name"/>.value) + '</value>';
                  hasValue = document.form.<x:out select="./@name"/>.value != "";
                  //bug 344452
                  <x:if select="./@name='paramValue'">
                  if(syntax == "Integer" || syntax == "Counter" || syntax == "LDAP:Counter" || syntax == "LDAP:Integer" || syntax == "Numeric String" || syntax == "LDAP:Numeric String")
                  {
                    var value = !(isNaN(document.form.<x:out select="./@name"/>.value));
					if((value == null) || (value == false))
					{
						alert("<iman:string key="Timestamp.InvalidValue"/>");
						document.form.<x:out select="./@name"/>.focus();
						return;
					}
                  }
                  </x:if>
               </x:when>
               <x:when select="./@type='integer'" >
                  xml += "<value>" + xmlEncode(document.form.<x:out select="./@name"/>.value) + "</value>";
                  hasValue = document.form.<x:out select="./@name"/>.value != "";
                  // Bug 344446
                  var isInt = !(isNaN(document.form.<x:out select="./@name"/>.value));
                  if(!isInt)
		 		  {
			 		alert("<iman:string key="Timestamp.InvalidValue"/>");
			 		document.form.<x:out select="./@name"/>.focus();
		 		    return;
		          }
               </x:when>
               <x:when select="./@type='htmlarea'" >
                  tinyMCE.triggerSave()
                  var htmlScripts = 1;
                  xml += "<value>" + xmlEncode(document.form.<x:out select="./@name"/>.value) + "</value>";
                  hasValue = document.form.<x:out select="./@name"/>.value != "";
               </x:when>
            </x:choose>
			
            xml += '</param>';
			
            if(required=="true" && !hasValue)
            {
               allRequiredHaveValues = false;
            }
         </x:forEach>

         xml += "</control>";
         if(readOnly == true && mandatory == true)
		 {
			 alert("<iman:string key="Studio.noMandatoryAndReadOnly"/>");
			 return;
		 }
		 if(hidden == true && hiddenValue != true)
		 {
		 	alert("<iman:string key="Studio.noHiddenValue"/>");
			return;
		 }
		 
         window.opener.selectedFields["<c:out value="${param.attributeName}"/>"].m_controlXml = xml;
         window.opener.document.getElementById("editBtn_<c:out value="${param.attributeName}"/>").src = "<%= session.getAttribute("ModulesPath") %>/dev/images/" + (allRequiredHaveValues ? "viewdetails.gif" : "viewdetails_warn.gif");
         window.close();
      }

      function toggleShowAll()
      {
         toggleDivDisplay("attributeDetails");
         toggleDivDisplay("noAttributeDetails");
      }

      function launchTask(taskId, params)
      {
         var url = "frameservice?NPService=fw.LaunchService&NPAction=Launch&launch="+taskId+"&launcher=fw.LaunchService&lifecycle=New";
         if(params && params!=null && params.length>0)
         {
            url += "&";
            url += params;
         }


         var winOpts = "toolbar=no,location=no,directories=no,menubar=no,scrollbars=no,resizable=yes,width=500,height=550";


         // since we are doing an http GET our URL must be unique
         var date = new Date();
         url += "&unique=" + date.getTime();

         var w = window.open( url, "someWindowName", winOpts );
      }
   </SCRIPT>

   <SCRIPT language="javascript" type="text/javascript">
	tinyMCE.init({
		mode : "exact",
		elements : "htmlarea1",
		save_callback : "htmlareacallback",
		theme : "advanced",
		plugins : "searchreplace",
		theme_advanced_buttons1 : "bold,italic,underline,separator,strikethrough,justifyleft,justifycenter,justifyright, justifyfull,bullist,numlist,undo,redo",
		theme_advanced_buttons2 : "cut,copy,paste,separator,search,replace,charmap,link,unlink,code,separator,forecolor,backcolor,separator,hr",
		theme_advanced_buttons1_add : "fontselect,fontsizeselect",
		theme_advanced_buttons3 : "",
		theme_advanced_toolbar_location : "top",
		theme_advanced_toolbar_align : "left"
		});
	
	function htmlareacallback(element_id, html, body)
	{
	   if(undefined != html)
	   {
		document.form.htmlarea.value = html;
	   }
	}
	</script>
</HEAD>

<BODY marginheight="0" marginwidth="0">
<FORM name="form">

   <table cellpadding="0" cellspacing="0"><tr><td valign="top" width="100%" style="padding: 5px">


   <iman:taskHeader titleKey="Studio.ControlProperties" titleBundle="FwResources"/><BR>



   <%

      CreateCustomPlugin task = (CreateCustomPlugin) request.getAttribute("CreateCustomPlugin");
      String attributeName = request.getParameter("attributeName");

      AttributeDefinition attDef = null;
      boolean isNaming = false;
      boolean isMandatory = false;
      try
      {
         DirUtils dirUtils = eMFrameFactory.getMContext(request).getDirUtils();
         attributeName = dirUtils.getRealName(attributeName);
         attDef = task.m_schema.getAttributeDefinition(attributeName);

         String pack = request.getParameter("objectTypeName");
         String[] types = eMFrameUtils.unpack(pack, context);
         ClassDefinition classDef = task.m_schema.getClassDefinition(types[0]);
         AttributeDefinition[] namingAttrs = classDef.getNamingAttributes();
         AttributeDefinition[] mandatoryAttrs = classDef.getMandatoryAttributes();

         isNaming = false;
         for(int i=0; i<namingAttrs.length; i++)
         {
            if(namingAttrs[i].getName().equals(attributeName))
            {
               isNaming = true;
               break;
            }
         }

         isMandatory = false;
         for(int i=0; i<mandatoryAttrs.length; i++)
         {
            if(mandatoryAttrs[i].getName().equals(attributeName))
            {
               isMandatory = true;
               break;
            }
         }
      }
      catch(Throwable e)
      {
         // getAttributeDefinition will fail for the special
         // fields that are not edir attrs.  This is ok
      }

      request.setAttribute("isEDirAttr", "" + (attributeName!=null));
   %>



   <c:if test="${isEDirAttr=='true'}">
   <DIV id=noAttributeDetails style="display:block">
   <TABLE>
      <TR>
         <TD><B><iman:string key="TaskBuilder.AttributeName"/>:</B></TD>
         <TD><B><%= attributeName %></B></TD>
         <TD><A href="#" id=toggleLink onclick="toggleShowAll();" style="text-decoration:none;font-size:12px;"><iman:string key="TaskBuilder.ShowAttributeDetails"/></A></TD>
      </TR>
   </TABLE>
   </DIV>
   </c:if>

   <c:if test="${isEDirAttr=='true'}">
   <DIV id=attributeDetails style="display:none">
      <TABLE>
         <TR>
            <TD><B><iman:string key="TaskBuilder.AttributeName"/>:</B></TD>
            <TD><B><%= attributeName %></B></TD>
            <TD><A href="#" id=toggleLink onclick="toggleShowAll();" style="text-decoration:none;font-size:12px;"><iman:string key="TaskBuilder.HideAttributeDetails"/></A></TD>
         </TR>
      </TABLE>
      <input type="hidden" name="attSyntax" value="<%= attDef.getSyntax().getName() %>">
      <TABLE>
         <TR>
            <TD><iman:string key="TaskBuilder.Syntax"/></TD>
            <TD><%= attDef.getSyntax().getName() %></TD>
         </TR>
         <TR>
            <TD><iman:string key="TaskBuilder.ReadOnly"/></TD>
            <TD><%= attDef.isReadOnly() %></TD>
         </TR>
         <TR>
            <TD><iman:string key="TaskBuilder.SingleValued"/></TD>
            <TD><%= attDef.isSingleValued() %></TD>
         </TR>
         <TR>
            <TD nowrap><iman:string key="TaskBuilder.Naming"/></TD>
            <TD nowrap><%= isNaming %></TD>
         </TR>
         <TR>
            <TD nowrap><iman:string key="TaskBuilder.Mandatory"/></TD>
            <TD nowrap><%= isMandatory %></TD>
         </TR>
      </TABLE>
      <BR><BR>
   </DIV>
   </c:if>



   <c:set var="noparams" value="true"/>

   <TABLE>
      <x:forEach select="$xml/control/param" >

         <c:set var="displayNameKey"><x:out select="./@displayNameKey"/></c:set>
         <c:set var="resourceFile"><x:out select="./@resourceFile"/></c:set>
         <%
            try
            {
               String resourceFile = (String)pageContext.findAttribute("resourceFile");
               String displayNameKey = (String)pageContext.findAttribute("displayNameKey");
               String displayName=eMFrameUtils.getLocalizedString(resourceFile, displayNameKey, context);
               if(displayName==null)
               {
                  displayName = displayNameKey;
               }

               request.setAttribute("displayName", displayName);
            }
            catch(Throwable t)
            {
               D.log(t);
            }
         %>



         <c:set var="noparams" value="false"/>

         <x:choose>
            <x:when select="./@type='boolean'" >
               <TR>
	              <TD colspan="2">
	              <x:if select="./@name='noDefault'">&nbsp;&nbsp;</x:if>
	              <INPUT type="checkbox" name="<x:out select="./@name"/>" <x:if select="./value='true'">checked</x:if> <x:if select="./@changeable='false'">disabled</x:if>>&nbsp;<c:out value="${displayName}" /></TD><TD><x:if select="./@required='true'"><SPAN class="smalltext2a" style="color:red">(<iman:string key="TaskBuilder.Mandatory"/>)</SPAN></x:if>
	              </TD>
               </TR>
            </x:when>

            <x:when select="./@type='mvstring'" >
               <TR>
                  <c:set var="name"><x:out select="./@name"/></c:set>
                  <TD><c:out value="${displayName}" /></TD>
                  <TD>
                     <x:set var="MVStringEditor_xmlNodeSet" select="." scope="request"/>
                     <iman:mved name="${name}" objectTypeName="*" allowOrder="true" />
                  </TD>
                  <TD><x:if select="./@required='true'"><SPAN class="smalltext2a" style="color:red">(<iman:string key="TaskBuilder.Mandatory"/>)</SPAN></x:if></TD>
               </TR>
            </x:when>

            <x:when select="./@type='mvstring-container'" >
               <TR>
                  <c:set var="name"><x:out select="./@name"/></c:set>
                  <TD><c:out value="${displayName}" /></TD>
                  <TD>
                     <x:set var="MVStringEditor_xmlNodeSet" select="." scope="request"/>
                     <iman:mved name="${name}" objectTypeName="[containers]" allowOrder="true" />
                  </TD>
                  <TD><x:if select="./@required='true'"><SPAN class="smalltext2a" style="color:red">(<iman:string key="TaskBuilder.Mandatory"/>)</SPAN></x:if></TD>
               </TR>
            </x:when>

            <x:when select="./@type='string'">
               <TR>
                  <TD><c:out value="${displayName}" /></TD>
                  <TD nowrap>
                     <INPUT type="text" name="<x:out select="./@name"/>" style="width:<iman:string key="UI.textboxPixel"/>" value="<x:out select="./value"/>">
                     <x:if select="./@name='customLabel'">
                        &nbsp;<a href="javascript: launchTask('fw.Schema Display Names', 'nextState=showEditDlg&type=attribute&attributeName=<%= attributeName %>&noEdit=true')"><iman:string key="Studio.SeeDefaults"/></a>
                     </x:if>
                  </TD>
                  <TD>
                     <x:if select="./@required='true'"><SPAN class="smalltext2a" style="color:red">(<iman:string key="TaskBuilder.Mandatory"/>)</SPAN></x:if>
                  </TD>
               </TR>
            </x:when>

            <x:when select="./@type='integer'">
               <TR>
                  <TD><c:out value="${displayName}" /></TD>
                  <TD><INPUT type="text" name="<x:out select="./@name"/>" style="width:<iman:string key="UI.textboxPixel"/>" value="<x:out select="./value"/>"></TD>
                  <TD><x:if select="./@required='true'"><SPAN class="smalltext2a" style="color:red">(<iman:string key="TaskBuilder.Mandatory"/>)</SPAN></x:if></TD>
               </TR>
            </x:when>
            <x:when select="./@type='htmlarea'">
               <TR>
                  <TD><c:out value="${displayName}" /></TD>
                  <TD><TEXTAREA name="<x:out select="./@name"/>1" cols="65" rows="20"><x:out select="./value"/></TEXTAREA>
                  <input type="hidden" name="<x:out select="./@name"/>">
                  </TD>
               </TR>
            </x:when>

         </x:choose>

      </x:forEach>
   </TABLE>


   <c:if test="${noparams == 'true'}">
      <iman:string key="Studio.noParams"/><BR>
   </c:if>


   <BR>
   <iman:bar/>
   <iman:button key="OK" onClick="onExit();"/>
   <iman:button key="Cancel" onClick="window.close()"/>


   </td><td>&nbsp;&nbsp;</td><td>

   <div style="width:200px; height:500px; overflow:auto; background-color:#edeeec; padding:15px">

   <x:forEach select="$xml/control/param">

      <c:set var="displayNameKey"><x:out select="./@displayNameKey"/></c:set>
      <c:set var="key"><x:out select="./@helpTextKey"/></c:set>
      <c:set var="file"><x:out select="./@resourceFile"/></c:set>


      <%
         String helpText = null;
         String displayName = null;
         try
         {
            String file = (String)pageContext.findAttribute("file");
            String displayNameKey = (String)pageContext.findAttribute("displayNameKey");
            String helpKey = (String)pageContext.findAttribute("key");

            displayName = eMFrameUtils.getLocalizedString(file, displayNameKey, context);
            helpText = eMFrameUtils.getLocalizedString(file, helpKey, context);
         }
         catch(Throwable t)
         {
            D.log(t);
         }

         if(helpText!=null)
         {
            out.print("<b>"+displayName+"</b><br/>");
            out.print(helpText);
            out.print("<br/><br/>");
         }
      %>

   </x:forEach>
   </div>


   </td></tr></table>



</FORM>
<jsp:include page='<%= c.getPath("dev/OSFooter_inc.jsp") %>' flush="true" />
</BODY>
</HTML>
