<%@  page pageEncoding="utf-8" contentType="text/html;charset=utf-8" import="com.novell.webaccess.common.JSPConduit, com.novell.emframe.dev.eMFrameUtils" %>
<%
   JSPConduit c = JSPConduit.getJSPConduit(request);
   c.stringTable("DevResources");
   c.stringTable("FwResources");
%>

<%@ taglib uri="/WEB-INF/c.tld" prefix="c" %>
<%@ taglib uri="/WEB-INF/iman.tld" prefix="iman" %>

<HTML>
<HEAD>
   <TITLE><%= c.string("ProductName") %></TITLE>
   <LINK rel='stylesheet' href='<%= c.getModulesUrl() + "/dev/css/hf_style.css" %>'>
   <jsp:include page='<%= c.getPath("dev/eMFrameScripts_inc.jsp") %>' flush="true" />
   <jsp:include page='<%= c.getPath("dev/OSScripts_inc.jsp") %>' flush="true" />

   <iman:mvedScripts/>

   <SCRIPT LANGUAGE="JavaScript">
      function isPageValid()
      {
         var form = document.forms[0];

         <c:forEach items="${attributesNeedingParams}" var="item">
            form.mv<c:out value="${item}"/>Data.value = mvGetValuesAsPack("mv<c:out value="${item}"/>");
         </c:forEach>

         return true;
      }

      function init()
      {
         parent.setFooterButtons(parent.nextButton | parent.backButton | parent.cancelButton);
         parent.setHeader("<% if (c.var("mode").equals("developer")) { %><%= c.string("TemplateBuilder.title") %><% } else { %><%= c.string("TaskBuilder.title") %><% } %>", "<%= c.string("TaskBuilder.FormatOptions") %>");
         returnFromOS();
      }
   </SCRIPT>

   <STYLE>
      select {width:200px; font-size:10px; font-face:Helvetica,Arial};
   </STYLE>
</HEAD>

<body text="#000000" bgcolor="#ffffff" onLoad="init();">
<FORM name="form" method=post action="webacc" onsubmit="isPageValid();" >

   <%-- System variables --%>
   <INPUT type=hidden name="taskId" value="<%= c.var("taskId") %>">
   <INPUT type=hidden name="nextState" value="WriteTemplate">
   <INPUT type=hidden name="objectTypeName" value="<%= c.toHTML(c.var("objectTypeName")) %>">

   <%
      if (c.var("mode").equals("developer"))
      {
         c.set("nextMerge", "fw.TemplateBuilder_created");
      }
      else
      {
         c.set("nextMerge", "fw.TemplateBuilder_preview");
      }
   %>

   <INPUT type=hidden name="merge" value="<%= c.var("nextMerge") %>">
   <INPUT type=hidden name="error" value="dev.GenErr">
   <INPUT type=hidden name="pluginType" value="<%= c.var("pluginType") %>">
   <INPUT type=hidden name="client" value="<%= c.var("client") %>">
   <INPUT type=hidden name="layout" value="<%= c.var("layout") %>">
   <INPUT type=hidden name="mode" value="<%= c.var("mode") %>">

   <DIV class=instructions><%= c.string("TaskBuilder.ParagadgetmsInstructions") %></DIV><BR>

   <TABLE>
      <TR bgcolor="#FFFFFF">
        <TD><font face="Trebuchet MS,Helvetica,Arial" size="-1"><B><%= c.string("TaskBuilder.AttributeName") %></B></font></TD>
        <TD><font face="Trebuchet MS,Helvetica,Arial" size="-1"><B><%= c.string("TaskBuilder.AvailableValues") %></B></font></td>
      </TR>

      <%
         String[] attributesNeedingParams = (String[]) request.getAttribute("attributesNeedingParams");
         String[] displayNames = (String[]) request.getAttribute("displayNames");

         for(int i=0; i<attributesNeedingParams.length; i++)
         {
            String color = (i%2==1 ? "#efeee9" : "white");
      %>
         <TR bgColor="<%= color %>">
            <TD><%= displayNames[i] %></TD>
            <TD>
               <% request.setAttribute("mvedName", "mv"+attributesNeedingParams[i]); %>
               <% request.setAttribute("mvedColor", ""+color); %>

               <c:choose>
                  <c:when test="${DeviceType=='browser'}">
                     <iman:mved name="${mvedName}" bgColor="${mvedColor}" objectTypeName="*"/>
                  </c:when>
                  <c:otherwise>
                     <c:set var="OS.Windowed" value="true" scope="request"/>
                     <iman:mved name="${mvedName}" bgColor="${mvedColor}" objectTypeName="*" size="3"/>
                  </c:otherwise>
               </c:choose>

               <input type="hidden" name="mv<%= attributesNeedingParams[i] %>Data"/>
            </TD>
         </TR>
      <% } %>

   </TABLE>
   <BR><BR>

</FORM>
<iman:include page="dev/OSFooter_inc.jsp"/>
</BODY>
</HTML>