<%@ page import="java.util.ResourceBundle,
                 java.util.Enumeration,
                 java.util.ArrayList,
                 com.novell.emframe.dev.eMFrameUtils,
                 com.novell.emframe.dev.eMFrameFactory,
                 com.novell.emframe.dev.dataTable.TableCell,
                 com.novell.emframe.dev.dataTable.IconTableCell,
                 com.novell.emframe.dev.dataTable.TextTableCell,
                 com.novell.emframe.dev.dataTable.CheckboxTableCell" %>
<%@  page pageEncoding="utf-8" contentType="text/html;charset=utf-8" %>


<%@ taglib uri="/WEB-INF/iman.tld" prefix="iman" %>
<%@ taglib uri="/WEB-INF/c.tld" prefix="c" %>
<%@ taglib uri="/WEB-INF/x.tld" prefix="x" %>

<iman:stringtable bundle="DevResources"/>
<iman:stringtable bundle="FwResources"/>
<iman:stringtable bundle="SDKResources"/>


<HTML>
<HEAD>
   <TITLE><iman:string key="ProductName"/></TITLE>
   <iman:stylesheet/>
   <iman:dataTableScripts/>

   <STYLE type = "text/css">
      td {font-size:12px;}   
      
      .iManTagCode {font-family:monospace;} 
      .iManTagName { color: #000080; 
      				font-weight: bold;
      				font-family:monospace;}
      .iManTagAttr { color: #0000ff; }
      .iManTagValue { color: #008000; }
   </STYLE>


   <iman:mvedScripts mode="mvie" />
   <iman:mvedScripts mode="mvsel" />
   <iman:osScripts/>
   <iman:eMFrameScripts/>
   <iman:calendarScripts/>
   <iman:targetChooserScripts />

   <SCRIPT>
      function getDate()
      {
         return new Date();
      }

      function saveDate(date)
      {
         alert(date.toString());
      }

      function onInit()
      {
      }

      function onExit()
      {
      }

      function showControlDiv(id)
      {
         for(var i=0; i < divs.length; i++)
         {
            var div = document.getElementById(divs[i]);
            if(div)
               div.style.display = "none";
         }

         document.getElementById(id).style.display = "block";
      }

      function menuHandler(menuItemId, selectedIndices, tableData)
      {
         alert("You clicked: " + menuItemId);
      }
      
      function ButtonExampleAlertOK()
      {
      	
      	
      }

      var divs = ["objectSelector", "buttons", "taskHeader", "wizardHeader", "bar", "mvStringEditor", "calendar", "spinner", "dataTable", "tabset", "dump", "menubar", "targetChooserDiv"];
   </SCRIPT>
</HEAD>

<BODY onLoad="onInit();">
<FORM name="form" method="post" action="webacc" onSubmit="return onExit();">

   <!---- edas and system variables  ---->
   <INPUT type="hidden" name="taskId" value="<c:out value="${taskId}"/>">
   <INPUT type="hidden" name="eDirCommand" value="Write">
   <INPUT type="hidden" name="eDir$target" value="<c:out value="${param.eDir$target}"/>">
   <INPUT type="hidden" name="merge" value="dev.GenConf">
   <INPUT type="hidden" name="error" value="dev.GenErr">

   <iman:taskHeader titleKey="SDKTagLib.Header" iconUrl="dev/bullet_default_16.gif"/><br/>


   <div class="mediumtext">
   <iman:string key="SDKTagLib.Description"/>:<br/>
   &nbsp;&nbsp;&nbsp;&nbsp;&lt;%@ taglib uri="/WEB-INF/iman.tld" prefix="iman" %&gt;<br/><br/>
   </div>


   <table>
      <tr>
         <td valign="top">
            <a href="javascript: showControlDiv('bar')">Bar</a></br>
            <a href="javascript: showControlDiv('buttons')">Button</a></br>
            <a href="javascript: showControlDiv('calendar')">Calendar</a></br>
            <a href="javascript: showControlDiv('dataTable')">Data Table</a></br>
         </td>
         <td>&nbsp;&nbsp;</td>
         <td valign="top">
            <a href="javascript: showControlDiv('dump')">Dump</a></br>
            <a href="javascript: showControlDiv('menubar')">Menubar</a></br>
            <a href="javascript: showControlDiv('mvStringEditor')">MVStringEditor</a></br>
            <a href="javascript: showControlDiv('objectSelector')">Object Selector</a></br>
         </td>
         <td>&nbsp;&nbsp;</td>
         <td valign="top">
            <a href="javascript: showControlDiv('spinner')">Spinner</a></br>
            <a href="javascript: showControlDiv('tabset')">Tab Set</a></br>
            <a href="javascript: showControlDiv('targetChooserDiv')">Target Chooser</a></br>
            <a href="javascript: showControlDiv('taskHeader')">Task header</a></br>
         </td>
         <td>&nbsp;&nbsp;</td>
         <td valign="top">
            <a href="javascript: showControlDiv('wizardHeader')">Wizard Header</a></br>
         </td>
      </tr>
   </table>




   <%-- -------------------------------- --%>
   <%-- targetChooser                    --%>
   <%-- -------------------------------- --%>
   <div id="targetChooserDiv" style="display:none">
      <table cellpadding="8px" style="border-width:1px" width="100%">
         <tr><td height="15px"></td></tr>
         <tr><TD colspan="2" bgColor="#cccccc"><B>Target Chooser</B></td></tr>
         <tr height="15px"><td></td></tr>
      </table>

      <iman:targetChooser id="targetObjects" objectTypeNames="User"/><br/><br/>
<b><iman:string key="SDKTagLib.ExampleTag"/></b>

      <br><br>
      <span class="iManTagCode">
         <span class="iManTagName">&lt;iman:targetChooser</span> <span class="iManTagAttr">id=</span><span class="iManTagValue">&quot;targetObjects&quot;</span> <span class="iManTagAttr">objectTypeNames=</span><span class="iManTagValue">&quot;User&quot;</span><span class="iManTagName">/&gt;</span>
         
      </span>
      <br><br>
         Note:
         <ul>
            <li style="font-size:14px"><span class="iManTagName">&lt;iman:targetChooserScripts/&gt;</span> <iman:string key="SDKTagLib.TargetChooser.Note1" param="<span class='iManTagName'>&lt;head&gt;</span>" /></li>
            <li style="font-size:14px"><span class="iManTagName">validateTargetChooser()</span> <iman:string key="SDKTagLib.TargetChooser.Note2"/></li>
            <li style="font-size:14px"><iman:string key="SDKTagLib.TargetChooser.Note3"/>:<br>&nbsp;&nbsp;&nbsp;<span class="iManTagName">TargetObjects targetObjects = TargetObjects.createInstance("targetObjects", taskContext);</span></li>
         </ul>

      <br/>
   </div>


   <%-- -------------------------------- --%>
   <%-- OS                               --%>
   <%-- -------------------------------- --%>
   <div id="objectSelector" style="display:none">
      <table cellpadding="8px" style="border-width:1px" width="100%">
         <tr><td height="15px"></td></tr>
         <tr><TD colspan="2" bgColor="#cccccc"><B>Object Selector</B></td></tr>
         <tr height="15px"><td></td></tr>
      </table>

      <table>
         <tr>
            <td><input type="text" name="osText"><iman:os control="osText" typeFilter="User" multiSelect="false"/></td>
         </tr>
      </table><br/>
	<b><iman:string key="SDKTagLib.ExampleTag"/></b>
	<br><br>
      <span class="iManTagCode">
         <span class="iManTagName">&lt;iman:os</span> <span class="iManTagAttr">control=</span><span class="iManTagValue">&quot;osText&quot;</span> <span class="iManTagAttr">typeFilter=</span><span class="iManTagValue">&quot;User&quot;</span> <span class="iManTagAttr">multiSelect=</span><span class="iManTagValue">&quot;false&quot;</span> <span class="iManTagName">/&gt;</span>
      </span>
         <br><br>
         Note:<br/>
         &nbsp;&nbsp;<span class="iManTagName">&lt;iman:osScripts/&gt;</span> must be called in the <span class="iManTagName">&lt;head&gt;</span> tag.<br/>
         &nbsp;&nbsp;<span class="iManTagName">&lt;iman:osFooter/&gt;</span> must be called before the <span class="iManTagName">&lt;/body&gt;</span> tag.<br/>
      
      
		<br>
		<B><SPAN class="mediumtext" style="color:red"><iman:string key="SDKTagLib.Note"/>: <iman:string key="SDKTagLib.IndepthDoc"/> <a href="/nps/docs/sdk/Using the iManager OS Widget.doc">Using the iManager OS Widget.doc</a></SPAN></B>
   
      </div>



   <%-- -------------------------------- --%>
   <%-- Button                           --%>
   <%-- -------------------------------- --%>

   <div id="buttons" style="display:none">
      <table cellpadding="8px" style="border-width:1px" width="100%">
         <tr><td height="15px"></td></tr>
         <tr><TD colspan="2" bgColor="#cccccc"><B>Button</B></td></tr>
         <tr height="15px"><td></td></tr>
      </table>
	<b><iman:string key="SDKTagLib.ExampleTag"/></b>

      <table cellpadding="8px" style="border-width:1px">
         <tr>
            <c:set var="text">alert('<iman:string key="SDKTagLib.Button.OK"/>');</c:set>            
            <td><iman:button key="OK" onClick="${text}"/></td>
            <TD nowrap><span class="iManTagCode">
               <span class="iManTagName">&lt;iman:button</span> <span class="iManTagAttr">key=</span><span class="iManTagValue">"OK"</span> <span class="iManTagAttr">onClick=</span><span class="iManTagValue">"alert('<iman:string key="SDKTagLib.Button.OK"/>');"</span><span class="iManTagName">/&gt;</span>
               </span>
            </td>
         </tr>
         <tr>
            <c:set var="text">alert('<iman:string key="SDKTagLib.Button.Cancel"/>');</c:set>            
            <td><iman:button key="Cancel" onClick="${text}"/></td>
            <TD nowrap><span class="iManTagCode">
               <span class="iManTagName">&lt;iman:button</span> <span class="iManTagAttr">key=</span><span class="iManTagValue">"Cancel"</span> <span class="iManTagAttr">onClick=</span><span class="iManTagValue">"alert('<iman:string key="SDKTagLib.Button.Cancel"/>');"</span><span class="iManTagName">/&gt;</span>
               </span>
            </td>
         </tr>
         <tr>
            <c:set var="text">alert('<iman:string key="SDKTagLib.Button.AddReplica"/>');</c:set>            
            <td><iman:button key="AddReplica" onClick="${text}"/></td>
            <TD nowrap><span class="iManTagCode">
               <span class="iManTagName">&lt;iman:button</span> <span class="iManTagAttr">key=</span><span class="iManTagValue">"AddReplica"</span> <span class="iManTagAttr">onClick=</span><span class="iManTagValue">"alert('<iman:string key="SDKTagLib.Button.AddReplica"/>');"</span><span class="iManTagName">/&gt;</span>
               </span>
            </td>
         </tr>
      </table><br/>

      <script>
         function updateTextbox()
         {
            var sel = document.form.buttons.selectedIndex;
            var option = document.form.buttons.options[sel];
            document.form.buttonKey.value = "<" + "iman:button key=\""  + option.value + "\" onClick=\"alert(1)\" />";
         }
      </script>

      <span class="mediumtext"><iman:string key="SDKTagLib.Button.AvailableButtons"/>:</span><br/>
      <select name="buttons" size="10" onchange="updateTextbox()">


      <%
         ArrayList nameList = new ArrayList();
         ArrayList keyList = new ArrayList();
         ResourceBundle bundle = ResourceBundle.getBundle("DevResources");
         Enumeration enum1 = bundle.getKeys();
         while(enum1.hasMoreElements())
         {
            String key=(String) enum1.nextElement();
            if(key.startsWith("Button.") && key.endsWith(".image"))
            {
               String name = key.substring(key.indexOf(".")+1, key.lastIndexOf("."));
               nameList.add(name);
               keyList.add(key);
            }
         }

         eMFrameUtils.sortKeyValues(nameList, keyList, eMFrameFactory.getMContext(request));

         int size = nameList.size();
         for(int i=0; i<size; i++)
         {
            out.println("<option value=\""+nameList.get(i)+"\">" + nameList.get(i));
         }
      %>

      </select></br>
      <input type="text" name="buttonKey" value="" style="width:420px">
   </div>


   <%-- -------------------------------- --%>
   <%-- TaskHeader                       --%>
   <%-- -------------------------------- --%>
   <div id="taskHeader" style="display:none">
      <table cellpadding="8px" style="border-width:1px" width="100%">
         <tr><td height="15px"></td></tr>
         <tr><TD colspan="2" bgColor="#cccccc"><B>Task Header</B></td></tr>
         <tr height="15px"><td></td></tr>
      </table>

      <iman:taskHeader title="Hello World"/><br/>
      <iman:taskHeader title="Hello World" iconUrl="dir/User.gif"/><br/>
      <iman:taskHeader titleKey="CreateUserTaskDisplayName" titleBundle="BaseResources" iconUrl="dir/User.gif"/><br/>

      <b><iman:string key="SDKTagLib.ExampleTag"/></b>
      <br>
      <pre>
      <span class="iManTagCode">
<span class="iManTagName">&lt;iman:taskHeader</span> <span class="iManTagAttr">title=</span><span class="iManTagValue">&quot;Hello World&quot;</span> <span class="iManTagName">/&gt;</span>
<span class="iManTagName">&lt;iman:taskHeader</span> <span class="iManTagAttr">title=</span><span class="iManTagValue">&quot;Hello World&quot;</span> <span class="iManTagAttr">iconUrl=</span><span class="iManTagValue">&quot;dir/User.gif&quot;</span><span class="iManTagName">/&gt;</span>
<span class="iManTagName">&lt;iman:taskHeader</span> <span class="iManTagAttr">titleKey=</span><span class="iManTagValue">&quot;CreateUserTaskDisplayName&quot;</span> <span class="iManTagAttr">titleBundle=</span><span class="iManTagValue">&quot;BaseResources&quot;</span> <span class="iManTagAttr">iconUrl=</span><span class="iManTagValue">&quot;dir/User.gif&quot;</span> <span class="iManTagName">/&gt;</span>
      </span>
      </pre>
   </div>


   <%-- -------------------------------- --%>
   <%-- WizardHeader                     --%>
   <%-- -------------------------------- --%>
   <div id="wizardHeader" style="display:none">
      <table cellpadding="8px" style="border-width:1px" width="100%">
         <tr><td height="15px"></td></tr>
         <tr><TD colspan="2" bgColor="#cccccc"><B>Wizard Header</B></td></tr>
         <tr height="15px"><td></td></tr>
      </table>

      <iman:wizardHeader title="Hello World" subtitle="my subtitle:" iconUrl="/nps/portal/modules/dev/images/dir/User.gif" instruction="My Instructions" helpFile="base/schemacreate_attr_wizard_flags.html" />
		<b><iman:string key="SDKTagLib.ExampleTag"/></b>
	<pre>
  <span class="iManTagCode">
<span class="iManTagName">&lt;iman:wizardHeader</span>
   <span class="iManTagAttr">title=</span><span class="iManTagValue">"Hello World"</span>
   <span class="iManTagAttr">subtitle=</span><span class="iManTagValue">"my subtitle:"</span>
   <span class="iManTagAttr">iconUrl=</span><span class="iManTagValue">"/nps/portal/modules/dev/images/dir/User.gif"</span>
   <span class="iManTagAttr">instruction=</span><span class="iManTagValue">"My Instructions"</span>
   <span class="iManTagAttr">helpFile=</span><span class="iManTagValue">"base/schemacreate_attr_wizard_flags.html"</span>
<span class="iManTagName">/&gt;</span> 
	    	
      </span>
      </pre>
      
   			
   </div>


   <%-- -------------------------------- --%>
   <%-- Bar                              --%>
   <%-- -------------------------------- --%>
   <div id="bar" style="display:none">
      <table cellpadding="8px" style="border-width:1px" width="100%">
         <tr><td height="15px"></td></tr>
         <tr><TD colspan="2" bgColor="#cccccc"><B>Bar</B></td></tr>
         <tr height="15px"><td></td></tr>
      </table>

      <iman:bar /><br/>
      <b><iman:string key="SDKTagLib.ExampleTag"/></b>
      <br><br>
      <span class="iManTagCode">
         <span class="iManTagName">&lt;iman:bar /&gt;</span>
      </span>
   </div>


   <%-- -------------------------------- --%>
   <%-- MVED                             --%>
   <%-- -------------------------------- --%>
   <div id="mvStringEditor" style="display:none">
      <table cellpadding="8px" style="border-width:1px" width="100%">
         <tr><td height="15px"></td></tr>
         <tr><TD colspan="2" bgColor="#cccccc"><B>MVStringEditor</B></td></tr>
         <tr height="15px"><td></td></tr>
      </table>
      <table cellpadding="8px" style="border-width:1px">
         <tr>
            <TD colspan="2" nowrap>
            <B><SPAN style="color:red"><iman:string key="SDKTagLib.Note"/>: <iman:string key="SDKTagLib.IndepthDoc"/> <a href="/nps/docs/sdk/MVStringEditor.doc">MVStringEditor.doc</a></SPAN></B></td>
         </tr>
         <tr>
            <c:set var="myxml"><values><value>item1</value><value>item2</value></values></c:set>

            <td><iman:mved name="mved1" width="150" xml="${myxml}"/></td>
            <TD nowrap><span class="iManTagCode">
               <span class="iManTagName">&lt;iman:mved</span> <span class="iManTagAttr">name=</span><span class="iManTagValue">&quot;mved1&quot;</span> <span class="iManTagAttr">width=</span><span class="iManTagValue">&quot;150&quot;</span>
               	<br>&nbsp;&nbsp;&nbsp;<span class="iManTagAttr">xml=</span><span class="iManTagValue">&quot;&lt;values&gt;&lt;value&gt;item1&lt;/value&gt;&lt;value&gt;item2&lt;/value&gt;&lt;/values&gt;&quot;</span> <span class="iManTagName"> /&gt;</span>
               	</span>
            </td>
         </tr>
         <tr>
            <x:parse var="myxml2" xml="${myxml}"/>
            <x:set var="MVStringEditor_xmlNodeSet" select="$myxml2/values" scope="request"/>
            <td><iman:mved name="mved3" readonly="true" /></td>
            <TD nowrap><span class="iManTagCode">
               <span class="iManTagName">&lt;iman:mved</span> <span class="iManTagAttr">name=</span><span class="iManTagValue">&quot;mved3&quot;</span> <span class="iManTagAttr">readonly=</span><span class="iManTagValue">&quot;true&quot;</span>
               	<br>&nbsp;&nbsp;&nbsp;<span class="iManTagAttr">xml=</span><span class="iManTagValue">&quot;&lt;values&gt;&lt;value&gt;item1&lt;/value&gt;&lt;value&gt;item2&lt;/value&gt;&lt;/values&gt;&quot;</span> <span class="iManTagName"> /&gt;</span>
               	</span>
               	</td>
         </tr>
         <tr>
            <td><iman:mved name="mved4" objectTypeName="User"/></td>
            <TD nowrap><span class="iManTagCode">
               <span class="iManTagName">&lt;iman:mved</span> <span class="iManTagAttr">name=</span><span class="iManTagValue">&quot;mved4&quot;</span> <span class="iManTagAttr">objectTypeName=</span><span class="iManTagValue">&quot;User&quot;</span> <span class="iManTagName"> /&gt;</span>
            </span></td>
         </tr>
         <tr>
            <td><iman:mved mode="mvsel" name="mved01" xml="<values><value>item1</value><value>item2</value></values>" /></td>
            <TD nowrap><span class="iManTagCode">
               <span class="iManTagName">&lt;iman:mved</span> <span class="iManTagAttr">mode=</span><span class="iManTagValue">&quot;mvsel&quot;</span> <span class="iManTagAttr">name=</span><span class="iManTagValue">&quot;mved01&quot;</span>
               	<br>&nbsp;&nbsp;&nbsp;<span class="iManTagAttr">xml=</span><span class="iManTagValue">&quot;&lt;values&gt;&lt;value&gt;item1&lt;/value&gt;&lt;value&gt;item2&lt;/value&gt;&lt;/values&gt;&quot;</span> <span class="iManTagName"> /&gt;</span>
               	</span></td>
         </tr>
         <tr>
            <td><iman:mved mode="mvsel" name="mved03" readonly="true" xml="<values><value>item1</value><value>item2</value></values>" /></td>
            <TD nowrap><span class="iManTagCode">
               <span class="iManTagName">&lt;iman:mved</span> <span class="iManTagAttr">mode=</span><span class="iManTagValue">&quot;mvsel&quot;</span> <span class="iManTagAttr">name=</span><span class="iManTagValue">&quot;mved03&quot;</span> <span class="iManTagAttr">readonly=</span><span class="iManTagValue">&quot;true&quot;</span>
               	<br>&nbsp;&nbsp;&nbsp;<span class="iManTagAttr">xml=</span><span class="iManTagValue">&quot;&lt;values&gt;&lt;value&gt;item1&lt;/value&gt;&lt;value&gt;item2&lt;/value&gt;&lt;/values&gt;&quot;</span> <span class="iManTagName"> /&gt;</span>
            </span></td>
         </tr>
         <tr>
            <%
               String[] myItems2 = {"apple", "peach"};
               request.setAttribute("myItems2", myItems2);
            %>

            <td><iman:mved mode="mvsel" size="2" name="mved13" readonly="true" items="${myItems2}" /></td>
            <TD nowrap><span class="iManTagCode">
               <span class="iManTagName">&lt;iman:mved</span> <span class="iManTagAttr">mode=</span><span class="iManTagValue">&quot;mvsel&quot;</span> <span class="iManTagAttr">size=</span><span class="iManTagValue">&quot;2&quot;</span> <span class="iManTagAttr">name=</span><span class="iManTagValue">&quot;mved13&quot;</span> <span class="iManTagAttr">readonly=</span><span class="iManTagValue">&quot;true&quot;</span>
               	<br>&nbsp;&nbsp;&nbsp;<span class="iManTagAttr">xml=</span><span class="iManTagValue">&quot;&lt;values&gt;&lt;value&gt;apple&lt;/value&gt;&lt;value&gt;peach&lt;/value&gt;&lt;/values&gt;&quot;</span> <span class="iManTagName"> /&gt;</span>
            </td>
         </tr>
         <tr>
         	<td valign="top">
         	<%
               String[] myItems = {"apple", "peach", "orange"};
               request.setAttribute("myItems", myItems);
            %>
            <iman:mved mode="mvsel" size="3" name="mved20" readonly="true" items="${myItems}" /></td>
            <TD nowrap><span class="iManTagCode">
            <span class="iManTagValue">&lt;%<br>
               &nbsp;&nbsp;&nbsp;String[] myItems2 = {"apple", "peach", "orange"};<br>
               &nbsp;&nbsp;&nbsp;request.setAttribute("myItems2", myItems2);<br>
            	%&gt;</span><br>
               <span class="iManTagName">&lt;iman:mved</span> <span class="iManTagAttr">mode=</span><span class="iManTagValue">&quot;mvsel&quot;</span> <span class="iManTagAttr">size=</span><span class="iManTagValue">&quot;3&quot;</span> <span class="iManTagAttr">name=</span><span class="iManTagValue">&quot;mved20&quot;</span> <span class="iManTagAttr">readonly=</span><span class="iManTagValue">&quot;true&quot;</span>
               	<br>&nbsp;&nbsp;&nbsp;<span class="iManTagAttr">items=</span><span class="iManTagValue">&quot;${myItems2}&quot;</span> <span class="iManTagName"> /&gt;</span>
            </td>
         </tr>
      </table>
   </div>


   <%-- -------------------------------- --%>
   <%-- Calendar                         --%>
   <%-- -------------------------------- --%>
   <div id="calendar" style="display:none">
      <table cellpadding="8px" style="border-width:1px" width="100%">
         <tr><td height="15px"></td></tr>
         <tr><TD colspan="2" bgColor="#cccccc"><B>Calendar</B></td></tr>
         <tr height="15px"><td></td></tr>
      </table>

      <iman:calendar onLoadCallback="getDate" name="myCal" returnCallback="saveDate" />
      <br/><br/> 

<pre>
<b><iman:string key="SDKTagLib.ExampleTag"/></b>
<span class="iManTagCode">
<span class="iManTagName">&lt;iman:calendar</span> <span class="iManTagAttr">sponLoadCallback=</span><span class="iManTagValue">&quot;getDate&quot;</span> <span class="iManTagAttr">name=</span><span class="iManTagValue">&quot;myCal&quot;</span> <span class="iManTagAttr">returnCallback=</span><span class="iManTagValue">&quot;saveDate&quot;</span><span class="iManTagName">/&gt;</span>
</span>

<b><iman:string key="SDKTagLib.OtherActions"/>:</b>

   <iman:string key="SDKTagLib.Step1"/>&nbsp;<iman:string key="SDKTagLib.Calendar.Action1"/>: <FONT style="font-family:monospaced;" COLOR="#000080"><B>&lt;iman:calendarScripts/&gt;</B></FONT>

   <iman:string key="SDKTagLib.Step2"/>&nbsp;<iman:string key="SDKTagLib.Calendar.Action2"/>

      // called after user has picked a date/time with calendar
      function returnFromCalendar(date, name)
      {
         document.forms[0].elements[name].value = date.toLocaleString();   // display user friendly date
         document.forms[0].elements[name+"_ms"].value = date.valueOf();    // save the milliseconds for application
      }

      // called when the user clicks the calendar widget; this should return the date to be selected in the calendar
      function onLoadCalendar(name)
      {
         var value = document.forms[0].elements[name+"_ms"].value;

         if(value != null && value.length>0)
         {
            return new Date(Number(value));
         }
         else
         {
            return new Date();   // we don't have a value, so initialize calendar to today's date
         }
      }
</pre>


      
   </div>


   <%-- -------------------------------- --%>
   <%-- Spinner                          --%>
   <%-- -------------------------------- --%>
   <div id="spinner" style="display:none">
      <table cellpadding="8px" style="border-width:1px" width="100%">
         <tr><td height="15px"></td></tr>
         <tr><TD colspan="2" bgColor="#cccccc"><B>Spinner</B></td></tr>
         <tr height="15px"><td></td></tr>
      </table>

      <table>
         <tr>
            <td><INPUT type="text" id="spinnerField" value="0"></td>
            <td><iman:spinner elementId="spinnerField"/></td>
         </tr>
      </table><br/>
<b><iman:string key="SDKTagLib.ExampleTag"/></b>

<br><br>

      <span class="iManTagCode">
         <span class="iManTagName">&lt;iman:spinner</span> <span class="iManTagAttr">elementId=</span><span class="iManTagValue">&quot;spinnerField&quot;</span><span class="iManTagName">/&gt;</span>
      </span>
   </div>


   <%-- -------------------------------- --%>
   <%-- Tabset                             --%>
   <%-- -------------------------------- --%>
   <div id="tabset" style="display:none">
      <table cellpadding="8px" style="border-width:1px" width="100%">
         <tr><td height="15px"></td></tr>
         <tr><TD colspan="2" bgColor="#cccccc"><B>Tabset</B></td></tr>
         <tr height="15px"><td></td></tr>
      </table>
      <iman:tabSet selectedIndex="3">
         <iman:tab textKey="RBS.RoleOperations" onClick="alert(1)"/>
         <iman:tab textKey="RBS.TaskOperations" onClick="alert(2)"/>
         <iman:tab textKey="RBS.PropertyBookOperations" onClick="alert(3)"/>
         <iman:tab textKey="RBS.ModuleOperations" onClick="alert(4)"/>
      </iman:tabSet>


<pre>
<b><iman:string key="SDKTagLib.ExampleTag"/></b>
<span class="iManTagCode">
<span class="iManTagName">&lt;iman:tabSet</span> <span class="iManTagAttr">selectedIndex=</span><span class="iManTagValue">&quot;3&quot;<span class="iManTagName">&gt;</span>
   <span class="iManTagName">&lt;iman:tab</span> <span class="iManTagAttr">textKey=</span> <span class="iManTagValue">&quot;RBS.RoleOperations&quot;</span> <span class="iManTagAttr">onClick=</span><span class="iManTagValue">&quot;alert(1)&quot;</span> <span class="iManTagName">/&gt;</span>
   <span class="iManTagName">&lt;iman:tab</span> <span class="iManTagAttr">textKey=</span> <span class="iManTagValue">&quot;RBS.TaskOperations&quot;</span> <span class="iManTagAttr">onClick=</span><span class="iManTagValue">&quot;alert(2)&quot;</span> <span class="iManTagName">/&gt;</span>
   <span class="iManTagName">&lt;iman:tab</span> <span class="iManTagAttr">textKey=</span> <span class="iManTagValue">&quot;RBS.PropertyBookOperations&quot;</span> <span class="iManTagAttr">onClick=</span><span class="iManTagValue">&quot;alert(3)&quot;</span> <span class="iManTagName">/&gt;</span>
   <span class="iManTagName">&lt;iman:tab</span> <span class="iManTagAttr">textKey=</span> <span class="iManTagValue">&quot;RBS.ModuleOperations&quot;</span> <span class="iManTagAttr">onClick=</span><span class="iManTagValue">&quot;alert(4)&quot;</span> <span class="iManTagName">/&gt;</span>
<span class="iManTagName">&lt;/iman:tabSet&gt;</span>
</span>
</pre>

   </div>


   <%-- -------------------------------- --%>
   <%-- dataTable                        --%>
   <%-- -------------------------------- --%>
   <div id="dataTable" style="display:none">
      <table cellpadding="8px" style="border-width:1px" width="100%">
         <tr><td height="15px"></td></tr>
         <tr><TD colspan="2" bgColor="#cccccc"><B>dataTable</B></td></tr>
         <tr height="15px"><td></td></tr>
      </table>

      <%
         // Data
         TableCell[][] data = new TableCell[20][];
         for(int i=0; i<20; i++)
         {
            data[i] = new TableCell[3];
            data[i][0] = new IconTableCell("hi", "dev/dir/rbsTask2.gif", "hi");
            data[i][1] = new TextTableCell("Data" + i, "Data" + i);
            data[i][2] = new CheckboxTableCell("true");
         }
         request.setAttribute("data", data);
      %>

      <iman:dataTable id="myTable" titleKey="Studio.installedCustomPlugins" tableData="${data}" menuActionHandler="menuHandler" sortedColumn="0" sortedDirection="Ascending" sortHandler="alert">
         <iman:menuItem textKey="RBS.New" id="CategoryNew"/>
         <iman:menuItem textKey="RBS.Delete" id="CategoryDelete"/>
         <iman:menuItem textKey="RBS.Actions" id="Actions">
            <iman:menuItem textKey="RBS.RoleAssignment" id="CategoryRoleAssignment"/>
            <iman:menuItem textKey="RBS.Description" id="CategoryDescription"/>
         </iman:menuItem>

         <iman:columnHeader textKey="RBS.Type" sortable="false" />
         <iman:columnHeader textKey="RBS.Category"/>
         <iman:columnHeader textKey="RBS.Category"/>
      </iman:dataTable>

<br/><br/>
<pre>
<b><iman:string key="SDKTagLib.ExampleTag"/>:</b>
   
   <span class="iManTagName">&lt;iman:dataTable</span> <span class="iManTagAttr">id=</span><span class="iManTagValue">&quot;myTable&quot;</span> <span class="iManTagAttr">titleKey=</span><span class="iManTagValue">&quot;Studio.installedCustomPlugins&quot;</span>
           <span class="iManTagAttr">tableData=</span><span class="iManTagValue">&quot;${data}&quot;</span> <span class="iManTagAttr">menuActionHandler=</span><span class="iManTagValue">&quot;menuHandler&quot;</span> <span class="iManTagAttr">sortedColumn=</span><span class="iManTagValue">&quot;0&quot;</span>
           <span class="iManTagAttr">sortedDirection=</span><span class="iManTagValue">&quot;Ascending&quot;</span> <span class="iManTagAttr">sortHandler=</span><span class="iManTagValue">&quot;alert&quot;</span><span class="iManTagName">&gt;</span>
      <span class="iManTagName">&lt;iman:menuItem</span> <span class="iManTagAttr">textKey=</span><span class="iManTagValue">&quot;RBS.New&quot;</span> <span class="iManTagAttr">id=</span><span class="iManTagValue">&quot;CategoryNew&quot;</span><span class="iManTagName">/&gt;</span>
      <span class="iManTagName">&lt;iman:menuItem</span> <span class="iManTagAttr">textKey=</span><span class="iManTagValue">&quot;RBS.Delete&quot;</span> <span class="iManTagAttr">id=</span><span class="iManTagValue">&quot;CategoryDelete&quot;</span><span class="iManTagName">/&gt;</span>
      <span class="iManTagName">&lt;iman:menuItem</span> <span class="iManTagAttr">textKey=</span><span class="iManTagValue">&quot;RBS.Actions&quot;</span> <span class="iManTagAttr">id=</span><span class="iManTagValue">&quot;Actions&quot;</span><span class="iManTagName">&gt;</span>
         <span class="iManTagName">&lt;iman:menuItem</span> <span class="iManTagAttr">textKey=</span><span class="iManTagValue">&quot;RBS.RoleAssigment&quot;</span> <span class="iManTagAttr">id=</span><span class="iManTagValue">&quot;CategoryRoleAssignment&quot;</span><span class="iManTagName">/&gt;</span>
         <span class="iManTagName">&lt;iman:menuItem</span> <span class="iManTagAttr">textKey=</span><span class="iManTagValue">&quot;RBS.Description&quot;</span> <span class="iManTagAttr">id=</span><span class="iManTagValue">&quot;CategoryDescription&quot;</span><span class="iManTagName">/&gt;</span>
      <span class="iManTagName">&lt;/iman:menuItem&gt;</span>

      <span class="iManTagName">&lt;iman:columnHeader</span> <span class="iManTagAttr">textKey=</span><span class="iManTagValue">&quot;RBS.Type&quot;</span> <span class="iManTagAttr">sortable=</span><span class="iManTagValue">&quot;false&quot;</span><span class="iManTagName">/&gt;</span>
      <span class="iManTagName">&lt;iman:columnHeader</span> <span class="iManTagAttr">textKey=</span><span class="iManTagValue">&quot;RBS.Category&quot;</span><span class="iManTagName">/&gt;</span>
      <span class="iManTagName">&lt;iman:columnHeader</span> <span class="iManTagAttr">textKey=</span><span class="iManTagValue">&quot;RBS.Category&quot;</span><span class="iManTagName">/&gt;</span>
   <span class="iManTagName">&lt;/iman:dataTable&gt;</span>

<br>
<b><iman:string key="SDKTagLib.OtherActions"/>:</b>

   <iman:string key="SDKTagLib.Step1"/>&nbsp;<iman:string key="SDKTagLib.TranslateDesc"/>&nbsp;
   &nbsp;&nbsp;&nbsp;<iman:string key="SDKTagLib.DataTable.TranslateDesc"/>

   <iman:string key="SDKTagLib.Step2"/>&nbsp;<iman:string key="SDKTagLib.DataTable.Step2"/>:

      /**
       * menuItemId - id of the menu item that was click (example dirxml.newAbcObject)
       * selectedIndices - array of integers of the rows selected
       * tableData - 2d array of the data in the table (as passed by the developer)
       */
      function handleMenu(menuItemId, selectedIndices, tableData)
      {
         if(menuItemId=="dirxml.newAbcObject")
         {
            window.location = "frameservice?NPService=fw.LaunchService&NPAction=Delegate&delegate=base.CreateGroup&launcher=<c:out value="${taskId}"/>";
         }
         else
         ...
      }

   <iman:string key="SDKTagLib.Step3"/> <iman:string key="SDKTagLib.DataTable.Step3"/>:

      In Java Code:
         TableCell[][] tableData= new TableCell[rowCount];
         tableData = new TableCell[columnCount];

         tableData[0][0] = new TextTableCell(displayText0, value0);
         tableData[0][1] = new TextTableCell(displayText1, value1);

         ...

         request.setAttribute(<font color="red">"data"</font>, tableData);  // This passes the data from the Java task to the JSP

      In JSP Code:
         <span class="iManTagName">&lt;iman:dataTable</span> <span class="iManTagAttr">id=</span><span class="iManTagValue">&quot;myTable&quot;</span> <span class="iManTagAttr">tableData=</span><FONT style="font-family:monospaced;" COLOR="red">&quot;${data}&quot;</FONT>
            <span class="iManTagAttr">titleKey=</span><span class="iManTagValue">&quot;Studio.installedCustomPlugins&quot;</span> 
            <span class="iManTagAttr">...</span>
         <span class="iManTagName">/&gt;</span>


</pre>

   </div>



   <%-- -------------------------------- --%>
   <%-- menubar                          --%>
   <%-- -------------------------------- --%>
   <div id="menubar" style="display:none">
      <table cellpadding="8px" style="border-width:1px" width="100%">
         <tr><td height="15px"></td></tr>
         <tr><TD colspan="2" bgColor="#cccccc"><B>Menubar</B></td></tr>
         <tr height="15px"><td></td></tr>
      </table>
      
     
      <iman:menubar id="myMenu" menuActionHandler="menuHandler">
         <iman:menuItem textKey="RBS.New" id="CategoryNew"/>
         <iman:menuItem textKey="RBS.Delete" id="CategoryDelete"/>
         <iman:menuItem textKey="RBS.Actions" id="Actions">
            <iman:menuItem textKey="RBS.RoleAssignment" id="CategoryRoleAssignment"/>
            <iman:menuItem textKey="RBS.Description" id="CategoryDescription"/>
         </iman:menuItem>
      </iman:menubar>

<pre>
<b><iman:string key="SDKTagLib.ExampleTag"/></b>


<span class="iManTagName">&lt;iman:menubar</span> <span class="iManTagAttr">id=</span><span class="iManTagValue">&quot;myMenu&quot;</span> <span class="iManTagAttr">menuActionHandler=</span><span class="iManTagValue">&quot;menuHandler&quot;</span><span class="iManTagName">&gt;</span>
   <span class="iManTagName">&lt;iman:menuItem</span> <span class="iManTagAttr">textKey=</span><span class="iManTagValue">&quot;RBS.New&quot;</span> <span class="iManTagAttr">id=</span><span class="iManTagValue">&quot;CategoryNew&quot;</span><span class="iManTagName">/&gt;</span> 
   <span class="iManTagName">&lt;iman:menuItem</span> <span class="iManTagAttr">textKey=</span><span class="iManTagValue">&quot;RBS.Delete&quot;</span> <span class="iManTagAttr">id=</span><span class="iManTagValue">&quot;CategoryDelete&quot;</span><span class="iManTagName">/&gt;</span> 
   <span class="iManTagName">&lt;iman:menuItem</span> <span class="iManTagAttr">textKey=</span><span class="iManTagValue">&quot;RBS.Actions&quot;</span> <span class="iManTagAttr">id=</span><span class="iManTagValue">&quot;Actions&quot;</span><span class="iManTagName">&gt;</span> 
      <span class="iManTagName">&lt;iman:menuItem</span> <span class="iManTagAttr">textKey=</span><span class="iManTagValue">&quot;RBS.RoleAssignment&quot;</span> <span class="iManTagAttr">id=</span><span class="iManTagValue">&quot;CategoryRoleAssignment&quot;</span><span class="iManTagName">/&gt;</span> 
      <span class="iManTagName">&lt;iman:menuItem</span> <span class="iManTagAttr">textKey=</span><span class="iManTagValue">&quot;RBS.Description&quot;</span> <span class="iManTagAttr">id=</span><span class="iManTagValue">&quot;CategoryDescription&quot;</span><span class="iManTagName">/&gt;</span> 
   <span class="iManTagName">&lt;/iman:menuItem&gt;</span>   
<span class="iManTagName">&lt;/iman:menubar&gt;</span>


<b><iman:string key="SDKTagLib.OtherActions"/>:</b>

   <iman:string key="SDKTagLib.Step1"/> <iman:string key="SDKTagLib.TranslateDesc"/>
      <iman:string key="SDKTagLib.MenuBar.TranslateDesc"/>

   <iman:string key="SDKTagLib.Step2"/> <iman:string key="SDKTagLib.MenuBar.Step2"/>:

      /**
       * menuItemId - id of the menu item that was click (example dirxml.newAbcObject)
       * selectedIndices - array of integers of the rows selected
       * tableData - 2d array of the data in the table (as passed by the developer)
       */
      function handleMenu(menuItemId, selectedIndices, tableData)
      {
         if(menuItemId=="dirxml.newAbcObject")
         {
            window.location = "frameservice?NPService=fw.LaunchService&NPAction=Delegate&delegate=base.CreateGroup&launcher=<c:out value="${taskId}"/>";
         }
         else
         ...
      }


</pre>

   </div>



   <%-- -------------------------------- --%>
   <%-- Dump                             --%>
   <%-- -------------------------------- --%>
   <div id="dump" style="display:none">
   
   <table cellpadding="8px" style="border-width:1px" width="100%">
         <tr><td height="15px"></td></tr>
         <tr><TD colspan="2" bgColor="#cccccc"><B>Dump</B></td></tr>
         <tr height="15px">
            <td><br><br>
            <b><iman:string key="SDKTagLib.ExampleTag"/></b>
            <br><br>
            <span class = "iManTagCode">    
               <span class ="iManTagName">&lt;iman:dump /&gt;</span>
               </span>
               <br><br>
            </td>
          </tr>
      </table>
      <iman:dump/>
   </div>


   <iman:osFooter/>
</FORM>
</BODY>
</HTML>



