<!-- 
			GADGET STYLESHEET 
	
	This Stylesheet controls the look and feel of the
	window around each gadget.  It is included by the
	BrandingArea gadget stylesheet.
-->


<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">


<!-- 
		SYSTEMStylesheet	 
	
		This is used to contain system templates such as those for errors
		and also those for login.
-->
<xsl:include href="SystemMessages.xsl"/>


<xsl:template match="Gadget[@container='n' and @top='n']">
	<xsl:param name="Position"/>

	<xsl:if test="@position=$Position">

		<xsl:choose>
			<xsl:when test="@hasframe[.='y']">
				<TABLE cellpadding="0" cellspacing="0"><!-- width="100%">-->
					<xsl:attribute name="width"><xsl:value-of select="@width"/></xsl:attribute>
					<xsl:attribute name="align"><xsl:value-of select="@align"/></xsl:attribute>
					<xsl:attribute name="border"><xsl:value-of select="@border"/></xsl:attribute>
					<TR valign="bottom">
						<xsl:attribute name="bgcolor"><xsl:value-of select="/PortalData/Layout/Colors/heading_bgcolor"/></xsl:attribute>
						<TD align="left" colspan="25">
							<xsl:if test="@allowClose[.='y']">
								<A>
									<xsl:attribute name="href">PortalServlet?GI_ID=<xsl:value-of select="../../@id"/>&amp;remWnd=<xsl:value-of select="@id"/></xsl:attribute>
									<IMG BORDER="0" ALIGN="right" SRC="/portal/stylesheets/images/remove.gif" alt="Remove"/>
								</A>
							</xsl:if>
							<xsl:if test="@custom">
								<A>
									<xsl:attribute name="href"><xsl:value-of select="@custom"/></xsl:attribute>
									<IMG BORDER="0" ALIGN="right" SRC="/portal/stylesheets/images/personalize.gif" ALT="Personalize"/>
								</A>
							</xsl:if>
							<!-- This is removed for now.
							<IMG BORDER="0" ALIGN="right" SRC="/portal/stylesheets/images/pin.gif"/>-->
							<xsl:if test="@state='max'">
								<A>
									<xsl:attribute name="href">PortalServlet?GI_ID=<xsl:value-of select="../../@id"/>&amp;minWnd=<xsl:value-of select="@id"/></xsl:attribute>
									<IMG BORDER="0" ALIGN="right" SRC="/portal/stylesheets/images/minimize.gif" alt="Minimize"/>
								</A>
							</xsl:if>
							<xsl:if test="@state='min'">
								<A>
									<xsl:attribute name="href">PortalServlet?GI_ID=<xsl:value-of select="../../@id"/>&amp;maxWnd=<xsl:value-of select="@id"/></xsl:attribute>
									<IMG BORDER="0" ALIGN="right" SRC="/portal/stylesheets/images/maximize.gif" alt="Maximize"/>
								</A>
							</xsl:if>
							
							<!-- GadgetInstanceActionIcons -->
							<xsl:for-each select="Icons/Icon">
								<xsl:sort select="@priority" data-type="number" order="ascending"/>
								<xsl:sort select="@name" data-type="text" order="ascending"/>
								<A>
									<xsl:attribute name="href">PortalServlet?GI_ID=<xsl:value-of select="../../@id"/><xsl:for-each select="actions/action">&amp;<xsl:value-of select="@name"/>=<xsl:value-of select="."/></xsl:for-each></xsl:attribute>
									<IMG BORDER="0" ALIGN="right">
										<xsl:attribute name="SRC"><xsl:value-of select="@href"/></xsl:attribute>
										<xsl:attribute name="ALT"><xsl:value-of select="@name"/></xsl:attribute>
									</IMG>
								</A>
							</xsl:for-each>

							<FONT>
								<xsl:attribute name="face"><xsl:value-of select="/PortalData/Layout/Fonts/window_title_face"/></xsl:attribute>
								<xsl:attribute name="color"><xsl:value-of select="/PortalData/Layout/Colors/heading_textcolor"/></xsl:attribute>
								<xsl:attribute name="size"><xsl:value-of select="/PortalData/Layout/Fonts/window_title_size"/></xsl:attribute>
								<b><xsl:value-of select="@title"/></b>
							</FONT>
						</TD>
					</TR>
					<TR>
						<TD width="100%" colspan="25">
							<xsl:attribute name="bgcolor"><xsl:value-of select="/PortalData/Layout/Colors/default_bgcolor"/></xsl:attribute>
	
	
	
							<!--	THIS NEXT LINE WILL APPLY THE GADGET'S DATA
								TAG, WHICH SHOULD BE THE LAST ELEMENT IN THE
								<Gadget> TAG.					-->
							<xsl:apply-templates select="*[last()]"/>
						</TD>
					</TR>
				</TABLE>
			</xsl:when>
			<xsl:otherwise>
				<TABLE cellpadding="0" cellspacing="0">
					<xsl:attribute name="width"><xsl:value-of select="@width"/></xsl:attribute>
					<xsl:attribute name="align"><xsl:value-of select="@align"/></xsl:attribute>
					<xsl:attribute name="border"><xsl:value-of select="@border"/></xsl:attribute>
					<TR>
						<TD>
							<xsl:apply-templates select="*[last()]"/>
						</TD>
					</TR>
				</TABLE>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:if>
</xsl:template>

</xsl:stylesheet>
