<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<!-- These normally come from LayoutSettings.xml, but when we don't include LayoutSettings.xml we must still include
     these variables. You can never include both globalvariables.xsl and LayoutSettings.xml.-->
	<xsl:variable name="Portal.Servlet.Normal" select="/PortalData/SessionInfo/WebAppInfo/Servlets/Normal"/>
	<xsl:variable name="Portal.Servlet.FullPage" select="/PortalData/SessionInfo/WebAppInfo/Servlets/FullPage"/>
	<xsl:variable name="Portal.Servlet.CustomContent" select="/PortalData/SessionInfo/WebAppInfo/Servlets/CustomContent"/>
    <xsl:variable name="Portal.Servlet.FullFrame" select="/PortalData/SessionInfo/WebAppInfo/Servlets/FullFrame"/>
	<xsl:variable name="Portal.ResourcePath" select="/PortalData/SessionInfo/WebAppInfo/ResourcePath"/>

	<xsl:variable name="Portal.WebAppContext" select="substring-before(substring-after($Portal.Servlet.Normal,'/'),'/servlet/')"/>
	<xsl:variable name="Portal.Session.BrowserXSLSupport"><xsl:value-of select="/PortalData/SessionInfo/BrowserXSLSupport"/></xsl:variable>
	<xsl:variable name="Portal.Servlet.Service">/<xsl:value-of select="$Portal.WebAppContext"/>/servlet/<xsl:if test="$Portal.Session.BrowserXSLSupport='true'">xml</xsl:if>service?</xsl:variable>

	<xsl:variable name="Portal.Session.UserCN" select="/PortalData/SessionInfo/User/CN"/>
	<xsl:variable name="Portal.Session.UserDN" select="/PortalData/SessionInfo/User/DN"/>
	
	<xsl:variable name="Portal.Stylesheet.Name">default</xsl:variable>
</xsl:stylesheet>
