<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:template match="*|/">
		<xsl:apply-templates/>
	</xsl:template>

	<xsl:template match="text()|@*">
		<xsl:value-of select="."/>
	</xsl:template>

	<!-- Beginning of Stylesheet -->
	<xsl:template match="DISPLAY_LOGIN">
		<CENTER>
			<xsl:value-of select="PROMPT"/>
			<FORM METHOD="POST">
				<xsl:attribute name="action"><xsl:choose><xsl:when test="FULLPAGE[.!='']"><xsl:value-of select="$Portal.Servlet.FullPage"/></xsl:when><xsl:otherwise><xsl:value-of select="$Portal.Servlet.Normal"/></xsl:otherwise></xsl:choose></xsl:attribute>
				<INPUT name="DISPLAY_LOGIN" type="HIDDEN" value="true"/>
				<INPUT name="GADGETINSTANCE" type="HIDDEN" value="{GADGET_INSTANCE}"/>
				<INPUT name="GI_ID" type="HIDDEN" value="{GADGET_INSTANCE}"/>
				<INPUT name="BASIC" type="HIDDEN" value="{BASIC}"/>
				<INPUT name="ENTRY" type="HIDDEN" value="{ENTRYTAG}"/>
				<xsl:for-each select="PARAMS/PARAM">
					<INPUT name="{NAME}" type="HIDDEN" value="{VALUE}"/>
				</xsl:for-each>
				<TABLE>
					<TR>
						<TD>
							<xsl:value-of select="$com.novell.nps.SystemMessages.UsernamePromptText"/>: </TD>
						<TD>
							<INPUT name="username" size="15" type="text" value="{USERNAME}"/>
						</TD>
					</TR>
					<TR>
						<TD>
							<xsl:value-of select="$com.novell.nps.SystemMessages.PasswordPromptText"/>: </TD>
						<TD>
							<INPUT name="password" size="15" type="password" value="{PASSWORD}"/>
						</TD>
					</TR>
					<xsl:for-each select="OTHER_PARAM">
						<TR>
							<TD>
								<xsl:value-of select="PROMPT"/>
							</TD>
							<TD>
					            <xsl:choose>
					                <xsl:when test="ISPASSWORD">
										<INPUT name="{NAME}" type="PASSWORD" value="{VALUE}"/>
									</xsl:when>
									<xsl:otherwise>
										<INPUT name="{NAME}" type="TEXT" value="{VALUE}"/>
									</xsl:otherwise>
								</xsl:choose>
							</TD>
						</TR>
					</xsl:for-each>
				</TABLE>
				<CENTER>
					<INPUT alt="{$com.novell.nps.SystemMessages.LoginButtonText}" name="SSLogin" type="submit" value="{$com.novell.nps.SystemMessages.LoginButtonText}"/>
				</CENTER>
				<font size="2">
					<CENTER>
						<INPUT checked="checked" name="savePWD" type="checkbox"/>
						<xsl:value-of select="$com.novell.nps.SystemMessages.SavePasswordInSecretStoreCheckboxText"/>
					</CENTER>
				</font>
			</FORM>
		</CENTER>
	</xsl:template>
	<xsl:template match="ERROR_MESSAGE">
		<xsl:choose>
			<xsl:when test="ERROR[.=&apos;10&apos;]">
				<table border="1" bordercolor="red" cellpadding="3" cellspacing="0">
					<tr>
						<td>
							<div class="errorhead">
								<IMG ALIGN="absmiddle" src="{$Portal.ResourcePath}/gadgets/com.novell.nps.gadgets.admin.AdminGadget/Error32.gif"/>
								<xsl:value-of select="$com.novell.nps.SystemMessages.URLNotValidErrorText"/>
							</div>
						</td>
					</tr>
				</table>
			</xsl:when>
			<xsl:when test="ERROR[.=&apos;11&apos;]">
				<table border="1" bordercolor="red" cellpadding="3" cellspacing="0">
					<tr>
						<td>
							<div class="errorhead">
								<IMG ALIGN="absmiddle" src="{$Portal.ResourcePath}/gadgets/com.novell.nps.gadgets.admin.AdminGadget/Error32.gif"/>
								<xsl:value-of select="$com.novell.nps.SystemMessages.InvalidGadgetConfigErrorText"/>
							</div>
						</td>
					</tr>
				</table>
				<P/>
			</xsl:when>
			<xsl:when test="ERROR[.=&apos;12&apos;]">
				<table border="1" bordercolor="red" cellpadding="3" cellspacing="0">
					<tr>
						<td>
							<div class="errorhead">
								<IMG ALIGN="absmiddle" src="{$Portal.ResourcePath}/gadgets/com.novell.nps.gadgets.admin.AdminGadget/Error32.gif"/>
								<xsl:value-of select="$com.novell.nps.SystemMessages.UsernamePasswordErrorText"/>
							</div>
						</td>
					</tr>
				</table>
				<P/>
			</xsl:when>
			<xsl:when test="ERRORSTRING[.!=&apos;&apos;]">
				<table border="1" bordercolor="red" cellpadding="3" cellspacing="0">
					<tr>
						<td>
							<div class="errorhead">
								<IMG ALIGN="absmiddle" src="{$Portal.ResourcePath}/gadgets/com.novell.nps.gadgets.admin.AdminGadget/Error32.gif"/>
								<xsl:value-of select="ERRORSTRING"/>
							</div>
						</td>
					</tr>
				</table>
				<P/>
			</xsl:when>
			<xsl:otherwise>
				<table border="1" bordercolor="red" cellpadding="3" cellspacing="0">
					<tr>
						<td>
							<div class="errorhead">
								<IMG ALIGN="absmiddle" src="{$Portal.ResourcePath}/gadgets/com.novell.nps.gadgets.admin.AdminGadget/Error32.gif"/>
								<xsl:value-of select="$com.novell.nps.SystemMessages.UnknownErrorText"/>
							</div>
						</td>
					</tr>
				</table>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template match="TimedOutError"> <xsl:value-of select="$com.novell.nps.SystemMessages.TIMEDOUT"/><br/>
		<a href="{$Portal.Servlet.Normal}GI_ID={../../../@id}&amp;ForceRead={../@id}"><xsl:value-of select="$com.novell.nps.SystemMessages.ClickHereForDataToBeReadText"/></a>
	</xsl:template>

	<!-- Template for system error messages -->
	<xsl:template match="com.novell.nps.ErrorMessage">
		<table border="0" cellpadding="3" cellspacing="0">
			<tr>
				<div class="errormessage">
					<td>
						<img ALIGN="absmiddle"
							alt="{SystemMessage}"
							border="0"
							src="{$Portal.ResourcePath}/stylesheets/skins/{$Portal.Stylesheet.Name}/images/Error32.gif"/>
					</td>

					<td>
						<xsl:if test="UserMessage">
							<xsl:value-of select="UserMessage"/><br/>
						</xsl:if>

						<xsl:choose>
							<xsl:when test="ErrorCode[.='2']">
								<xsl:value-of select="$com.novell.nps.SystemMessages.CommunicationError"/>
							</xsl:when>

							<xsl:when test="ErrorCode[.='3']">
								<xsl:value-of select="$com.novell.nps.SystemMessages.TimeLimitExceeded"/>
							</xsl:when>

							<xsl:when test="ErrorCode[.='4']">
								<xsl:value-of select="$com.novell.nps.SystemMessages.SizeLimitExceeded"/>
							</xsl:when>

							<xsl:when test="ErrorCode[.='7']">
								<xsl:value-of select="$com.novell.nps.SystemMessages.AuthenticationMethodNotSupported"/>
							</xsl:when>

							<xsl:when test="ErrorCode[.='8']">
								<xsl:value-of select="$com.novell.nps.SystemMessages.AuthenticationFailed"/>
							</xsl:when>

							<xsl:when test="ErrorCode[.='11']">
								<xsl:value-of select="$com.novell.nps.SystemMessages.LimitExceeded"/>
							</xsl:when>

							<xsl:when test="ErrorCode[.='12']">
								<xsl:value-of select="$com.novell.nps.SystemMessages.ExtensionUnavailable"/>
							</xsl:when>

							<xsl:when test="ErrorCode[.='16']">
								<xsl:value-of select="$com.novell.nps.SystemMessages.NoSuchAttribute"/>
							</xsl:when>

							<xsl:when test="ErrorCode[.='17']">
								<xsl:value-of select="$com.novell.nps.SystemMessages.UndefinedAttributeType"/>
							</xsl:when>

							<xsl:when test="ErrorCode[.='18']">
								<xsl:value-of select="$com.novell.nps.SystemMessages.InvalidSearchFilter"/>
							</xsl:when>

							<xsl:when test="ErrorCode[.='19']">
								<xsl:value-of select="$com.novell.nps.SystemMessages.InvalidAttributeValue"/>
							</xsl:when>

							<xsl:when test="ErrorCode[.='20']">
								<xsl:value-of select="$com.novell.nps.SystemMessages.AttributeOrValueExists"/>
							</xsl:when>

							<xsl:when test="ErrorCode[.='32']">
								<xsl:value-of select="$com.novell.nps.SystemMessages.ObjectNotFound"/>
							</xsl:when>

							<xsl:when test="ErrorCode[.='34']">
								<xsl:value-of select="$com.novell.nps.SystemMessages.InvalidName"/>
							</xsl:when>

							<xsl:when test="ErrorCode[.='50']">
								<xsl:value-of select="$com.novell.nps.SystemMessages.InsufficientAccessRights"/>
							</xsl:when>

							<xsl:when test="ErrorCode[.='51']">
								<xsl:value-of select="$com.novell.nps.SystemMessages.ServiceUnavailable"/>
							</xsl:when>

							<xsl:when test="ErrorCode[.='65']">
								<xsl:value-of select="$com.novell.nps.SystemMessages.SchemaViolation"/>
							</xsl:when>

							<xsl:when test="ErrorCode[.='66']">
								<xsl:value-of select="$com.novell.nps.SystemMessages.ContextNotEmpty"/>
							</xsl:when>

							<xsl:when test="ErrorCode[.='68']">
								<xsl:value-of select="$com.novell.nps.SystemMessages.ObjectAlreadyExists"/>
							</xsl:when>

							<xsl:otherwise>
								<xsl:value-of select="SystemMessage"/>
							</xsl:otherwise>
						</xsl:choose>

						<!-- Now tack on the error code -->
						<xsl:if test="ErrorCode[.!='0']">
							(<xsl:value-of select="ErrorCode"/>)
						</xsl:if>
					</td>
				</div>
			</tr>
		</table>
	</xsl:template>

    <xsl:template match="com.novell.nps.close-my-window">
    <script language="javascript">
    if( top.opener != null )
        top.close();
    </script>
    </xsl:template>

	<xsl:template match="HandleActionErrorState">
		<table border="0" cellpadding="3" cellspacing="0">
			<tr>
				<div class="errormessage">
					<td>
						<img ALIGN="absmiddle"
							alt="{StackTrace}"
							border="0"
							src="{$Portal.ResourcePath}/stylesheets/skins/default/images/Error32.gif"/>
					</td>

					<td>
						<xsl:value-of select="$com.novell.nps.SystemMessages.ServiceUnavailable"/>: <xsl:value-of select="ThrownError"/>
					</td>
				</div>
			</tr>
		</table>
	</xsl:template>

</xsl:stylesheet>

