<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <!--
	This template builds the active/maximized Object
	Scheme/Page.

	The Object Scheme consists of a Header, Body, and 
	Footer.  It is responsible for arranging the Gadgets
	inside the Object Scheme.  It controls the column
	widths inside the Body and whether the Gadgets in the
	Header and Footer are stacked on top of one another
	or arranged horizontally left to right.

	*******************************************************

	The following conditions are REQUIRED for this file to
	function properly in Novell Portal Services.  Any 
	additional templates are optional and may be added,
	removed, or modified as needed.

	Templates REQUIRED in this file:

		<xsl:template match="com.novell.nps.gadgetManager.ObjectSchemeGadget">

	Templates that must be called in this file:

		1.  The Object Scheme must render the Gadgets
			assigned to its Header, Body (Column 1, 2, 
			or 3), and Footer by calling the 
			Portal.Gadget template.  Follow the same 
			syntax as made in the base stylesheets.

			<xsl:call-template name="Portal.Gadget"/>
-->
    <xsl:template match="com.novell.nps.gadgetManager.ObjectSchemeGadget">
        <!--
		In this template, we ensure that we don't create 
		empty rows or cells where not necessary.  For this 
		reason, there are extra <xsl:if> conditions that 
		prevent the Header, Body, and/or Footer from being
		rendered to the ObjectScheme when there are no 
		gadgets assigned to one of these.
	-->
        <xsl:if test="Gadget[@position=&apos;Header&apos;]">
            <xsl:call-template name="Portal.ObjectSchemeHeader"/>
        </xsl:if>
        <xsl:if test="Gadget[contains(@position,&apos;Column&apos;)]">
            <xsl:call-template name="Portal.ObjectSchemeBody"/>
        </xsl:if>
        <xsl:if test="Gadget[@position=&apos;Footer&apos;]">
            <xsl:call-template name="Portal.ObjectSchemeFooter"/>
        </xsl:if>
    </xsl:template>
    <xsl:template name="Portal.ObjectSchemeHeader">
        <table border="0" cellpadding="0" cellspacing="0" width="100%">
            <tr>
                <!-- Spacer Column (EMPTY) -->
                <td>
                    <img alt="" src="{$Portal.ResourcePath}/stylesheets/skins/{$Portal.Stylesheet.Name}/images/cp.gif" width="10"/>
                </td>
                <!-- Column 1 is built here -->
                <td valign="top" width="100%">
                    <table border="0" cellpadding="0" cellspacing="0" width="100%">
                        <tr valign="top">
                            <xsl:for-each select="Gadget[@position=&apos;Header&apos;]">
                                <xsl:sort data-type="number" order="ascending" select="@priority"/>
                                <xsl:sort order="ascending" select="@title"/>
                                <td>
                                    <xsl:call-template name="Portal.Gadget"/>
                                </td>
                            </xsl:for-each>
                        </tr>
                    </table>
                </td>
            </tr>
            <!-- Spacer Row (EMPTY) -->
            <tr>
                <td>
                    <img alt="" height="10" src="{$Portal.ResourcePath}/stylesheets/skins/{$Portal.Stylesheet.Name}/images/cp.gif"/>
                </td>
            </tr>
        </table>
    </xsl:template>
    <xsl:template name="Portal.ObjectSchemeBody">
        <!--
		Test to see whether there are any Gadgets that should be
		placed in the Body of the Object Scheme.

		If there are, we'll dynamically build the columns.

		Gadgets are sorted in each column first by their
		priority and then by their title.
	-->
        <xsl:if test="Gadget[starts-with(@position,&apos;Column&apos;)]">
            <xsl:choose>
                <xsl:when test="../@scheme=&apos;3 Column&apos;">
                    <!--
					A three column scheme layout is selected
					for the Object Scheme Body.
				-->
                    <table border="0" cellpadding="0" cellspacing="0" width="100%">
                        <tr>
                            <!-- Spacer Column (EMPTY) -->
                            <td>
                                <img alt="" src="{$Portal.ResourcePath}/stylesheets/skins/{$Portal.Stylesheet.Name}/images/cp.gif" width="10"/>
                            </td>
                            <!-- Column 1 is built here -->
                            <td valign="top">
                                <table border="0" cellpadding="0" cellspacing="0" width="100%">
                                    <xsl:for-each select="Gadget[@position=&apos;Column 1&apos;]">
                                        <xsl:sort data-type="number" order="ascending" select="@priority"/>
                                        <xsl:sort order="ascending" select="@title"/>
                                        <tr>
                                            <td>
                                                <xsl:call-template name="Portal.Gadget"/>
                                            </td>
                                        </tr>
                                        <!-- Spacer Row (EMPTY) -->
                                        <tr>
                                            <td>
                                                <img alt="" height="10" src="{$Portal.ResourcePath}/stylesheets/skins/{$Portal.Stylesheet.Name}/images/cp.gif"/>
                                            </td>
                                        </tr>
                                    </xsl:for-each>
                                </table>
                            </td>
                            <!-- Spacer Column (EMPTY) -->
                            <td>
                                <img alt="" src="{$Portal.ResourcePath}/stylesheets/skins/{$Portal.Stylesheet.Name}/images/cp.gif" width="10"/>
                            </td>
                            <!-- Column 2 is built here -->
                            <td valign="top">
                                <table border="0" cellpadding="0" cellspacing="0" width="100%">
                                    <xsl:for-each select="Gadget[@position=&apos;Column 2&apos;]">
                                        <xsl:sort data-type="number" order="ascending" select="@priority"/>
                                        <xsl:sort order="ascending" select="@title"/>
                                        <tr>
                                            <td>
                                                <xsl:call-template name="Portal.Gadget"/>
                                            </td>
                                        </tr>
                                        <!-- Spacer Row (EMPTY) -->
                                        <tr>
                                            <td>
                                                <img alt="" height="10" src="{$Portal.ResourcePath}/stylesheets/skins/{$Portal.Stylesheet.Name}/images/cp.gif"/>
                                            </td>
                                        </tr>
                                    </xsl:for-each>
                                </table>
                            </td>
                            <!-- Spacer Column (EMPTY) -->
                            <td>
                                <img alt="" src="{$Portal.ResourcePath}/stylesheets/skins/{$Portal.Stylesheet.Name}/images/cp.gif" width="10"/>
                            </td>
                            <!-- Column 3 is built here -->
                            <td valign="top">
                                <table border="0" cellpadding="0" cellspacing="0" width="100%">
                                    <xsl:for-each select="Gadget[@position=&apos;Column 3&apos;]">
                                        <xsl:sort data-type="number" order="ascending" select="@priority"/>
                                        <xsl:sort order="ascending" select="@title"/>
                                        <tr>
                                            <td>
                                                <xsl:call-template name="Portal.Gadget"/>
                                            </td>
                                        </tr>
                                        <!-- Spacer Row (EMPTY) -->
                                        <tr>
                                            <td>
                                                <img alt="" height="10" src="{$Portal.ResourcePath}/stylesheets/skins/{$Portal.Stylesheet.Name}/images/cp.gif"/>
                                            </td>
                                        </tr>
                                    </xsl:for-each>
                                </table>
                            </td>
                        </tr>
                    </table>
                </xsl:when>
                <xsl:when test="../@scheme=&apos;2 Column&apos;">
                    <!--
					A two column scheme layout is selected
					for the Object Scheme Body.
				-->
                    <table border="0" cellpadding="0" cellspacing="0" width="100%">
                        <tr>
                            <!-- Spacer Column (EMPTY) -->
                            <td>
                                <img alt="" src="{$Portal.ResourcePath}/stylesheets/skins/{$Portal.Stylesheet.Name}/images/cp.gif" width="10"/>
                            </td>
                            <!-- Column 1 is built here -->
                            <td valign="top">
                                <table border="0" cellpadding="0" cellspacing="0" width="100%">
                                    <xsl:for-each select="Gadget[@position=&apos;Column 1&apos;]">
                                        <xsl:sort data-type="number" order="ascending" select="@priority"/>
                                        <xsl:sort order="ascending" select="@title"/>
                                        <tr>
                                            <td>
                                                <xsl:call-template name="Portal.Gadget"/>
                                            </td>
                                        </tr>
                                        <!-- Spacer Row (EMPTY) -->
                                        <tr>
                                            <td>
                                                <img alt="" height="10" src="{$Portal.ResourcePath}/stylesheets/skins/{$Portal.Stylesheet.Name}/images/cp.gif"/>
                                            </td>
                                        </tr>
                                    </xsl:for-each>
                                </table>
                            </td>
                            <!-- Spacer Column (EMPTY) -->
                            <td>
                                <img alt="" src="{$Portal.ResourcePath}/stylesheets/skins/{$Portal.Stylesheet.Name}/images/cp.gif" width="10"/>
                            </td>
                            <!-- Column 2 is built here. -->
                            <td valign="top">
                                <!--								
								Since Column 3 does not exist in the
								two-column layout, we'll force all
								Gadgets that could have accidentally been
								assigned to Column 3 to show up at the
								bottom of Column 2.
							-->
                                <table border="0" cellpadding="0" cellspacing="0" width="100%">
                                    <xsl:for-each select="Gadget[@position!=&apos;Column 1&apos; and starts-with(@position,&apos;Column&apos;)]">
                                        <xsl:sort order="ascending" select="@position"/>
                                        <xsl:sort data-type="number" order="ascending" select="@priority"/>
                                        <xsl:sort order="ascending" select="@title"/>
                                        <tr>
                                            <td>
                                                <xsl:call-template name="Portal.Gadget"/>
                                            </td>
                                        </tr>
                                        <!-- Spacer Row (EMPTY) -->
                                        <tr>
                                            <td>
                                                <img alt="" height="10" src="{$Portal.ResourcePath}/stylesheets/skins/{$Portal.Stylesheet.Name}/images/cp.gif"/>
                                            </td>
                                        </tr>
                                    </xsl:for-each>
                                </table>
                            </td>
                        </tr>
                    </table>
                </xsl:when>
                <xsl:otherwise>
                    <!--
					A one column scheme layout is selected
					for the Object Scheme Body.
						
					Since Column 2 and 3 do not exist in the
					one-column layout, we'll force all
					Gadgets that could have accidentally been
					assigned to Column 2 and 3 to show up at 
					the of Column 1.
				
			<xsl:value-of select="name(../../..)"/>&#160;
						<xsl:value-of select="../../../@title"/>&#160;-->
			<xsl:choose>
				<xsl:when test="../../../com.novell.nps.MainPage"> <!-- OS really in the IA -->
				<table border="0" cellpadding="0" cellspacing="0" width="100%">
	                        <tr>
	                            <!-- Spacer Column (EMPTY) -->
	                            <td>
	                                <img alt="" src="{$Portal.ResourcePath}/stylesheets/skins/{$Portal.Stylesheet.Name}/images/cp.gif" width="10"/>
	                            </td>
	                            <!-- Column 1 is built here -->
	                            <td valign="top">
	                                <table border="0" cellpadding="0" cellspacing="0" width="100%">
	                                    <xsl:for-each select="Gadget[starts-with(@position,&apos;Column&apos;)]">
	                                        <xsl:sort order="ascending" select="@position"/>
	                                        <xsl:sort data-type="number" order="ascending" select="@priority"/>
	                                        <xsl:sort order="ascending" select="@title"/>
	                                        <tr>
	                                            <td valign="top">
	                                                <xsl:call-template name="Portal.Gadget"/>
	                                            </td>
	                                        </tr>
	                                        <!-- Spacer Row (EMPTY) -->
	                                        <xsl:if test="not(last())">
	                                        <tr>
	                                            <td>
	                                                <img alt="" height="10" src="{$Portal.ResourcePath}/stylesheets/skins/{$Portal.Stylesheet.Name}/images/cp.gif"/>
	                                            </td>
	                                        </tr>
	                                        </xsl:if>
	                                    </xsl:for-each>
	                                </table>
	                            </td>
	                        </tr>
	                    </table>
				
				</xsl:when>
				<xsl:otherwise> <!-- container gadget -->
					<table border="0" cellpadding="0" cellspacing="0" width="100%">
                                    <xsl:for-each select="Gadget[starts-with(@position,&apos;Column&apos;)]">
                                        <xsl:sort order="ascending" select="@position"/>
                                        <xsl:sort data-type="number" order="ascending" select="@priority"/>
                                        <xsl:sort order="ascending" select="@title"/>
                                        <tr>
                                            <td valign="top">
                                                <xsl:call-template name="Portal.Gadget"/>
                                            </td>
                                        </tr>
                                        <!-- Spacer Row (EMPTY) -->
                                        <xsl:if test="not(last())">
                                        <tr>
                                            <td>
                                                <img alt="" height="10" src="{$Portal.ResourcePath}/stylesheets/skins/{$Portal.Stylesheet.Name}/images/cp.gif"/>
                                            </td>
                                        </tr>
                                        </xsl:if>
                                    </xsl:for-each>
                                </table>
				</xsl:otherwise>
			</xsl:choose>
                    
                </xsl:otherwise>
            </xsl:choose>
        </xsl:if>
    </xsl:template>
    <xsl:template name="Portal.ObjectSchemeFooter">
        <table border="0" cellpadding="0" cellspacing="0" width="100%">
            <tr>
                <!-- Spacer Column (EMPTY) -->
                <td>
                    <img alt="" src="{$Portal.ResourcePath}/stylesheets/skins/{$Portal.Stylesheet.Name}/images/cp.gif" width="10"/>
                </td>
                <!-- Column 1 is built here -->
                <td valign="top" width="100%">
                    <table border="0" cellpadding="0" cellspacing="0" width="100%">
                        <tr valign="top">
                            <xsl:for-each select="Gadget[@position=&apos;Footer&apos;]">
                                <xsl:sort data-type="number" order="ascending" select="@priority"/>
                                <xsl:sort order="ascending" select="@title"/>
                                <td>
                                    <xsl:call-template name="Portal.Gadget"/>
                                </td>
                            </xsl:for-each>
                        </tr>
                    </table>
                </td>
            </tr>
            <!-- Spacer Row (EMPTY) -->
            <tr>
                <td>
                    <img alt="" height="10" src="{$Portal.ResourcePath}/stylesheets/skins/{$Portal.Stylesheet.Name}/images/cp.gif"/>
                </td>
            </tr>
        </table>
    </xsl:template>
</xsl:stylesheet>
<!-- Stylesheet edited using Stylus Studio - (c)1998-2001 eXcelon Corp. -->
